/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.core.settings.IvyVariableContainerImpl;
import org.apache.ivy.util.Message;

public final class IvyPatternHelper {
    public static final String CONF_KEY = "conf";
    public static final String TYPE_KEY = "type";
    public static final String EXT_KEY = "ext";
    public static final String ARTIFACT_KEY = "artifact";
    public static final String BRANCH_KEY = "branch";
    public static final String REVISION_KEY = "revision";
    public static final String MODULE_KEY = "module";
    public static final String ORGANISATION_KEY = "organisation";
    public static final String ORGANISATION_KEY2 = "organization";
    public static final String ORGANISATION_PATH_KEY = "orgPath";
    public static final String ORIGINAL_ARTIFACTNAME_KEY = "originalname";
    private static final Pattern PARAM_PATTERN = Pattern.compile("\\@\\{(.*?)\\}");
    private static final Pattern VAR_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");

    private IvyPatternHelper() {
    }

    public static String substitute(String pattern, ModuleRevisionId moduleRevision) {
        return IvyPatternHelper.substitute(pattern, moduleRevision.getOrganisation(), moduleRevision.getName(), moduleRevision.getBranch(), moduleRevision.getRevision(), "ivy", "ivy", "xml", null, null, moduleRevision.getQualifiedExtraAttributes(), null);
    }

    public static String substitute(String pattern, ModuleRevisionId moduleRevision, String artifact, String type, String ext) {
        return IvyPatternHelper.substitute(pattern, moduleRevision, new DefaultArtifact(moduleRevision, null, artifact, type, ext));
    }

    public static String substitute(String pattern, Artifact artifact) {
        return IvyPatternHelper.substitute(pattern, artifact, (String)null);
    }

    public static String substitute(String pattern, Artifact artifact, ArtifactOrigin origin) {
        return IvyPatternHelper.substitute(pattern, artifact.getModuleRevisionId(), artifact, (String)null, origin);
    }

    public static String substitute(String pattern, Artifact artifact, String conf) {
        return IvyPatternHelper.substitute(pattern, artifact.getModuleRevisionId(), artifact, conf, (ArtifactOrigin)null);
    }

    public static String substitute(String pattern, ModuleRevisionId mrid, Artifact artifact) {
        return IvyPatternHelper.substitute(pattern, mrid, artifact, (String)null, (ArtifactOrigin)null);
    }

    public static String substitute(String pattern, ModuleRevisionId mrid, Artifact artifact, String conf, ArtifactOrigin origin) {
        return IvyPatternHelper.substitute(pattern, mrid.getOrganisation(), mrid.getName(), mrid.getBranch(), mrid.getRevision(), artifact.getName(), artifact.getType(), artifact.getExt(), conf, origin, mrid.getQualifiedExtraAttributes(), artifact.getQualifiedExtraAttributes());
    }

    public static String substitute(String pattern, String org, String module, String revision, String artifact, String type, String ext) {
        return IvyPatternHelper.substitute(pattern, org, module, null, revision, artifact, type, ext, null, null, null, null);
    }

    public static String substitute(String pattern, String org, String module, String revision, String artifact, String type, String ext, String conf) {
        return IvyPatternHelper.substitute(pattern, org, module, null, revision, artifact, type, ext, conf, null, null, null);
    }

    public static String substitute(String pattern, String org, String module, String revision, String artifact, String type, String ext, String conf, Map extraModuleAttributes, Map extraArtifactAttributes) {
        return IvyPatternHelper.substitute(pattern, org, module, null, revision, artifact, type, ext, conf, null, extraModuleAttributes, extraArtifactAttributes);
    }

    public static String substitute(String pattern, String org, String module, String branch, String revision, String artifact, String type, String ext, String conf, ArtifactOrigin origin, Map extraModuleAttributes, Map extraArtifactAttributes) {
        String token;
        HashMap tokens = new HashMap();
        if (extraModuleAttributes != null) {
            for (Map.Entry entry : extraModuleAttributes.entrySet()) {
                token = (String)entry.getKey();
                if (token.indexOf(58) > 0) {
                    token = token.substring(token.indexOf(58) + 1);
                }
                tokens.put(token, entry.getValue());
            }
        }
        if (extraArtifactAttributes != null) {
            for (Map.Entry entry : extraArtifactAttributes.entrySet()) {
                token = (String)entry.getKey();
                if (token.indexOf(58) > 0) {
                    token = token.substring(token.indexOf(58) + 1);
                }
                tokens.put(token, entry.getValue());
            }
        }
        tokens.put(ORGANISATION_KEY, org == null ? "" : org);
        tokens.put(ORGANISATION_KEY2, org == null ? "" : org);
        tokens.put(ORGANISATION_PATH_KEY, org == null ? "" : org.replace('.', '/'));
        tokens.put(MODULE_KEY, module == null ? "" : module);
        tokens.put(BRANCH_KEY, branch == null ? "" : branch);
        tokens.put(REVISION_KEY, revision == null ? "" : revision);
        tokens.put(ARTIFACT_KEY, artifact == null ? module : artifact);
        tokens.put(TYPE_KEY, type == null ? "jar" : type);
        tokens.put(EXT_KEY, ext == null ? "jar" : ext);
        tokens.put(CONF_KEY, conf == null ? "default" : conf);
        if (origin == null) {
            tokens.put(ORIGINAL_ARTIFACTNAME_KEY, new OriginalArtifactNameValue(org, module, branch, revision, artifact, type, ext, extraModuleAttributes, extraArtifactAttributes));
        } else {
            tokens.put(ORIGINAL_ARTIFACTNAME_KEY, new OriginalArtifactNameValue(origin));
        }
        return IvyPatternHelper.substituteTokens(pattern, tokens);
    }

    public static String substituteVariables(String pattern, Map variables) {
        return IvyPatternHelper.substituteVariables(pattern, new IvyVariableContainerImpl(variables), new Stack());
    }

    public static String substituteVariables(String pattern, IvyVariableContainer variables) {
        return IvyPatternHelper.substituteVariables(pattern, variables, new Stack());
    }

    private static String substituteVariables(String pattern, IvyVariableContainer variables, Stack substituting) {
        if (pattern == null) {
            return null;
        }
        Matcher m = VAR_PATTERN.matcher(pattern);
        boolean useVariables = false;
        StringBuffer sb = null;
        while (m.find()) {
            String var;
            String val;
            if (!useVariables) {
                useVariables = true;
                sb = new StringBuffer();
            }
            if ((val = variables.getVariable(var = m.group(1))) != null) {
                int index = substituting.indexOf(var);
                if (index != -1) {
                    ArrayList<String> cycle = new ArrayList<String>(substituting.subList(index, substituting.size()));
                    cycle.add(var);
                    throw new IllegalArgumentException("cyclic variable definition: cycle = " + cycle);
                }
                substituting.push(var);
                val = IvyPatternHelper.substituteVariables(val, variables, substituting);
                substituting.pop();
            } else {
                val = m.group();
            }
            m.appendReplacement(sb, val.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$"));
        }
        if (useVariables) {
            m.appendTail(sb);
            return sb.toString();
        }
        return pattern;
    }

    public static String substituteTokens(String pattern, Map tokens) {
        HashMap tokensCopy = new HashMap(tokens);
        if (tokensCopy.containsKey(ORGANISATION_KEY) && !tokensCopy.containsKey(ORGANISATION_KEY2)) {
            tokensCopy.put(ORGANISATION_KEY2, tokensCopy.get(ORGANISATION_KEY));
        }
        if (tokensCopy.containsKey(ORGANISATION_KEY) && !tokensCopy.containsKey(ORGANISATION_PATH_KEY)) {
            String org = (String)tokensCopy.get(ORGANISATION_KEY);
            tokensCopy.put(ORGANISATION_PATH_KEY, org == null ? "" : org.replace('.', '/'));
        }
        StringBuffer buffer = new StringBuffer();
        char[] chars = pattern.toCharArray();
        StringBuffer optionalPart = null;
        StringBuffer tokenBuffer = null;
        boolean insideOptionalPart = false;
        boolean insideToken = false;
        boolean tokenSeen = false;
        boolean tokenHadValue = false;
        block6: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '(': {
                    if (insideOptionalPart) {
                        throw new IllegalArgumentException("invalid start of optional part at position " + i + " in pattern " + pattern);
                    }
                    optionalPart = new StringBuffer();
                    insideOptionalPart = true;
                    tokenSeen = false;
                    tokenHadValue = false;
                    continue block6;
                }
                case ')': {
                    if (!insideOptionalPart || insideToken) {
                        throw new IllegalArgumentException("invalid end of optional part at position " + i + " in pattern " + pattern);
                    }
                    if (tokenHadValue) {
                        buffer.append(optionalPart.toString());
                    } else if (!tokenSeen) {
                        buffer.append('(').append(optionalPart.toString()).append(')');
                    }
                    insideOptionalPart = false;
                    continue block6;
                }
                case '[': {
                    if (insideToken) {
                        throw new IllegalArgumentException("invalid start of token at position " + i + " in pattern " + pattern);
                    }
                    tokenBuffer = new StringBuffer();
                    insideToken = true;
                    continue block6;
                }
                case ']': {
                    String value;
                    if (!insideToken) {
                        throw new IllegalArgumentException("invalid end of token at position " + i + " in pattern " + pattern);
                    }
                    String token = tokenBuffer.toString();
                    Object tokenValue = tokensCopy.get(token);
                    String string = value = tokenValue == null ? null : tokenValue.toString();
                    if (insideOptionalPart) {
                        tokenHadValue = value != null && value.length() > 0;
                        optionalPart.append(value);
                    } else {
                        if (value == null) {
                            value = "[" + token + "]";
                        }
                        buffer.append(value);
                    }
                    insideToken = false;
                    tokenSeen = true;
                    continue block6;
                }
                default: {
                    if (insideToken) {
                        tokenBuffer.append(chars[i]);
                        continue block6;
                    }
                    if (insideOptionalPart) {
                        optionalPart.append(chars[i]);
                        continue block6;
                    }
                    buffer.append(chars[i]);
                }
            }
        }
        if (insideToken) {
            throw new IllegalArgumentException("last token hasn't been closed in pattern " + pattern);
        }
        if (insideOptionalPart) {
            throw new IllegalArgumentException("optional part hasn't been closed in pattern " + pattern);
        }
        return buffer.toString();
    }

    public static String substituteVariable(String pattern, String variable, String value) {
        StringBuffer buf = new StringBuffer(pattern);
        IvyPatternHelper.substituteVariable(buf, variable, value);
        return buf.toString();
    }

    public static void substituteVariable(StringBuffer buf, String variable, String value) {
        String from = "${" + variable + "}";
        int fromLength = from.length();
        int index = buf.indexOf(from);
        while (index != -1) {
            buf.replace(index, index + fromLength, value);
            index = buf.indexOf(from, index);
        }
    }

    public static String substituteToken(String pattern, String token, String value) {
        StringBuffer buf = new StringBuffer(pattern);
        IvyPatternHelper.substituteToken(buf, token, value);
        return buf.toString();
    }

    public static void substituteToken(StringBuffer buf, String token, String value) {
        String from = IvyPatternHelper.getTokenString(token);
        int fromLength = from.length();
        int index = buf.indexOf(from);
        while (index != -1) {
            buf.replace(index, index + fromLength, value);
            index = buf.indexOf(from, index);
        }
    }

    public static String getTokenString(String token) {
        return "[" + token + "]";
    }

    public static String substituteParams(String pattern, Map params) {
        return IvyPatternHelper.substituteParams(pattern, new IvyVariableContainerImpl(params), new Stack());
    }

    private static String substituteParams(String pattern, IvyVariableContainer params, Stack substituting) {
        if (pattern == null) {
            return null;
        }
        Matcher m = PARAM_PATTERN.matcher(pattern);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String var = m.group(1);
            String val = params.getVariable(var);
            if (val != null) {
                int index = substituting.indexOf(var);
                if (index != -1) {
                    ArrayList<String> cycle = new ArrayList<String>(substituting.subList(index, substituting.size()));
                    cycle.add(var);
                    throw new IllegalArgumentException("cyclic param definition: cycle = " + cycle);
                }
                substituting.push(var);
                val = IvyPatternHelper.substituteVariables(val, params, substituting);
                substituting.pop();
            } else {
                val = m.group();
            }
            m.appendReplacement(sb, val.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\@", "\\\\\\@"));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String getTokenRoot(String pattern) {
        int index = pattern.indexOf(91);
        if (index == -1) {
            return pattern;
        }
        int optionalIndex = pattern.indexOf(40);
        if (optionalIndex >= 0) {
            index = Math.min(index, optionalIndex);
        }
        return pattern.substring(0, index);
    }

    public static String getFirstToken(String pattern) {
        if (pattern == null) {
            return null;
        }
        int startIndex = pattern.indexOf(91);
        if (startIndex == -1) {
            return null;
        }
        int endIndex = pattern.indexOf(93, startIndex);
        if (endIndex == -1) {
            return null;
        }
        return pattern.substring(startIndex + 1, endIndex);
    }

    private static class OriginalArtifactNameValue {
        private String org;
        private String moduleName;
        private String branch;
        private String revision;
        private Map extraModuleAttributes;
        private String artifactName;
        private String artifactType;
        private String artifactExt;
        private Map extraArtifactAttributes;
        private ArtifactOrigin origin;

        public OriginalArtifactNameValue(String org, String moduleName, String branch, String revision, String artifactName, String artifactType, String artifactExt, Map extraModuleAttributes, Map extraArtifactAttributes) {
            this.org = org;
            this.moduleName = moduleName;
            this.branch = branch;
            this.revision = revision;
            this.artifactName = artifactName;
            this.artifactType = artifactType;
            this.artifactExt = artifactExt;
            this.extraModuleAttributes = extraModuleAttributes;
            this.extraArtifactAttributes = extraArtifactAttributes;
        }

        public OriginalArtifactNameValue(ArtifactOrigin origin) {
            this.origin = origin;
        }

        public String toString() {
            if (this.origin == null) {
                ModuleRevisionId revId = ModuleRevisionId.newInstance(this.org, this.moduleName, this.branch, this.revision, this.extraModuleAttributes);
                DefaultArtifact artifact = new DefaultArtifact(revId, null, this.artifactName, this.artifactType, this.artifactExt, this.extraArtifactAttributes);
                RepositoryCacheManager cacheManager = IvyContext.getContext().getSettings().getResolver(revId).getRepositoryCacheManager();
                this.origin = cacheManager.getSavedArtifactOrigin(artifact);
                if (ArtifactOrigin.isUnknown(this.origin)) {
                    Message.debug("no artifact origin found for " + artifact + " in " + cacheManager);
                    return null;
                }
            }
            if (ArtifactOrigin.isUnknown(this.origin)) {
                return null;
            }
            String location = this.origin.getLocation();
            int lastPathIndex = location.lastIndexOf(47);
            if (lastPathIndex == -1) {
                lastPathIndex = location.lastIndexOf(92);
            }
            int lastColonIndex = location.lastIndexOf(46);
            return location.substring(lastPathIndex + 1, lastColonIndex);
        }
    }
}

