/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Revision
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Kind revKind;
    public static final Revision HEAD = new Revision(Kind.head);
    public static final Revision START = new Revision(Kind.unspecified);
    public static final Revision COMMITTED = new Revision(Kind.committed);
    public static final Revision PREVIOUS = new Revision(Kind.previous);
    public static final Revision BASE = new Revision(Kind.base);
    public static final Revision WORKING = new Revision(Kind.working);
    public static final int SVN_INVALID_REVNUM = -1;

    public Revision(Kind kind) {
        if (kind.ordinal() < Kind.unspecified.ordinal() || kind.ordinal() > Kind.head.ordinal()) {
            throw new IllegalArgumentException((Object)((Object)kind) + " is not a legal revision kind");
        }
        this.revKind = kind;
    }

    public Kind getKind() {
        return this.revKind;
    }

    public String toString() {
        switch (this.revKind) {
            case base: {
                return "BASE";
            }
            case committed: {
                return "COMMITTED";
            }
            case head: {
                return "HEAD";
            }
            case previous: {
                return "PREV";
            }
            case working: {
                return "WORKING";
            }
        }
        return super.toString();
    }

    public int hashCode() {
        return this.revKind.ordinal() * -1;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof Revision)) {
            return false;
        }
        return ((Revision)target).revKind == this.revKind;
    }

    public static Revision getInstance(long revisionNumber) {
        return new Number(revisionNumber);
    }

    static Number createNumber(long revNumber) {
        return revNumber < 0L ? null : new Number(revNumber);
    }

    public static Revision getInstance(Date revisionDate) {
        return new DateSpec(revisionDate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        unspecified,
        number,
        date,
        committed,
        previous,
        base,
        working,
        head;

    }

    public static class DateSpec
    extends Revision {
        private static final long serialVersionUID = 1L;
        protected Date revDate;

        public DateSpec(Date date) {
            super(Kind.date);
            if (date == null) {
                throw new IllegalArgumentException("a date must be specified");
            }
            this.revDate = date;
        }

        public Date getDate() {
            return this.revDate;
        }

        public String toString() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
            return '{' + dateFormat.format(this.revDate) + '}';
        }

        public boolean equals(Object target) {
            if (!super.equals(target)) {
                return false;
            }
            return ((DateSpec)target).revDate.equals(this.revDate);
        }

        public int hashCode() {
            return this.revDate.hashCode();
        }
    }

    public static class Number
    extends Revision {
        private static final long serialVersionUID = 1L;
        protected long revNumber;

        public Number(long number) {
            super(Kind.number);
            if (number < 0L) {
                throw new IllegalArgumentException("Invalid (negative) revision number: " + number);
            }
            this.revNumber = number;
        }

        public long getNumber() {
            return this.revNumber;
        }

        public String toString() {
            return Long.toString(this.revNumber);
        }

        public boolean equals(Object target) {
            if (!super.equals(target)) {
                return false;
            }
            return ((Number)target).revNumber == this.revNumber;
        }

        public int hashCode() {
            return (int)(this.revNumber ^ this.revNumber >>> 32);
        }
    }
}

