/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.references.MavenFilteredPropertyPsiReference;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;

public class MavenFilteredPropertyPsiReferenceProvider
extends PsiReferenceProvider {
    private static final Key<Pattern> KEY = Key.create((String)"MavenFilteredPropertyPsiReferenceProvider:delimitersKey");
    public static final Pattern DEFAULT_DELIMITERS = MavenPropertyResolver.PATTERN;

    @NotNull
    public static Pattern getDelimitersPattern(MavenProject mavenProject) {
        Pattern res = mavenProject.getCachedValue(KEY);
        if (res == null) {
            Element cfg = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
            if (cfg == null) {
                res = DEFAULT_DELIMITERS;
            } else {
                List<String> delimiters = MavenJDOMUtil.findChildrenValuesByPath(cfg, "delimiters", "delimiter");
                if (delimiters.isEmpty() || delimiters.size() > 10) {
                    res = DEFAULT_DELIMITERS;
                } else {
                    StringBuilder patternBuilder = new StringBuilder();
                    for (String delimiter : delimiters) {
                        if ((delimiter = delimiter.trim()).isEmpty()) continue;
                        int ind = delimiter.indexOf(42);
                        if (ind >= 0) {
                            MavenFilteredPropertyPsiReferenceProvider.appendDelimiter(patternBuilder, delimiter.substring(0, ind), delimiter.substring(ind + 1));
                            continue;
                        }
                        MavenFilteredPropertyPsiReferenceProvider.appendDelimiter(patternBuilder, delimiter, delimiter);
                    }
                    boolean useDefaultDelimiters = true;
                    String useDefaultDelimitersText = cfg.getChildText("useDefaultDelimiters");
                    if (StringUtil.isNotEmpty((String)useDefaultDelimitersText)) {
                        useDefaultDelimiters = Boolean.parseBoolean(useDefaultDelimitersText);
                    }
                    if (useDefaultDelimiters) {
                        MavenFilteredPropertyPsiReferenceProvider.appendDelimiter(patternBuilder, "${", "}");
                        MavenFilteredPropertyPsiReferenceProvider.appendDelimiter(patternBuilder, "@", "@");
                    }
                    res = Pattern.compile(patternBuilder.toString());
                }
            }
            res = mavenProject.putCachedValue(KEY, res);
        }
        Pattern pattern = res;
        if (pattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenFilteredPropertyPsiReferenceProvider", "getDelimitersPattern"));
        }
        return pattern;
    }

    private static void appendDelimiter(StringBuilder pattern, String prefix, String suffix) {
        if (pattern.length() > 0) {
            pattern.append('|');
        }
        pattern.append(Pattern.quote(prefix)).append("(.+?)").append(Pattern.quote(suffix));
    }

    private static boolean shouldAddReference(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/dom/references/MavenFilteredPropertyPsiReferenceProvider", "shouldAddReference"));
        }
        if (element.getFirstChild() == element.getLastChild()) {
            return true;
        }
        return element instanceof XmlAttribute;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/dom/references/MavenFilteredPropertyPsiReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/maven/dom/references/MavenFilteredPropertyPsiReferenceProvider", "getReferencesByElement"));
        }
        if (!MavenFilteredPropertyPsiReferenceProvider.shouldAddReference(element)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenFilteredPropertyPsiReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (!MavenDomUtil.isFilteredResourceFile(element)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenFilteredPropertyPsiReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String text = element.getText();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenFilteredPropertyPsiReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        MavenProject mavenProject = MavenDomUtil.findContainingProject(element);
        if (mavenProject == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenFilteredPropertyPsiReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<MavenFilteredPropertyPsiReference> res = null;
        Pattern pattern = MavenFilteredPropertyPsiReferenceProvider.getDelimitersPattern(mavenProject);
        Matcher matcher = pattern.matcher(text);
        int groupCount = matcher.groupCount();
        while (matcher.find()) {
            String propertyName = null;
            int from = 0;
            for (int i = 0; i < groupCount; ++i) {
                propertyName = matcher.group(i + 1);
                if (propertyName == null) continue;
                from = matcher.start(i + 1);
                break;
            }
            assert (propertyName != null);
            if (res == null) {
                res = new ArrayList<MavenFilteredPropertyPsiReference>();
            }
            TextRange range = TextRange.from((int)from, (int)propertyName.length());
            res.add(new MavenFilteredPropertyPsiReference(mavenProject, element, propertyName, range));
        }
        PsiReference[] psiReferenceArray = res == null ? PsiReference.EMPTY_ARRAY : res.toArray(new PsiReference[res.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenFilteredPropertyPsiReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

