/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.ActionType;
import org.jetbrains.idea.devkit.util.ComponentType;

public class DescriptorUtil {
    public static void processComponents(XmlTag root, ComponentType.Processor processor) {
        ComponentType[] types;
        for (ComponentType type : types = ComponentType.values()) {
            type.process(root, processor);
        }
    }

    public static void processActions(XmlTag root, ActionType.Processor processor) {
        ActionType[] types;
        for (ActionType type : types = ActionType.values()) {
            type.process(root, processor);
        }
    }

    public static void patchPluginXml(Patcher patcher, PsiClass klass, XmlFile ... pluginXmls) throws IncorrectOperationException {
        VirtualFile[] files = new VirtualFile[pluginXmls.length];
        int i = 0;
        for (XmlFile pluginXml : pluginXmls) {
            files[i++] = pluginXml.getVirtualFile();
        }
        ReadonlyStatusHandler readonlyStatusHandler = ReadonlyStatusHandler.getInstance((Project)klass.getProject());
        ReadonlyStatusHandler.OperationStatus status = readonlyStatusHandler.ensureFilesWritable(files);
        if (status.hasReadonlyFiles()) {
            throw new IncorrectOperationException(DevKitBundle.message("error.plugin.xml.readonly", new Object[0]));
        }
        for (XmlFile pluginXml : pluginXmls) {
            patcher.patchPluginXml(pluginXml, klass);
        }
    }

    @Nullable
    public static String getPluginId(Module plugin) {
        assert (PluginModuleType.isOfType(plugin));
        XmlFile pluginXml = PluginModuleType.getPluginXml(plugin);
        if (pluginXml == null) {
            return null;
        }
        DomFileElement<IdeaPlugin> ideaPlugin = DescriptorUtil.getIdeaPlugin(pluginXml);
        if (ideaPlugin == null) {
            return null;
        }
        return ((IdeaPlugin)ideaPlugin.getRootElement()).getPluginId();
    }

    public static boolean isPluginXml(PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return false;
        }
        return DescriptorUtil.getIdeaPlugin((XmlFile)file) != null;
    }

    @Nullable
    public static DomFileElement<IdeaPlugin> getIdeaPlugin(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/devkit/util/DescriptorUtil", "getIdeaPlugin"));
        }
        return DomManager.getDomManager((Project)file.getProject()).getFileElement(file, IdeaPlugin.class);
    }

    public static interface Patcher {
        public void patchPluginXml(XmlFile var1, PsiClass var2) throws IncorrectOperationException;
    }
}

