/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.overrideImplement;

import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideMemberChooserObject;
import org.jetbrains.kotlin.idea.core.overrideImplement.OverrideMemberChooserObjectKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"OVERRIDE_RENDERER", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "generateConstructorParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "generateFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "bodyType", "Lorg/jetbrains/kotlin/idea/core/overrideImplement/OverrideMemberChooserObject$BodyType;", "generateProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "generateUnsupportedOrSuperCall", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "generateMember", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lorg/jetbrains/kotlin/idea/core/overrideImplement/OverrideMemberChooserObject;", "idea-core"})
public final class OverrideMemberChooserObjectKt {
    private static final DescriptorRenderer OVERRIDE_RENDERER = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)OVERRIDE_RENDERER.1.INSTANCE));

    @NotNull
    public static final KtCallableDeclaration generateMember(@NotNull OverrideMemberChooserObject $receiver, @NotNull Project project) {
        KtCallableDeclaration ktCallableDeclaration;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        CallableMemberDescriptor descriptor2 = $receiver.getImmediateSuper();
        if ($receiver.getPreferConstructorParameter() && descriptor2 instanceof PropertyDescriptor) {
            return OverrideMemberChooserObjectKt.generateConstructorParameter(project, (PropertyDescriptor)descriptor2);
        }
        CallableMemberDescriptor callableMemberDescriptor = descriptor2;
        if (callableMemberDescriptor instanceof SimpleFunctionDescriptor) {
            ktCallableDeclaration = OverrideMemberChooserObjectKt.generateFunction(project, (FunctionDescriptor)descriptor2, $receiver.getBodyType());
        } else if (callableMemberDescriptor instanceof PropertyDescriptor) {
            ktCallableDeclaration = OverrideMemberChooserObjectKt.generateProperty(project, (PropertyDescriptor)descriptor2, $receiver.getBodyType());
        } else {
            String string = "Unknown member to override: " + descriptor2;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return ktCallableDeclaration;
    }

    private static final KtProperty generateProperty(Project project, PropertyDescriptor descriptor2, OverrideMemberChooserObject.BodyType bodyType) {
        CallableMemberDescriptor callableMemberDescriptor = descriptor2.copy(descriptor2.getContainingDeclaration(), Modality.OPEN, descriptor2.getVisibility(), descriptor2.getKind(), true);
        if (callableMemberDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
        }
        PropertyDescriptor newDescriptor = (PropertyDescriptor)callableMemberDescriptor;
        DescriptorUtilsKt.setSingleOverridden(newDescriptor, descriptor2);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder $receiver = stringBuilder;
        $receiver.append("\nget()");
        $receiver.append(" = ");
        $receiver.append(OverrideMemberChooserObjectKt.generateUnsupportedOrSuperCall(descriptor2, bodyType));
        if (descriptor2.isVar()) {
            $receiver.append("\nset(value) {}");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String body2 = string;
        return new KtPsiFactory(project).createProperty(OVERRIDE_RENDERER.render(newDescriptor) + body2);
    }

    private static final KtParameter generateConstructorParameter(Project project, PropertyDescriptor descriptor2) {
        CallableMemberDescriptor callableMemberDescriptor = descriptor2.copy(descriptor2.getContainingDeclaration(), Modality.OPEN, descriptor2.getVisibility(), descriptor2.getKind(), true);
        if (callableMemberDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
        }
        PropertyDescriptor newDescriptor = (PropertyDescriptor)callableMemberDescriptor;
        DescriptorUtilsKt.setSingleOverridden(newDescriptor, descriptor2);
        return new KtPsiFactory(project).createParameter(OVERRIDE_RENDERER.render(newDescriptor));
    }

    private static final KtNamedFunction generateFunction(Project project, FunctionDescriptor descriptor2, OverrideMemberChooserObject.BodyType bodyType) {
        FunctionDescriptor newDescriptor = descriptor2.copy(descriptor2.getContainingDeclaration(), Modality.OPEN, descriptor2.getVisibility(), descriptor2.getKind(), true);
        DescriptorUtilsKt.setSingleOverridden(newDescriptor, descriptor2);
        KotlinType returnType2 = descriptor2.getReturnType();
        boolean returnsNotUnit = returnType2 != null && !KotlinBuiltIns.isUnit(returnType2);
        String delegation = OverrideMemberChooserObjectKt.generateUnsupportedOrSuperCall(descriptor2, bodyType);
        String body2 = "{" + (returnsNotUnit && Intrinsics.areEqual((Object)((Object)bodyType), (Object)((Object)OverrideMemberChooserObject.BodyType.EMPTY)) ^ true ? "return " : "") + delegation + "}";
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project);
        StringBuilder stringBuilder = new StringBuilder();
        DeclarationDescriptor declarationDescriptor = newDescriptor;
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"newDescriptor");
        return ktPsiFactory.createFunction(stringBuilder.append(OVERRIDE_RENDERER.render(declarationDescriptor)).append(body2).toString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String generateUnsupportedOrSuperCall(@NotNull CallableMemberDescriptor descriptor2, @NotNull OverrideMemberChooserObject.BodyType bodyType) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)bodyType), (String)"bodyType");
        if (Intrinsics.areEqual((Object)((Object)bodyType), (Object)((Object)OverrideMemberChooserObject.BodyType.EMPTY))) {
            return "throw UnsupportedOperationException()";
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder $receiver = stringBuilder;
        $receiver.append("super");
        if (Intrinsics.areEqual((Object)((Object)bodyType), (Object)((Object)OverrideMemberChooserObject.BodyType.QUALIFIED_SUPER))) {
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassifierDescriptor");
            }
            String superClassFqName = IdeDescriptorRenderers.SOURCE_CODE.renderClassifierName((ClassifierDescriptor)declarationDescriptor);
            $receiver.append("<").append(superClassFqName).append(">");
        }
        $receiver.append(".").append(RenderingUtilsKt.render(descriptor2.getName()));
        if (descriptor2 instanceof FunctionDescriptor) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = ((FunctionDescriptor)descriptor2).getValueParameters();
            void var6_6 = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                void var11_11 = destination$iv$iv;
                String renderedName = RenderingUtilsKt.render(it.getName());
                String string = it.getVarargElementType() != null ? "*" + renderedName : renderedName;
                var11_11.add(string);
            }
            List paramTexts = (List)destination$iv$iv;
            CollectionsKt.joinTo$default((Iterable)paramTexts, (Appendable)$receiver, null, (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)114, null);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

