/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.CollectingNameValidator;
import org.jetbrains.kotlin.idea.quickfix.AddFunctionParametersFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionSignatureFix;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMutableMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinTypeInfo;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0002J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00070\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\"\u0010!\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddFunctionParametersFix;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionSignatureFix;", "callElement", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "hasTypeMismatches", "", "(Lorg/jetbrains/kotlin/psi/KtCallElement;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Z)V", "typesToShorten", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/types/KotlinType;", "addParameterConfiguration", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureConfiguration;", "getNewParameterInfo", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinParameterInfo;", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "validator", "Lkotlin/Function1;", "", "getText", "hasOtherUsages", "function", "Lcom/intellij/psi/PsiElement;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Lcom/intellij/psi/PsiFile;", "isConstructor", "idea"})
public final class AddFunctionParametersFix
extends ChangeFunctionSignatureFix {
    private final ArrayList<KotlinType> typesToShorten;
    private final KtCallElement callElement;
    private final boolean hasTypeMismatches;

    @NotNull
    public String getText() {
        String string;
        String subjectSuffix;
        Unit unit;
        List<ValueParameterDescriptor> parameters2 = this.getFunctionDescriptor().getValueParameters();
        List<? extends ValueArgument> arguments2 = this.callElement.getValueArguments();
        int newParametersCnt = arguments2.size() - parameters2.size();
        boolean bl = newParametersCnt > 0;
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        String string3 = subjectSuffix = newParametersCnt > 1 ? "s" : "";
        if (this.isConstructor()) {
            String className = this.getFunctionDescriptor().getContainingDeclaration().getName().asString();
            string = "constructor '" + className + "'";
        } else {
            String functionName2 = this.getFunctionDescriptor().getName().asString();
            string = "function '" + functionName2 + "'";
        }
        String callableDescription = string;
        return this.hasTypeMismatches ? "Change the signature of " + callableDescription : "Add parameter" + subjectSuffix + " to " + callableDescription;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        int newParametersCnt = this.callElement.getValueArguments().size() - this.getFunctionDescriptor().getValueParameters().size();
        return newParametersCnt > 0;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KotlinChangeSignatureKt.runChangeSignature(project, this.getFunctionDescriptor(), this.addParameterConfiguration(), (PsiElement)this.callElement, this.getText());
    }

    private final KotlinChangeSignatureConfiguration addParameterConfiguration() {
        return new KotlinChangeSignatureConfiguration(this){
            final /* synthetic */ AddFunctionParametersFix this$0;

            @NotNull
            public KotlinMethodDescriptor configure(@NotNull KotlinMethodDescriptor originalDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)originalDescriptor, (String)"originalDescriptor");
                return KotlinChangeSignatureKt.modify(originalDescriptor, (Function1<? super KotlinMutableMethodDescriptor, Unit>)((Function1)new Function1<KotlinMutableMethodDescriptor, Unit>(this, originalDescriptor){
                    final /* synthetic */ addParameterConfiguration.1 this$0;
                    final /* synthetic */ KotlinMethodDescriptor $originalDescriptor;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull KotlinMutableMethodDescriptor it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        List<ValueParameterDescriptor> parameters2 = this.this$0.this$0.getFunctionDescriptor().getValueParameters();
                        List<? extends ValueArgument> arguments2 = AddFunctionParametersFix.access$getCallElement$p(this.this$0.this$0).getValueArguments();
                        CollectingNameValidator validator2 = new CollectingNameValidator(null, null, 3, null);
                        IntRange intRange = CollectionsKt.getIndices((Collection)arguments2);
                        int n = intRange.getFirst();
                        int n2 = intRange.getLast();
                        if (n <= n2) {
                            while (true) {
                                Object it2;
                                Object object;
                                void i;
                                ValueArgument argument2 = arguments2.get((int)i);
                                KtExpression expression2 = argument2.getArgumentExpression();
                                if (i < parameters2.size()) {
                                    KotlinType kotlinType;
                                    String string = parameters2.get((int)i).getName().asString();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parameters[i].name.asString()");
                                    validator2.addName(string);
                                    if (expression2 != null) {
                                        it2 = object;
                                        BindingContext bindingContext2 = ResolutionUtils.analyze$default((KtElement)it2, null, 1, null);
                                        KotlinType kotlinType2 = (KotlinType)bindingContext2.get(BindingContext.SMARTCAST, it2);
                                        if (kotlinType2 == null) {
                                            kotlinType2 = bindingContext2.getType((KtExpression)it2);
                                        }
                                        kotlinType = kotlinType2;
                                    } else {
                                        kotlinType = null;
                                    }
                                    KotlinType argumentType = kotlinType;
                                    KotlinType parameterType = parameters2.get((int)i).getType();
                                    if (argumentType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(argumentType, parameterType)) {
                                        it.getParameters().get((int)i).setCurrentTypeInfo(new KotlinTypeInfo(false, argumentType, null, 4, null));
                                        AddFunctionParametersFix.access$getTypesToShorten$p(this.this$0.this$0).add(argumentType);
                                    }
                                } else {
                                    Boolean bl;
                                    AddFunctionParametersFix addFunctionParametersFix = this.this$0.this$0;
                                    CallableDescriptor callableDescriptor = this.$originalDescriptor.getBaseDescriptor();
                                    if (callableDescriptor == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                                    }
                                    FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor;
                                    ValueArgument valueArgument = argument2;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)valueArgument, (String)"argument");
                                    KotlinParameterInfo parameterInfo = AddFunctionParametersFix.access$getNewParameterInfo(addFunctionParametersFix, functionDescriptor, valueArgument, validator2);
                                    if (parameterInfo.getOriginalTypeInfo().getType() != null) {
                                        it2 = (KotlinType)object;
                                        bl = AddFunctionParametersFix.access$getTypesToShorten$p(this.this$0.this$0).add(it2);
                                    } else {
                                        bl = null;
                                    }
                                    if (expression2 != null) {
                                        parameterInfo.setDefaultValueForCall(expression2);
                                    }
                                    it.addParameter(parameterInfo);
                                }
                                if (i == n2) break;
                                ++i;
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$originalDescriptor = kotlinMethodDescriptor;
                        super(1);
                    }
                }));
            }

            public boolean performSilently(@NotNull Collection<? extends PsiElement> affectedFunctions) {
                Intrinsics.checkParameterIsNotNull(affectedFunctions, (String)"affectedFunctions");
                PsiElement psiElement = (PsiElement)CollectionsKt.singleOrNull((Iterable)affectedFunctions);
                if (psiElement == null) {
                    return false;
                }
                PsiElement onlyFunction = psiElement;
                return !AddFunctionParametersFix.access$getHasTypeMismatches$p(this.this$0) && !AddFunctionParametersFix.access$isConstructor(this.this$0) && !AddFunctionParametersFix.access$hasOtherUsages(this.this$0, onlyFunction);
            }
            {
                this.this$0 = $outer;
            }

            public boolean forcePerformForSelectedFunctionOnly() {
                return KotlinChangeSignatureConfiguration.DefaultImpls.forcePerformForSelectedFunctionOnly(this);
            }
        };
    }

    private final KotlinParameterInfo getNewParameterInfo(FunctionDescriptor functionDescriptor, ValueArgument argument2, Function1<? super String, Boolean> validator2) {
        Object object;
        Object object2;
        String name2;
        block3: {
            block2: {
                name2 = this.getNewArgumentName(argument2, validator2);
                KtExpression expression2 = argument2.getArgumentExpression();
                object2 = expression2;
                if (object2 == null) break block2;
                object = object2;
                Object it = object;
                object2 = ResolutionUtils.analyze$default((KtElement)it, null, 1, null).getType((KtExpression)it);
                if (object2 != null) break block3;
            }
            object2 = DescriptorUtilsKt.getBuiltIns(functionDescriptor).getNullableAnyType();
        }
        Object type2 = object2;
        object = new KotlinParameterInfo(functionDescriptor, -1, name2, new KotlinTypeInfo(false, null, null, 4, null), null, null, null, null, 240, null);
        KotlinParameterInfo $receiver = (KotlinParameterInfo)object;
        $receiver.setCurrentTypeInfo(new KotlinTypeInfo(false, (KotlinType)type2, null, 4, null));
        return (KotlinParameterInfo)object;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasOtherUsages(PsiElement function2) {
        boolean bl;
        block1: {
            Iterable $receiver$iv = (Iterable)ReferencesSearch.search((PsiElement)function2);
            for (Object element$iv : $receiver$iv) {
                void strict$iv;
                void $receiver$iv2;
                PsiReference it = (PsiReference)element$iv;
                PsiElement psiElement = it.getElement();
                boolean bl2 = false;
                KtCallElement call = (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtCallElement.class, (boolean)strict$iv);
                if (!(call != null && Intrinsics.areEqual((Object)this.callElement, (Object)call) ^ true)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isConstructor() {
        return this.getFunctionDescriptor() instanceof ConstructorDescriptor;
    }

    public AddFunctionParametersFix(@NotNull KtCallElement callElement2, @NotNull FunctionDescriptor functionDescriptor, boolean hasTypeMismatches) {
        Intrinsics.checkParameterIsNotNull((Object)callElement2, (String)"callElement");
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        super((PsiElement)callElement2, functionDescriptor);
        this.callElement = callElement2;
        this.hasTypeMismatches = hasTypeMismatches;
        this.typesToShorten = new ArrayList();
    }

    @NotNull
    public static final /* synthetic */ KtCallElement access$getCallElement$p(AddFunctionParametersFix $this) {
        return $this.callElement;
    }

    @NotNull
    public static final /* synthetic */ ArrayList access$getTypesToShorten$p(AddFunctionParametersFix $this) {
        return $this.typesToShorten;
    }

    @NotNull
    public static final /* synthetic */ KotlinParameterInfo access$getNewParameterInfo(AddFunctionParametersFix $this, @NotNull FunctionDescriptor functionDescriptor, @NotNull ValueArgument argument2, @NotNull Function1 validator2) {
        return $this.getNewParameterInfo(functionDescriptor, argument2, (Function1<? super String, Boolean>)validator2);
    }

    public static final /* synthetic */ boolean access$getHasTypeMismatches$p(AddFunctionParametersFix $this) {
        return $this.hasTypeMismatches;
    }

    public static final /* synthetic */ boolean access$isConstructor(AddFunctionParametersFix $this) {
        return $this.isConstructor();
    }

    public static final /* synthetic */ boolean access$hasOtherUsages(AddFunctionParametersFix $this, @NotNull PsiElement function2) {
        return $this.hasOtherUsages(function2);
    }
}

