/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\"\u0010\u0012\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableMutabilityFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtValVarKeywordOwner;", "element", "makeVar", "", "(Lorg/jetbrains/kotlin/psi/KtValVarKeywordOwner;Z)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Lcom/intellij/psi/PsiFile;", "Companion", "idea"})
public final class ChangeVariableMutabilityFix
extends KotlinQuickFixAction<KtValVarKeywordOwner> {
    private final boolean makeVar;
    @NotNull
    private static final KotlinSingleIntentionActionFactory VAL_WITH_SETTER_FACTORY;
    @NotNull
    private static final Companion.ReassignmentActionFactory VAL_REASSIGNMENT_FACTORY;
    @NotNull
    private static final Companion.ReassignmentActionFactory CAPTURED_VAL_INITIALIZATION_FACTORY;
    @NotNull
    private static final KotlinSingleIntentionActionFactory VAR_OVERRIDDEN_BY_VAL_FACTORY;
    public static final Companion Companion;

    @NotNull
    public String getText() {
        return this.makeVar ? "Make variable mutable" : "Make variable immutable";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        PsiElement psiElement = ((KtValVarKeywordOwner)this.getElement()).getValOrVarKeyword();
        if (psiElement == null || (psiElement = psiElement.getNode()) == null || (psiElement = psiElement.getElementType()) == null) {
            return false;
        }
        PsiElement valOrVar = psiElement;
        return Intrinsics.areEqual((Object)valOrVar, (Object)((Object)KtTokens.VAR_KEYWORD)) != this.makeVar;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtPsiFactory factory2 = new KtPsiFactory(project);
        PsiElement newKeyword = this.makeVar ? factory2.createVarKeyword() : factory2.createValKeyword();
        PsiElement psiElement = ((KtValVarKeywordOwner)this.getElement()).getValOrVarKeyword();
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        psiElement.replace(newKeyword);
    }

    public ChangeVariableMutabilityFix(@NotNull KtValVarKeywordOwner element2, boolean makeVar) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        super((PsiElement)element2);
        this.makeVar = makeVar;
    }

    static {
        Companion = new Companion(null);
        VAL_WITH_SETTER_FACTORY = new KotlinSingleIntentionActionFactory(){

            @Nullable
            protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                PsiElement psiElement = diagnostic.getPsiElement();
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPropertyAccessor");
                }
                KtPropertyAccessor accessor = (KtPropertyAccessor)psiElement;
                KtValVarKeywordOwner ktValVarKeywordOwner = accessor.getProperty();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktValVarKeywordOwner, (String)"accessor.property");
                return new ChangeVariableMutabilityFix(ktValVarKeywordOwner, true);
            }
        };
        DiagnosticFactory1<KtExpression, DeclarationDescriptor> diagnosticFactory1 = Errors.VAL_REASSIGNMENT;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory1, (String)"Errors.VAL_REASSIGNMENT");
        VAL_REASSIGNMENT_FACTORY = new Companion.ReassignmentActionFactory(diagnosticFactory1);
        DiagnosticFactory1<KtExpression, DeclarationDescriptor> diagnosticFactory12 = Errors.CAPTURED_VAL_INITIALIZATION;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory12, (String)"Errors.CAPTURED_VAL_INITIALIZATION");
        CAPTURED_VAL_INITIALIZATION_FACTORY = new Companion.ReassignmentActionFactory(diagnosticFactory12);
        VAR_OVERRIDDEN_BY_VAL_FACTORY = new KotlinSingleIntentionActionFactory(){

            @Nullable
            protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                IntentionAction intentionAction;
                PsiElement element2;
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                PsiElement psiElement = element2 = diagnostic.getPsiElement();
                if (psiElement instanceof KtProperty || psiElement instanceof KtParameter) {
                    PsiElement psiElement2 = element2;
                    if (psiElement2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtValVarKeywordOwner");
                    }
                    intentionAction = new ChangeVariableMutabilityFix((KtValVarKeywordOwner)psiElement2, true);
                } else {
                    intentionAction = null;
                }
                return intentionAction;
            }
        };
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableMutabilityFix$Companion;", "", "()V", "CAPTURED_VAL_INITIALIZATION_FACTORY", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableMutabilityFix$Companion$ReassignmentActionFactory;", "getCAPTURED_VAL_INITIALIZATION_FACTORY", "()Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableMutabilityFix$Companion$ReassignmentActionFactory;", "VAL_REASSIGNMENT_FACTORY", "getVAL_REASSIGNMENT_FACTORY", "VAL_WITH_SETTER_FACTORY", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "getVAL_WITH_SETTER_FACTORY", "()Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "VAR_OVERRIDDEN_BY_VAL_FACTORY", "getVAR_OVERRIDDEN_BY_VAL_FACTORY", "ReassignmentActionFactory", "idea"})
    public static final class Companion {
        @NotNull
        public final KotlinSingleIntentionActionFactory getVAL_WITH_SETTER_FACTORY() {
            return VAL_WITH_SETTER_FACTORY;
        }

        @NotNull
        public final ReassignmentActionFactory getVAL_REASSIGNMENT_FACTORY() {
            return VAL_REASSIGNMENT_FACTORY;
        }

        @NotNull
        public final ReassignmentActionFactory getCAPTURED_VAL_INITIALIZATION_FACTORY() {
            return CAPTURED_VAL_INITIALIZATION_FACTORY;
        }

        @NotNull
        public final KotlinSingleIntentionActionFactory getVAR_OVERRIDDEN_BY_VAL_FACTORY() {
            return VAR_OVERRIDDEN_BY_VAL_FACTORY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u001b\u0010\u0002\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableMutabilityFix$Companion$ReassignmentActionFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;)V", "getFactory", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
        public static final class ReassignmentActionFactory
        extends KotlinSingleIntentionActionFactory {
            @NotNull
            private final DiagnosticFactory1<?, DeclarationDescriptor> factory;

            @Override
            @Nullable
            protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                DeclarationDescriptor propertyDescriptor;
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                DeclarationDescriptor declarationDescriptor = propertyDescriptor = (DeclarationDescriptor)((DiagnosticWithParameters1)this.factory.cast(diagnostic)).getA();
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"propertyDescriptor");
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
                if (!(psiElement instanceof KtValVarKeywordOwner)) {
                    psiElement = null;
                }
                KtValVarKeywordOwner ktValVarKeywordOwner = (KtValVarKeywordOwner)psiElement;
                if (ktValVarKeywordOwner == null) {
                    return null;
                }
                KtValVarKeywordOwner declaration = ktValVarKeywordOwner;
                return new ChangeVariableMutabilityFix(declaration, true);
            }

            @NotNull
            public final DiagnosticFactory1<?, DeclarationDescriptor> getFactory() {
                return this.factory;
            }

            public ReassignmentActionFactory(@NotNull DiagnosticFactory1<?, DeclarationDescriptor> factory2) {
                Intrinsics.checkParameterIsNotNull(factory2, (String)"factory");
                this.factory = factory2;
            }
        }
    }
}

