/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.google.common.collect.ImmutableMap;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.AbstractKotlinParsing;
import org.jetbrains.kotlin.parsing.KotlinParsing;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilder;

public class KotlinExpressionParsing
extends AbstractKotlinParsing {
    private static final TokenSet WHEN_CONDITION_RECOVERY_SET;
    private static final TokenSet WHEN_CONDITION_RECOVERY_SET_WITH_ARROW;
    private static final ImmutableMap<String, KtToken> KEYWORD_TEXTS;
    private static final TokenSet TYPE_ARGUMENT_LIST_STOPPERS;
    static final TokenSet EXPRESSION_FIRST;
    private static final TokenSet STATEMENT_FIRST;
    private static final TokenSet STATEMENT_NEW_LINE_QUICK_RECOVERY_SET;
    static final TokenSet EXPRESSION_FOLLOW;
    public static final TokenSet ALLOW_NEWLINE_OPERATIONS;
    public static final TokenSet ALL_OPERATIONS;
    private final KotlinParsing myKotlinParsing;

    private static ImmutableMap<String, KtToken> tokenSetToMap(TokenSet tokens2) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (IElementType token : tokens2.getTypes()) {
            builder.put((Object)token.toString(), (Object)((KtToken)token));
        }
        return builder.build();
    }

    public KotlinExpressionParsing(SemanticWhitespaceAwarePsiBuilder builder, KotlinParsing kotlinParsing) {
        super(builder);
        this.myKotlinParsing = kotlinParsing;
    }

    public void parseExpression() {
        if (!this.atSet(EXPRESSION_FIRST)) {
            this.error("Expecting an expression");
            return;
        }
        this.parseBinaryExpression(Precedence.ASSIGNMENT);
    }

    private void parseBinaryExpression(Precedence precedence) {
        PsiBuilder.Marker expression2 = this.mark();
        precedence.parseHigherPrecedence(this);
        while (!this.interruptedWithNewLine() && this.atSet(precedence.getOperations())) {
            IElementType operation = this.tt();
            this.parseOperationReference();
            KtNodeType resultType = precedence.parseRightHandSide(operation, this);
            expression2.done((IElementType)resultType);
            expression2 = expression2.precede();
        }
        expression2.drop();
    }

    private void parseLabeledExpression() {
        PsiBuilder.Marker expression2 = this.mark();
        this.parseLabelDefinition();
        this.parsePrefixExpression();
        expression2.done((IElementType)KtNodeTypes.LABELED_EXPRESSION);
    }

    private void parsePrefixExpression() {
        if (this.at(KtTokens.AT)) {
            if (!this.parseLocalDeclaration()) {
                PsiBuilder.Marker expression2 = this.mark();
                this.myKotlinParsing.parseAnnotations(KotlinParsing.AnnotationParsingMode.DEFAULT);
                this.parsePrefixExpression();
                expression2.done((IElementType)KtNodeTypes.ANNOTATED_EXPRESSION);
            }
        } else {
            this.myBuilder.disableJoiningComplexTokens();
            if (this.isAtLabelDefinitionOrMissingIdentifier()) {
                this.myBuilder.restoreJoiningComplexTokensState();
                this.parseLabeledExpression();
            } else if (this.atSet(Precedence.PREFIX.getOperations())) {
                PsiBuilder.Marker expression3 = this.mark();
                this.parseOperationReference();
                this.myBuilder.restoreJoiningComplexTokensState();
                this.parsePrefixExpression();
                expression3.done((IElementType)KtNodeTypes.PREFIX_EXPRESSION);
            } else {
                this.myBuilder.restoreJoiningComplexTokensState();
                this.parsePostfixExpression();
            }
        }
    }

    private boolean parseDoubleColonExpression() {
        PsiBuilder.Marker expression2 = this.mark();
        if (!this.at(KtTokens.COLONCOLON)) {
            PsiBuilder.Marker typeReference = this.mark();
            this.myKotlinParsing.parseUserType();
            typeReference = this.myKotlinParsing.parseNullableTypeSuffix(typeReference);
            typeReference.done(KtNodeTypes.TYPE_REFERENCE);
            if (!this.at(KtTokens.COLONCOLON)) {
                expression2.rollbackTo();
                return false;
            }
        }
        this.advance();
        if (this.at(KtTokens.CLASS_KEYWORD)) {
            this.advance();
            expression2.done((IElementType)KtNodeTypes.CLASS_LITERAL_EXPRESSION);
        } else {
            this.parseSimpleNameExpression();
            if (this.at(KtTokens.LT)) {
                PsiBuilder.Marker typeArgumentList = this.mark();
                if (this.myKotlinParsing.tryParseTypeArgumentList(TYPE_ARGUMENT_LIST_STOPPERS)) {
                    typeArgumentList.error("Type arguments are not allowed");
                } else {
                    typeArgumentList.rollbackTo();
                }
            }
            expression2.done((IElementType)KtNodeTypes.CALLABLE_REFERENCE_EXPRESSION);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parsePostfixExpression() {
        PsiBuilder.Marker expression2 = this.mark();
        boolean doubleColonExpression = this.parseDoubleColonExpression();
        boolean firstExpressionParsed = !doubleColonExpression ? this.parseAtomicExpression() : true;
        while (!this.interruptedWithNewLine()) {
            block9: {
                if (this.at(KtTokens.LBRACKET)) {
                    this.parseArrayAccess();
                    expression2.done((IElementType)KtNodeTypes.ARRAY_ACCESS_EXPRESSION);
                } else if (!doubleColonExpression && this.parseCallSuffix()) {
                    expression2.done((IElementType)KtNodeTypes.CALL_EXPRESSION);
                } else {
                    if (this.at(KtTokens.DOT) || this.at(KtTokens.SAFE_ACCESS)) {
                        IElementType expressionType = this.at(KtTokens.DOT) ? KtNodeTypes.DOT_QUALIFIED_EXPRESSION : KtNodeTypes.SAFE_ACCESS_EXPRESSION;
                        this.advance();
                        if (!firstExpressionParsed) {
                            expression2.drop();
                            expression2 = this.mark();
                        }
                        this.parseCallExpression();
                        if (firstExpressionParsed) {
                            expression2.done(expressionType);
                            break block9;
                        } else {
                            firstExpressionParsed = true;
                            continue;
                        }
                    }
                    if (!this.atSet(Precedence.POSTFIX.getOperations())) break;
                    this.parseOperationReference();
                    expression2.done((IElementType)KtNodeTypes.POSTFIX_EXPRESSION);
                }
            }
            expression2 = expression2.precede();
        }
        expression2.drop();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseCallSuffix() {
        if (this.parseCallWithClosure()) return true;
        if (this.at(KtTokens.LPAR)) {
            this.parseValueArgumentList();
            this.parseCallWithClosure();
            return true;
        } else {
            if (!this.at(KtTokens.LT)) return false;
            PsiBuilder.Marker typeArgumentList = this.mark();
            if (this.myKotlinParsing.tryParseTypeArgumentList(TYPE_ARGUMENT_LIST_STOPPERS)) {
                typeArgumentList.done(KtNodeTypes.TYPE_ARGUMENT_LIST);
                if (!this.myBuilder.newlineBeforeCurrentToken() && this.at(KtTokens.LPAR)) {
                    this.parseValueArgumentList();
                }
                this.parseCallWithClosure();
                return true;
            } else {
                typeArgumentList.rollbackTo();
                return false;
            }
        }
    }

    private void parseCallExpression() {
        PsiBuilder.Marker mark = this.mark();
        this.parseAtomicExpression();
        if (!this.myBuilder.newlineBeforeCurrentToken() && this.parseCallSuffix()) {
            mark.done((IElementType)KtNodeTypes.CALL_EXPRESSION);
        } else {
            mark.drop();
        }
    }

    private void parseOperationReference() {
        PsiBuilder.Marker operationReference = this.mark();
        this.advance();
        operationReference.done((IElementType)KtNodeTypes.OPERATION_REFERENCE);
    }

    protected boolean parseCallWithClosure() {
        PsiBuilder.Marker argument2;
        boolean success = false;
        while (true) {
            argument2 = this.mark();
            if (!this.parseAnnotatedLambda(false)) break;
            argument2.done((IElementType)KtNodeTypes.LAMBDA_ARGUMENT);
            success = true;
        }
        argument2.drop();
        return success;
    }

    private boolean parseAnnotatedLambda(boolean preferBlock) {
        PsiBuilder.Marker annotated = this.mark();
        boolean wereAnnotations = this.myKotlinParsing.parseAnnotations(KotlinParsing.AnnotationParsingMode.DEFAULT);
        PsiBuilder.Marker labeled = this.mark();
        boolean wasLabel = this.isAtLabelDefinitionOrMissingIdentifier();
        if (wasLabel) {
            this.parseLabelDefinition();
        }
        if (!this.at(KtTokens.LBRACE)) {
            annotated.rollbackTo();
            return false;
        }
        this.parseFunctionLiteral(preferBlock);
        KotlinExpressionParsing.doneOrDrop(labeled, KtNodeTypes.LABELED_EXPRESSION, wasLabel);
        KotlinExpressionParsing.doneOrDrop(annotated, KtNodeTypes.ANNOTATED_EXPRESSION, wereAnnotations);
        return true;
    }

    private static void doneOrDrop(@NotNull PsiBuilder.Marker marker, @NotNull IElementType type2, boolean condition2) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "org/jetbrains/kotlin/parsing/KotlinExpressionParsing", "doneOrDrop"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/parsing/KotlinExpressionParsing", "doneOrDrop"));
        }
        if (condition2) {
            marker.done(type2);
        } else {
            marker.drop();
        }
    }

    private boolean isAtLabelDefinitionBeforeLBrace() {
        if (this.at(KtTokens.IDENTIFIER)) {
            if (this.myBuilder.rawLookup(1) != KtTokens.AT) {
                return false;
            }
            return this.lookahead(2) == KtTokens.LBRACE;
        }
        return this.at(KtTokens.AT) && this.lookahead(1) == KtTokens.LBRACE;
    }

    private boolean isAtLabelDefinitionOrMissingIdentifier() {
        return this.at(KtTokens.IDENTIFIER) && this.myBuilder.rawLookup(1) == KtTokens.AT || this.at(KtTokens.AT);
    }

    private boolean parseAtomicExpression() {
        boolean ok = true;
        if (this.at(KtTokens.LPAR)) {
            this.parseParenthesizedExpression();
        } else if (this.at(KtTokens.THIS_KEYWORD)) {
            this.parseThisExpression();
        } else if (this.at(KtTokens.SUPER_KEYWORD)) {
            this.parseSuperExpression();
        } else if (this.at(KtTokens.OBJECT_KEYWORD)) {
            this.parseObjectLiteral();
        } else if (this.at(KtTokens.THROW_KEYWORD)) {
            this.parseThrow();
        } else if (this.at(KtTokens.RETURN_KEYWORD)) {
            this.parseReturn();
        } else if (this.at(KtTokens.CONTINUE_KEYWORD)) {
            this.parseJump(KtNodeTypes.CONTINUE);
        } else if (this.at(KtTokens.BREAK_KEYWORD)) {
            this.parseJump(KtNodeTypes.BREAK);
        } else if (this.at(KtTokens.IF_KEYWORD)) {
            this.parseIf();
        } else if (this.at(KtTokens.WHEN_KEYWORD)) {
            this.parseWhen();
        } else if (this.at(KtTokens.TRY_KEYWORD)) {
            this.parseTry();
        } else if (this.at(KtTokens.FOR_KEYWORD)) {
            this.parseFor();
        } else if (this.at(KtTokens.WHILE_KEYWORD)) {
            this.parseWhile();
        } else if (this.at(KtTokens.DO_KEYWORD)) {
            this.parseDoWhile();
        } else if (this.atSet(KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD, KtTokens.FUN_KEYWORD, KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD, KtTokens.TYPE_ALIAS_KEYWORD)) {
            this.parseLocalDeclaration();
        } else if (this.at(KtTokens.IDENTIFIER)) {
            this.parseSimpleNameExpression();
        } else if (this.at(KtTokens.LBRACE)) {
            this.parseFunctionLiteral();
        } else if (this.at(KtTokens.OPEN_QUOTE)) {
            this.parseStringTemplate();
        } else if (!this.parseLiteralConstant()) {
            ok = false;
            this.errorWithRecovery("Expecting an element", EXPRESSION_FOLLOW);
        }
        return ok;
    }

    private void parseStringTemplate() {
        assert (this._at(KtTokens.OPEN_QUOTE));
        PsiBuilder.Marker template = this.mark();
        this.advance();
        while (!(this.eof() || this.at(KtTokens.CLOSING_QUOTE) || this.at(KtTokens.DANGLING_NEWLINE))) {
            this.parseStringTemplateElement();
        }
        if (this.at(KtTokens.DANGLING_NEWLINE)) {
            this.errorAndAdvance("Expecting '\"'");
        } else {
            this.expect(KtTokens.CLOSING_QUOTE, "Expecting '\"'");
        }
        template.done((IElementType)KtNodeTypes.STRING_TEMPLATE);
    }

    private void parseStringTemplateElement() {
        if (this.at(KtTokens.REGULAR_STRING_PART)) {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            mark.done((IElementType)KtNodeTypes.LITERAL_STRING_TEMPLATE_ENTRY);
        } else if (this.at(KtTokens.ESCAPE_SEQUENCE)) {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            mark.done((IElementType)KtNodeTypes.ESCAPE_STRING_TEMPLATE_ENTRY);
        } else if (this.at(KtTokens.SHORT_TEMPLATE_ENTRY_START)) {
            PsiBuilder.Marker entry = this.mark();
            this.advance();
            if (this.at(KtTokens.THIS_KEYWORD)) {
                PsiBuilder.Marker thisExpression = this.mark();
                PsiBuilder.Marker reference2 = this.mark();
                this.advance();
                reference2.done(KtNodeTypes.REFERENCE_EXPRESSION);
                thisExpression.done((IElementType)KtNodeTypes.THIS_EXPRESSION);
            } else {
                KtToken keyword = (KtToken)((Object)KEYWORD_TEXTS.get((Object)this.myBuilder.getTokenText()));
                if (keyword != null) {
                    this.myBuilder.remapCurrentToken(keyword);
                    this.errorAndAdvance("Keyword cannot be used as a reference");
                } else {
                    PsiBuilder.Marker reference3 = this.mark();
                    this.expect(KtTokens.IDENTIFIER, "Expecting a name");
                    reference3.done(KtNodeTypes.REFERENCE_EXPRESSION);
                }
            }
            entry.done((IElementType)KtNodeTypes.SHORT_STRING_TEMPLATE_ENTRY);
        } else if (this.at(KtTokens.LONG_TEMPLATE_ENTRY_START)) {
            PsiBuilder.Marker longTemplateEntry = this.mark();
            this.advance();
            this.parseExpression();
            this.expect(KtTokens.LONG_TEMPLATE_ENTRY_END, "Expecting '}'", TokenSet.create((IElementType[])new IElementType[]{KtTokens.CLOSING_QUOTE, KtTokens.DANGLING_NEWLINE, KtTokens.REGULAR_STRING_PART, KtTokens.ESCAPE_SEQUENCE, KtTokens.SHORT_TEMPLATE_ENTRY_START}));
            longTemplateEntry.done((IElementType)KtNodeTypes.LONG_STRING_TEMPLATE_ENTRY);
        } else {
            this.errorAndAdvance("Unexpected token in a string template");
        }
    }

    private boolean parseLiteralConstant() {
        if (this.at(KtTokens.TRUE_KEYWORD) || this.at(KtTokens.FALSE_KEYWORD)) {
            this.parseOneTokenExpression(KtNodeTypes.BOOLEAN_CONSTANT);
        } else if (this.at(KtTokens.INTEGER_LITERAL)) {
            this.parseOneTokenExpression(KtNodeTypes.INTEGER_CONSTANT);
        } else if (this.at(KtTokens.CHARACTER_LITERAL)) {
            this.parseOneTokenExpression(KtNodeTypes.CHARACTER_CONSTANT);
        } else if (this.at(KtTokens.FLOAT_LITERAL)) {
            this.parseOneTokenExpression(KtNodeTypes.FLOAT_CONSTANT);
        } else if (this.at(KtTokens.NULL_KEYWORD)) {
            this.parseOneTokenExpression(KtNodeTypes.NULL);
        } else {
            return false;
        }
        return true;
    }

    private void parseWhen() {
        assert (this._at(KtTokens.WHEN_KEYWORD));
        PsiBuilder.Marker when = this.mark();
        this.advance();
        this.myBuilder.disableNewlines();
        if (this.at(KtTokens.LPAR)) {
            this.advanceAt(KtTokens.LPAR);
            PsiBuilder.Marker property2 = this.mark();
            this.myKotlinParsing.parseModifierList(KotlinParsing.AnnotationParsingMode.DEFAULT, TokenSet.create((IElementType[])new IElementType[]{KtTokens.EQ, KtTokens.RPAR}));
            if (this.at(KtTokens.VAL_KEYWORD) || this.at(KtTokens.VAR_KEYWORD)) {
                this.myKotlinParsing.parseProperty(true);
                property2.done(KtNodeTypes.PROPERTY);
            } else {
                property2.rollbackTo();
                this.parseExpression();
            }
            this.expect(KtTokens.RPAR, "Expecting ')'");
        }
        this.myBuilder.restoreNewlinesState();
        this.myBuilder.enableNewlines();
        if (this.expect(KtTokens.LBRACE, "Expecting '{'")) {
            while (!this.eof() && !this.at(KtTokens.RBRACE)) {
                this.parseWhenEntry();
            }
            this.expect(KtTokens.RBRACE, "Expecting '}'");
        }
        this.myBuilder.restoreNewlinesState();
        when.done((IElementType)KtNodeTypes.WHEN);
    }

    private void parseWhenEntry() {
        PsiBuilder.Marker entry = this.mark();
        if (this.at(KtTokens.ELSE_KEYWORD)) {
            this.advance();
            if (!this.at(KtTokens.ARROW)) {
                this.errorUntil("Expecting '->'", TokenSet.create((IElementType[])new IElementType[]{KtTokens.ARROW, KtTokens.LBRACE, KtTokens.RBRACE, KtTokens.EOL_OR_SEMICOLON}));
            }
            if (this.at(KtTokens.ARROW)) {
                this.advance();
                if (this.atSet(WHEN_CONDITION_RECOVERY_SET)) {
                    this.error("Expecting an element");
                } else {
                    this.parseExpressionPreferringBlocks();
                }
            } else if (this.at(KtTokens.LBRACE)) {
                this.parseExpressionPreferringBlocks();
            } else if (!this.atSet(WHEN_CONDITION_RECOVERY_SET)) {
                this.errorAndAdvance("Expecting '->'");
            }
        } else {
            this.parseWhenEntryNotElse();
        }
        entry.done((IElementType)KtNodeTypes.WHEN_ENTRY);
        this.consumeIf(KtTokens.SEMICOLON);
    }

    private void parseWhenEntryNotElse() {
        while (true) {
            if (this.at(KtTokens.COMMA)) {
                this.errorAndAdvance("Expecting a when-condition");
                continue;
            }
            this.parseWhenCondition();
            if (!this.at(KtTokens.COMMA)) break;
            this.advance();
        }
        this.expect(KtTokens.ARROW, "Expecting '->'", WHEN_CONDITION_RECOVERY_SET);
        if (this.atSet(WHEN_CONDITION_RECOVERY_SET)) {
            this.error("Expecting an element");
        } else {
            this.parseExpressionPreferringBlocks();
        }
    }

    private void parseWhenCondition() {
        PsiBuilder.Marker condition2 = this.mark();
        this.myBuilder.disableNewlines();
        if (this.at(KtTokens.IN_KEYWORD) || this.at(KtTokens.NOT_IN)) {
            PsiBuilder.Marker mark = this.mark();
            this.advance();
            mark.done((IElementType)KtNodeTypes.OPERATION_REFERENCE);
            if (this.atSet(WHEN_CONDITION_RECOVERY_SET_WITH_ARROW)) {
                this.error("Expecting an element");
            } else {
                this.parseExpression();
            }
            condition2.done((IElementType)KtNodeTypes.WHEN_CONDITION_IN_RANGE);
        } else if (this.at(KtTokens.IS_KEYWORD) || this.at(KtTokens.NOT_IS)) {
            this.advance();
            if (this.atSet(WHEN_CONDITION_RECOVERY_SET_WITH_ARROW)) {
                this.error("Expecting a type");
            } else {
                this.myKotlinParsing.parseTypeRef();
            }
            condition2.done((IElementType)KtNodeTypes.WHEN_CONDITION_IS_PATTERN);
        } else {
            if (this.atSet(WHEN_CONDITION_RECOVERY_SET_WITH_ARROW)) {
                this.error("Expecting an expression, is-condition or in-condition");
            } else {
                this.parseExpression();
            }
            condition2.done((IElementType)KtNodeTypes.WHEN_CONDITION_EXPRESSION);
        }
        this.myBuilder.restoreNewlinesState();
    }

    private void parseArrayAccess() {
        assert (this._at(KtTokens.LBRACKET));
        PsiBuilder.Marker indices = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        while (true) {
            if (this.at(KtTokens.COMMA)) {
                this.errorAndAdvance("Expecting an index element");
            }
            if (this.at(KtTokens.RBRACKET)) {
                this.error("Expecting an index element");
                break;
            }
            this.parseExpression();
            if (!this.at(KtTokens.COMMA)) break;
            this.advance();
        }
        this.expect(KtTokens.RBRACKET, "Expecting ']'");
        this.myBuilder.restoreNewlinesState();
        indices.done((IElementType)KtNodeTypes.INDICES);
    }

    public void parseSimpleNameExpression() {
        PsiBuilder.Marker simpleName = this.mark();
        this.expect(KtTokens.IDENTIFIER, "Expecting an identifier");
        simpleName.done(KtNodeTypes.REFERENCE_EXPRESSION);
    }

    private boolean parseLocalDeclaration() {
        PsiBuilder.Marker decl = this.mark();
        KotlinParsing.ModifierDetector detector2 = new KotlinParsing.ModifierDetector();
        this.myKotlinParsing.parseModifierList(detector2, KotlinParsing.AnnotationParsingMode.DEFAULT, TokenSet.EMPTY);
        IElementType declType = this.parseLocalDeclarationRest(detector2.isEnumDetected());
        if (declType != null) {
            KotlinExpressionParsing.closeDeclarationWithCommentBinders(decl, declType, declType != KtNodeTypes.PROPERTY && declType != KtNodeTypes.DESTRUCTURING_DECLARATION);
            return true;
        }
        decl.rollbackTo();
        return false;
    }

    private void parseFunctionLiteral() {
        this.parseFunctionLiteral(false);
    }

    private void parseFunctionLiteral(boolean preferBlock) {
        assert (this._at(KtTokens.LBRACE));
        PsiBuilder.Marker literalExpression = this.mark();
        PsiBuilder.Marker literal = this.mark();
        this.myBuilder.enableNewlines();
        this.advance();
        boolean paramsFound = false;
        if (this.at(KtTokens.ARROW)) {
            this.mark().done(KtNodeTypes.VALUE_PARAMETER_LIST);
            this.advance();
            paramsFound = true;
        } else if (this.at(KtTokens.IDENTIFIER) || this.at(KtTokens.COLON)) {
            PsiBuilder.Marker rollbackMarker = this.mark();
            IElementType nextToken = this.lookahead(1);
            boolean preferParamsToExpressions = nextToken == KtTokens.COMMA || nextToken == KtTokens.COLON;
            this.parseFunctionLiteralShorthandParameterList();
            boolean bl = paramsFound = preferParamsToExpressions ? this.rollbackOrDrop(rollbackMarker, KtTokens.ARROW, "An -> is expected", KtTokens.RBRACE) : this.rollbackOrDropAt(rollbackMarker, KtTokens.ARROW);
        }
        if (!paramsFound && preferBlock) {
            literal.drop();
            this.parseStatements();
            this.expect(KtTokens.RBRACE, "Expecting '}'");
            literalExpression.done((IElementType)KtNodeTypes.BLOCK);
            this.myBuilder.restoreNewlinesState();
            return;
        }
        PsiBuilder.Marker body2 = this.mark();
        this.parseStatements();
        body2.done((IElementType)KtNodeTypes.BLOCK);
        this.expect(KtTokens.RBRACE, "Expecting '}'");
        this.myBuilder.restoreNewlinesState();
        literal.done((IElementType)KtNodeTypes.FUNCTION_LITERAL);
        literalExpression.done((IElementType)KtNodeTypes.LAMBDA_EXPRESSION);
    }

    private boolean rollbackOrDropAt(PsiBuilder.Marker rollbackMarker, IElementType dropAt) {
        if (this.at(dropAt)) {
            this.advance();
            rollbackMarker.drop();
            return true;
        }
        rollbackMarker.rollbackTo();
        return false;
    }

    private boolean rollbackOrDrop(PsiBuilder.Marker rollbackMarker, KtToken expected, String expectMessage, IElementType validForDrop) {
        if (this.at(expected)) {
            this.advance();
            rollbackMarker.drop();
            return true;
        }
        if (this.at(validForDrop)) {
            rollbackMarker.drop();
            this.expect(expected, expectMessage);
            return true;
        }
        rollbackMarker.rollbackTo();
        return false;
    }

    private void parseFunctionLiteralShorthandParameterList() {
        PsiBuilder.Marker parameterList2 = this.mark();
        while (!this.eof()) {
            PsiBuilder.Marker parameter = this.mark();
            if (this.at(KtTokens.COLON)) {
                this.error("Expecting parameter name");
            } else {
                this.expect(KtTokens.IDENTIFIER, "Expecting parameter name", TokenSet.create((IElementType[])new IElementType[]{KtTokens.ARROW}));
            }
            if (this.at(KtTokens.COLON)) {
                this.advance();
                this.myKotlinParsing.parseTypeRef(TokenSet.create((IElementType[])new IElementType[]{KtTokens.ARROW, KtTokens.COMMA}));
            }
            parameter.done(KtNodeTypes.VALUE_PARAMETER);
            if (this.at(KtTokens.ARROW)) break;
            if (this.at(KtTokens.COMMA)) {
                this.advance();
                continue;
            }
            this.error("Expecting '->' or ','");
            break;
        }
        parameterList2.done(KtNodeTypes.VALUE_PARAMETER_LIST);
    }

    public void parseStatements() {
        this.parseStatements(false);
    }

    public void parseStatements(boolean isScriptTopLevel) {
        while (this.at(KtTokens.SEMICOLON)) {
            this.advance();
        }
        while (!this.eof() && !this.at(KtTokens.RBRACE)) {
            if (!this.atSet(STATEMENT_FIRST)) {
                this.errorAndAdvance("Expecting an element");
            }
            if (this.atSet(STATEMENT_FIRST)) {
                this.parseStatement(isScriptTopLevel);
            }
            if (this.at(KtTokens.SEMICOLON)) {
                while (this.at(KtTokens.SEMICOLON)) {
                    this.advance();
                }
                continue;
            }
            if (this.at(KtTokens.RBRACE)) break;
            if (this.myBuilder.newlineBeforeCurrentToken()) continue;
            String severalStatementsError = "Unexpected tokens (use ';' to separate expressions on the same line)";
            if (this.atSet(STATEMENT_NEW_LINE_QUICK_RECOVERY_SET)) {
                this.error(severalStatementsError);
                continue;
            }
            this.errorUntil(severalStatementsError, TokenSet.create((IElementType[])new IElementType[]{KtTokens.EOL_OR_SEMICOLON, KtTokens.LBRACE, KtTokens.RBRACE}));
        }
    }

    private void parseStatement(boolean isScriptTopLevel) {
        if (!this.parseLocalDeclaration()) {
            if (!this.atSet(EXPRESSION_FIRST)) {
                this.errorAndAdvance("Expecting a statement");
            } else if (isScriptTopLevel) {
                PsiBuilder.Marker scriptInitializer = this.mark();
                this.parseExpression();
                scriptInitializer.done(KtNodeTypes.SCRIPT_INITIALIZER);
            } else {
                this.parseExpression();
            }
        }
    }

    private IElementType parseLocalDeclarationRest(boolean isEnum) {
        IElementType keywordToken = this.tt();
        IElementType declType = null;
        if (keywordToken == KtTokens.CLASS_KEYWORD || keywordToken == KtTokens.INTERFACE_KEYWORD) {
            declType = this.myKotlinParsing.parseClass(isEnum);
        } else if (keywordToken == KtTokens.FUN_KEYWORD) {
            declType = this.myKotlinParsing.parseFunction();
        } else if (keywordToken == KtTokens.VAL_KEYWORD || keywordToken == KtTokens.VAR_KEYWORD) {
            declType = this.myKotlinParsing.parseProperty(true);
        } else if (keywordToken == KtTokens.OBJECT_KEYWORD) {
            IElementType lookahead = this.lookahead(1);
            if (lookahead == KtTokens.COLON || lookahead == KtTokens.LBRACE) {
                return null;
            }
            this.myKotlinParsing.parseObject(KotlinParsing.NameParsingMode.REQUIRED, true);
            declType = KtNodeTypes.OBJECT_DECLARATION;
        }
        return declType;
    }

    private void parseDoWhile() {
        assert (this._at(KtTokens.DO_KEYWORD));
        PsiBuilder.Marker loop = this.mark();
        this.advance();
        if (!this.at(KtTokens.WHILE_KEYWORD)) {
            this.parseControlStructureBody();
        }
        if (this.expect(KtTokens.WHILE_KEYWORD, "Expecting 'while' followed by a post-condition")) {
            this.parseCondition();
        }
        loop.done((IElementType)KtNodeTypes.DO_WHILE);
    }

    private void parseWhile() {
        assert (this._at(KtTokens.WHILE_KEYWORD));
        PsiBuilder.Marker loop = this.mark();
        this.advance();
        this.parseCondition();
        this.parseControlStructureBody();
        loop.done((IElementType)KtNodeTypes.WHILE);
    }

    private void parseFor() {
        assert (this._at(KtTokens.FOR_KEYWORD));
        PsiBuilder.Marker loop = this.mark();
        this.advance();
        if (this.expect(KtTokens.LPAR, "Expecting '(' to open a loop range", EXPRESSION_FIRST)) {
            this.myBuilder.disableNewlines();
            if (!this.at(KtTokens.RPAR)) {
                PsiBuilder.Marker parameter = this.mark();
                if (!this.at(KtTokens.IN_KEYWORD)) {
                    this.myKotlinParsing.parseModifierList(KotlinParsing.AnnotationParsingMode.DEFAULT, TokenSet.create((IElementType[])new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.RPAR, KtTokens.COLON}));
                }
                if (this.at(KtTokens.VAL_KEYWORD) || this.at(KtTokens.VAR_KEYWORD)) {
                    this.advance();
                }
                if (this.at(KtTokens.LPAR)) {
                    this.myKotlinParsing.parseMultiDeclarationName(TokenSet.create((IElementType[])new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.LBRACE}));
                    parameter.done(KtNodeTypes.DESTRUCTURING_DECLARATION);
                } else {
                    this.expect(KtTokens.IDENTIFIER, "Expecting a variable name", TokenSet.create((IElementType[])new IElementType[]{KtTokens.COLON, KtTokens.IN_KEYWORD}));
                    if (this.at(KtTokens.COLON)) {
                        this.advance();
                        this.myKotlinParsing.parseTypeRef(TokenSet.create((IElementType[])new IElementType[]{KtTokens.IN_KEYWORD}));
                    }
                    parameter.done(KtNodeTypes.VALUE_PARAMETER);
                }
                if (this.expect(KtTokens.IN_KEYWORD, "Expecting 'in'", TokenSet.create((IElementType[])new IElementType[]{KtTokens.LPAR, KtTokens.LBRACE, KtTokens.RPAR}))) {
                    PsiBuilder.Marker range = this.mark();
                    this.parseExpression();
                    range.done((IElementType)KtNodeTypes.LOOP_RANGE);
                }
            } else {
                this.error("Expecting a variable name");
            }
            this.expectNoAdvance(KtTokens.RPAR, "Expecting ')'");
            this.myBuilder.restoreNewlinesState();
        }
        this.parseControlStructureBody();
        loop.done((IElementType)KtNodeTypes.FOR);
    }

    private void parseExpressionPreferringBlocks() {
        if (!this.parseAnnotatedLambda(true)) {
            this.parseExpression();
        }
    }

    private void parseControlStructureBody() {
        PsiBuilder.Marker body2 = this.mark();
        if (!this.at(KtTokens.SEMICOLON)) {
            this.parseExpressionPreferringBlocks();
        }
        body2.done((IElementType)KtNodeTypes.BODY);
    }

    private void parseTry() {
        assert (this._at(KtTokens.TRY_KEYWORD));
        PsiBuilder.Marker tryExpression = this.mark();
        this.advance();
        this.myKotlinParsing.parseBlock();
        boolean catchOrFinally = false;
        while (this.at(KtTokens.CATCH_KEYWORD)) {
            catchOrFinally = true;
            PsiBuilder.Marker catchBlock = this.mark();
            this.advance();
            TokenSet recoverySet = TokenSet.create((IElementType[])new IElementType[]{KtTokens.LBRACE, KtTokens.RBRACE, KtTokens.FINALLY_KEYWORD, KtTokens.CATCH_KEYWORD});
            if (this.atSet(recoverySet)) {
                this.error("Expecting exception variable declaration");
            } else {
                PsiBuilder.Marker parameters2 = this.mark();
                this.expect(KtTokens.LPAR, "Expecting '('", recoverySet);
                if (!this.atSet(recoverySet)) {
                    this.myKotlinParsing.parseValueParameter(true);
                    this.expect(KtTokens.RPAR, "Expecting ')'", recoverySet);
                } else {
                    this.error("Expecting exception variable declaration");
                }
                parameters2.done(KtNodeTypes.VALUE_PARAMETER_LIST);
            }
            if (this.at(KtTokens.LBRACE)) {
                this.myKotlinParsing.parseBlock();
            } else {
                this.error("Expecting a block: { ... }");
            }
            catchBlock.done((IElementType)KtNodeTypes.CATCH);
        }
        if (this.at(KtTokens.FINALLY_KEYWORD)) {
            catchOrFinally = true;
            PsiBuilder.Marker finallyBlock = this.mark();
            this.advance();
            this.myKotlinParsing.parseBlock();
            finallyBlock.done((IElementType)KtNodeTypes.FINALLY);
        }
        if (!catchOrFinally) {
            this.error("Expecting 'catch' or 'finally'");
        }
        tryExpression.done((IElementType)KtNodeTypes.TRY);
    }

    private void parseIf() {
        assert (this._at(KtTokens.IF_KEYWORD));
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseCondition();
        PsiBuilder.Marker thenBranch = this.mark();
        if (!this.at(KtTokens.ELSE_KEYWORD) && !this.at(KtTokens.SEMICOLON)) {
            this.parseExpressionPreferringBlocks();
        }
        if (this.at(KtTokens.SEMICOLON) && this.lookahead(1) == KtTokens.ELSE_KEYWORD) {
            this.advance();
        }
        thenBranch.done((IElementType)KtNodeTypes.THEN);
        if (this.at(KtTokens.ELSE_KEYWORD) && this.lookahead(1) != KtTokens.ARROW) {
            this.advance();
            PsiBuilder.Marker elseBranch = this.mark();
            if (!this.at(KtTokens.SEMICOLON)) {
                this.parseExpressionPreferringBlocks();
            }
            elseBranch.done((IElementType)KtNodeTypes.ELSE);
        }
        marker.done((IElementType)KtNodeTypes.IF);
    }

    private void parseCondition() {
        this.myBuilder.disableNewlines();
        if (this.expect(KtTokens.LPAR, "Expecting a condition in parentheses '(...)'", EXPRESSION_FIRST)) {
            PsiBuilder.Marker condition2 = this.mark();
            this.parseExpression();
            condition2.done((IElementType)KtNodeTypes.CONDITION);
            this.expect(KtTokens.RPAR, "Expecting ')");
        }
        this.myBuilder.restoreNewlinesState();
    }

    private void parseJump(KtNodeType type2) {
        assert (this._at(KtTokens.BREAK_KEYWORD) || this._at(KtTokens.CONTINUE_KEYWORD));
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseLabelReferenceWithNoWhitespace();
        marker.done((IElementType)type2);
    }

    private void parseReturn() {
        assert (this._at(KtTokens.RETURN_KEYWORD));
        PsiBuilder.Marker returnExpression = this.mark();
        this.advance();
        this.parseLabelReferenceWithNoWhitespace();
        if (this.atSet(EXPRESSION_FIRST) && !this.at(KtTokens.EOL_OR_SEMICOLON)) {
            this.parseExpression();
        }
        returnExpression.done((IElementType)KtNodeTypes.RETURN);
    }

    private void parseLabelReferenceWithNoWhitespace() {
        if (this.at(KtTokens.AT) && !this.myBuilder.newlineBeforeCurrentToken()) {
            if (KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(this.myBuilder.rawLookup(-1))) {
                this.error("There should be no space or comments before '@' in label reference");
            }
            this.parseLabelReference();
        }
    }

    private void parseLabelDefinition() {
        if (this.at(KtTokens.AT)) {
            this.errorAndAdvance("Label must be named");
            return;
        }
        PsiBuilder.Marker labelWrap = this.mark();
        PsiBuilder.Marker mark = this.mark();
        assert (this._at(KtTokens.IDENTIFIER) && this.myBuilder.rawLookup(1) == KtTokens.AT) : "Callers must check that current token is IDENTIFIER followed with '@'";
        this.advance();
        this.advance();
        mark.done((IElementType)KtNodeTypes.LABEL);
        labelWrap.done((IElementType)KtNodeTypes.LABEL_QUALIFIER);
    }

    private void parseLabelReference() {
        assert (this._at(KtTokens.AT));
        PsiBuilder.Marker labelWrap = this.mark();
        PsiBuilder.Marker mark = this.mark();
        if (this.myBuilder.rawLookup(1) != KtTokens.IDENTIFIER) {
            this.errorAndAdvance("Label must be named");
            labelWrap.drop();
            mark.drop();
            return;
        }
        this.advance();
        this.advance();
        mark.done((IElementType)KtNodeTypes.LABEL);
        labelWrap.done((IElementType)KtNodeTypes.LABEL_QUALIFIER);
    }

    private void parseThrow() {
        assert (this._at(KtTokens.THROW_KEYWORD));
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        this.parseExpression();
        marker.done((IElementType)KtNodeTypes.THROW);
    }

    private void parseParenthesizedExpression() {
        assert (this._at(KtTokens.LPAR));
        PsiBuilder.Marker mark = this.mark();
        this.myBuilder.disableNewlines();
        this.advance();
        if (this.at(KtTokens.RPAR)) {
            this.error("Expecting an expression");
        } else {
            this.parseExpression();
        }
        this.expect(KtTokens.RPAR, "Expecting ')'");
        this.myBuilder.restoreNewlinesState();
        mark.done((IElementType)KtNodeTypes.PARENTHESIZED);
    }

    private void parseThisExpression() {
        assert (this._at(KtTokens.THIS_KEYWORD));
        PsiBuilder.Marker mark = this.mark();
        PsiBuilder.Marker thisReference = this.mark();
        this.advance();
        thisReference.done(KtNodeTypes.REFERENCE_EXPRESSION);
        this.parseLabelReferenceWithNoWhitespace();
        mark.done((IElementType)KtNodeTypes.THIS_EXPRESSION);
    }

    private void parseSuperExpression() {
        assert (this._at(KtTokens.SUPER_KEYWORD));
        PsiBuilder.Marker mark = this.mark();
        PsiBuilder.Marker superReference = this.mark();
        this.advance();
        superReference.done(KtNodeTypes.REFERENCE_EXPRESSION);
        if (this.at(KtTokens.LT)) {
            PsiBuilder.Marker supertype = this.mark();
            this.myBuilder.disableNewlines();
            this.advance();
            this.myKotlinParsing.parseTypeRef();
            if (this.at(KtTokens.GT)) {
                this.advance();
                supertype.drop();
            } else {
                supertype.rollbackTo();
            }
            this.myBuilder.restoreNewlinesState();
        }
        this.parseLabelReferenceWithNoWhitespace();
        mark.done((IElementType)KtNodeTypes.SUPER_EXPRESSION);
    }

    public void parseValueArgumentList() {
        PsiBuilder.Marker list2 = this.mark();
        this.myBuilder.disableNewlines();
        if (this.expect(KtTokens.LPAR, "Expecting an argument list", EXPRESSION_FOLLOW)) {
            block5: {
                if (!this.at(KtTokens.RPAR)) {
                    while (true) {
                        if (this.at(KtTokens.COMMA)) {
                            this.errorAndAdvance("Expecting an argument");
                            continue;
                        }
                        this.parseValueArgument();
                        if (this.at(KtTokens.COLON) && this.lookahead(1) == KtTokens.IDENTIFIER) {
                            this.errorAndAdvance("Unexpected type specification", 2);
                        }
                        if (!this.at(KtTokens.COMMA)) break block5;
                        this.advance();
                        if (this.at(KtTokens.RPAR)) break;
                    }
                    this.error("Expecting an argument");
                }
            }
            this.expect(KtTokens.RPAR, "Expecting ')'", EXPRESSION_FOLLOW);
        }
        this.myBuilder.restoreNewlinesState();
        list2.done((IElementType)KtNodeTypes.VALUE_ARGUMENT_LIST);
    }

    private void parseValueArgument() {
        PsiBuilder.Marker argument2 = this.mark();
        if (this.at(KtTokens.IDENTIFIER) && this.lookahead(1) == KtTokens.EQ) {
            PsiBuilder.Marker argName = this.mark();
            PsiBuilder.Marker reference2 = this.mark();
            this.advance();
            reference2.done(KtNodeTypes.REFERENCE_EXPRESSION);
            argName.done((IElementType)KtNodeTypes.VALUE_ARGUMENT_NAME);
            this.advance();
        }
        if (this.at(KtTokens.MUL)) {
            this.advance();
        }
        this.parseExpression();
        argument2.done((IElementType)KtNodeTypes.VALUE_ARGUMENT);
    }

    public void parseObjectLiteral() {
        PsiBuilder.Marker literal = this.mark();
        PsiBuilder.Marker declaration = this.mark();
        this.myKotlinParsing.parseObject(KotlinParsing.NameParsingMode.PROHIBITED, false);
        declaration.done(KtNodeTypes.OBJECT_DECLARATION);
        literal.done((IElementType)KtNodeTypes.OBJECT_LITERAL);
    }

    private void parseOneTokenExpression(KtNodeType type2) {
        PsiBuilder.Marker mark = this.mark();
        this.advance();
        mark.done((IElementType)type2);
    }

    @Override
    protected KotlinParsing create(SemanticWhitespaceAwarePsiBuilder builder) {
        return this.myKotlinParsing.create(builder);
    }

    private boolean interruptedWithNewLine() {
        return !ALLOW_NEWLINE_OPERATIONS.contains(this.tt()) && this.myBuilder.newlineBeforeCurrentToken();
    }

    static {
        Precedence[] values;
        WHEN_CONDITION_RECOVERY_SET = TokenSet.create((IElementType[])new IElementType[]{KtTokens.RBRACE, KtTokens.IN_KEYWORD, KtTokens.NOT_IN, KtTokens.IS_KEYWORD, KtTokens.NOT_IS, KtTokens.ELSE_KEYWORD});
        WHEN_CONDITION_RECOVERY_SET_WITH_ARROW = TokenSet.create((IElementType[])new IElementType[]{KtTokens.RBRACE, KtTokens.IN_KEYWORD, KtTokens.NOT_IN, KtTokens.IS_KEYWORD, KtTokens.NOT_IS, KtTokens.ELSE_KEYWORD, KtTokens.ARROW, KtTokens.DOT});
        KEYWORD_TEXTS = KotlinExpressionParsing.tokenSetToMap(KtTokens.KEYWORDS);
        TYPE_ARGUMENT_LIST_STOPPERS = TokenSet.create((IElementType[])new IElementType[]{KtTokens.INTEGER_LITERAL, KtTokens.FLOAT_LITERAL, KtTokens.CHARACTER_LITERAL, KtTokens.OPEN_QUOTE, KtTokens.PACKAGE_KEYWORD, KtTokens.AS_KEYWORD, KtTokens.TYPE_ALIAS_KEYWORD, KtTokens.INTERFACE_KEYWORD, KtTokens.CLASS_KEYWORD, KtTokens.THIS_KEYWORD, KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD, KtTokens.FUN_KEYWORD, KtTokens.FOR_KEYWORD, KtTokens.NULL_KEYWORD, KtTokens.TRUE_KEYWORD, KtTokens.FALSE_KEYWORD, KtTokens.IS_KEYWORD, KtTokens.THROW_KEYWORD, KtTokens.RETURN_KEYWORD, KtTokens.BREAK_KEYWORD, KtTokens.CONTINUE_KEYWORD, KtTokens.OBJECT_KEYWORD, KtTokens.IF_KEYWORD, KtTokens.TRY_KEYWORD, KtTokens.ELSE_KEYWORD, KtTokens.WHILE_KEYWORD, KtTokens.DO_KEYWORD, KtTokens.WHEN_KEYWORD, KtTokens.RBRACKET, KtTokens.RBRACE, KtTokens.RPAR, KtTokens.PLUSPLUS, KtTokens.MINUSMINUS, KtTokens.EXCLEXCL, KtTokens.PLUS, KtTokens.MINUS, KtTokens.EXCL, KtTokens.DIV, KtTokens.PERC, KtTokens.LTEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.ANDAND, KtTokens.OROR, KtTokens.SAFE_ACCESS, KtTokens.ELVIS, KtTokens.SEMICOLON, KtTokens.RANGE, KtTokens.EQ, KtTokens.MULTEQ, KtTokens.DIVEQ, KtTokens.PERCEQ, KtTokens.PLUSEQ, KtTokens.MINUSEQ, KtTokens.NOT_IN, KtTokens.NOT_IS, KtTokens.COLONCOLON, KtTokens.COLON});
        EXPRESSION_FIRST = TokenSet.create((IElementType[])new IElementType[]{KtTokens.MINUS, KtTokens.PLUS, KtTokens.MINUSMINUS, KtTokens.PLUSPLUS, KtTokens.EXCL, KtTokens.EXCLEXCL, KtTokens.COLONCOLON, KtTokens.LPAR, KtTokens.TRUE_KEYWORD, KtTokens.FALSE_KEYWORD, KtTokens.OPEN_QUOTE, KtTokens.INTEGER_LITERAL, KtTokens.CHARACTER_LITERAL, KtTokens.FLOAT_LITERAL, KtTokens.NULL_KEYWORD, KtTokens.LBRACE, KtTokens.FUN_KEYWORD, KtTokens.THIS_KEYWORD, KtTokens.SUPER_KEYWORD, KtTokens.IF_KEYWORD, KtTokens.WHEN_KEYWORD, KtTokens.TRY_KEYWORD, KtTokens.OBJECT_KEYWORD, KtTokens.THROW_KEYWORD, KtTokens.RETURN_KEYWORD, KtTokens.CONTINUE_KEYWORD, KtTokens.BREAK_KEYWORD, KtTokens.FOR_KEYWORD, KtTokens.WHILE_KEYWORD, KtTokens.DO_KEYWORD, KtTokens.IDENTIFIER, KtTokens.PACKAGE_KEYWORD, KtTokens.AT});
        STATEMENT_FIRST = TokenSet.orSet((TokenSet[])new TokenSet[]{EXPRESSION_FIRST, TokenSet.create((IElementType[])new IElementType[]{KtTokens.FUN_KEYWORD, KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD, KtTokens.INTERFACE_KEYWORD, KtTokens.CLASS_KEYWORD, KtTokens.TYPE_ALIAS_KEYWORD}), KtTokens.MODIFIER_KEYWORDS});
        STATEMENT_NEW_LINE_QUICK_RECOVERY_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.andSet((TokenSet)STATEMENT_FIRST, (TokenSet)TokenSet.andNot((TokenSet)KtTokens.KEYWORDS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{KtTokens.IN_KEYWORD}))), TokenSet.create((IElementType[])new IElementType[]{KtTokens.EOL_OR_SEMICOLON})});
        EXPRESSION_FOLLOW = TokenSet.create((IElementType[])new IElementType[]{KtTokens.SEMICOLON, KtTokens.ARROW, KtTokens.COMMA, KtTokens.RBRACE, KtTokens.RPAR, KtTokens.RBRACKET});
        ALLOW_NEWLINE_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{KtTokens.DOT, KtTokens.SAFE_ACCESS, KtTokens.COLON, KtTokens.AS_KEYWORD, KtTokens.AS_SAFE, KtTokens.ELVIS, KtTokens.ANDAND, KtTokens.OROR});
        IElementType[] operations = new HashSet();
        for (Precedence precedence : values = Precedence.values()) {
            operations.addAll(Arrays.asList(precedence.getOperations().getTypes()));
        }
        ALL_OPERATIONS = TokenSet.create((IElementType[])operations.toArray(new IElementType[operations.size()]));
        operations = KtTokens.OPERATIONS.getTypes();
        HashSet<IElementType> opSet = new HashSet<IElementType>(Arrays.asList(operations));
        IElementType[] usedOperations = ALL_OPERATIONS.getTypes();
        HashSet<IElementType> usedSet = new HashSet<IElementType>(Arrays.asList(usedOperations));
        if (opSet.size() > usedSet.size()) {
            opSet.removeAll(usedSet);
            assert (false) : opSet;
        }
        assert (usedSet.size() == opSet.size()) : "Either some ops are unused, or something a non-op is used";
        usedSet.removeAll(opSet);
        assert (usedSet.isEmpty()) : ((Object)usedSet).toString();
    }

    public static class Precedence
    extends Enum<Precedence> {
        public static final /* enum */ Precedence POSTFIX;
        public static final /* enum */ Precedence PREFIX;
        public static final /* enum */ Precedence AS;
        public static final /* enum */ Precedence MULTIPLICATIVE;
        public static final /* enum */ Precedence ADDITIVE;
        public static final /* enum */ Precedence RANGE;
        public static final /* enum */ Precedence SIMPLE_NAME;
        public static final /* enum */ Precedence ELVIS;
        public static final /* enum */ Precedence IN_OR_IS;
        public static final /* enum */ Precedence COMPARISON;
        public static final /* enum */ Precedence EQUALITY;
        public static final /* enum */ Precedence CONJUNCTION;
        public static final /* enum */ Precedence DISJUNCTION;
        public static final /* enum */ Precedence ASSIGNMENT;
        private Precedence higher;
        private final TokenSet operations;
        private static final /* synthetic */ Precedence[] $VALUES;

        public static Precedence[] values() {
            return (Precedence[])$VALUES.clone();
        }

        public static Precedence valueOf(String name2) {
            return Enum.valueOf(Precedence.class, name2);
        }

        private Precedence(IElementType ... operations) {
            this.operations = TokenSet.create((IElementType[])operations);
        }

        public void parseHigherPrecedence(KotlinExpressionParsing parser) {
            assert (this.higher != null);
            parser.parseBinaryExpression(this.higher);
        }

        public KtNodeType parseRightHandSide(IElementType operation, KotlinExpressionParsing parser) {
            this.parseHigherPrecedence(parser);
            return KtNodeTypes.BINARY_EXPRESSION;
        }

        @NotNull
        public final TokenSet getOperations() {
            TokenSet tokenSet = this.operations;
            if (tokenSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/KotlinExpressionParsing$Precedence", "getOperations"));
            }
            return tokenSet;
        }

        static {
            Precedence[] values;
            POSTFIX = new Precedence(KtTokens.PLUSPLUS, KtTokens.MINUSMINUS, KtTokens.EXCLEXCL, KtTokens.DOT, KtTokens.SAFE_ACCESS);
            PREFIX = new Precedence(new IElementType[]{KtTokens.MINUS, KtTokens.PLUS, KtTokens.MINUSMINUS, KtTokens.PLUSPLUS, KtTokens.EXCL}){

                @Override
                public void parseHigherPrecedence(KotlinExpressionParsing parser) {
                    throw new IllegalStateException("Don't call this method");
                }
            };
            AS = new Precedence(new IElementType[]{KtTokens.AS_KEYWORD, KtTokens.AS_SAFE}){

                @Override
                public KtNodeType parseRightHandSide(IElementType operation, KotlinExpressionParsing parser) {
                    parser.myKotlinParsing.parseTypeRef();
                    return KtNodeTypes.BINARY_WITH_TYPE;
                }

                @Override
                public void parseHigherPrecedence(KotlinExpressionParsing parser) {
                    parser.parsePrefixExpression();
                }
            };
            MULTIPLICATIVE = new Precedence(KtTokens.MUL, KtTokens.DIV, KtTokens.PERC);
            ADDITIVE = new Precedence(KtTokens.PLUS, KtTokens.MINUS);
            RANGE = new Precedence(KtTokens.RANGE);
            SIMPLE_NAME = new Precedence(KtTokens.IDENTIFIER);
            ELVIS = new Precedence(KtTokens.ELVIS);
            IN_OR_IS = new Precedence(new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.NOT_IN, KtTokens.IS_KEYWORD, KtTokens.NOT_IS}){

                @Override
                public KtNodeType parseRightHandSide(IElementType operation, KotlinExpressionParsing parser) {
                    if (operation == KtTokens.IS_KEYWORD || operation == KtTokens.NOT_IS) {
                        parser.myKotlinParsing.parseTypeRef();
                        return KtNodeTypes.IS_EXPRESSION;
                    }
                    return super.parseRightHandSide(operation, parser);
                }
            };
            COMPARISON = new Precedence(KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ);
            EQUALITY = new Precedence(KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ);
            CONJUNCTION = new Precedence(KtTokens.ANDAND);
            DISJUNCTION = new Precedence(KtTokens.OROR);
            ASSIGNMENT = new Precedence(KtTokens.EQ, KtTokens.PLUSEQ, KtTokens.MINUSEQ, KtTokens.MULTEQ, KtTokens.DIVEQ, KtTokens.PERCEQ);
            $VALUES = new Precedence[]{POSTFIX, PREFIX, AS, MULTIPLICATIVE, ADDITIVE, RANGE, SIMPLE_NAME, ELVIS, IN_OR_IS, COMPARISON, EQUALITY, CONJUNCTION, DISJUNCTION, ASSIGNMENT};
            for (Precedence precedence : values = Precedence.values()) {
                int ordinal = precedence.ordinal();
                precedence.higher = ordinal > 0 ? values[ordinal - 1] : null;
            }
        }
    }
}

