/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Queue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.BodyResolveCache;
import org.jetbrains.kotlin.resolve.ControlFlowAnalyzer;
import org.jetbrains.kotlin.resolve.DeclarationsChecker;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionAnalyzerExtension;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;
import org.jetbrains.kotlin.types.expressions.ValueParameterResolver;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.Box;
import org.jetbrains.kotlin.util.ReenteringLazyValueComputationException;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class BodyResolver {
    @NotNull
    private final AnnotationChecker annotationChecker;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final ObservableBindingTrace trace;
    @NotNull
    private final ControlFlowAnalyzer controlFlowAnalyzer;
    @NotNull
    private final DeclarationsChecker declarationsChecker;
    @NotNull
    private final AnnotationResolver annotationResolver;
    @NotNull
    private final DelegatedPropertyResolver delegatedPropertyResolver;
    @NotNull
    private final FunctionAnalyzerExtension functionAnalyzerExtension;
    @NotNull
    private final ValueParameterResolver valueParameterResolver;
    @NotNull
    private final BodyResolveCache bodyResolveCache;
    @NotNull
    private final KotlinBuiltIns builtIns;

    public BodyResolver(@NotNull AnnotationResolver annotationResolver, @NotNull BodyResolveCache bodyResolveCache, @NotNull CallResolver callResolver, @NotNull ControlFlowAnalyzer controlFlowAnalyzer, @NotNull DeclarationsChecker declarationsChecker, @NotNull DelegatedPropertyResolver delegatedPropertyResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull FunctionAnalyzerExtension functionAnalyzerExtension, @NotNull BindingTrace trace, @NotNull ValueParameterResolver valueParameterResolver, @NotNull AnnotationChecker annotationChecker, @NotNull KotlinBuiltIns builtIns) {
        if (annotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResolver", "org/jetbrains/kotlin/resolve/BodyResolver", "<init>"));
        }
        if (bodyResolveCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyResolveCache", "org/jetbrains/kotlin/resolve/BodyResolver", "<init>"));
        }
        if (callResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/kotlin/resolve/BodyResolver", "<init>"));
        }
        if (controlFlowAnalyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlFlowAnalyzer", "org/jetbrains/kotlin/resolve/BodyResolver", "<init>"));
        }
        if (declarationsChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationsChecker", "org/jetbrains/kotlin/resolve/BodyResolver", "<init>"));
        }
        if (delegatedPropertyResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegatedPropertyResolver", "org/jetbrains/kotlin/resolve/BodyResolver", "<init>"));
        }
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/BodyResolver", "<init>"));
        }
        if (functionAnalyzerExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionAnalyzerExtension", "org/jetbrains/kotlin/resolve/BodyResolver", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BodyResolver", "<init>"));
        }
        if (valueParameterResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterResolver", "org/jetbrains/kotlin/resolve/BodyResolver", "<init>"));
        }
        if (annotationChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationChecker", "org/jetbrains/kotlin/resolve/BodyResolver", "<init>"));
        }
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/BodyResolver", "<init>"));
        }
        this.annotationResolver = annotationResolver;
        this.bodyResolveCache = bodyResolveCache;
        this.callResolver = callResolver;
        this.controlFlowAnalyzer = controlFlowAnalyzer;
        this.declarationsChecker = declarationsChecker;
        this.delegatedPropertyResolver = delegatedPropertyResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.functionAnalyzerExtension = functionAnalyzerExtension;
        this.annotationChecker = annotationChecker;
        this.trace = new ObservableBindingTrace(trace);
        this.valueParameterResolver = valueParameterResolver;
        this.builtIns = builtIns;
    }

    private void resolveBehaviorDeclarationBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveBehaviorDeclarationBodies"));
        }
        this.resolveSuperTypeEntryLists(c);
        this.resolvePropertyDeclarationBodies(c);
        this.resolveAnonymousInitializers(c);
        this.resolvePrimaryConstructorParameters(c);
        this.resolveSecondaryConstructors(c);
        this.resolveFunctionBodies(c);
        if (!c.getTopDownAnalysisMode().isLocalDeclarations()) {
            this.computeDeferredTypes();
        }
    }

    private void resolveSecondaryConstructors(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructors"));
        }
        for (Map.Entry<KtSecondaryConstructor, ConstructorDescriptor> entry : c.getSecondaryConstructors().entrySet()) {
            LexicalScope declaringScope = c.getDeclaringScope(entry.getKey());
            assert (declaringScope != null) : "Declaring scope should be registered before body resolve";
            this.resolveSecondaryConstructorBody(c.getOuterDataFlowInfo(), this.trace, entry.getKey(), entry.getValue(), declaringScope);
        }
        if (c.getSecondaryConstructors().isEmpty()) {
            return;
        }
        HashSet visitedConstructors = Sets.newHashSet();
        for (Map.Entry<KtSecondaryConstructor, ConstructorDescriptor> entry : c.getSecondaryConstructors().entrySet()) {
            this.checkCyclicConstructorDelegationCall(entry.getValue(), visitedConstructors);
        }
    }

    public void resolveSecondaryConstructorBody(final @NotNull DataFlowInfo outerDataFlowInfo, final @NotNull BindingTrace trace, final @NotNull KtSecondaryConstructor constructor, final @NotNull ConstructorDescriptor descriptor2, @NotNull LexicalScope declaringScope) {
        if (outerDataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerDataFlowInfo", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorBody"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorBody"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorBody"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorBody"));
        }
        if (declaringScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaringScope", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorBody"));
        }
        ForceResolveUtil.forceResolveAllContents(descriptor2.getAnnotations());
        this.resolveFunctionBody(outerDataFlowInfo, trace, constructor, descriptor2, declaringScope, new Function1<LexicalScope, DataFlowInfo>(){

            public DataFlowInfo invoke(@NotNull LexicalScope headerInnerScope) {
                if (headerInnerScope == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerInnerScope", "org/jetbrains/kotlin/resolve/BodyResolver$1", "invoke"));
                }
                return BodyResolver.this.resolveSecondaryConstructorDelegationCall(outerDataFlowInfo, trace, headerInnerScope, constructor, descriptor2);
            }
        }, new Function1<LexicalScope, LexicalScope>(){

            public LexicalScope invoke(LexicalScope scope2) {
                return new LexicalScopeImpl(scope2, descriptor2, scope2.isOwnerDescriptorAccessibleByLabel(), scope2.getImplicitReceiver(), LexicalScopeKind.CONSTRUCTOR_HEADER);
            }
        });
    }

    @Nullable
    private DataFlowInfo resolveSecondaryConstructorDelegationCall(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull BindingTrace trace, @NotNull LexicalScope scope2, @NotNull KtSecondaryConstructor constructor, @NotNull ConstructorDescriptor descriptor2) {
        if (outerDataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerDataFlowInfo", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorDelegationCall"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorDelegationCall"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorDelegationCall"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorDelegationCall"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSecondaryConstructorDelegationCall"));
        }
        OverloadResolutionResults<ConstructorDescriptor> results2 = this.callResolver.resolveConstructorDelegationCall(trace, scope2, outerDataFlowInfo, descriptor2, constructor.getDelegationCall());
        if (results2 != null && results2.isSingleResult()) {
            ResolvedCall<ConstructorDescriptor> resolvedCall2 = results2.getResultingCall();
            BodyResolver.recordConstructorDelegationCall(trace, descriptor2, resolvedCall2);
            return resolvedCall2.getDataFlowInfoForArguments().getResultInfo();
        }
        return null;
    }

    private void checkCyclicConstructorDelegationCall(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull Set<ConstructorDescriptor> visitedConstructors) {
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "checkCyclicConstructorDelegationCall"));
        }
        if (visitedConstructors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedConstructors", "org/jetbrains/kotlin/resolve/BodyResolver", "checkCyclicConstructorDelegationCall"));
        }
        if (visitedConstructors.contains(constructorDescriptor)) {
            return;
        }
        HashSet visitedInCurrentChain = Sets.newHashSet();
        ConstructorDescriptor currentConstructorDescriptor = constructorDescriptor;
        while (true) {
            visitedInCurrentChain.add(currentConstructorDescriptor);
            ConstructorDescriptor delegatedConstructorDescriptor = this.getDelegatedConstructor(currentConstructorDescriptor);
            if (delegatedConstructorDescriptor == null || !constructorDescriptor.getContainingDeclaration().equals(delegatedConstructorDescriptor.getContainingDeclaration()) || delegatedConstructorDescriptor.isPrimary() || visitedConstructors.contains(delegatedConstructorDescriptor)) break;
            if (visitedInCurrentChain.contains(delegatedConstructorDescriptor)) {
                this.reportEachConstructorOnCycle(delegatedConstructorDescriptor);
                break;
            }
            currentConstructorDescriptor = delegatedConstructorDescriptor;
        }
        visitedConstructors.addAll(visitedInCurrentChain);
    }

    private void reportEachConstructorOnCycle(@NotNull ConstructorDescriptor startConstructor) {
        if (startConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startConstructor", "org/jetbrains/kotlin/resolve/BodyResolver", "reportEachConstructorOnCycle"));
        }
        ConstructorDescriptor currentConstructor = startConstructor;
        do {
            PsiElement constructorToReport;
            if ((constructorToReport = DescriptorToSourceUtils.descriptorToDeclaration(currentConstructor)) != null) {
                KtConstructorDelegationCall call = ((KtSecondaryConstructor)constructorToReport).getDelegationCall();
                assert (call.getCalleeExpression() != null) : "Callee expression of delegation call should not be null on cycle as there should be explicit 'this' calls";
                this.trace.report(Errors.CYCLIC_CONSTRUCTOR_DELEGATION_CALL.on(call.getCalleeExpression()));
            }
            currentConstructor = this.getDelegatedConstructor(currentConstructor);
            assert (currentConstructor != null) : "Delegated constructor should not be null in cycle";
        } while (startConstructor != currentConstructor);
    }

    @Nullable
    private ConstructorDescriptor getDelegatedConstructor(@NotNull ConstructorDescriptor constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/resolve/BodyResolver", "getDelegatedConstructor"));
        }
        ResolvedCall<ConstructorDescriptor> call = this.trace.get(BindingContext.CONSTRUCTOR_RESOLVED_DELEGATION_CALL, constructor);
        return call == null || !call.getStatus().isSuccess() ? null : call.getResultingDescriptor().getOriginal();
    }

    public void resolveBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveBodies"));
        }
        this.resolveBehaviorDeclarationBodies(c);
        this.controlFlowAnalyzer.process(c);
        this.declarationsChecker.process(c);
        this.functionAnalyzerExtension.process(c);
    }

    private void resolveSuperTypeEntryLists(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSuperTypeEntryLists"));
        }
        for (Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            KtClassOrObject classOrObject = entry.getKey();
            ClassDescriptorWithResolutionScopes descriptor2 = entry.getValue();
            this.resolveSuperTypeEntryList(c.getOuterDataFlowInfo(), classOrObject, descriptor2, descriptor2.getUnsubstitutedPrimaryConstructor(), descriptor2.getScopeForConstructorHeaderResolution(), descriptor2.getScopeForMemberDeclarationResolution());
        }
    }

    public void resolveSuperTypeEntryList(final @NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtClassOrObject jetClass, final @NotNull ClassDescriptor descriptor2, final @Nullable ConstructorDescriptor primaryConstructor2, @NotNull LexicalScope scopeForConstructorResolution, final @NotNull LexicalScope scopeForMemberResolution) {
        if (outerDataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerDataFlowInfo", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSuperTypeEntryList"));
        }
        if (jetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetClass", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSuperTypeEntryList"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSuperTypeEntryList"));
        }
        if (scopeForConstructorResolution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForConstructorResolution", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSuperTypeEntryList"));
        }
        if (scopeForMemberResolution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForMemberResolution", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveSuperTypeEntryList"));
        }
        final LexicalScope scopeForConstructor = primaryConstructor2 == null ? null : FunctionDescriptorUtil.getFunctionInnerScope(scopeForConstructorResolution, (FunctionDescriptor)primaryConstructor2, this.trace);
        final ExpressionTypingServices typeInferrer = this.expressionTypingServices;
        final LinkedHashMap supertypes2 = Maps.newLinkedHashMap();
        final ResolvedCall[] primaryConstructorDelegationCall = new ResolvedCall[1];
        KtVisitorVoid visitor2 = new KtVisitorVoid(){

            private void recordSupertype(KtTypeReference typeReference, KotlinType supertype) {
                if (supertype == null) {
                    return;
                }
                supertypes2.put(typeReference, supertype);
            }

            @Override
            public void visitDelegatedSuperTypeEntry(@NotNull KtDelegatedSuperTypeEntry specifier) {
                KtExpression delegateExpression;
                ClassDescriptor classDescriptor;
                ClassifierDescriptor declarationDescriptor;
                if (specifier == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/kotlin/resolve/BodyResolver$3", "visitDelegatedSuperTypeEntry"));
                }
                if (descriptor2.getKind() == ClassKind.INTERFACE) {
                    BodyResolver.this.trace.report(Errors.DELEGATION_IN_INTERFACE.on(specifier));
                }
                KotlinType supertype = BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, specifier.getTypeReference());
                this.recordSupertype(specifier.getTypeReference(), supertype);
                if (supertype != null && (declarationDescriptor = supertype.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor && (classDescriptor = (ClassDescriptor)declarationDescriptor).getKind() != ClassKind.INTERFACE) {
                    BodyResolver.this.trace.report(Errors.DELEGATION_NOT_TO_INTERFACE.on(specifier.getTypeReference()));
                }
                if ((delegateExpression = specifier.getDelegateExpression()) != null) {
                    LexicalScope scope2 = scopeForConstructor == null ? scopeForMemberResolution : scopeForConstructor;
                    KotlinType expectedType = supertype != null ? supertype : TypeUtils.NO_EXPECTED_TYPE;
                    typeInferrer.getType(scope2, delegateExpression, expectedType, outerDataFlowInfo, BodyResolver.this.trace);
                }
                if (primaryConstructor2 == null) {
                    BodyResolver.this.trace.report(Errors.UNSUPPORTED.on((PsiElement)specifier, "Delegation without primary constructor is not supported"));
                }
            }

            @Override
            public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call) {
                KtTypeReference typeReference;
                KtElement elementToMark;
                if (call == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/BodyResolver$3", "visitSuperTypeCallEntry"));
                }
                KtValueArgumentList valueArgumentList = call.getValueArgumentList();
                KtElement ktElement = elementToMark = valueArgumentList == null ? call : valueArgumentList;
                if (descriptor2.getKind() == ClassKind.INTERFACE) {
                    BodyResolver.this.trace.report(Errors.SUPERTYPE_INITIALIZED_IN_INTERFACE.on((PsiElement)elementToMark));
                }
                if ((typeReference = call.getTypeReference()) == null) {
                    return;
                }
                if (primaryConstructor2 == null) {
                    if (descriptor2.getKind() != ClassKind.INTERFACE) {
                        BodyResolver.this.trace.report(Errors.SUPERTYPE_INITIALIZED_WITHOUT_PRIMARY_CONSTRUCTOR.on(call));
                    }
                    this.recordSupertype(typeReference, BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                    return;
                }
                OverloadResolutionResults<FunctionDescriptor> results2 = BodyResolver.this.callResolver.resolveFunctionCall(BodyResolver.this.trace, scopeForConstructor, CallMaker.makeConstructorCallWithoutTypeArguments(call), TypeUtils.NO_EXPECTED_TYPE, outerDataFlowInfo, false);
                if (results2.isSuccess()) {
                    KotlinType supertype = results2.getResultingDescriptor().getReturnType();
                    this.recordSupertype(typeReference, supertype);
                    ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(supertype);
                    if (classDescriptor != null) {
                        primaryConstructorDelegationCall[0] = primaryConstructorDelegationCall[0] == null ? results2.getResultingCall() : null;
                    }
                    BodyResolver.this.trace.record(BindingContext.PROCESSED, call.getCalleeExpression(), true);
                    BodyResolver.this.trace.record(BindingContext.EXPRESSION_TYPE_INFO, call.getCalleeExpression(), TypeInfoFactoryKt.noTypeInfo(results2.getResultingCall().getDataFlowInfoForArguments().getResultInfo()));
                } else {
                    this.recordSupertype(typeReference, BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                }
            }

            @Override
            public void visitSuperTypeEntry(@NotNull KtSuperTypeEntry specifier) {
                if (specifier == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/kotlin/resolve/BodyResolver$3", "visitSuperTypeEntry"));
                }
                KtTypeReference typeReference = specifier.getTypeReference();
                KotlinType supertype = BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference);
                this.recordSupertype(typeReference, supertype);
                if (supertype == null) {
                    return;
                }
                ClassDescriptor superClass = TypeUtils.getClassDescriptor(supertype);
                if (superClass == null) {
                    return;
                }
                if (superClass.getKind().isSingleton()) {
                    return;
                }
                if (descriptor2.getKind() != ClassKind.INTERFACE && descriptor2.getUnsubstitutedPrimaryConstructor() != null && superClass.getKind() != ClassKind.INTERFACE && !superClass.getConstructors().isEmpty() && !ErrorUtils.isError(superClass)) {
                    BodyResolver.this.trace.report(Errors.SUPERTYPE_NOT_INITIALIZED.on(specifier));
                }
            }

            @Override
            public void visitKtElement(@NotNull KtElement element2) {
                if (element2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/BodyResolver$3", "visitKtElement"));
                }
                throw new UnsupportedOperationException(element2.getText() + " : " + element2);
            }
        };
        for (KtSuperTypeListEntry delegationSpecifier : jetClass.getSuperTypeListEntries()) {
            delegationSpecifier.accept(visitor2);
        }
        if (DescriptorUtils.isAnnotationClass(descriptor2) && jetClass.getSuperTypeList() != null) {
            this.trace.report(Errors.SUPERTYPES_FOR_ANNOTATION_CLASS.on(jetClass.getSuperTypeList()));
        }
        if (primaryConstructorDelegationCall[0] != null && primaryConstructor2 != null) {
            BodyResolver.recordConstructorDelegationCall(this.trace, primaryConstructor2, primaryConstructorDelegationCall[0]);
        }
        this.checkSupertypeList(descriptor2, supertypes2, jetClass);
    }

    @NotNull
    private static Set<TypeConstructor> getAllowedFinalSupertypes(@NotNull ClassDescriptor descriptor2, @NotNull KtClassOrObject jetClass) {
        Set<TypeConstructor> parentEnumOrSealed;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "getAllowedFinalSupertypes"));
        }
        if (jetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetClass", "org/jetbrains/kotlin/resolve/BodyResolver", "getAllowedFinalSupertypes"));
        }
        if (jetClass instanceof KtEnumEntry) {
            parentEnumOrSealed = Collections.singleton(((ClassDescriptor)descriptor2.getContainingDeclaration()).getTypeConstructor());
        } else {
            parentEnumOrSealed = Collections.emptySet();
            ClassDescriptor currentDescriptor = descriptor2;
            while (currentDescriptor.getContainingDeclaration() instanceof ClassDescriptor) {
                if ((currentDescriptor = (ClassDescriptor)currentDescriptor.getContainingDeclaration()).getModality() != Modality.SEALED) continue;
                if (parentEnumOrSealed.isEmpty()) {
                    parentEnumOrSealed = new HashSet();
                }
                parentEnumOrSealed.add(currentDescriptor.getTypeConstructor());
            }
        }
        Set<TypeConstructor> set = parentEnumOrSealed;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BodyResolver", "getAllowedFinalSupertypes"));
        }
        return set;
    }

    private static void recordConstructorDelegationCall(@NotNull BindingTrace trace, @NotNull ConstructorDescriptor constructor, @NotNull ResolvedCall<?> call) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BodyResolver", "recordConstructorDelegationCall"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/resolve/BodyResolver", "recordConstructorDelegationCall"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/BodyResolver", "recordConstructorDelegationCall"));
        }
        trace.record(BindingContext.CONSTRUCTOR_RESOLVED_DELEGATION_CALL, constructor, call);
    }

    private void checkSupertypeList(@NotNull ClassDescriptor supertypeOwner, @NotNull Map<KtTypeReference, KotlinType> supertypes2, @NotNull KtClassOrObject jetClass) {
        if (supertypeOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypeOwner", "org/jetbrains/kotlin/resolve/BodyResolver", "checkSupertypeList"));
        }
        if (supertypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/kotlin/resolve/BodyResolver", "checkSupertypeList"));
        }
        if (jetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetClass", "org/jetbrains/kotlin/resolve/BodyResolver", "checkSupertypeList"));
        }
        Set<TypeConstructor> allowedFinalSupertypes = BodyResolver.getAllowedFinalSupertypes(supertypeOwner, jetClass);
        HashSet typeConstructors = Sets.newHashSet();
        boolean classAppeared = false;
        for (Map.Entry<KtTypeReference, KotlinType> entry : supertypes2.entrySet()) {
            KtTypeReference typeReference = entry.getKey();
            KotlinType supertype = entry.getValue();
            KtTypeElement typeElement = typeReference.getTypeElement();
            if (typeElement instanceof KtFunctionType) {
                for (KtParameter parameter : ((KtFunctionType)typeElement).getParameters()) {
                    PsiElement nameIdentifier = parameter.getNameIdentifier();
                    if (nameIdentifier == null) continue;
                    this.trace.report(Errors.UNSUPPORTED.on(nameIdentifier, "named parameter in function type in supertype position"));
                }
            }
            boolean addSupertype = true;
            ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(supertype);
            if (classDescriptor != null) {
                if (ErrorUtils.isError(classDescriptor)) continue;
                if (FunctionTypesKt.isExtensionFunctionType(supertype)) {
                    this.trace.report(Errors.SUPERTYPE_IS_EXTENSION_FUNCTION_TYPE.on(typeReference));
                }
                if (classDescriptor.getKind() != ClassKind.INTERFACE) {
                    if (supertypeOwner.getKind() == ClassKind.ENUM_CLASS) {
                        this.trace.report(Errors.CLASS_IN_SUPERTYPE_FOR_ENUM.on((PsiElement)typeReference));
                        addSupertype = false;
                    } else if (supertypeOwner.getKind() == ClassKind.INTERFACE && !classAppeared && !DynamicTypesKt.isDynamic(supertype)) {
                        this.trace.report(Errors.INTERFACE_WITH_SUPERCLASS.on((PsiElement)typeReference));
                        addSupertype = false;
                    } else if (jetClass.hasModifier(KtTokens.DATA_KEYWORD)) {
                        this.trace.report(Errors.DATA_CLASS_CANNOT_HAVE_CLASS_SUPERTYPES.on(typeReference));
                        addSupertype = false;
                    } else if (DescriptorUtils.isSubclass(classDescriptor, this.builtIns.getThrowable()) && !supertypeOwner.getDeclaredTypeParameters().isEmpty()) {
                        this.trace.report(Errors.GENERIC_THROWABLE_SUBCLASS.on(jetClass.getTypeParameterList()));
                        addSupertype = false;
                    }
                    if (classAppeared) {
                        this.trace.report(Errors.MANY_CLASSES_IN_SUPERTYPE_LIST.on(typeReference));
                    } else {
                        classAppeared = true;
                    }
                }
            } else {
                this.trace.report(Errors.SUPERTYPE_NOT_A_CLASS_OR_INTERFACE.on(typeReference));
            }
            TypeConstructor constructor = supertype.getConstructor();
            if (addSupertype && !typeConstructors.add(constructor)) {
                this.trace.report(Errors.SUPERTYPE_APPEARS_TWICE.on(typeReference));
            }
            if (classDescriptor == null) {
                return;
            }
            if (classDescriptor.getKind().isSingleton()) {
                if (DescriptorUtils.isEnumEntry(classDescriptor)) continue;
                this.trace.report(Errors.SINGLETON_IN_SUPERTYPE.on(typeReference));
                continue;
            }
            if (allowedFinalSupertypes.contains(constructor)) continue;
            if (classDescriptor.getModality() == Modality.SEALED) {
                DeclarationDescriptor containingDescriptor;
                for (containingDescriptor = supertypeOwner.getContainingDeclaration(); containingDescriptor != null && containingDescriptor != classDescriptor; containingDescriptor = containingDescriptor.getContainingDeclaration()) {
                }
                if (containingDescriptor == null) {
                    this.trace.report(Errors.SEALED_SUPERTYPE.on(typeReference));
                    continue;
                }
                this.trace.report(Errors.SEALED_SUPERTYPE_IN_LOCAL_CLASS.on(typeReference));
                continue;
            }
            if (!ModalityKt.isFinalOrEnum(classDescriptor)) continue;
            this.trace.report(Errors.FINAL_SUPERTYPE.on(typeReference));
        }
    }

    private void resolveAnonymousInitializers(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveAnonymousInitializers"));
        }
        for (Map.Entry<KtAnonymousInitializer, ClassDescriptorWithResolutionScopes> entry : c.getAnonymousInitializers().entrySet()) {
            KtAnonymousInitializer initializer2 = entry.getKey();
            ClassDescriptorWithResolutionScopes descriptor2 = entry.getValue();
            this.resolveAnonymousInitializer(c.getOuterDataFlowInfo(), initializer2, descriptor2);
        }
    }

    public void resolveAnonymousInitializer(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtAnonymousInitializer anonymousInitializer, @NotNull ClassDescriptorWithResolutionScopes classDescriptor) {
        if (outerDataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerDataFlowInfo", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveAnonymousInitializer"));
        }
        if (anonymousInitializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anonymousInitializer", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveAnonymousInitializer"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveAnonymousInitializer"));
        }
        LexicalScope scopeForInitializers = classDescriptor.getScopeForInitializerResolution();
        KtExpression body2 = anonymousInitializer.getBody();
        if (body2 != null) {
            PreliminaryDeclarationVisitor.Companion.createForDeclaration((KtDeclaration)anonymousInitializer.getParent().getParent(), this.trace);
            this.expressionTypingServices.getTypeInfo(scopeForInitializers, body2, TypeUtils.NO_EXPECTED_TYPE, outerDataFlowInfo, this.trace, true);
        }
        this.processModifiersOnInitializer(anonymousInitializer, scopeForInitializers);
        if (classDescriptor.getConstructors().isEmpty()) {
            this.trace.report(Errors.ANONYMOUS_INITIALIZER_IN_INTERFACE.on(anonymousInitializer));
        }
    }

    private void processModifiersOnInitializer(@NotNull KtModifierListOwner owner, @NotNull LexicalScope scope2) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/resolve/BodyResolver", "processModifiersOnInitializer"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/BodyResolver", "processModifiersOnInitializer"));
        }
        this.annotationChecker.check(owner, this.trace, null);
        ModifierCheckerCore.INSTANCE.check(owner, this.trace, null);
        KtModifierList modifierList = owner.getModifierList();
        if (modifierList == null) {
            return;
        }
        this.annotationResolver.resolveAnnotationsWithArguments(scope2, modifierList, (BindingTrace)this.trace);
    }

    private void resolvePrimaryConstructorParameters(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePrimaryConstructorParameters"));
        }
        for (Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            KtClassOrObject klass = entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptor = entry.getValue();
            ConstructorDescriptor unsubstitutedPrimaryConstructor = classDescriptor.getUnsubstitutedPrimaryConstructor();
            if (unsubstitutedPrimaryConstructor == null) continue;
            ForceResolveUtil.forceResolveAllContents(unsubstitutedPrimaryConstructor.getAnnotations());
            LexicalScope parameterScope = BodyResolver.getPrimaryConstructorParametersScope(classDescriptor.getScopeForConstructorHeaderResolution(), unsubstitutedPrimaryConstructor);
            this.valueParameterResolver.resolveValueParameters(klass.getPrimaryConstructorParameters(), unsubstitutedPrimaryConstructor.getValueParameters(), parameterScope, c.getOuterDataFlowInfo(), this.trace);
        }
    }

    private static LexicalScope getPrimaryConstructorParametersScope(LexicalScope originalScope, final ConstructorDescriptor unsubstitutedPrimaryConstructor) {
        return new LexicalScopeImpl(originalScope, unsubstitutedPrimaryConstructor, false, null, LexicalScopeKind.DEFAULT_VALUE, LocalRedeclarationChecker.DO_NOTHING.INSTANCE, (Function1<? super LexicalScopeImpl.InitializeHandler, Unit>)new Function1<LexicalScopeImpl.InitializeHandler, Unit>(){

            public Unit invoke(LexicalScopeImpl.InitializeHandler handler2) {
                for (ValueParameterDescriptor valueParameterDescriptor : unsubstitutedPrimaryConstructor.getValueParameters()) {
                    handler2.addVariableDescriptor(valueParameterDescriptor);
                }
                return Unit.INSTANCE;
            }
        });
    }

    public void resolveProperty(@NotNull BodiesResolveContext c, @NotNull KtProperty property2, @NotNull PropertyDescriptor propertyDescriptor) {
        KtExpression delegateExpression;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveProperty"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveProperty"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveProperty"));
        }
        BodyResolver.computeDeferredType(propertyDescriptor.getReturnType());
        PreliminaryDeclarationVisitor.Companion.createForDeclaration(property2, this.trace);
        KtExpression initializer2 = property2.getInitializer();
        LexicalScope propertyHeaderScope = ScopeUtils.makeScopeForPropertyHeader(BodyResolver.getScopeForProperty(c, property2), propertyDescriptor);
        if (initializer2 != null) {
            this.resolvePropertyInitializer(c.getOuterDataFlowInfo(), property2, propertyDescriptor, initializer2, propertyHeaderScope);
        }
        if ((delegateExpression = property2.getDelegateExpression()) != null) {
            assert (initializer2 == null) : "Initializer should be null for delegated property : " + property2.getText();
            this.resolvePropertyDelegate(c.getOuterDataFlowInfo(), property2, propertyDescriptor, delegateExpression, propertyHeaderScope);
        }
        this.resolvePropertyAccessors(c, property2, propertyDescriptor);
    }

    private void resolvePropertyDeclarationBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyDeclarationBodies"));
        }
        HashSet processed = Sets.newHashSet();
        for (Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            if (!(entry.getKey() instanceof KtClass)) continue;
            KtClass ktClass = (KtClass)entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptor = entry.getValue();
            for (KtProperty property2 : ktClass.getProperties()) {
                PropertyDescriptor propertyDescriptor = c.getProperties().get(property2);
                assert (propertyDescriptor != null);
                this.resolveProperty(c, property2, propertyDescriptor);
                processed.add(property2);
            }
        }
        for (Map.Entry<KtTypeParameterListOwnerStub, MemberDescriptor> entry : c.getProperties().entrySet()) {
            KtProperty property3 = (KtProperty)entry.getKey();
            if (processed.contains(property3)) continue;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            this.resolveProperty(c, property3, propertyDescriptor);
        }
    }

    private static LexicalScope makeScopeForPropertyAccessor(@NotNull BodiesResolveContext c, @NotNull KtPropertyAccessor accessor, @NotNull PropertyDescriptor descriptor2) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "makeScopeForPropertyAccessor"));
        }
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/kotlin/resolve/BodyResolver", "makeScopeForPropertyAccessor"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "makeScopeForPropertyAccessor"));
        }
        LexicalScope accessorDeclaringScope = c.getDeclaringScope(accessor);
        assert (accessorDeclaringScope != null) : "Scope for accessor " + accessor.getText() + " should exists";
        LexicalScope headerScope2 = ScopeUtils.makeScopeForPropertyHeader(accessorDeclaringScope, descriptor2);
        return new LexicalScopeImpl(headerScope2, descriptor2, true, descriptor2.getExtensionReceiverParameter(), LexicalScopeKind.PROPERTY_ACCESSOR_BODY);
    }

    private void resolvePropertyAccessors(@NotNull BodiesResolveContext c, @NotNull KtProperty property2, @NotNull PropertyDescriptor propertyDescriptor) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyAccessors"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyAccessors"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyAccessors"));
        }
        ObservableBindingTrace fieldAccessTrackingTrace = this.createFieldTrackingTrace(propertyDescriptor);
        KtPropertyAccessor getter = property2.getGetter();
        PropertyGetterDescriptor getterDescriptor = propertyDescriptor.getGetter();
        if (getter != null && getterDescriptor != null) {
            LexicalScope accessorScope = BodyResolver.makeScopeForPropertyAccessor(c, getter, propertyDescriptor);
            ForceResolveUtil.forceResolveAllContents(getterDescriptor.getAnnotations());
            this.resolveFunctionBody(c.getOuterDataFlowInfo(), fieldAccessTrackingTrace, getter, getterDescriptor, accessorScope);
        }
        KtPropertyAccessor setter = property2.getSetter();
        PropertySetterDescriptor setterDescriptor = propertyDescriptor.getSetter();
        if (setter != null && setterDescriptor != null) {
            LexicalScope accessorScope = BodyResolver.makeScopeForPropertyAccessor(c, setter, propertyDescriptor);
            ForceResolveUtil.forceResolveAllContents(setterDescriptor.getAnnotations());
            this.resolveFunctionBody(c.getOuterDataFlowInfo(), fieldAccessTrackingTrace, setter, setterDescriptor, accessorScope);
        }
    }

    private ObservableBindingTrace createFieldTrackingTrace(final PropertyDescriptor propertyDescriptor) {
        return new ObservableBindingTrace(this.trace).addHandler(BindingContext.REFERENCE_TARGET, new ObservableBindingTrace.RecordHandler<KtReferenceExpression, DeclarationDescriptor>(){

            @Override
            public void handleRecord(WritableSlice<KtReferenceExpression, DeclarationDescriptor> slice, KtReferenceExpression expression2, DeclarationDescriptor descriptor2) {
                if (expression2 instanceof KtSimpleNameExpression && descriptor2 instanceof SyntheticFieldDescriptor) {
                    BodyResolver.this.trace.record(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
                }
            }
        });
    }

    private void resolvePropertyDelegate(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull KtExpression delegateExpression, @NotNull LexicalScope propertyHeaderScope) {
        KtPropertyAccessor setter;
        if (outerDataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerDataFlowInfo", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        if (delegateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateExpression", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        if (propertyHeaderScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyHeaderScope", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyDelegate"));
        }
        KtPropertyAccessor getter = property2.getGetter();
        if (getter != null && getter.hasBody()) {
            this.trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on(getter));
        }
        if ((setter = property2.getSetter()) != null && setter.hasBody()) {
            this.trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on(setter));
        }
        LexicalScope delegateFunctionsScope = ScopeUtils.makeScopeForDelegateConventionFunctions(propertyHeaderScope, propertyDescriptor);
        LexicalScope initializerScope = ScopeUtils.makeScopeForPropertyInitializer(propertyHeaderScope, propertyDescriptor);
        KotlinType delegateType = this.delegatedPropertyResolver.resolveDelegateExpression(delegateExpression, property2, propertyDescriptor, initializerScope, this.trace, outerDataFlowInfo);
        this.delegatedPropertyResolver.resolveDelegatedPropertyGetMethod(propertyDescriptor, delegateExpression, delegateType, this.trace, delegateFunctionsScope);
        if (property2.isVar()) {
            this.delegatedPropertyResolver.resolveDelegatedPropertySetMethod(propertyDescriptor, delegateExpression, delegateType, this.trace, delegateFunctionsScope);
        }
        this.delegatedPropertyResolver.resolveDelegatedPropertyPDMethod(propertyDescriptor, delegateExpression, delegateType, this.trace, delegateFunctionsScope);
    }

    private void resolvePropertyInitializer(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull KtProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull KtExpression initializer2, @NotNull LexicalScope propertyHeader) {
        KotlinType expectedTypeForInitializer;
        if (outerDataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerDataFlowInfo", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyInitializer"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyInitializer"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyInitializer"));
        }
        if (initializer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyInitializer"));
        }
        if (propertyHeader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyHeader", "org/jetbrains/kotlin/resolve/BodyResolver", "resolvePropertyInitializer"));
        }
        LexicalScope propertyDeclarationInnerScope = ScopeUtils.makeScopeForPropertyInitializer(propertyHeader, propertyDescriptor);
        KotlinType kotlinType = expectedTypeForInitializer = property2.getTypeReference() != null ? propertyDescriptor.getType() : TypeUtils.NO_EXPECTED_TYPE;
        if (propertyDescriptor.getCompileTimeInitializer() == null) {
            this.expressionTypingServices.getType(propertyDeclarationInnerScope, initializer2, expectedTypeForInitializer, outerDataFlowInfo, this.trace);
        }
    }

    @NotNull
    private static LexicalScope getScopeForProperty(@NotNull BodiesResolveContext c, @NotNull KtProperty property2) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "getScopeForProperty"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/BodyResolver", "getScopeForProperty"));
        }
        LexicalScope scope2 = c.getDeclaringScope(property2);
        assert (scope2 != null) : "Scope for property " + property2.getText() + " should exists";
        LexicalScope lexicalScope = scope2;
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/BodyResolver", "getScopeForProperty"));
        }
        return lexicalScope;
    }

    private void resolveFunctionBodies(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBodies"));
        }
        for (Map.Entry<KtNamedFunction, SimpleFunctionDescriptor> entry : c.getFunctions().entrySet()) {
            KtNamedFunction declaration = entry.getKey();
            LexicalScope scope2 = c.getDeclaringScope(declaration);
            assert (scope2 != null) : "Scope is null: " + PsiUtilsKt.getElementTextWithContext(declaration);
            if (!c.getTopDownAnalysisMode().isLocalDeclarations() && !(this.bodyResolveCache instanceof BodyResolveCache.ThrowException) && this.expressionTypingServices.getStatementFilter() != StatementFilter.NONE) {
                this.bodyResolveCache.resolveFunctionBody(declaration).addOwnDataTo(this.trace, true);
                continue;
            }
            this.resolveFunctionBody(c.getOuterDataFlowInfo(), this.trace, declaration, entry.getValue(), scope2);
        }
    }

    public void resolveFunctionBody(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull BindingTrace trace, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull LexicalScope declaringScope) {
        if (outerDataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerDataFlowInfo", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (declaringScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaringScope", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        BodyResolver.computeDeferredType(functionDescriptor.getReturnType());
        this.resolveFunctionBody(outerDataFlowInfo, trace, function2, functionDescriptor, declaringScope, null, null);
        assert (functionDescriptor.getReturnType() != null);
    }

    private void resolveFunctionBody(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull BindingTrace trace, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull LexicalScope scope2, @Nullable Function1<LexicalScope, DataFlowInfo> beforeBlockBody, @Nullable Function1<LexicalScope, LexicalScope> headerScopeFactory) {
        if (outerDataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerDataFlowInfo", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveFunctionBody"));
        }
        PreliminaryDeclarationVisitor.Companion.createForDeclaration(function2, trace);
        LexicalScope innerScope = FunctionDescriptorUtil.getFunctionInnerScope(scope2, functionDescriptor, trace);
        List<KtParameter> valueParameters = function2.getValueParameters();
        List<ValueParameterDescriptor> valueParameterDescriptors = functionDescriptor.getValueParameters();
        LexicalScope headerScope2 = headerScopeFactory != null ? (LexicalScope)headerScopeFactory.invoke((Object)innerScope) : innerScope;
        this.valueParameterResolver.resolveValueParameters(valueParameters, valueParameterDescriptors, headerScope2, outerDataFlowInfo, trace);
        if (functionDescriptor instanceof PropertyAccessorDescriptor && functionDescriptor.getExtensionReceiverParameter() == null) {
            PropertyAccessorDescriptor accessorDescriptor = (PropertyAccessorDescriptor)functionDescriptor;
            KtProperty property2 = (KtProperty)function2.getParent();
            final SyntheticFieldDescriptor fieldDescriptor = new SyntheticFieldDescriptor(accessorDescriptor, property2);
            innerScope = new LexicalScopeImpl(innerScope, functionDescriptor, true, null, LexicalScopeKind.PROPERTY_ACCESSOR_BODY, LocalRedeclarationChecker.DO_NOTHING.INSTANCE, (Function1<? super LexicalScopeImpl.InitializeHandler, Unit>)new Function1<LexicalScopeImpl.InitializeHandler, Unit>(){

                public Unit invoke(LexicalScopeImpl.InitializeHandler handler2) {
                    handler2.addVariableDescriptor(fieldDescriptor);
                    return Unit.INSTANCE;
                }
            });
            for (KtParameter parameter : function2.getValueParameters()) {
                if (!SyntheticFieldDescriptor.NAME.equals(parameter.getNameAsName())) continue;
                trace.report(Errors.ACCESSOR_PARAMETER_NAME_SHADOWING.on(parameter));
            }
        }
        DataFlowInfo dataFlowInfo = null;
        if (beforeBlockBody != null) {
            dataFlowInfo = (DataFlowInfo)beforeBlockBody.invoke((Object)headerScope2);
        }
        if (function2.hasBody()) {
            this.expressionTypingServices.checkFunctionReturnType(innerScope, function2, functionDescriptor, dataFlowInfo != null ? dataFlowInfo : outerDataFlowInfo, null, trace);
        }
        assert (functionDescriptor.getReturnType() != null);
    }

    public void resolveConstructorParameterDefaultValuesAndAnnotations(@NotNull DataFlowInfo outerDataFlowInfo, @NotNull BindingTrace trace, @NotNull KtClass klass, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull LexicalScope declaringScope) {
        if (outerDataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerDataFlowInfo", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveConstructorParameterDefaultValuesAndAnnotations"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveConstructorParameterDefaultValuesAndAnnotations"));
        }
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveConstructorParameterDefaultValuesAndAnnotations"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveConstructorParameterDefaultValuesAndAnnotations"));
        }
        if (declaringScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaringScope", "org/jetbrains/kotlin/resolve/BodyResolver", "resolveConstructorParameterDefaultValuesAndAnnotations"));
        }
        List<KtParameter> valueParameters = klass.getPrimaryConstructorParameters();
        List<ValueParameterDescriptor> valueParameterDescriptors = constructorDescriptor.getValueParameters();
        LexicalScope scope2 = BodyResolver.getPrimaryConstructorParametersScope(declaringScope, constructorDescriptor);
        this.valueParameterResolver.resolveValueParameters(valueParameters, valueParameterDescriptors, scope2, outerDataFlowInfo, trace);
    }

    private static void computeDeferredType(KotlinType type2) {
        DeferredType deferredType;
        if (type2 instanceof DeferredType && !(deferredType = (DeferredType)type2).isComputed()) {
            deferredType.getDelegate();
        }
    }

    private void computeDeferredTypes() {
        Collection<Box<DeferredType>> deferredTypes = this.trace.getKeys(BindingContext.DEFERRED_TYPE);
        if (deferredTypes.isEmpty()) {
            return;
        }
        final Queue queue = new Queue(deferredTypes.size() + 1);
        this.trace.addHandler(BindingContext.DEFERRED_TYPE, new ObservableBindingTrace.RecordHandler<Box<DeferredType>, Boolean>(){

            @Override
            public void handleRecord(WritableSlice<Box<DeferredType>, Boolean> deferredTypeKeyDeferredTypeWritableSlice, Box<DeferredType> key, Boolean value2) {
                queue.addLast((Object)key.getData());
            }
        });
        for (Box<DeferredType> deferredType : deferredTypes) {
            queue.addLast((Object)deferredType.getData());
        }
        while (!queue.isEmpty()) {
            DeferredType deferredType = (DeferredType)queue.pullFirst();
            if (deferredType.isComputed()) continue;
            try {
                deferredType.getDelegate();
            }
            catch (ReenteringLazyValueComputationException reenteringLazyValueComputationException) {}
        }
    }
}

