/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorWithInitializerImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ6\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ8\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J8\u0010%\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/resolve/VariableTypeResolver;", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "delegatedPropertyResolver", "Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;)V", "process", "Lorg/jetbrains/kotlin/types/KotlinType;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/VariableDescriptorWithInitializerImpl;", "scopeForInitializer", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "variable", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "notLocal", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "resolveDelegatedPropertyType", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "delegateExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "resolveInitializerType", "scope", "initializer", "setConstantForVariableIfNeeded", "", "variableType", "frontend"})
public final class VariableTypeResolver {
    private final StorageManager storageManager;
    private final ExpressionTypingServices expressionTypingServices;
    private final TypeResolver typeResolver;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final DelegatedPropertyResolver delegatedPropertyResolver;

    @NotNull
    public final KotlinType process(@NotNull VariableDescriptorWithInitializerImpl variableDescriptor, @NotNull LexicalScope scopeForInitializer, @NotNull KtVariableDeclaration variable2, @NotNull DataFlowInfo dataFlowInfo, boolean notLocal, @NotNull BindingTrace trace) {
        boolean hasDelegate;
        Intrinsics.checkParameterIsNotNull((Object)variableDescriptor, (String)"variableDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)scopeForInitializer, (String)"scopeForInitializer");
        Intrinsics.checkParameterIsNotNull((Object)variable2, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        KtTypeReference propertyTypeRef = variable2.getTypeReference();
        boolean bl = hasDelegate = variable2 instanceof KtProperty && ((KtProperty)variable2).hasDelegateExpression();
        if (propertyTypeRef != null) {
            KotlinType type2 = this.typeResolver.resolveType(scopeForInitializer, propertyTypeRef, trace, true);
            this.setConstantForVariableIfNeeded(variableDescriptor, scopeForInitializer, variable2, dataFlowInfo, type2, trace);
            return type2;
        }
        if (!variable2.hasInitializer()) {
            if (hasDelegate && variableDescriptor instanceof PropertyDescriptor) {
                KtVariableDeclaration ktVariableDeclaration = variable2;
                if (ktVariableDeclaration == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
                }
                KtProperty property2 = (KtProperty)ktVariableDeclaration;
                if (property2.hasDelegateExpression()) {
                    KotlinType kotlinType = DeferredType.createRecursionIntolerant(this.storageManager, trace, (Function0<KotlinType>)((Function0)new Function0<KotlinType>(this, property2, variableDescriptor, scopeForInitializer, dataFlowInfo, trace){
                        final /* synthetic */ VariableTypeResolver this$0;
                        final /* synthetic */ KtProperty $property;
                        final /* synthetic */ VariableDescriptorWithInitializerImpl $variableDescriptor;
                        final /* synthetic */ LexicalScope $scopeForInitializer;
                        final /* synthetic */ DataFlowInfo $dataFlowInfo;
                        final /* synthetic */ BindingTrace $trace;

                        @NotNull
                        public final KotlinType invoke() {
                            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)((Object)this.$variableDescriptor);
                            KtExpression ktExpression = this.$property.getDelegateExpression();
                            if (ktExpression == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"property.delegateExpression!!");
                            return VariableTypeResolver.access$resolveDelegatedPropertyType(this.this$0, this.$property, propertyDescriptor, this.$scopeForInitializer, ktExpression, this.$dataFlowInfo, this.$trace);
                        }
                        {
                            this.this$0 = variableTypeResolver;
                            this.$property = ktProperty;
                            this.$variableDescriptor = variableDescriptorWithInitializerImpl;
                            this.$scopeForInitializer = lexicalScope;
                            this.$dataFlowInfo = dataFlowInfo;
                            this.$trace = bindingTrace;
                            super(0);
                        }
                    }));
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"DeferredType.createRecur\u2026                        }");
                    return kotlinType;
                }
            }
            if (!notLocal) {
                trace.report(Errors.VARIABLE_WITH_NO_TYPE_NO_INITIALIZER.on((KtVariableDeclaration)((PsiElement)variable2)));
            }
            KotlinType kotlinType = ErrorUtils.createErrorType("No type, no body");
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"ErrorUtils.createErrorType(\"No type, no body\")");
            return kotlinType;
        }
        if (notLocal) {
            KotlinType kotlinType = DeferredType.createRecursionIntolerant(this.storageManager, trace, (Function0<KotlinType>)((Function0)new Function0<KotlinType>(this, variable2, trace, scopeForInitializer, dataFlowInfo, variableDescriptor){
                final /* synthetic */ VariableTypeResolver this$0;
                final /* synthetic */ KtVariableDeclaration $variable;
                final /* synthetic */ BindingTrace $trace;
                final /* synthetic */ LexicalScope $scopeForInitializer;
                final /* synthetic */ DataFlowInfo $dataFlowInfo;
                final /* synthetic */ VariableDescriptorWithInitializerImpl $variableDescriptor;

                @Nullable
                public final KotlinType invoke() {
                    PreliminaryDeclarationVisitor.Companion.createForDeclaration(this.$variable, this.$trace);
                    KtExpression ktExpression = this.$variable.getInitializer();
                    if (ktExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"variable.initializer!!");
                    KotlinType initializerType = VariableTypeResolver.access$resolveInitializerType(this.this$0, this.$scopeForInitializer, ktExpression, this.$dataFlowInfo, this.$trace);
                    VariableTypeResolver.access$setConstantForVariableIfNeeded(this.this$0, this.$variableDescriptor, this.$scopeForInitializer, this.$variable, this.$dataFlowInfo, initializerType, this.$trace);
                    return DescriptorResolver.transformAnonymousTypeIfNeeded(this.$variableDescriptor, this.$variable, initializerType, this.$trace);
                }
                {
                    this.this$0 = variableTypeResolver;
                    this.$variable = ktVariableDeclaration;
                    this.$trace = bindingTrace;
                    this.$scopeForInitializer = lexicalScope;
                    this.$dataFlowInfo = dataFlowInfo;
                    this.$variableDescriptor = variableDescriptorWithInitializerImpl;
                    super(0);
                }
            }));
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"DeferredType.createRecur\u2026 trace)\n                }");
            return kotlinType;
        }
        KtExpression ktExpression = variable2.getInitializer();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"variable.initializer!!");
        KotlinType initializerType = this.resolveInitializerType(scopeForInitializer, ktExpression, dataFlowInfo, trace);
        this.setConstantForVariableIfNeeded(variableDescriptor, scopeForInitializer, variable2, dataFlowInfo, initializerType, trace);
        return initializerType;
    }

    private final void setConstantForVariableIfNeeded(VariableDescriptorWithInitializerImpl variableDescriptor, LexicalScope scope2, KtVariableDeclaration variable2, DataFlowInfo dataFlowInfo, KotlinType variableType, BindingTrace trace) {
        if (!DescriptorUtils.shouldRecordInitializerForProperty(variableDescriptor, variableType)) {
            return;
        }
        if (!variable2.hasInitializer()) {
            return;
        }
        variableDescriptor.setCompileTimeInitializer(this.storageManager.createRecursionTolerantNullableLazyValue((Function0)new Function0<ConstantValue<? extends Object>>(this, variable2, scope2, variableType, dataFlowInfo, trace, variableDescriptor){
            final /* synthetic */ VariableTypeResolver this$0;
            final /* synthetic */ KtVariableDeclaration $variable;
            final /* synthetic */ LexicalScope $scope;
            final /* synthetic */ KotlinType $variableType;
            final /* synthetic */ DataFlowInfo $dataFlowInfo;
            final /* synthetic */ BindingTrace $trace;
            final /* synthetic */ VariableDescriptorWithInitializerImpl $variableDescriptor;

            @Nullable
            public final ConstantValue<Object> invoke() {
                KtExpression initializer2 = this.$variable.getInitializer();
                ExpressionTypingServices expressionTypingServices = VariableTypeResolver.access$getExpressionTypingServices$p(this.this$0);
                KtExpression ktExpression = initializer2;
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                KotlinType initializerType = expressionTypingServices.safeGetType(this.$scope, ktExpression, this.$variableType, this.$dataFlowInfo, this.$trace);
                CompileTimeConstant<?> compileTimeConstant = VariableTypeResolver.access$getConstantExpressionEvaluator$p(this.this$0).evaluateExpression(initializer2, this.$trace, initializerType);
                if (compileTimeConstant == null) {
                    return null;
                }
                CompileTimeConstant<?> constant = compileTimeConstant;
                if (constant.getUsesNonConstValAsConstant() && this.$variableDescriptor.isConst()) {
                    this.$trace.report(Errors.NON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION.on((KtExpression)((PsiElement)initializer2)));
                }
                KotlinType kotlinType = initializerType;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"initializerType");
                return constant.toConstantValue(kotlinType);
            }
            {
                this.this$0 = variableTypeResolver;
                this.$variable = ktVariableDeclaration;
                this.$scope = lexicalScope;
                this.$variableType = kotlinType;
                this.$dataFlowInfo = dataFlowInfo;
                this.$trace = bindingTrace;
                this.$variableDescriptor = variableDescriptorWithInitializerImpl;
                super(0);
            }
        }, null));
    }

    private final KotlinType resolveDelegatedPropertyType(KtProperty property2, PropertyDescriptor propertyDescriptor, LexicalScope scopeForInitializer, KtExpression delegateExpression, DataFlowInfo dataFlowInfo, BindingTrace trace) {
        LexicalScope delegateFunctionsScope;
        KotlinType type2 = this.delegatedPropertyResolver.resolveDelegateExpression(delegateExpression, property2, propertyDescriptor, scopeForInitializer, trace, dataFlowInfo);
        KotlinType getterReturnType = this.delegatedPropertyResolver.getDelegatedPropertyGetMethodReturnType(propertyDescriptor, delegateExpression, type2, trace, delegateFunctionsScope = ScopeUtils.makeScopeForDelegateConventionFunctions(scopeForInitializer, propertyDescriptor));
        if (getterReturnType != null) {
            return getterReturnType;
        }
        KotlinType kotlinType = ErrorUtils.createErrorType("Type from delegate");
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"ErrorUtils.createErrorType(\"Type from delegate\")");
        return kotlinType;
    }

    private final KotlinType resolveInitializerType(LexicalScope scope2, KtExpression initializer2, DataFlowInfo dataFlowInfo, BindingTrace trace) {
        KotlinType kotlinType = this.expressionTypingServices.safeGetType(scope2, initializer2, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, trace);
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"expressionTypingServices\u2026YPE, dataFlowInfo, trace)");
        return kotlinType;
    }

    public VariableTypeResolver(@NotNull StorageManager storageManager, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull TypeResolver typeResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull DelegatedPropertyResolver delegatedPropertyResolver) {
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        Intrinsics.checkParameterIsNotNull((Object)expressionTypingServices, (String)"expressionTypingServices");
        Intrinsics.checkParameterIsNotNull((Object)typeResolver, (String)"typeResolver");
        Intrinsics.checkParameterIsNotNull((Object)constantExpressionEvaluator, (String)"constantExpressionEvaluator");
        Intrinsics.checkParameterIsNotNull((Object)delegatedPropertyResolver, (String)"delegatedPropertyResolver");
        this.storageManager = storageManager;
        this.expressionTypingServices = expressionTypingServices;
        this.typeResolver = typeResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.delegatedPropertyResolver = delegatedPropertyResolver;
    }

    @NotNull
    public static final /* synthetic */ KotlinType access$resolveDelegatedPropertyType(VariableTypeResolver $this, @NotNull KtProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull LexicalScope scopeForInitializer, @NotNull KtExpression delegateExpression, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        return $this.resolveDelegatedPropertyType(property2, propertyDescriptor, scopeForInitializer, delegateExpression, dataFlowInfo, trace);
    }

    @NotNull
    public static final /* synthetic */ KotlinType access$resolveInitializerType(VariableTypeResolver $this, @NotNull LexicalScope scope2, @NotNull KtExpression initializer2, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        return $this.resolveInitializerType(scope2, initializer2, dataFlowInfo, trace);
    }

    public static final /* synthetic */ void access$setConstantForVariableIfNeeded(VariableTypeResolver $this, @NotNull VariableDescriptorWithInitializerImpl variableDescriptor, @NotNull LexicalScope scope2, @NotNull KtVariableDeclaration variable2, @NotNull DataFlowInfo dataFlowInfo, @NotNull KotlinType variableType, @NotNull BindingTrace trace) {
        $this.setConstantForVariableIfNeeded(variableDescriptor, scope2, variable2, dataFlowInfo, variableType, trace);
    }

    @NotNull
    public static final /* synthetic */ ExpressionTypingServices access$getExpressionTypingServices$p(VariableTypeResolver $this) {
        return $this.expressionTypingServices;
    }

    @NotNull
    public static final /* synthetic */ ConstantExpressionEvaluator access$getConstantExpressionEvaluator$p(VariableTypeResolver $this) {
        return $this.constantExpressionEvaluator;
    }
}

