/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtElementImpl;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionTypeResolveUtilsKt;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolver;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForImplicitConstructorDelegationCall;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForInvoke;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyImpl;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolveOldInference;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitorDispatcher;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.PerformanceCounter;

public class CallResolver {
    private ExpressionTypingServices expressionTypingServices;
    private TypeResolver typeResolver;
    private ArgumentTypeResolver argumentTypeResolver;
    private GenericCandidateResolver genericCandidateResolver;
    private CallCompleter callCompleter;
    private NewResolveOldInference newCallResolver;
    private final KotlinBuiltIns builtIns;
    private static final PerformanceCounter callResolvePerfCounter = PerformanceCounter.Companion.create("Call resolve", ExpressionTypingVisitorDispatcher.typeInfoPerfCounter);

    public CallResolver(@NotNull KotlinBuiltIns builtIns) {
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/calls/CallResolver", "<init>"));
        }
        this.builtIns = builtIns;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setTypeResolver"));
        }
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setArgumentTypeResolver(@NotNull ArgumentTypeResolver argumentTypeResolver) {
        if (argumentTypeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypeResolver", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setArgumentTypeResolver"));
        }
        this.argumentTypeResolver = argumentTypeResolver;
    }

    @Inject
    public void setGenericCandidateResolver(GenericCandidateResolver genericCandidateResolver) {
        this.genericCandidateResolver = genericCandidateResolver;
    }

    @Inject
    public void setCallCompleter(@NotNull CallCompleter callCompleter) {
        if (callCompleter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callCompleter", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setCallCompleter"));
        }
        this.callCompleter = callCompleter;
    }

    @Inject
    public void setCallCompleter(@NotNull NewResolveOldInference newCallResolver) {
        if (newCallResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newCallResolver", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setCallCompleter"));
        }
        this.newCallResolver = newCallResolver;
    }

    @NotNull
    public OverloadResolutionResults<VariableDescriptor> resolveSimpleProperty(@NotNull BasicCallResolutionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveSimpleProperty"));
        }
        KtExpression calleeExpression = context.call.getCalleeExpression();
        assert (calleeExpression instanceof KtSimpleNameExpression);
        KtSimpleNameExpression nameExpression2 = (KtSimpleNameExpression)calleeExpression;
        Name referencedName = nameExpression2.getReferencedNameAsName();
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, referencedName, nameExpression2, ResolveKind.VARIABLE);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveSimpleProperty"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<CallableDescriptor> resolveCallForMember(@NotNull KtSimpleNameExpression nameExpression2, @NotNull BasicCallResolutionContext context) {
        if (nameExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForMember"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForMember"));
        }
        OverloadResolutionResults<CallableDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, nameExpression2.getReferencedNameAsName(), nameExpression2, ResolveKind.CALLABLE_REFERENCE);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForMember"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull ExpressionTypingContext context, @NotNull Call call, @NotNull KtReferenceExpression functionReference, @NotNull Name name2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (functionReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionReference", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context, call, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(callResolutionContext, name2, functionReference, ResolveKind.FUNCTION);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    private OverloadResolutionResults<FunctionDescriptor> resolveCallForInvoke(@NotNull BasicCallResolutionContext context, @NotNull TracingStrategy tracing) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForInvoke"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForInvoke"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, OperatorNameConventions.INVOKE, tracing, ResolveKind.INVOKE);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForInvoke"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResults<D> computeTasksAndResolveCall(@NotNull BasicCallResolutionContext context, @NotNull Name name2, @NotNull KtReferenceExpression referenceExpression, @NotNull ResolveKind kind2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        TracingStrategy tracing = TracingStrategyImpl.create(referenceExpression, context.call);
        OverloadResolutionResults<D> overloadResolutionResults = this.computeTasksAndResolveCall(context, name2, tracing, kind2);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResults<D> computeTasksAndResolveCall(final @NotNull BasicCallResolutionContext context, final @NotNull Name name2, final @NotNull TracingStrategy tracing, final @NotNull ResolveKind kind2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        OverloadResolutionResults overloadResolutionResults = (OverloadResolutionResults)callResolvePerfCounter.time(new Function0<OverloadResolutionResults<D>>(){

            public OverloadResolutionResults<D> invoke() {
                ResolutionTask resolutionTask = new ResolutionTask(kind2, name2, null);
                return CallResolver.this.doResolveCallOrGetCachedResults(context, resolutionTask, tracing);
            }
        });
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResults<D> computeTasksFromCandidatesAndResolvedCall(@NotNull BasicCallResolutionContext context, @NotNull KtReferenceExpression referenceExpression, @NotNull Collection<ResolutionCandidate<D>> candidates2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        if (candidates2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        OverloadResolutionResults<D> overloadResolutionResults = this.computeTasksFromCandidatesAndResolvedCall(context, candidates2, TracingStrategyImpl.create(referenceExpression, context.call));
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResults<D> computeTasksFromCandidatesAndResolvedCall(final @NotNull BasicCallResolutionContext context, final @NotNull Collection<ResolutionCandidate<D>> candidates2, final @NotNull TracingStrategy tracing) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        if (candidates2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        OverloadResolutionResults overloadResolutionResults = (OverloadResolutionResults)callResolvePerfCounter.time(new Function0<OverloadResolutionResults<D>>(){

            public OverloadResolutionResults<D> invoke() {
                ResolutionTask resolutionTask = new ResolutionTask(ResolveKind.GIVEN_CANDIDATES, null, candidates2);
                return CallResolver.this.doResolveCallOrGetCachedResults(context, resolutionTask, tracing);
            }
        });
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveBinaryCall(ExpressionTypingContext context, ExpressionReceiver receiver, KtBinaryExpression binaryExpression, Name name2) {
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallWithGivenName(context, CallMaker.makeCall((ReceiverValue)receiver, binaryExpression), binaryExpression.getOperationReference(), name2);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveBinaryCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BindingTrace trace, @NotNull LexicalScope scope2, @NotNull Call call, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, boolean isAnnotationContext) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveFunctionCall(BasicCallResolutionContext.create(trace, scope2, call, expectedType, dataFlowInfo, ContextDependency.INDEPENDENT, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, isAnnotationContext));
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BasicCallResolutionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        Call.CallType callType = context.call.getCallType();
        if (callType == Call.CallType.ARRAY_GET_METHOD || callType == Call.CallType.ARRAY_SET_METHOD) {
            Name name2 = Name.identifier(callType == Call.CallType.ARRAY_GET_METHOD ? "get" : "set");
            KtArrayAccessExpression arrayAccessExpression = (KtArrayAccessExpression)context.call.getCallElement();
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, name2, arrayAccessExpression, ResolveKind.FUNCTION);
            if (overloadResolutionResults == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
            }
            return overloadResolutionResults;
        }
        KtExpression calleeExpression = context.call.getCalleeExpression();
        if (calleeExpression instanceof KtSimpleNameExpression) {
            KtSimpleNameExpression expression2 = (KtSimpleNameExpression)calleeExpression;
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, expression2.getReferencedNameAsName(), expression2, ResolveKind.FUNCTION);
            if (overloadResolutionResults == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
            }
            return overloadResolutionResults;
        }
        if (calleeExpression instanceof KtConstructorCalleeExpression) {
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallForConstructor(context, (KtConstructorCalleeExpression)calleeExpression);
            if (overloadResolutionResults == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
            }
            return overloadResolutionResults;
        }
        if (calleeExpression instanceof KtConstructorDelegationReferenceExpression) {
            KtConstructorDelegationCall delegationCall = (KtConstructorDelegationCall)context.call.getCallElement();
            DeclarationDescriptor container2 = context.scope.getOwnerDescriptor();
            assert (container2 instanceof ConstructorDescriptor) : "Trying to resolve JetConstructorDelegationCall not in constructor. scope.ownerDescriptor = " + container2;
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveConstructorDelegationCall(context, delegationCall, (KtConstructorDelegationReferenceExpression)calleeExpression, (ConstructorDescriptor)container2);
            if (overloadResolutionResults == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
            }
            return overloadResolutionResults;
        }
        if (calleeExpression == null) {
            OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
            }
            return overloadResolutionResultsImpl;
        }
        KotlinType expectedType = TypeUtils.NO_EXPECTED_TYPE;
        if (calleeExpression instanceof KtLambdaExpression) {
            int parameterNumber = ((KtLambdaExpression)calleeExpression).getValueParameters().size();
            ArrayList<KotlinType> parameterTypes = new ArrayList<KotlinType>(parameterNumber);
            for (int i = 0; i < parameterNumber; ++i) {
                parameterTypes.add(TypeUtils.NO_EXPECTED_TYPE);
            }
            expectedType = FunctionTypeResolveUtilsKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), null, parameterTypes, context.expectedType);
        }
        KotlinType calleeType = this.expressionTypingServices.safeGetType(context.scope, calleeExpression, expectedType, context.dataFlowInfo, context.trace);
        ExpressionReceiver expressionReceiver = ExpressionReceiver.Companion.create(calleeExpression, calleeType, context.trace.getBindingContext());
        CallTransformer.CallForImplicitInvoke call = new CallTransformer.CallForImplicitInvoke(context.call.getExplicitReceiver(), expressionReceiver, context.call);
        TracingStrategyForInvoke tracingForInvoke = new TracingStrategyForInvoke(calleeExpression, call, calleeType);
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallForInvoke(context.replaceCall(call), tracingForInvoke);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        return overloadResolutionResults;
    }

    private OverloadResolutionResults<ConstructorDescriptor> resolveCallForConstructor(@NotNull BasicCallResolutionContext context, @NotNull KtConstructorCalleeExpression expression2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForConstructor"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForConstructor"));
        }
        assert (context.call.getExplicitReceiver() == null) : "Constructor can't be invoked with explicit receiver: " + context.call.getCallElement().getText();
        context.trace.record(BindingContext.LEXICAL_SCOPE, context.call.getCallElement(), context.scope);
        KtSimpleNameExpression functionReference = expression2.getConstructorReferenceExpression();
        KtTypeReference typeReference = expression2.getTypeReference();
        if (functionReference == null || typeReference == null) {
            return this.checkArgumentTypesAndFail(context);
        }
        KotlinType constructedType = this.typeResolver.resolveType(context.scope, typeReference, context.trace, true);
        if (constructedType.isError()) {
            return this.checkArgumentTypesAndFail(context);
        }
        ClassifierDescriptor declarationDescriptor = constructedType.getConstructor().getDeclarationDescriptor();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            context.trace.report(Errors.NOT_A_CLASS.on(expression2));
            return this.checkArgumentTypesAndFail(context);
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        Collection<ConstructorDescriptor> constructors2 = classDescriptor.getConstructors();
        if (constructors2.isEmpty()) {
            context.trace.report(Errors.NO_CONSTRUCTOR.on((PsiElement)CallUtilKt.getValueArgumentListOrElement(context.call)));
            return this.checkArgumentTypesAndFail(context);
        }
        Pair<Collection<ResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> candidatesAndContext = CallResolver.prepareCandidatesAndContextForConstructorCall(constructedType, context);
        Collection candidates2 = (Collection)candidatesAndContext.getFirst();
        context = (BasicCallResolutionContext)candidatesAndContext.getSecond();
        return this.computeTasksFromCandidatesAndResolvedCall(context, functionReference, candidates2);
    }

    @Nullable
    public OverloadResolutionResults<ConstructorDescriptor> resolveConstructorDelegationCall(@NotNull BindingTrace trace, @NotNull LexicalScope scope2, @NotNull DataFlowInfo dataFlowInfo, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull KtConstructorDelegationCall call) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        BasicCallResolutionContext context = BasicCallResolutionContext.create(trace, scope2, CallMaker.makeCall(null, null, call), TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, ContextDependency.INDEPENDENT, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, false);
        if (call.getCalleeExpression() == null) {
            return this.checkArgumentTypesAndFail(context);
        }
        if (constructorDescriptor.getContainingDeclaration().getKind() == ClassKind.ENUM_CLASS && call.isImplicit()) {
            return null;
        }
        return this.resolveConstructorDelegationCall(context, call, call.getCalleeExpression(), constructorDescriptor);
    }

    @NotNull
    private OverloadResolutionResults<ConstructorDescriptor> resolveConstructorDelegationCall(@NotNull BasicCallResolutionContext context, @NotNull KtConstructorDelegationCall call, @NotNull KtConstructorDelegationReferenceExpression calleeExpression, @NotNull ConstructorDescriptor calleeConstructor) {
        KtElementImpl reportOn;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (calleeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeExpression", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (calleeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeConstructor", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        context.trace.record(BindingContext.LEXICAL_SCOPE, call, context.scope);
        ClassDescriptor currentClassDescriptor = calleeConstructor.getContainingDeclaration();
        boolean isThisCall = calleeExpression.isThis();
        if (currentClassDescriptor.getKind() == ClassKind.ENUM_CLASS && !isThisCall) {
            context.trace.report(Errors.DELEGATION_SUPER_CALL_IN_ENUM_CONSTRUCTOR.on(calleeExpression));
            OverloadResolutionResultsImpl<ConstructorDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
            }
            return overloadResolutionResultsImpl;
        }
        ClassDescriptor delegateClassDescriptor = isThisCall ? currentClassDescriptor : DescriptorUtilsKt.getSuperClassOrAny(currentClassDescriptor);
        Collection<ConstructorDescriptor> constructors2 = delegateClassDescriptor.getConstructors();
        if (!isThisCall && currentClassDescriptor.getUnsubstitutedPrimaryConstructor() != null) {
            if (DescriptorUtils.canHaveDeclaredConstructors(currentClassDescriptor)) {
                context.trace.report(Errors.PRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED.on((KtConstructorDelegationCall)calleeExpression.getParent()));
            }
            if (call.isImplicit()) {
                OverloadResolutionResultsImpl<ConstructorDescriptor> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.nameNotFound();
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
                }
                return overloadResolutionResultsImpl;
            }
        }
        if (constructors2.isEmpty()) {
            context.trace.report(Errors.NO_CONSTRUCTOR.on((PsiElement)CallUtilKt.getValueArgumentListOrElement(context.call)));
            OverloadResolutionResultsImpl<ConstructorDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
            }
            return overloadResolutionResultsImpl;
        }
        KotlinType superType = isThisCall ? calleeConstructor.getContainingDeclaration().getDefaultType() : DescriptorUtils.getSuperClassType(currentClassDescriptor);
        Pair<Collection<ResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> candidatesAndContext = CallResolver.prepareCandidatesAndContextForConstructorCall(superType, context);
        Collection candidates2 = (Collection)candidatesAndContext.getFirst();
        context = (BasicCallResolutionContext)candidatesAndContext.getSecond();
        TracingStrategy tracing = call.isImplicit() ? new TracingStrategyForImplicitConstructorDelegationCall(call, context.call) : TracingStrategyImpl.create(calleeExpression, context.call);
        KtElementImpl ktElementImpl = reportOn = call.isImplicit() ? call : calleeExpression;
        if (delegateClassDescriptor.isInner() && !DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, (PsiElement)reportOn, (ClassDescriptor)delegateClassDescriptor.getContainingDeclaration())) {
            OverloadResolutionResultsImpl<ConstructorDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
            }
            return overloadResolutionResultsImpl;
        }
        OverloadResolutionResults<ConstructorDescriptor> overloadResolutionResults = this.computeTasksFromCandidatesAndResolvedCall(context, candidates2, tracing);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    private static Pair<Collection<ResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> prepareCandidatesAndContextForConstructorCall(@NotNull KotlinType superType, @NotNull BasicCallResolutionContext context) {
        TypeSubstitutor knownTypeParametersSubstitutor;
        if (superType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superType", "org/jetbrains/kotlin/resolve/calls/CallResolver", "prepareCandidatesAndContextForConstructorCall"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "prepareCandidatesAndContextForConstructorCall"));
        }
        if (!(superType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor)) {
            Pair pair2 = new Pair(Collections.emptyList(), (Object)context);
            if (pair2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "prepareCandidatesAndContextForConstructorCall"));
            }
            return pair2;
        }
        ClassDescriptor superClass = (ClassDescriptor)superType.getConstructor().getDeclarationDescriptor();
        boolean anyConstructorHasDeclaredTypeParameters = CallResolver.anyConstructorHasDeclaredTypeParameters(superType.getConstructor().getDeclarationDescriptor());
        TypeSubstitutor typeSubstitutor2 = knownTypeParametersSubstitutor = anyConstructorHasDeclaredTypeParameters ? null : TypeSubstitutor.create(superType);
        if (anyConstructorHasDeclaredTypeParameters) {
            context = (BasicCallResolutionContext)context.replaceExpectedType(superType);
        }
        Collection<ResolutionCandidate<ConstructorDescriptor>> candidates2 = CallResolverUtilKt.createResolutionCandidatesForConstructors(context.scope, context.call, superClass, knownTypeParametersSubstitutor);
        Pair pair3 = new Pair(candidates2, (Object)context);
        if (pair3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "prepareCandidatesAndContextForConstructorCall"));
        }
        return pair3;
    }

    private static boolean anyConstructorHasDeclaredTypeParameters(@Nullable ClassifierDescriptor classDescriptor) {
        if (!(classDescriptor instanceof ClassDescriptor)) {
            return false;
        }
        for (ConstructorDescriptor constructor : ((ClassDescriptor)classDescriptor).getConstructors()) {
            if (constructor.getTypeParameters().size() <= constructor.getContainingDeclaration().getDeclaredTypeParameters().size()) continue;
            return true;
        }
        return false;
    }

    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithKnownCandidate(final @NotNull Call call, final @NotNull TracingStrategy tracing, final @NotNull ResolutionContext<?> context, final @NotNull ResolutionCandidate<FunctionDescriptor> candidate, final @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        return callResolvePerfCounter.time(new Function0<OverloadResolutionResults<FunctionDescriptor>>(){

            public OverloadResolutionResults<FunctionDescriptor> invoke() {
                BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context, call, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, dataFlowInfoForArguments);
                Set<ResolutionCandidate> candidates2 = Collections.singleton(candidate);
                ResolutionTask resolutionTask = new ResolutionTask(ResolveKind.GIVEN_CANDIDATES, null, candidates2);
                return CallResolver.this.doResolveCallOrGetCachedResults(basicCallResolutionContext, resolutionTask, tracing);
            }
        });
    }

    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> doResolveCallOrGetCachedResults(@NotNull BasicCallResolutionContext context, @NotNull ResolutionTask<D> resolutionTask, @NotNull TracingStrategy tracing) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        if (resolutionTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionTask", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        Call call = context.call;
        tracing.bindCall(context.trace, call);
        TemporaryBindingTrace traceToResolveCall = TemporaryBindingTrace.create(context.trace, "trace to resolve call", call);
        BasicCallResolutionContext newContext = (BasicCallResolutionContext)context.replaceBindingTrace(traceToResolveCall);
        BindingContextUtilsKt.recordScope(newContext.trace, newContext.scope, newContext.call.getCalleeExpression());
        BindingContextUtilsKt.recordDataFlowInfo(newContext, newContext.call.getCalleeExpression());
        OverloadResolutionResultsImpl<D> results2 = this.doResolveCall(newContext, resolutionTask, tracing);
        DelegatingBindingTrace deltasTraceForTypeInference = results2.getTrace();
        if (deltasTraceForTypeInference != null) {
            deltasTraceForTypeInference.addOwnDataTo(traceToResolveCall);
        }
        this.completeTypeInferenceDependentOnFunctionLiterals(newContext, results2, tracing);
        if (context.contextDependency == ContextDependency.DEPENDENT) {
            CallResolver.cacheResults(context, results2, traceToResolveCall, tracing);
        }
        traceToResolveCall.commit();
        if (context.contextDependency == ContextDependency.INDEPENDENT) {
            results2 = this.callCompleter.completeCall(context, results2, tracing);
        }
        return results2;
    }

    private <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionLiterals(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<D> results2, @NotNull TracingStrategy tracing) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "completeTypeInferenceDependentOnFunctionLiterals"));
        }
        if (results2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/calls/CallResolver", "completeTypeInferenceDependentOnFunctionLiterals"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "completeTypeInferenceDependentOnFunctionLiterals"));
        }
        if (CallResolverUtilKt.isInvokeCallOnVariable(context.call)) {
            return;
        }
        if (!results2.isSingleResult()) {
            if (results2.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) {
                this.argumentTypeResolver.checkTypesWithNoCallee(context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
            }
            return;
        }
        CallCandidateResolutionContext candidateContext = CallCandidateResolutionContext.createForCallBeingAnalyzed(results2.getResultingCall(), context, tracing);
        this.genericCandidateResolver.completeTypeInferenceDependentOnFunctionArgumentsForCall(candidateContext);
    }

    private static <F extends CallableDescriptor> void cacheResults(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<F> results2, @NotNull DelegatingBindingTrace traceToResolveCall, @NotNull TracingStrategy tracing) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "cacheResults"));
        }
        if (results2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/calls/CallResolver", "cacheResults"));
        }
        if (traceToResolveCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceToResolveCall", "org/jetbrains/kotlin/resolve/calls/CallResolver", "cacheResults"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "cacheResults"));
        }
        Call call = context.call;
        if (CallResolverUtilKt.isInvokeCallOnVariable(call)) {
            return;
        }
        DelegatingBindingTrace deltasTraceToCacheResolve = new DelegatingBindingTrace(BindingContext.EMPTY, "delta trace for caching resolve of", context.call);
        traceToResolveCall.addOwnDataTo(deltasTraceToCacheResolve);
        context.resolutionResultsCache.record(call, results2, context, tracing, deltasTraceToCacheResolve);
    }

    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> checkArgumentTypesAndFail(BasicCallResolutionContext context) {
        this.argumentTypeResolver.checkTypesWithNoCallee(context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        return OverloadResolutionResultsImpl.nameNotFound();
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> doResolveCall(@NotNull BasicCallResolutionContext context, @NotNull ResolutionTask<D> resolutionTask, @NotNull TracingStrategy tracing) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (resolutionTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionTask", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (context.checkArguments == CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            this.argumentTypeResolver.analyzeArgumentsAndRecordTypes(context, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
        }
        List<KtTypeProjection> typeArguments = context.call.getTypeArguments();
        for (KtTypeProjection projection : typeArguments) {
            KotlinType type2;
            if (projection.getProjectionKind() != KtProjectionKind.NONE) {
                context.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(projection));
                ModifierCheckerCore.INSTANCE.check(projection, context.trace, null);
            }
            if ((type2 = this.argumentTypeResolver.resolveTypeRefWithDefault(projection.getTypeReference(), context.scope, context.trace, null)) == null) continue;
            ForceResolveUtil.forceResolveAllContents(type2);
        }
        if (resolutionTask.resolveKind != ResolveKind.GIVEN_CANDIDATES) {
            assert (resolutionTask.name != null);
            OverloadResolutionResultsImpl<?> overloadResolutionResultsImpl = this.newCallResolver.runResolve(context, resolutionTask.name, resolutionTask.resolveKind, tracing);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
            }
            return overloadResolutionResultsImpl;
        }
        assert (resolutionTask.givenCandidates != null);
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = this.newCallResolver.runResolveForGivenCandidates(context, tracing, resolutionTask.givenCandidates);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        return overloadResolutionResultsImpl;
    }

    public static enum ResolveKind {
        FUNCTION,
        INVOKE,
        VARIABLE,
        CALLABLE_REFERENCE,
        GIVEN_CANDIDATES;

    }

    private static class ResolutionTask<D extends CallableDescriptor> {
        @Nullable
        final Name name;
        @Nullable
        final Collection<ResolutionCandidate<D>> givenCandidates;
        @NotNull
        final ResolveKind resolveKind;

        private ResolutionTask(@NotNull ResolveKind kind2, @Nullable Name name2, @Nullable Collection<ResolutionCandidate<D>> candidates2) {
            if (kind2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/resolve/calls/CallResolver$ResolutionTask", "<init>"));
            }
            this.name = name2;
            this.givenCandidates = candidates2;
            this.resolveKind = kind2;
        }
    }
}

