/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCallImpl;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/InvokeConventionChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "frontend"})
public final class InvokeConventionChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCallImpl) {
            ResolvedCall functionCall2 = ((VariableAsFunctionResolvedCallImpl)resolvedCall2).getFunctionCall();
            ResolvedCall variableCall = ((VariableAsFunctionResolvedCallImpl)resolvedCall2).getVariableCall();
            if (functionCall2.getDispatchReceiver() != null && functionCall2.getExtensionReceiver() != null && FunctionTypesKt.isExtensionFunctionType(((VariableDescriptor)variableCall.getResultingDescriptor()).getType()) && (variableCall.getDispatchReceiver() instanceof ExpressionReceiver || variableCall.getExtensionReceiver() instanceof ExpressionReceiver)) {
                KtElement callElement2 = variableCall.getCall().getCallElement();
                context.trace.report(Errors.INVOKE_ON_EXTENSION_FUNCTION_WITH_EXPLICIT_DISPATCH_RECEIVER.on((KtElement)((PsiElement)callElement2)));
            }
        }
    }
}

