/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.AndroidFakeFileSystem;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import icons.AndroidIcons;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringsVirtualFile
extends LightVirtualFile {
    public static final String NAME = "Translations Editor";
    private static final Key<StringsVirtualFile> KEY = Key.create((String)StringsVirtualFile.class.getName());
    @NotNull
    private final AndroidFacet myFacet;

    private StringsVirtualFile(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/editors/strings/StringsVirtualFile", "<init>"));
        }
        super(NAME, (FileType)StringsResourceFileType.INSTANCE, (CharSequence)"");
        this.myFacet = facet;
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringsVirtualFile", "getFacet"));
        }
        return androidFacet;
    }

    public VirtualFile getParent() {
        VirtualFile moduleFile = this.myFacet.getModule().getModuleFile();
        return moduleFile == null ? null : moduleFile.getParent();
    }

    @NotNull
    public String getPath() {
        String string = AndroidFakeFileSystem.constructPathForFile(this.getName(), this.myFacet.getModule());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringsVirtualFile", "getPath"));
        }
        return string;
    }

    @Nullable
    public static StringsVirtualFile getInstance(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/strings/StringsVirtualFile", "getInstance"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/strings/StringsVirtualFile", "getInstance"));
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        return module == null ? null : StringsVirtualFile.getStringsVirtualFile(module);
    }

    @Nullable
    public static StringsVirtualFile getStringsVirtualFile(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/strings/StringsVirtualFile", "getStringsVirtualFile"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        StringsVirtualFile vfile = (StringsVirtualFile)((Object)facet.getUserData(KEY));
        if (vfile == null) {
            vfile = new StringsVirtualFile(facet);
            facet.putUserData(KEY, (Object)vfile);
        }
        return vfile;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = AndroidFakeFileSystem.INSTANCE;
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringsVirtualFile", "getFileSystem"));
        }
        return virtualFileSystem;
    }

    private static class StringsResourceFileType
    extends FakeFileType {
        public static final StringsResourceFileType INSTANCE = new StringsResourceFileType();

        private StringsResourceFileType() {
        }

        public boolean isMyFileType(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/strings/StringsVirtualFile$StringsResourceFileType", "isMyFileType"));
            }
            return file.getFileType() instanceof StringsResourceFileType;
        }

        @NotNull
        public String getName() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringsVirtualFile$StringsResourceFileType", "getName"));
            }
            return "";
        }

        @NotNull
        public String getDescription() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/StringsVirtualFile$StringsResourceFileType", "getDescription"));
            }
            return "";
        }

        public Icon getIcon() {
            return AndroidIcons.Globe;
        }
    }
}

