/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileTreeDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesModel
extends GradleDslBlockModel {
    public DependenciesModel(@NotNull DependenciesDslElement dslElement) {
        if (dslElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "<init>"));
        }
        super(dslElement);
    }

    @NotNull
    public List<DependencyModel> all() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getProperty(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslElement element : list.getElements(GradleDslElement.class)) {
                dependencies.addAll(ArtifactDependencyModel.create(element));
            }
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "all"));
        }
        return arrayList;
    }

    @NotNull
    public List<ArtifactDependencyModel> artifacts(@NotNull String configurationName) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "artifacts"));
        }
        ArrayList dependencies = Lists.newArrayList();
        this.addArtifacts(configurationName, dependencies);
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "artifacts"));
        }
        return arrayList;
    }

    @NotNull
    public List<ArtifactDependencyModel> artifacts() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            this.addArtifacts(configurationName, dependencies);
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "artifacts"));
        }
        return arrayList;
    }

    private void addArtifacts(@NotNull String configurationName, @NotNull List<ArtifactDependencyModel> dependencies) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifacts"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifacts"));
        }
        GradleDslElementList list = this.myDslElement.getProperty(configurationName, GradleDslElementList.class);
        if (list != null) {
            for (GradleDslElement element : list.getElements(GradleDslElement.class)) {
                dependencies.addAll(ArtifactDependencyModel.create(element));
            }
        }
    }

    @NotNull
    public DependenciesModel addArtifact(@NotNull String configurationName, @NotNull String compactNotation) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifact"));
        }
        if (compactNotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compactNotation", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifact"));
        }
        ArtifactDependencySpec dependency = ArtifactDependencySpec.create(compactNotation);
        if (dependency == null) {
            String msg = String.format("'%1$s' is not a valid artifact dependency", compactNotation);
            throw new IllegalArgumentException(msg);
        }
        this.addArtifact(configurationName, dependency);
        DependenciesModel dependenciesModel = this;
        if (dependenciesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifact"));
        }
        return dependenciesModel;
    }

    @NotNull
    public DependenciesModel addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifact"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifact"));
        }
        GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
        ArtifactDependencyModel.createAndAddToList(list, configurationName, dependency);
        DependenciesModel dependenciesModel = this;
        if (dependenciesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifact"));
        }
        return dependenciesModel;
    }

    @NotNull
    public List<ModuleDependencyModel> modules() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getProperty(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslMethodCall element : list.getElements(GradleDslMethodCall.class)) {
                dependencies.addAll(ModuleDependencyModel.create(configurationName, element));
            }
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "modules"));
        }
        return arrayList;
    }

    @NotNull
    public DependenciesModel addModule(@NotNull String configurationName, @NotNull String path) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addModule"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addModule"));
        }
        DependenciesModel dependenciesModel = this.addModule(configurationName, path, null);
        if (dependenciesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addModule"));
        }
        return dependenciesModel;
    }

    @NotNull
    public DependenciesModel addModule(@NotNull String configurationName, @NotNull String path, @Nullable String config) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addModule"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addModule"));
        }
        GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
        ModuleDependencyModel.createAndAddToList(list, configurationName, path, config);
        DependenciesModel dependenciesModel = this;
        if (dependenciesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addModule"));
        }
        return dependenciesModel;
    }

    @NotNull
    private GradleDslElementList getOrCreateGradleDslElementList(@NotNull String configurationName) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "getOrCreateGradleDslElementList"));
        }
        GradleDslElementList list = this.myDslElement.getProperty(configurationName, GradleDslElementList.class);
        if (list == null) {
            list = new GradleDslElementList(this.myDslElement, configurationName);
            this.myDslElement.setNewElement(configurationName, list);
        }
        GradleDslElementList gradleDslElementList = list;
        if (gradleDslElementList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "getOrCreateGradleDslElementList"));
        }
        return gradleDslElementList;
    }

    @NotNull
    public List<FileTreeDependencyModel> fileTrees() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getProperty(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslMethodCall element : list.getElements(GradleDslMethodCall.class)) {
                dependencies.addAll(FileTreeDependencyModel.create(element));
            }
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "fileTrees"));
        }
        return arrayList;
    }

    @NotNull
    public DependenciesModel remove(@NotNull DependencyModel dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "remove"));
        }
        GradleDslElementList gradleDslElementList = this.myDslElement.getProperty(dependency.configurationName(), GradleDslElementList.class);
        if (gradleDslElementList != null) {
            GradleDslElement dependencyElement = dependency.getDslElement();
            GradleDslElement parent = dependencyElement.getParent();
            if (parent instanceof GradleDslMethodCall) {
                GradleDslMethodCall methodCall = (GradleDslMethodCall)parent;
                List<GradleDslElement> arguments = methodCall.getArguments();
                if (arguments.size() == 1 && arguments.get(0).equals(dependencyElement)) {
                    gradleDslElementList.removeElement(methodCall);
                } else {
                    methodCall.remove(dependencyElement);
                }
            } else {
                gradleDslElementList.removeElement(dependencyElement);
            }
        }
        DependenciesModel dependenciesModel = this;
        if (dependenciesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "remove"));
        }
        return dependenciesModel;
    }
}

