/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UnsupportedModelVersionErrorHandler
extends AbstractSyncErrorHandler {
    @NotNull
    public static final String UNSUPPORTED_MODEL_VERSION_ERROR_PREFIX = "The project is using an unsupported version of the Android Gradle plug-in";
    @NotNull
    public static final String READ_MIGRATION_GUIDE_MSG = "Please read the migration guide";

    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/service/notification/errors/UnsupportedModelVersionErrorHandler", "handleError"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/service/notification/errors/UnsupportedModelVersionErrorHandler", "handleError"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/UnsupportedModelVersionErrorHandler", "handleError"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/UnsupportedModelVersionErrorHandler", "handleError"));
        }
        String msg = error.getMessage();
        if (msg.startsWith(UNSUPPORTED_MODEL_VERSION_ERROR_PREFIX)) {
            boolean openMigrationGuide = msg.contains(READ_MIGRATION_GUIDE_MSG);
            UnsupportedModelVersionErrorHandler.updateNotification(notification, project, msg, new FixAndroidGradlePluginVersionHyperlink(openMigrationGuide));
            return true;
        }
        return false;
    }
}

