/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.editor.dependencies;

import com.android.builder.model.Library;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.AddDependencyPanel;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.AndroidSdkRepositorySearch;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.ArtifactDependencyEditor;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.ArtifactRepositorySearch;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.DependenciesEditor;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.DependenciesTreePanel;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.DependencyAction;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.LibrariesPanel;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.MavenCentralRepositorySearch;
import com.android.tools.idea.gradle.structure.configurables.model.ArtifactDependencyMergedModel;
import com.android.tools.idea.gradle.structure.configurables.model.DependencyMergedModel;
import com.android.tools.idea.gradle.structure.configurables.model.ModuleMergedModel;
import com.android.tools.idea.structure.dialog.HeaderPanel;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DependenciesPanel
extends JPanel {
    @NotNull
    private final DependenciesEditor myDependenciesEditor;
    @NotNull
    private final ModuleMergedModel myModel;
    @NotNull
    private final TableView<DependencyMergedModel> myDependencyTable;
    @NotNull
    private final JBSplitter myMainHorizontalSplitter;
    @NotNull
    private final JBSplitter myMainVerticalSplitter;
    @NotNull
    private final List<ArtifactRepositorySearch> myRepositorySearches;
    @NotNull
    private final List<AddDependencyPanel> myDependenciesPanels;
    @NotNull
    private final JPanel myEditorPanel;
    @NotNull
    private JPanel myEmptyEditorPanel;
    @NotNull
    private final JBScrollPane myEditorScrollPane;
    @NotNull
    private final ArtifactDependencyEditor myArtifactDependencyEditor;
    @NotNull
    private final DependenciesTreePanel myDependenciesTreePanel;
    private boolean myShowGroupId;
    private int mySelectedAddDependencyActionIndex;

    DependenciesPanel(@NotNull DependenciesEditor dependenciesEditor, @NotNull ModuleMergedModel model) {
        if (dependenciesEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesEditor", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myDependenciesEditor = dependenciesEditor;
        this.myModel = model;
        DependenciesTableModel tableModel = new DependenciesTableModel();
        List<DependencyMergedModel> dependencies = model.getDependencies();
        tableModel.setItems(dependencies);
        this.myDependencyTable = new TableView((ListTableModel)tableModel);
        if (!dependencies.isEmpty()) {
            this.myDependencyTable.changeSelection(0, 0, false, false);
        }
        this.myRepositorySearches = Lists.newArrayList((Object[])new ArtifactRepositorySearch[]{new MavenCentralRepositorySearch(), new AndroidSdkRepositorySearch(this.myModel)});
        this.myDependenciesPanels = Lists.newArrayList((Object[])new AddDependencyPanel[]{new LibrariesPanel(this, this.myRepositorySearches), new ModulesPanel(), new FilesPanel()});
        this.myDependenciesTreePanel = new DependenciesTreePanel(this);
        this.myMainHorizontalSplitter = new JBSplitter(true, "psd.dependencies.main.horizonal.splitter.proportion", 0.55f);
        this.myMainVerticalSplitter = new JBSplitter(false, "psi.dependencies.main.vertical.splitter.proportion", 0.75f);
        this.myEditorPanel = new JPanel(new BorderLayout());
        this.myEditorPanel.add((Component)new HeaderPanel("Details"), "North");
        this.myEditorScrollPane = new JBScrollPane();
        this.myEditorPanel.add((Component)this.myEditorScrollPane, "Center");
        this.myEditorPanel.setBorder(IdeBorderFactory.createBorder((int)4));
        this.myEmptyEditorPanel = new JPanel(new BorderLayout());
        JBLabel emptyText = new JBLabel("Please select a dependency");
        emptyText.setForeground(UIUtil.getInactiveTextColor());
        emptyText.setHorizontalAlignment(0);
        this.myEmptyEditorPanel.add((Component)emptyText, "Center");
        this.myArtifactDependencyEditor = new ArtifactDependencyEditor();
        this.setUpUI();
    }

    private void setUpUI() {
        this.myDependencyTable.setDragEnabled(false);
        this.myDependencyTable.setIntercellSpacing(new Dimension(0, 0));
        this.myDependencyTable.setShowGrid(false);
        this.myDependencyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                DependenciesPanel.this.updateSelection();
            }
        });
        this.myDependencyTable.getSelectionModel().setSelectionMode(2);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.createDependenciesEditorPanel(), "Center");
        mainPanel.add((Component)this.createActionsPanel(), "South");
        mainPanel.setBorder(BorderFactory.createEmptyBorder());
        this.myMainHorizontalSplitter.setFirstComponent((JComponent)mainPanel);
        this.myMainHorizontalSplitter.setSecondComponent((JComponent)this.getSelectedPanel());
        this.myMainVerticalSplitter.setFirstComponent((JComponent)this.myMainHorizontalSplitter);
        this.myMainVerticalSplitter.setSecondComponent((JComponent)this.myDependenciesTreePanel);
        this.add((Component)this.myMainVerticalSplitter, "Center");
        this.updateSelection();
        this.myDependencyTable.updateColumnSizes();
    }

    private void updateSelection() {
        this.updateCurrentEditor();
        this.selectInTreeView();
    }

    void selectInTreeView() {
        Collection selection = this.myDependencyTable.getSelection();
        if (selection.size() == 1) {
            DependencyMergedModel dependency = (DependencyMergedModel)ContainerUtil.getFirstItem((Collection)selection);
            assert (dependency != null);
            this.myDependenciesTreePanel.select(dependency);
            return;
        }
        this.myDependenciesTreePanel.clearSelection();
    }

    private void updateCurrentEditor() {
        DependencyMergedModel dependency;
        Collection selection = this.myDependencyTable.getSelection();
        if (selection.size() == 1 && (dependency = (DependencyMergedModel)ContainerUtil.getFirstItem((Collection)selection)) instanceof ArtifactDependencyMergedModel) {
            this.myArtifactDependencyEditor.update((ArtifactDependencyMergedModel)dependency);
            this.setCurrentEditor(this.myArtifactDependencyEditor.getPanel());
            return;
        }
        this.setCurrentEditor(this.myEmptyEditorPanel);
    }

    @NotNull
    private JPanel createDependenciesEditorPanel() {
        OnePixelSplitter splitter = new OnePixelSplitter(false, "psd.dependencies.editor.splitter.proportion", 0.65f);
        splitter.setFirstComponent((JComponent)new JBScrollPane(this.myDependencyTable));
        splitter.setSecondComponent((JComponent)this.myEditorPanel);
        this.setCurrentEditor(this.myEmptyEditorPanel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)splitter, "Center");
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel", "createDependenciesEditorPanel"));
        }
        return jPanel;
    }

    private void setCurrentEditor(@NotNull JPanel editorPanel) {
        if (editorPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorPanel", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel", "setCurrentEditor"));
        }
        this.myEditorScrollPane.setViewportView((Component)editorPanel);
    }

    @NotNull
    private JPanel createActionsPanel() {
        JBLabel addLabel = new JBLabel("Add:");
        addLabel.setBorder((Border)BorderFactory.createCompoundBorder(IdeBorderFactory.createBorder((int)10), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        JPanel actionsPanel = new JPanel(new BorderLayout());
        actionsPanel.add((Component)addLabel, "West");
        DefaultActionGroup group = new DefaultActionGroup();
        for (int i = 0; i < this.myDependenciesPanels.size(); ++i) {
            AddDependencyPanel panel = this.myDependenciesPanels.get(i);
            group.add((AnAction)new AddDependencyAction(panel.getDescription(), panel.getIcon(), i));
        }
        group.addSeparator();
        group.add((AnAction)new CheckboxAction("Show Group ID"){

            public boolean isSelected(AnActionEvent e) {
                return DependenciesPanel.this.myShowGroupId;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                DependenciesPanel.this.setShowGroupId(state);
            }
        });
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("BOTTOM", (ActionGroup)group, true);
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setBorder(IdeBorderFactory.createBorder((int)14));
        actionsPanel.add((Component)toolbarComponent, "Center");
        JPanel jPanel = actionsPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel", "createActionsPanel"));
        }
        return jPanel;
    }

    private void setShowGroupId(boolean showGroupId) {
        this.myShowGroupId = showGroupId;
        Collection selection = this.myDependencyTable.getSelection();
        this.myDependencyTable.getListTableModel().fireTableDataChanged();
        this.myDependencyTable.setSelection(selection);
    }

    @NotNull
    private AddDependencyPanel getSelectedPanel() {
        AddDependencyPanel addDependencyPanel = this.myDependenciesPanels.get(this.mySelectedAddDependencyActionIndex);
        if (addDependencyPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel", "getSelectedPanel"));
        }
        return addDependencyPanel;
    }

    void runAction(@NotNull DependencyAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel", "runAction"));
        }
        try {
            action.run();
        }
        finally {
            this.myDependencyTable.requestFocusInWindow();
        }
    }

    @NotNull
    ModuleMergedModel getModel() {
        ModuleMergedModel moduleMergedModel = this.myModel;
        if (moduleMergedModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel", "getModel"));
        }
        return moduleMergedModel;
    }

    void addLibraryDependency(@NotNull String coordinate) {
        if (coordinate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinate", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel", "addLibraryDependency"));
        }
    }

    @Nullable
    ArtifactDependencyMergedModel find(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel", "find"));
        }
        for (DependencyMergedModel dependency : this.myModel.getDependencies()) {
            ArtifactDependencyMergedModel artifactDependency;
            if (!(dependency instanceof ArtifactDependencyMergedModel) || !(artifactDependency = (ArtifactDependencyMergedModel)dependency).matches(library)) continue;
            return artifactDependency;
        }
        return null;
    }

    void select(@NotNull DependencyMergedModel dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel", "select"));
        }
        this.myDependencyTable.setSelection(Collections.singleton(dependency));
    }

    void registerDisposable(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel", "registerDisposable"));
        }
        this.myDependenciesEditor.registerDisposable(disposable);
    }

    private static class FilesPanel
    extends AddDependencyPanel {
        FilesPanel() {
            super("File", AllIcons.FileTypes.Any_type);
            this.add((Component)new HeaderPanel("Files"), "North");
        }
    }

    private static class ModulesPanel
    extends AddDependencyPanel {
        ModulesPanel() {
            super("Module", AllIcons.Nodes.Module);
            this.add((Component)new HeaderPanel("Modules"), "North");
        }
    }

    private class AddDependencyAction
    extends ToggleActionButton {
        @NotNull
        private final JPanel myDependencyPanel;
        private final int myIndex;

        AddDependencyAction(@NotNull String text, Icon icon, int index) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel$AddDependencyAction", "<init>"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel$AddDependencyAction", "<init>"));
            }
            super(text + " Dependency", icon);
            this.myDependencyPanel = (JPanel)DependenciesPanel.this.myDependenciesPanels.get(index);
            this.myIndex = index;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myIndex == DependenciesPanel.this.mySelectedAddDependencyActionIndex;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            DependenciesPanel.this.mySelectedAddDependencyActionIndex = this.myIndex;
            DependenciesPanel.this.myMainHorizontalSplitter.setSecondComponent((JComponent)this.myDependencyPanel);
        }
    }

    private class DependencyCellRenderer
    extends DefaultTableCellRenderer {
        @NotNull
        private final DependencyMergedModel myModel;

        DependencyCellRenderer(DependencyMergedModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel$DependencyCellRenderer", "<init>"));
            }
            this.myModel = model;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setIcon(this.myModel.getIcon());
            if (!DependenciesPanel.this.myShowGroupId && this.myModel instanceof ArtifactDependencyMergedModel) {
                label.setToolTipText(this.myModel.toString());
            }
            return label;
        }
    }

    private class DependenciesTableModel
    extends ListTableModel<DependencyMergedModel> {
        DependenciesTableModel() {
            super(new ColumnInfo[0]);
            this.createAndSetColumnInfos();
        }

        private void createAndSetColumnInfos() {
            ColumnInfo<DependencyMergedModel, String> dependency = new ColumnInfo<DependencyMergedModel, String>("Dependency"){

                @Nullable
                public String valueOf(DependencyMergedModel model) {
                    String compactNotation;
                    GradleCoordinate coordinate;
                    if (model instanceof ArtifactDependencyMergedModel && !DependenciesPanel.this.myShowGroupId && (coordinate = GradleCoordinate.parseCoordinateString((String)(compactNotation = model.toString()))) != null) {
                        return coordinate.getArtifactId() + ":" + coordinate.getRevision();
                    }
                    return model.toString();
                }

                @NotNull
                public TableCellRenderer getRenderer(DependencyMergedModel model) {
                    DependencyCellRenderer dependencyCellRenderer = new DependencyCellRenderer(model);
                    if (dependencyCellRenderer == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel$DependenciesTableModel$1", "getRenderer"));
                    }
                    return dependencyCellRenderer;
                }

                @NotNull
                public String getPreferredStringValue() {
                    if ("com.android.support:appcompat-v7:23.1.0" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel$DependenciesTableModel$1", "getPreferredStringValue"));
                    }
                    return "com.android.support:appcompat-v7:23.1.0";
                }
            };
            ColumnInfo<DependencyMergedModel, String> scope = new ColumnInfo<DependencyMergedModel, String>("Scope"){

                @Nullable
                public String valueOf(DependencyMergedModel model) {
                    return model.getConfigurationName();
                }

                @NotNull
                public String getPreferredStringValue() {
                    if ("flavor1AndroidTestCompile" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/DependenciesPanel$DependenciesTableModel$2", "getPreferredStringValue"));
                    }
                    return "flavor1AndroidTestCompile";
                }
            };
            this.setColumnInfos(new ColumnInfo[]{dependency, scope});
        }
    }
}

