/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.editor.dependencies;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.ArtifactRepositorySearch;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.DependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.SearchResult;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.RowSorter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LibrarySearch {
    @NotNull
    private final DependenciesPanel myDependenciesPanel;
    @NotNull
    private final List<ArtifactRepositorySearch> myRepositorySearches;
    private JBTextField myArtifactNameTextField;
    private JPanel myPanel;
    private JBTextField myGroupIdTextField;
    private TableView<LibraryFound> myResultsTable;
    private JButton mySearchButton;
    private JButton myAddLibraryButton;
    private JBLabel myArtifactNameLabel;
    private JBLabel myRequiredFieldLabel;
    private JBScrollPane myResultsScrollPane;

    LibrarySearch(@NotNull DependenciesPanel dependenciesPanel, @NotNull List<ArtifactRepositorySearch> repositorySearches) {
        if (dependenciesPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependenciesPanel", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/LibrarySearch", "<init>"));
        }
        if (repositorySearches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositorySearches", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/LibrarySearch", "<init>"));
        }
        this.myDependenciesPanel = dependenciesPanel;
        this.myRepositorySearches = repositorySearches;
        this.$$$setupUI$$$();
        this.myArtifactNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                LibrarySearch.this.mySearchButton.setEnabled(LibrarySearch.this.getArtifactName().length() >= 3);
            }
        });
        this.myArtifactNameLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        this.myArtifactNameLabel.setDisplayedMnemonic(78);
        this.myArtifactNameLabel.setIcon(AllIcons.General.WarningDecorator);
        this.myRequiredFieldLabel.setIcon(AllIcons.General.WarningDecorator);
        this.myArtifactNameTextField.addActionListener((ActionListener)new SearchActionListener());
        this.myArtifactNameTextField.getEmptyText().setText("Example: \"guava\"");
        this.myGroupIdTextField.addActionListener((ActionListener)new SearchActionListener());
        this.myGroupIdTextField.getEmptyText().setText("Example: \"com.google.guava\"");
        this.mySearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibrarySearch.this.performSearch();
            }
        });
        this.myAddLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Collection selection = LibrarySearch.this.myResultsTable.getSelection();
                for (LibraryFound libraryFound : selection) {
                    LibrarySearch.this.myDependenciesPanel.addLibraryDependency(libraryFound.coordinate.toString());
                }
            }
        });
        this.myResultsTable = new TableView((ListTableModel)new ResultsTableModel());
        this.myResultsTable.setAutoCreateRowSorter(true);
        this.myResultsTable.setShowGrid(false);
        this.myResultsTable.getTableHeader().setReorderingAllowed(false);
        this.myResultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LibrarySearch.this.myAddLibraryButton.setEnabled(!LibrarySearch.this.myResultsTable.getSelection().isEmpty());
            }
        });
        this.myResultsScrollPane.setViewportView(this.myResultsTable);
        List<RowSorter.SortKey> sortKeys = this.myResultsTable.getRowSorter().getSortKeys();
        new TableSpeedSearch(this.myResultsTable);
        this.clearResults();
    }

    private void performSearch() {
        this.mySearchButton.setEnabled(false);
        this.myResultsTable.getEmptyText().setText("Searching...");
        this.myResultsTable.setPaintBusy(true);
        this.clearResults();
        final ArtifactRepositorySearch.Request request = new ArtifactRepositorySearch.Request(this.getArtifactName(), this.getGroupId(), 50, 0);
        final ActionCallback callback = new ActionCallback();
        final ArrayList jobs = Lists.newArrayListWithExpectedSize((int)this.myRepositorySearches.size());
        final ArrayList librariesFound = Lists.newArrayList();
        final Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                for (final ArtifactRepositorySearch search : LibrarySearch.this.myRepositorySearches) {
                    jobs.add(application.executeOnPooledThread((Callable)new Callable<SearchResult>(){

                        @Override
                        public SearchResult call() throws Exception {
                            return search.start(request);
                        }
                    }));
                }
                for (Future job : jobs) {
                    try {
                        SearchResult result = (SearchResult)Futures.get((Future)job, Exception.class);
                        for (String coordinateText : result.data) {
                            GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)coordinateText);
                            if (coordinate == null) continue;
                            librariesFound.add(new LibraryFound(coordinate, result.repository));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                callback.setDone();
            }
        });
        callback.doWhenDone(new Runnable(){

            @Override
            public void run() {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LibrarySearch.this.myResultsTable.getListTableModel().setItems(librariesFound);
                        LibrarySearch.this.myResultsTable.updateColumnSizes();
                        LibrarySearch.this.myResultsTable.setPaintBusy(false);
                        LibrarySearch.this.myResultsTable.getEmptyText().setText("Nothing to show");
                        if (librariesFound.isEmpty()) {
                            LibrarySearch.this.myAddLibraryButton.setEnabled(false);
                        } else {
                            LibrarySearch.this.myResultsTable.changeSelection(0, 0, false, false);
                        }
                        LibrarySearch.this.myResultsTable.requestFocusInWindow();
                        LibrarySearch.this.mySearchButton.setEnabled(true);
                    }
                });
            }
        });
    }

    @NotNull
    private String getArtifactName() {
        String string = this.myArtifactNameTextField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/LibrarySearch", "getArtifactName"));
        }
        return string;
    }

    @Nullable
    private String getGroupId() {
        String groupId = this.myGroupIdTextField.getText().trim();
        return StringUtil.isNotEmpty((String)groupId) ? groupId : null;
    }

    @NotNull
    JPanel getPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/LibrarySearch", "getPanel"));
        }
        return jPanel;
    }

    private void clearResults() {
        this.myResultsTable.getListTableModel().setItems(Collections.emptyList());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBScrollPane jBScrollPane;
        JBLabel jBLabel;
        JButton jButton;
        JButton jButton2;
        JBTextField jBTextField;
        JBTextField jBTextField2;
        JBLabel jBLabel2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(5, 5, 5, 5), -1, -1, false, false));
        this.myArtifactNameLabel = jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setText("Artifact Name:");
        jBLabel2.setDisplayedMnemonic('N');
        jBLabel2.setDisplayedMnemonicIndex(9);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myArtifactNameTextField = jBTextField2 = new JBTextField();
        jPanel.add((Component)jBTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel3.setText("Group ID:");
        jBLabel3.setDisplayedMnemonic('G');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myGroupIdTextField = jBTextField = new JBTextField();
        jPanel.add((Component)jBTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.mySearchButton = jButton2 = new JButton();
        ((Component)jButton2).setEnabled(false);
        jButton2.setText("Search");
        jButton2.setMnemonic('S');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton2, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(3, 0, 1, 3, 0, 3, 1, 0, null, null, null));
        this.myAddLibraryButton = jButton = new JButton();
        ((Component)jButton).setEnabled(false);
        jButton.setText("Add Library");
        jButton.setMnemonic('A');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myRequiredFieldLabel = jBLabel = new JBLabel();
        jBLabel.setText("Required");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myResultsScrollPane = jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jBLabel2.setLabelFor((Component)jBTextField2);
        jBLabel3.setLabelFor((Component)jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class LibraryFound {
        @NotNull
        final GradleCoordinate coordinate;
        @NotNull
        final String repository;

        LibraryFound(@NotNull GradleCoordinate coordinate, @NotNull String repository) {
            if (coordinate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinate", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/LibrarySearch$LibraryFound", "<init>"));
            }
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/LibrarySearch$LibraryFound", "<init>"));
            }
            this.coordinate = coordinate;
            this.repository = repository;
        }
    }

    private static class ResultsTableModel
    extends ListTableModel<LibraryFound> {
        ResultsTableModel() {
            super(new ColumnInfo[0]);
            this.createAndSetColumnInfos();
            this.setSortable(true);
        }

        private void createAndSetColumnInfos() {
            ColumnInfo<LibraryFound, String> groupId = new ColumnInfo<LibraryFound, String>("Group ID"){

                @Nullable
                public String valueOf(LibraryFound libraryFound) {
                    return libraryFound.coordinate.getGroupId();
                }

                @NonNls
                @NotNull
                public String getPreferredStringValue() {
                    if ("abcdefghijklmno" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/LibrarySearch$ResultsTableModel$1", "getPreferredStringValue"));
                    }
                    return "abcdefghijklmno";
                }
            };
            ColumnInfo<LibraryFound, String> artifactName = new ColumnInfo<LibraryFound, String>("Artifact Name"){

                @Nullable
                public String valueOf(LibraryFound libraryFound) {
                    return libraryFound.coordinate.getArtifactId();
                }

                @NonNls
                @NotNull
                public String getPreferredStringValue() {
                    if ("abcdefg" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/LibrarySearch$ResultsTableModel$2", "getPreferredStringValue"));
                    }
                    return "abcdefg";
                }
            };
            ColumnInfo<LibraryFound, String> version = new ColumnInfo<LibraryFound, String>("Version"){

                @Nullable
                public String valueOf(LibraryFound libraryFound) {
                    return libraryFound.coordinate.getRevision();
                }

                @NotNull
                public String getPreferredStringValue() {
                    if ("100.100.100" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/dependencies/LibrarySearch$ResultsTableModel$3", "getPreferredStringValue"));
                    }
                    return "100.100.100";
                }
            };
            ColumnInfo<LibraryFound, String> repository = new ColumnInfo<LibraryFound, String>("Repository"){

                @Nullable
                public String valueOf(LibraryFound libraryFound) {
                    return libraryFound.repository;
                }
            };
            this.setColumnInfos(new ColumnInfo[]{groupId, artifactName, version, repository});
        }
    }

    private class SearchActionListener
    implements ActionListener {
        private SearchActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (LibrarySearch.this.mySearchButton.isEnabled()) {
                LibrarySearch.this.performSearch();
            }
        }
    }
}

