/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.tools.idea.logcat.AndroidLogcatView;
import com.intellij.execution.actions.ConsoleActionsPostProcessor;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.project.DumbAwareAction;
import java.util.ArrayList;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public final class LogcatConsoleActionsPostProcessor
extends ConsoleActionsPostProcessor {
    @NotNull
    public AnAction[] postProcess(@NotNull ConsoleView console, @NotNull AnAction[] actions) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/android/tools/idea/logcat/LogcatConsoleActionsPostProcessor", "postProcess"));
        }
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/android/tools/idea/logcat/LogcatConsoleActionsPostProcessor", "postProcess"));
        }
        if (!(console instanceof ConsoleViewImpl)) {
            if (actions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/LogcatConsoleActionsPostProcessor", "postProcess"));
            }
            return actions;
        }
        ConsoleViewImpl consoleImpl = (ConsoleViewImpl)console;
        if (!(consoleImpl.getParent() instanceof AndroidLogcatView.AndroidLogConsole)) {
            if (actions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/LogcatConsoleActionsPostProcessor", "postProcess"));
            }
            return actions;
        }
        AnAction[] anActionArray = this.processActions((AndroidLogcatView.AndroidLogConsole)((Object)consoleImpl.getParent()), actions);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/LogcatConsoleActionsPostProcessor", "postProcess"));
        }
        return anActionArray;
    }

    private AnAction[] processActions(AndroidLogcatView.AndroidLogConsole console, AnAction[] actions) {
        ArrayList<Object> actionList = new ArrayList<Object>(actions.length);
        AnAction scrollToEndAction = null;
        for (AnAction a : actions) {
            if (a instanceof ConsoleViewImpl.ClearAllAction) continue;
            if (a instanceof ScrollToTheEndToolbarAction) {
                String message = "Scroll to the end. Clicking on a particular line stops scrolling and keeps that line visible.";
                a.getTemplatePresentation().setDescription(message);
                a.getTemplatePresentation().setText(message);
                scrollToEndAction = a;
                continue;
            }
            actionList.add(a);
        }
        if (scrollToEndAction != null) {
            actionList.add(0, scrollToEndAction);
        }
        actionList.add(0, (Object)new ClearLogCatAction(console));
        return actionList.toArray(new AnAction[actionList.size()]);
    }

    private static final class ClearLogCatAction
    extends DumbAwareAction {
        private final AndroidLogcatView.AndroidLogConsole myConsole;

        public ClearLogCatAction(AndroidLogcatView.AndroidLogConsole console) {
            super(AndroidBundle.message("android.logcat.clear.log.action.title", new Object[0]), AndroidBundle.message("android.logcat.clear.log.action.tooltip", new Object[0]), AllIcons.Actions.GC);
            this.myConsole = console;
        }

        public void update(AnActionEvent e) {
            boolean enabled = e.getData(LangDataKeys.CONSOLE_VIEW) != null;
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != null && editor.getDocument().getTextLength() == 0) {
                enabled = false;
            }
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            this.myConsole.clearLogcat();
        }
    }
}

