/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.ShellCommandLauncher;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.stats.UsageTracker;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDeepLinkLaunchTask
implements LaunchTask {
    @NotNull
    private final String myApplicationId;
    @NotNull
    private final String myDeepLink;
    private final boolean myWaitForDebugger;
    @NotNull
    private final String myExtraAmOptions;

    public AndroidDeepLinkLaunchTask(@NotNull String applicationId, @NotNull String deepLink, boolean waitForDebugger, @NotNull String extraAmOptions) {
        if (applicationId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationId", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "<init>"));
        }
        if (deepLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deepLink", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "<init>"));
        }
        if (extraAmOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraAmOptions", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "<init>"));
        }
        this.myApplicationId = applicationId;
        this.myDeepLink = deepLink;
        this.myWaitForDebugger = waitForDebugger;
        this.myExtraAmOptions = extraAmOptions;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Launching deeplink" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "getDescription"));
        }
        return "Launching deeplink";
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "perform"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "perform"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "perform"));
        }
        printer.stdout("Launching deeplink: " + this.myDeepLink + ".\n");
        UsageTracker.getInstance().trackEvent("appIndexing", "deepLinkLaunched", null, null);
        ShellCommandLauncher.execute("setprop log.tag.AppIndexApi VERBOSE", device, launchStatus, printer, 5L, TimeUnit.SECONDS);
        String command = AndroidDeepLinkLaunchTask.getLaunchDeepLinkCommand(this.myDeepLink, this.myApplicationId, this.myWaitForDebugger, this.myExtraAmOptions);
        return ShellCommandLauncher.execute(command, device, launchStatus, printer, 5L, TimeUnit.SECONDS);
    }

    @NotNull
    public static String getLaunchDeepLinkCommand(@NotNull String deepLink, @Nullable String packageId, boolean waitForDebugger, @NotNull String extraFlags) {
        if (deepLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deepLink", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "getLaunchDeepLinkCommand"));
        }
        if (extraFlags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraFlags", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "getLaunchDeepLinkCommand"));
        }
        String string = "am start" + (waitForDebugger ? " -D" : "") + " -a android.intent.action.VIEW" + " -c android.intent.category.BROWSABLE" + " -d " + deepLink + (packageId == null ? "" : " " + packageId) + (extraFlags.isEmpty() ? "" : " " + extraFlags);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask", "getLaunchDeepLinkCommand"));
        }
        return string;
    }
}

