/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdkv2;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.SettingsController;
import com.android.tools.idea.sdkv2.StudioProgressIndicatorAdapter;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class StudioDownloader
implements Downloader {
    private com.intellij.openapi.progress.ProgressIndicator myStudioProgressIndicator;

    public StudioDownloader() {
    }

    public StudioDownloader(com.intellij.openapi.progress.ProgressIndicator progress) {
        this.myStudioProgressIndicator = progress;
    }

    public InputStream downloadAndStream(@NotNull URL url, SettingsController settings, @NotNull ProgressIndicator indicator) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/sdkv2/StudioDownloader", "downloadAndStream"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/sdkv2/StudioDownloader", "downloadAndStream"));
        }
        File file = this.downloadFully(url, settings, indicator);
        if (file == null) {
            return null;
        }
        return new FileInputStream(file);
    }

    public File downloadFully(URL url, SettingsController settings, ProgressIndicator indicator) throws IOException {
        indicator.logInfo("Downloading " + url);
        indicator.setText("Downloading...");
        indicator.setSecondaryText(url.toString());
        String suffix = url.getPath();
        suffix = suffix.substring(suffix.lastIndexOf("/") + 1);
        File tempFile = FileUtil.createTempFile((String)"StudioDownloader", (String)suffix, (boolean)true);
        tempFile.deleteOnExit();
        com.intellij.openapi.progress.ProgressIndicator studioProgress = this.myStudioProgressIndicator;
        if (studioProgress == null) {
            studioProgress = ProgressManager.getInstance().getProgressIndicator();
        }
        HttpRequests.request((String)url.toExternalForm()).saveToFile(tempFile, (com.intellij.openapi.progress.ProgressIndicator)new StudioProgressIndicatorAdapter(indicator, studioProgress));
        return tempFile;
    }
}

