/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.android.tools.idea.structure.services.DeveloperServiceBuildSystemOperations;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

final class BuildSystemOperationsLookup {
    BuildSystemOperationsLookup() {
    }

    @NotNull
    static DeveloperServiceBuildSystemOperations getBuildSystemOperations(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/structure/services/BuildSystemOperationsLookup", "getBuildSystemOperations"));
        }
        DeveloperServiceBuildSystemOperations found = null;
        for (DeveloperServiceBuildSystemOperations operations : (DeveloperServiceBuildSystemOperations[])DeveloperServiceBuildSystemOperations.EP_NAME.getExtensions()) {
            if (!operations.canHandle(project)) continue;
            found = operations;
            break;
        }
        assert (found != null);
        DeveloperServiceBuildSystemOperations developerServiceBuildSystemOperations = found;
        if (developerServiceBuildSystemOperations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/BuildSystemOperationsLookup", "getBuildSystemOperations"));
        }
        return developerServiceBuildSystemOperations;
    }

    @NotNull
    static DeveloperServiceBuildSystemOperations getBuildSystemOperations(@NotNull String buildSystemId) {
        if (buildSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildSystemId", "com/android/tools/idea/structure/services/BuildSystemOperationsLookup", "getBuildSystemOperations"));
        }
        DeveloperServiceBuildSystemOperations found = null;
        for (DeveloperServiceBuildSystemOperations operations : (DeveloperServiceBuildSystemOperations[])DeveloperServiceBuildSystemOperations.EP_NAME.getExtensions()) {
            if (!operations.getBuildSystemId().equals(buildSystemId)) continue;
            found = operations;
            break;
        }
        assert (found != null);
        DeveloperServiceBuildSystemOperations developerServiceBuildSystemOperations = found;
        if (developerServiceBuildSystemOperations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/structure/services/BuildSystemOperationsLookup", "getBuildSystemOperations"));
        }
        return developerServiceBuildSystemOperations;
    }
}

