/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Platform;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ObjectArraySubject<T>
extends AbstractArraySubject<ObjectArraySubject<T>, T[]> {
    private final String typeName;

    ObjectArraySubject(FailureStrategy failureStrategy, @Nullable T[] o) {
        super(failureStrategy, o);
        this.typeName = this.typeNameFromInstance(o);
    }

    @Override
    protected String underlyingType() {
        return this.typeName;
    }

    @Override
    protected List<T> listRepresentation() {
        return Arrays.asList((Object[])this.getSubject());
    }

    private String typeNameFromInstance(Object instance) {
        if (instance == null) {
            return "null reference of unknown array type";
        }
        if (!instance.getClass().isArray()) {
            throw new IllegalArgumentException(String.valueOf(instance.getClass().getName()).concat(" instance passed into T[] subject."));
        }
        Class<?> type = instance.getClass().getComponentType();
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("Primitive array passed into T[] subject.");
        }
        return Platform.compressType(type.toString());
    }

    @Override
    public void isEqualTo(Object expected) {
        Object[] actual = (Object[])this.getSubject();
        if (actual == expected) {
            return;
        }
        try {
            Object[] expectedArray = (Object[])expected;
            if (actual.length != expectedArray.length) {
                this.failWithRawMessage("%s has length %s. Expected length is %s", this.getDisplaySubject(), actual.length, expectedArray.length);
            } else {
                for (int i = 0; i < actual.length; ++i) {
                    if (Objects.equals(actual[i], expectedArray[i])) continue;
                    this.failWithBadResults("is equal to", Arrays.asList(expectedArray), "differs at index", i);
                }
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Override
    public void isNotEqualTo(Object expected) {
        Object[] actual = (Object[])this.getSubject();
        try {
            Object[] expectedArray = (Object[])expected;
            if (actual == expected || Arrays.equals(actual, expectedArray)) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.getDisplaySubject(), Arrays.asList(expectedArray));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public IterableSubject<?, T, List<T>> asList() {
        return IterableSubject.create(this.failureStrategy, this.listRepresentation());
    }
}

