/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Executable;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.MultipleFailuresError;

@API(value=API.Usage.Maintained)
public final class Assertions {
    private Assertions() {
    }

    public static void fail(String message) {
        throw new AssertionFailedError(message);
    }

    public static void fail(Supplier<String> messageSupplier) {
        Assertions.fail(Assertions.nullSafeGet(messageSupplier));
    }

    public static void assertTrue(boolean condition) {
        Assertions.assertTrue(() -> condition, () -> null);
    }

    public static void assertTrue(boolean condition, Supplier<String> messageSupplier) {
        Assertions.assertTrue(() -> condition, messageSupplier);
    }

    public static void assertTrue(BooleanSupplier booleanSupplier) {
        Assertions.assertTrue(booleanSupplier, () -> null);
    }

    public static void assertTrue(BooleanSupplier booleanSupplier, String message) {
        Assertions.assertTrue(booleanSupplier, () -> message);
    }

    public static void assertTrue(boolean condition, String message) {
        Assertions.assertTrue(() -> condition, () -> message);
    }

    public static void assertTrue(BooleanSupplier booleanSupplier, Supplier<String> messageSupplier) {
        if (!booleanSupplier.getAsBoolean()) {
            Assertions.fail(messageSupplier);
        }
    }

    public static void assertFalse(boolean condition) {
        Assertions.assertFalse(() -> condition, () -> null);
    }

    public static void assertFalse(boolean condition, String message) {
        Assertions.assertFalse(() -> condition, () -> message);
    }

    public static void assertFalse(boolean condition, Supplier<String> messageSupplier) {
        Assertions.assertFalse(() -> condition, messageSupplier);
    }

    public static void assertFalse(BooleanSupplier booleanSupplier) {
        Assertions.assertFalse(booleanSupplier, () -> null);
    }

    public static void assertFalse(BooleanSupplier booleanSupplier, String message) {
        Assertions.assertFalse(booleanSupplier, () -> message);
    }

    public static void assertFalse(BooleanSupplier booleanSupplier, Supplier<String> messageSupplier) {
        if (booleanSupplier.getAsBoolean()) {
            Assertions.fail(messageSupplier);
        }
    }

    public static void assertNull(Object actual) {
        Assertions.assertNull(actual, () -> null);
    }

    public static void assertNull(Object actual, String message) {
        Assertions.assertNull(actual, () -> message);
    }

    public static void assertNull(Object actual, Supplier<String> messageSupplier) {
        if (actual != null) {
            Assertions.failNotNull(actual, Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertNotNull(Object actual) {
        Assertions.assertNotNull(actual, () -> null);
    }

    public static void assertNotNull(Object actual, String message) {
        Assertions.assertNotNull(actual, () -> message);
    }

    public static void assertNotNull(Object actual, Supplier<String> messageSupplier) {
        if (actual == null) {
            Assertions.failNull(Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertEquals(short expected, short actual) {
        Assertions.assertEquals(expected, actual, () -> null);
    }

    public static void assertEquals(short expected, short actual, String message) {
        Assertions.assertEquals(expected, actual, () -> message);
    }

    public static void assertEquals(short expected, short actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            Assertions.failNotEqual(expected, actual, Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertEquals(byte expected, byte actual) {
        Assertions.assertEquals(expected, actual, () -> null);
    }

    public static void assertEquals(byte expected, byte actual, String message) {
        Assertions.assertEquals(expected, actual, () -> message);
    }

    public static void assertEquals(byte expected, byte actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            Assertions.failNotEqual(expected, actual, Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertEquals(int expected, int actual) {
        Assertions.assertEquals(expected, actual, () -> null);
    }

    public static void assertEquals(int expected, int actual, String message) {
        Assertions.assertEquals(expected, actual, () -> message);
    }

    public static void assertEquals(int expected, int actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            Assertions.failNotEqual(expected, actual, Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertEquals(long expected, long actual) {
        Assertions.assertEquals(expected, actual, () -> null);
    }

    public static void assertEquals(long expected, long actual, String message) {
        Assertions.assertEquals(expected, actual, () -> message);
    }

    public static void assertEquals(long expected, long actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            Assertions.failNotEqual(expected, actual, Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertEquals(char expected, char actual) {
        Assertions.assertEquals(expected, actual, () -> null);
    }

    public static void assertEquals(char expected, char actual, String message) {
        Assertions.assertEquals(expected, actual, () -> message);
    }

    public static void assertEquals(char expected, char actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            Assertions.failNotEqual(Character.valueOf(expected), Character.valueOf(actual), Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertEquals(float expected, float actual) {
        Assertions.assertEquals(expected, actual, () -> null);
    }

    public static void assertEquals(float expected, float actual, String message) {
        Assertions.assertEquals(expected, actual, () -> message);
    }

    public static void assertEquals(float expected, float actual, Supplier<String> messageSupplier) {
        if (!Assertions.floatsAreEqual(expected, actual)) {
            Assertions.failNotEqual(Float.valueOf(expected), Float.valueOf(actual), Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertEquals(float expected, float actual, float delta) {
        Assertions.assertEquals(expected, actual, delta, () -> null);
    }

    public static void assertEquals(float expected, float actual, float delta, String message) {
        Assertions.assertEquals(expected, actual, delta, () -> message);
    }

    public static void assertEquals(float expected, float actual, float delta, Supplier<String> messageSupplier) {
        if (!Assertions.floatsAreEqual(expected, actual, delta)) {
            Assertions.failNotEqual(Float.valueOf(expected), Float.valueOf(actual), Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertEquals(double expected, double actual) {
        Assertions.assertEquals(expected, actual, () -> null);
    }

    public static void assertEquals(double expected, double actual, String message) {
        Assertions.assertEquals(expected, actual, () -> message);
    }

    public static void assertEquals(double expected, double actual, Supplier<String> messageSupplier) {
        if (!Assertions.doublesAreEqual(expected, actual)) {
            Assertions.failNotEqual(expected, actual, Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertEquals(double expected, double actual, double delta) {
        Assertions.assertEquals(expected, actual, delta, () -> null);
    }

    public static void assertEquals(double expected, double actual, double delta, String message) {
        Assertions.assertEquals(expected, actual, delta, () -> message);
    }

    public static void assertEquals(double expected, double actual, double delta, Supplier<String> messageSupplier) {
        if (!Assertions.doublesAreEqual(expected, actual, delta)) {
            Assertions.failNotEqual(expected, actual, Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        Assertions.assertEquals(expected, actual, () -> null);
    }

    public static void assertEquals(Object expected, Object actual, String message) {
        Assertions.assertEquals(expected, actual, () -> message);
    }

    public static void assertEquals(Object expected, Object actual, Supplier<String> messageSupplier) {
        if (!Assertions.objectsAreEqual(expected, actual)) {
            Assertions.failNotEqual(expected, actual, Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertArrayEquals(boolean[] expected, boolean[] actual) {
        Assertions.assertArrayEquals(expected, actual, () -> null);
    }

    public static void assertArrayEquals(boolean[] expected, boolean[] actual, String message) {
        Assertions.assertArrayEquals(expected, actual, () -> message);
    }

    public static void assertArrayEquals(boolean[] expected, boolean[] actual, Supplier<String> messageSupplier) {
        Assertions.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    public static void assertArrayEquals(char[] expected, char[] actual) {
        Assertions.assertArrayEquals(expected, actual, () -> null);
    }

    public static void assertArrayEquals(char[] expected, char[] actual, String message) {
        Assertions.assertArrayEquals(expected, actual, () -> message);
    }

    public static void assertArrayEquals(char[] expected, char[] actual, Supplier<String> messageSupplier) {
        Assertions.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    public static void assertArrayEquals(byte[] expected, byte[] actual) {
        Assertions.assertArrayEquals(expected, actual, () -> null);
    }

    public static void assertArrayEquals(byte[] expected, byte[] actual, String message) {
        Assertions.assertArrayEquals(expected, actual, () -> message);
    }

    public static void assertArrayEquals(byte[] expected, byte[] actual, Supplier<String> messageSupplier) {
        Assertions.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    public static void assertArrayEquals(short[] expected, short[] actual) {
        Assertions.assertArrayEquals(expected, actual, () -> null);
    }

    public static void assertArrayEquals(short[] expected, short[] actual, String message) {
        Assertions.assertArrayEquals(expected, actual, () -> message);
    }

    public static void assertArrayEquals(short[] expected, short[] actual, Supplier<String> messageSupplier) {
        Assertions.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    public static void assertArrayEquals(int[] expected, int[] actual) {
        Assertions.assertArrayEquals(expected, actual, () -> null);
    }

    public static void assertArrayEquals(int[] expected, int[] actual, String message) {
        Assertions.assertArrayEquals(expected, actual, () -> message);
    }

    public static void assertArrayEquals(int[] expected, int[] actual, Supplier<String> messageSupplier) {
        Assertions.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    public static void assertArrayEquals(long[] expected, long[] actual) {
        Assertions.assertArrayEquals(expected, actual, () -> null);
    }

    public static void assertArrayEquals(long[] expected, long[] actual, String message) {
        Assertions.assertArrayEquals(expected, actual, () -> message);
    }

    public static void assertArrayEquals(long[] expected, long[] actual, Supplier<String> messageSupplier) {
        Assertions.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    public static void assertArrayEquals(float[] expected, float[] actual) {
        Assertions.assertArrayEquals(expected, actual, () -> null);
    }

    public static void assertArrayEquals(float[] expected, float[] actual, String message) {
        Assertions.assertArrayEquals(expected, actual, () -> message);
    }

    public static void assertArrayEquals(float[] expected, float[] actual, Supplier<String> messageSupplier) {
        Assertions.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    public static void assertArrayEquals(float[] expected, float[] actual, float delta) {
        Assertions.assertArrayEquals(expected, actual, delta, () -> null);
    }

    public static void assertArrayEquals(float[] expected, float[] actual, float delta, String message) {
        Assertions.assertArrayEquals(expected, actual, delta, () -> message);
    }

    public static void assertArrayEquals(float[] expected, float[] actual, float delta, Supplier<String> messageSupplier) {
        Assertions.assertArrayEquals(expected, actual, delta, null, messageSupplier);
    }

    public static void assertArrayEquals(double[] expected, double[] actual) {
        Assertions.assertArrayEquals(expected, actual, () -> null);
    }

    public static void assertArrayEquals(double[] expected, double[] actual, String message) {
        Assertions.assertArrayEquals(expected, actual, () -> message);
    }

    public static void assertArrayEquals(double[] expected, double[] actual, Supplier<String> messageSupplier) {
        Assertions.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    public static void assertArrayEquals(double[] expected, double[] actual, double delta) {
        Assertions.assertArrayEquals(expected, actual, delta, () -> null);
    }

    public static void assertArrayEquals(double[] expected, double[] actual, double delta, String message) {
        Assertions.assertArrayEquals(expected, actual, delta, () -> message);
    }

    public static void assertArrayEquals(double[] expected, double[] actual, double delta, Supplier<String> messageSupplier) {
        Assertions.assertArrayEquals(expected, actual, delta, null, messageSupplier);
    }

    public static void assertArrayEquals(Object[] expected, Object[] actual) {
        Assertions.assertArrayEquals(expected, actual, () -> null);
    }

    public static void assertArrayEquals(Object[] expected, Object[] actual, String message) {
        Assertions.assertArrayEquals(expected, actual, () -> message);
    }

    public static void assertArrayEquals(Object[] expected, Object[] actual, Supplier<String> messageSupplier) {
        Assertions.assertArrayEquals(expected, actual, new ArrayDeque<Integer>(), messageSupplier);
    }

    public static void assertNotEquals(Object unexpected, Object actual) {
        Assertions.assertNotEquals(unexpected, actual, () -> null);
    }

    public static void assertNotEquals(Object unexpected, Object actual, String message) {
        Assertions.assertNotEquals(unexpected, actual, () -> message);
    }

    public static void assertNotEquals(Object unexpected, Object actual, Supplier<String> messageSupplier) {
        if (Assertions.objectsAreEqual(unexpected, actual)) {
            Assertions.failEqual(actual, Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertSame(Object expected, Object actual) {
        Assertions.assertSame(expected, actual, () -> null);
    }

    public static void assertSame(Object expected, Object actual, String message) {
        Assertions.assertSame(expected, actual, () -> message);
    }

    public static void assertSame(Object expected, Object actual, Supplier<String> messageSupplier) {
        if (expected != actual) {
            Assertions.failNotSame(expected, actual, Assertions.nullSafeGet(messageSupplier));
        }
    }

    public static void assertNotSame(Object unexpected, Object actual) {
        Assertions.assertNotSame(unexpected, actual, () -> null);
    }

    public static void assertNotSame(Object unexpected, Object actual, String message) {
        Assertions.assertNotSame(unexpected, actual, () -> message);
    }

    public static void assertNotSame(Object unexpected, Object actual, Supplier<String> messageSupplier) {
        if (unexpected == actual) {
            Assertions.failSame(actual, Assertions.nullSafeGet(messageSupplier));
        }
    }

    @API(value=API.Usage.Experimental)
    public static void assertAll(Executable ... executables) throws MultipleFailuresError {
        Assertions.assertAll(null, executables);
    }

    @API(value=API.Usage.Experimental)
    public static void assertAll(String heading, Executable ... executables) throws MultipleFailuresError {
        MultipleFailuresError multipleFailuresError = new MultipleFailuresError(heading);
        for (Executable executable : executables) {
            try {
                executable.execute();
            }
            catch (AssertionError assertionError) {
                multipleFailuresError.addFailure(assertionError);
            }
            catch (Throwable t) {
                throw ExceptionUtils.throwAsUncheckedException((Throwable)t);
            }
        }
        if (multipleFailuresError.hasFailures()) {
            throw multipleFailuresError;
        }
    }

    public static void assertThrows(Class<? extends Throwable> expectedType, Executable executable) {
        Assertions.expectThrows(expectedType, executable);
    }

    public static <T extends Throwable> T expectThrows(Class<T> expectedType, Executable executable) {
        try {
            executable.execute();
        }
        catch (Throwable actualException) {
            if (expectedType.isInstance(actualException)) {
                return (T)actualException;
            }
            String message = Assertions.format(expectedType.getName(), actualException.getClass().getName(), "Unexpected exception type thrown");
            throw new AssertionFailedError(message, actualException);
        }
        throw new AssertionFailedError(String.format("Expected %s to be thrown, but nothing was thrown.", expectedType.getName()));
    }

    private static void assertArrayEquals(boolean[] expected, boolean[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        Assertions.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        Assertions.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assertions.failArraysNotEqual(expected[i], actual[i], Assertions.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(char[] expected, char[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        Assertions.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        Assertions.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assertions.failArraysNotEqual(Character.valueOf(expected[i]), Character.valueOf(actual[i]), Assertions.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(byte[] expected, byte[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        Assertions.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        Assertions.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assertions.failArraysNotEqual(expected[i], actual[i], Assertions.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(short[] expected, short[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        Assertions.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        Assertions.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assertions.failArraysNotEqual(expected[i], actual[i], Assertions.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(int[] expected, int[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        Assertions.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        Assertions.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assertions.failArraysNotEqual(expected[i], actual[i], Assertions.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(long[] expected, long[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        Assertions.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        Assertions.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assertions.failArraysNotEqual(expected[i], actual[i], Assertions.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(float[] expected, float[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        Assertions.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        Assertions.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (Assertions.floatsAreEqual(expected[i], actual[i])) continue;
            Assertions.failArraysNotEqual(Float.valueOf(expected[i]), Float.valueOf(actual[i]), Assertions.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(float[] expected, float[] actual, float delta, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        Assertions.assertValidDelta(delta);
        if (expected == actual) {
            return;
        }
        Assertions.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        Assertions.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (Assertions.floatsAreEqual(expected[i], actual[i], delta)) continue;
            Assertions.failArraysNotEqual(Float.valueOf(expected[i]), Float.valueOf(actual[i]), Assertions.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(double[] expected, double[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        Assertions.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        Assertions.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (Assertions.doublesAreEqual(expected[i], actual[i])) continue;
            Assertions.failArraysNotEqual(expected[i], actual[i], Assertions.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(double[] expected, double[] actual, double delta, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        Assertions.assertValidDelta(delta);
        if (expected == actual) {
            return;
        }
        Assertions.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        Assertions.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (Assertions.doublesAreEqual(expected[i], actual[i], delta)) continue;
            Assertions.failArraysNotEqual(expected[i], actual[i], Assertions.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(Object[] expected, Object[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        Assertions.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        Assertions.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            Object expectedElement = expected[i];
            Object actualElement = actual[i];
            if (expectedElement == actualElement) continue;
            indexes.addLast(i);
            Assertions.assertArrayElementsEqual(expectedElement, actualElement, indexes, messageSupplier);
            indexes.removeLast();
        }
    }

    private static void assertArrayElementsEqual(Object expected, Object actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected instanceof Object[] && actual instanceof Object[]) {
            Assertions.assertArrayEquals((Object[])expected, (Object[])actual, indexes, messageSupplier);
        } else if (expected instanceof byte[] && actual instanceof byte[]) {
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual, indexes, messageSupplier);
        } else if (expected instanceof short[] && actual instanceof short[]) {
            Assertions.assertArrayEquals((short[])expected, (short[])actual, indexes, messageSupplier);
        } else if (expected instanceof int[] && actual instanceof int[]) {
            Assertions.assertArrayEquals((int[])expected, (int[])actual, indexes, messageSupplier);
        } else if (expected instanceof long[] && actual instanceof long[]) {
            Assertions.assertArrayEquals((long[])expected, (long[])actual, indexes, messageSupplier);
        } else if (expected instanceof char[] && actual instanceof char[]) {
            Assertions.assertArrayEquals((char[])expected, (char[])actual, indexes, messageSupplier);
        } else if (expected instanceof float[] && actual instanceof float[]) {
            Assertions.assertArrayEquals((float[])expected, (float[])actual, indexes, messageSupplier);
        } else if (expected instanceof double[] && actual instanceof double[]) {
            Assertions.assertArrayEquals((double[])expected, (double[])actual, indexes, messageSupplier);
        } else if (expected instanceof boolean[] && actual instanceof boolean[]) {
            Assertions.assertArrayEquals((boolean[])expected, (boolean[])actual, indexes, messageSupplier);
        } else if (!Objects.equals(expected, actual)) {
            if (expected == null && ReflectionUtils.isArray((Object)actual)) {
                Assertions.failExpectedArrayIsNull(indexes, messageSupplier);
            } else if (ReflectionUtils.isArray((Object)expected) && actual == null) {
                Assertions.failActualArrayIsNull(indexes, messageSupplier);
            } else {
                Assertions.failArraysNotEqual(expected, actual, indexes, messageSupplier);
            }
        }
    }

    private static void assertArraysNotNull(Object expected, Object actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == null) {
            Assertions.failExpectedArrayIsNull(indexes, messageSupplier);
        }
        if (actual == null) {
            Assertions.failActualArrayIsNull(indexes, messageSupplier);
        }
    }

    private static void failExpectedArrayIsNull(Deque<Integer> indexes, Supplier<String> messageSupplier) {
        Assertions.fail(Assertions.buildPrefix(Assertions.nullSafeGet(messageSupplier)) + "expected array was <null>" + Assertions.formatIndexes(indexes));
    }

    private static void failActualArrayIsNull(Deque<Integer> indexes, Supplier<String> messageSupplier) {
        Assertions.fail(Assertions.buildPrefix(Assertions.nullSafeGet(messageSupplier)) + "actual array was <null>" + Assertions.formatIndexes(indexes));
    }

    private static void assertArraysHaveSameLength(int expected, int actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected != actual) {
            String prefix = Assertions.buildPrefix(Assertions.nullSafeGet(messageSupplier));
            String message = "array lengths differ" + Assertions.formatIndexes(indexes) + ", expected: <" + expected + "> but was: <" + actual + ">";
            Assertions.fail(prefix + message);
        }
    }

    private static void failArraysNotEqual(Object expected, Object actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        String prefix = Assertions.buildPrefix(Assertions.nullSafeGet(messageSupplier));
        String message = "array contents differ" + Assertions.formatIndexes(indexes) + ", " + Assertions.formatValues(expected, actual);
        Assertions.fail(prefix + message);
    }

    private static Deque<Integer> nullSafeIndexes(Deque<Integer> indexes, int newIndex) {
        ArrayDeque<Integer> result = indexes != null ? indexes : new ArrayDeque<Integer>();
        result.addLast(newIndex);
        return result;
    }

    private static String formatIndexes(Deque<Integer> indexes) {
        if (indexes == null || indexes.isEmpty()) {
            return "";
        }
        String indexesString = indexes.stream().map(Object::toString).collect(Collectors.joining("][", "[", "]"));
        return " at index " + indexesString;
    }

    private static void failEqual(Object actual, String message) {
        Assertions.fail(Assertions.buildPrefix(message) + "expected: not equal but was: <" + actual + ">");
    }

    private static void failNull(String message) {
        Assertions.fail(Assertions.buildPrefix(message) + "expected: not <null>");
    }

    private static void failNotNull(Object actual, String message) {
        Assertions.fail(Assertions.buildPrefix(message) + "expected: <null> but was: <" + actual + ">", null, actual);
    }

    private static void failSame(Object actual, String message) {
        Assertions.fail(Assertions.buildPrefix(message) + "expected: not same but was: <" + actual + ">");
    }

    private static void failNotSame(Object expected, Object actual, String message) {
        Assertions.fail(Assertions.format(expected, actual, message), expected, actual);
    }

    private static void failNotEqual(Object expected, Object actual, String message) {
        Assertions.fail(Assertions.format(expected, actual, message), expected, actual);
    }

    private static void fail(String message, Object expected, Object actual) {
        throw new AssertionFailedError(message, expected, actual);
    }

    private static String format(Object expected, Object actual, String message) {
        return Assertions.buildPrefix(message) + Assertions.formatValues(expected, actual);
    }

    private static String formatValues(Object expected, Object actual) {
        String actualString;
        String expectedString = String.valueOf(expected);
        if (expectedString.equals(actualString = String.valueOf(actual))) {
            return "expected: " + Assertions.formatClassAndValue(expected, expectedString) + " but was: " + Assertions.formatClassAndValue(actual, actualString);
        }
        return "expected: <" + expectedString + "> but was: <" + actualString + ">";
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        String hash = value == null ? "" : "@" + Integer.toHexString(System.identityHashCode(value));
        return className + hash + "<" + valueString + ">";
    }

    private static String buildPrefix(String message) {
        return StringUtils.isNotBlank((String)message) ? message + " ==> " : "";
    }

    private static String nullSafeGet(Supplier<String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }

    private static boolean objectsAreEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    private static boolean floatsAreEqual(float value1, float value2) {
        return Float.floatToIntBits(value1) == Float.floatToIntBits(value2);
    }

    private static boolean floatsAreEqual(float value1, float value2, float delta) {
        Assertions.assertValidDelta(delta);
        return Assertions.floatsAreEqual(value1, value2) || Math.abs(value1 - value2) <= delta;
    }

    private static void assertValidDelta(float delta) {
        if (Float.isNaN(delta) || (double)delta <= 0.0) {
            Assertions.failIllegalDelta(String.valueOf(delta));
        }
    }

    private static boolean doublesAreEqual(double value1, double value2) {
        return Double.doubleToLongBits(value1) == Double.doubleToLongBits(value2);
    }

    private static boolean doublesAreEqual(double value1, double value2, double delta) {
        Assertions.assertValidDelta(delta);
        return Assertions.doublesAreEqual(value1, value2) || Math.abs(value1 - value2) <= delta;
    }

    private static void assertValidDelta(double delta) {
        if (Double.isNaN(delta) || delta <= 0.0) {
            Assertions.failIllegalDelta(String.valueOf(delta));
        }
    }

    private static void failIllegalDelta(String delta) {
        Assertions.fail("positive delta expected but was: <" + delta + ">");
    }
}

