/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5;

import com.intellij.rt.execution.junit.JUnitStarter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;

public class JUnit5TestRunnerUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LauncherDiscoveryRequest buildRequest(String[] suiteClassNames, String[] packageNameRef) {
        if (suiteClassNames.length == 0) {
            return null;
        }
        LauncherDiscoveryRequestBuilder builder = LauncherDiscoveryRequestBuilder.request();
        ArrayList<String> lines = new ArrayList<String>();
        if (suiteClassNames.length == 1 && suiteClassNames[0].charAt(0) == '@') {
            try (BufferedReader reader = new BufferedReader(new FileReader(suiteClassNames[0].substring(1)));){
                String line2;
                String packageName = reader.readLine();
                if (packageName == null) {
                    LauncherDiscoveryRequest launcherDiscoveryRequest = null;
                    return launcherDiscoveryRequest;
                }
                String categoryName = reader.readLine();
                while ((line2 = reader.readLine()) != null) {
                    lines.add(line2);
                }
                String string = packageNameRef[0] = packageName.length() == 0 ? "<default package>" : packageName;
                if (JUnitStarter.isJUnit5Preferred()) {
                    PackageSelector selector = DiscoverySelectors.selectPackage((String)packageName);
                    LauncherDiscoveryRequest launcherDiscoveryRequest = builder.selectors(new DiscoverySelector[]{selector}).build();
                    return launcherDiscoveryRequest;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            Collections.addAll(lines, suiteClassNames);
        }
        List mappedLines = lines.stream().map(line -> line.replaceFirst(",", "#")).collect(Collectors.toList());
        return builder.selectors(DiscoverySelectors.selectNames(mappedLines)).build();
    }
}

