/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fd.runtime;

import com.android.tools.fd.common.Log;
import com.android.tools.fd.runtime.PatchesLoader;
import java.lang.reflect.Field;
import java.util.logging.Level;

public abstract class AbstractPatchesLoaderImpl
implements PatchesLoader {
    public abstract String[] getPatchedClasses();

    @Override
    public boolean load() {
        try {
            for (String className : this.getPatchedClasses()) {
                Field isObsolete;
                ClassLoader cl = this.getClass().getClassLoader();
                Class<?> aClass = cl.loadClass(className + "$override");
                Object o = aClass.newInstance();
                Class<?> originalClass = cl.loadClass(className);
                Field changeField = originalClass.getDeclaredField("$change");
                changeField.setAccessible(true);
                Object previous = changeField.get(null);
                if (previous != null && (isObsolete = previous.getClass().getDeclaredField("$obsolete")) != null) {
                    isObsolete.set(null, true);
                }
                changeField.set(null, o);
                if (Log.logging == null || !Log.logging.isLoggable(Level.INFO)) continue;
                Log.logging.log(Level.INFO, String.format("patched %s", className));
            }
        }
        catch (Exception e) {
            if (Log.logging != null) {
                Log.logging.log(Level.SEVERE, String.format("Exception while patching %s", "foo.bar"), e);
            }
            return false;
        }
        return true;
    }
}

