/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.RangeCodegenUtil;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0014J \u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\n0\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J \u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0017J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\bH\u0014J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0014J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\bH\u0014J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\bH\u0014J \u0010 \u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u000eH\u0014J\u001a\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\nH\u0017R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter;", "insnList", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "(Lorg/jetbrains/org/objectweb/asm/tree/InsnList;)V", "boxingPlaces", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue;", "createNewBoxing", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "progressionIterator", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue;", "isExactValue", "", "value", "merge", "kotlin.jvm.PlatformType", "v", "w", "naryOperation", "values", "", "onMergeFail", "", "onMergeSuccess", "onMethodCallWithBoxedValue", "onNewBoxedValue", "onUnboxing", "resultType", "unaryOperation", "Companion", "kotlin-compiler"})
public class BoxingInterpreter
extends OptimizationBasicInterpreter {
    private final HashMap<Integer, BoxedBasicValue> boxingPlaces;
    private final InsnList insnList;
    private static final ImmutableSet<String> UNBOXING_METHOD_NAMES;
    private static final String KCLASS_TO_JLCLASS;
    private static final String JLCLASS_TO_KCLASS;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected BasicValue createNewBoxing(@NotNull AbstractInsnNode insn, @NotNull Type type2, @Nullable ProgressionIteratorBasicValue progressionIterator) {
        Object object;
        void key$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        int index2 = this.insnList.indexOf(insn);
        Map map2 = this.boxingPlaces;
        Integer n = index2;
        Object value$iv = $receiver$iv.get(key$iv);
        if (value$iv == null) {
            BoxedBasicValue boxedBasicValue = new BoxedBasicValue(type2, insn, progressionIterator);
            this.onNewBoxedValue(boxedBasicValue);
            BoxedBasicValue answer$iv = boxedBasicValue;
            $receiver$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (BasicValue)object;
    }

    @Override
    @Nullable
    public BasicValue naryOperation(@NotNull AbstractInsnNode insn, @NotNull List<? extends BasicValue> values) throws AnalyzerException {
        Value value;
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(values, "values");
        Value value2 = super.naryOperation(insn, (List)values);
        BasicValue basicValue = CollectionsKt.firstOrNull(values);
        if (basicValue == null) {
            return value2;
        }
        BasicValue firstArg = basicValue;
        if (BoxingInterpreter.Companion.isBoxing(insn)) {
            Type type2 = ((BasicValue)value2).getType();
            Intrinsics.checkExpressionValueIsNotNull(type2, "value.type");
            value = this.createNewBoxing(insn, type2, null);
        } else if (BoxingInterpreter.Companion.isUnboxing(insn) && firstArg instanceof BoxedBasicValue) {
            BoxedBasicValue boxedBasicValue = (BoxedBasicValue)firstArg;
            Type type3 = ((BasicValue)value2).getType();
            Intrinsics.checkExpressionValueIsNotNull(type3, "value.type");
            this.onUnboxing(insn, boxedBasicValue, type3);
            value = value2;
        } else if (BoxingInterpreter.Companion.isIteratorMethodCallOfProgression(insn, values)) {
            String string = firstArg.getType().getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "firstArg.type.internalName");
            value = new ProgressionIteratorBasicValue(BoxingInterpreter.Companion.getValuesTypeOfProgressionClass(string));
        } else if (BoxingInterpreter.Companion.isNextMethodCallOfProgressionIterator(insn, values)) {
            BasicValue basicValue2 = firstArg;
            if (!(basicValue2 instanceof ProgressionIteratorBasicValue)) {
                basicValue2 = null;
            }
            ProgressionIteratorBasicValue progressionIteratorBasicValue = (ProgressionIteratorBasicValue)basicValue2;
            if (progressionIteratorBasicValue == null) {
                throw (Throwable)((Object)new AssertionError((Object)"firstArg should be progression iterator"));
            }
            ProgressionIteratorBasicValue progressionIteratorBasicValue2 = progressionIteratorBasicValue;
            Type type4 = AsmUtil.boxType(progressionIteratorBasicValue2.getValuesPrimitiveType());
            Intrinsics.checkExpressionValueIsNotNull(type4, "AsmUtil.boxType(progress\u2026ator.valuesPrimitiveType)");
            value = this.createNewBoxing(insn, type4, progressionIteratorBasicValue2);
        } else {
            for (BasicValue basicValue3 : values) {
                if (!(basicValue3 instanceof BoxedBasicValue)) continue;
                this.onMethodCallWithBoxedValue((BoxedBasicValue)basicValue3);
            }
            value = value2;
        }
        return value;
    }

    @Override
    @Nullable
    public BasicValue unaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value) throws AnalyzerException {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value, "value");
        return insn.getOpcode() == 192 && this.isExactValue(value) ? value : super.unaryOperation(insn, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isExactValue(@NotNull BasicValue value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        if (value instanceof ProgressionIteratorBasicValue) return true;
        if (value instanceof BoxedBasicValue) return true;
        if (value.getType() == null) return false;
        String string = value.getType().getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "value.type.internalName");
        if (!BoxingInterpreter.Companion.isProgressionClass(string)) return false;
        return true;
    }

    @Override
    public BasicValue merge(@NotNull BasicValue v, @NotNull BasicValue w) {
        BasicValue basicValue;
        Intrinsics.checkParameterIsNotNull(v, "v");
        Intrinsics.checkParameterIsNotNull(w, "w");
        if (Intrinsics.areEqual(v, BasicValue.UNINITIALIZED_VALUE) || Intrinsics.areEqual(w, BasicValue.UNINITIALIZED_VALUE)) {
            basicValue = BasicValue.UNINITIALIZED_VALUE;
        } else if (v instanceof BoxedBasicValue && ((BoxedBasicValue)v).typeEquals(w)) {
            BasicValue basicValue2 = w;
            if (basicValue2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            }
            this.onMergeSuccess((BoxedBasicValue)v, (BoxedBasicValue)basicValue2);
            basicValue = v;
        } else {
            if (v instanceof BoxedBasicValue) {
                this.onMergeFail((BoxedBasicValue)v);
            }
            if (w instanceof BoxedBasicValue) {
                this.onMergeFail((BoxedBasicValue)w);
            }
            basicValue = super.merge(v, w);
        }
        return basicValue;
    }

    protected void onNewBoxedValue(@NotNull BoxedBasicValue value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
    }

    protected void onUnboxing(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value, @NotNull Type resultType) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(resultType, "resultType");
    }

    protected void onMethodCallWithBoxedValue(@NotNull BoxedBasicValue value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
    }

    protected void onMergeFail(@NotNull BoxedBasicValue value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
    }

    protected void onMergeSuccess(@NotNull BoxedBasicValue v, @NotNull BoxedBasicValue w) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        Intrinsics.checkParameterIsNotNull(w, "w");
    }

    public BoxingInterpreter(@NotNull InsnList insnList) {
        Intrinsics.checkParameterIsNotNull(insnList, "insnList");
        this.insnList = insnList;
        this.boxingPlaces = new HashMap();
    }

    static {
        Companion = new Companion(null);
        UNBOXING_METHOD_NAMES = ImmutableSet.of("booleanValue", "charValue", "byteValue", "shortValue", "intValue", "floatValue", new String[]{"longValue", "doubleValue"});
        KCLASS_TO_JLCLASS = Type.getMethodDescriptor(AsmTypes.JAVA_CLASS_TYPE, AsmTypes.K_CLASS_TYPE);
        JLCLASS_TO_KCLASS = Type.getMethodDescriptor(AsmTypes.K_CLASS_TYPE, AsmTypes.JAVA_CLASS_TYPE);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0015\u0010\u0011\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\f\u0010\u001a\u001a\u00020\u0015*\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u0015*\u00020\u001dH\u0002J\u001a\u0010\u001e\u001a\u00020\u0015*\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\f\u0010\"\u001a\u00020\u0015*\u00020\u001bH\u0002J\f\u0010#\u001a\u00020\u0015*\u00020\u001bH\u0002J.\u0010$\u001a\u00020\u0015*\u00020\u001b2\u0006\u0010%\u001a\u00020&2\u0017\u0010'\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00150(\u00a2\u0006\u0002\b)H\u0082\bJ\u001a\u0010*\u001a\u00020\u0015*\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\f\u0010+\u001a\u00020\u0015*\u00020\u001bH\u0002J\f\u0010,\u001a\u00020\u0015*\u00020\u001bH\u0002J\f\u0010-\u001a\u00020\u0015*\u00020\u001bH\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R8\u0010\n\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00040\u0004 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter$Companion;", "", "()V", "JLCLASS_TO_KCLASS", "", "kotlin.jvm.PlatformType", "getJLCLASS_TO_KCLASS", "()Ljava/lang/String;", "KCLASS_TO_JLCLASS", "getKCLASS_TO_JLCLASS", "UNBOXING_METHOD_NAMES", "Lcom/google/common/collect/ImmutableSet;", "getUNBOXING_METHOD_NAMES", "()Lcom/google/common/collect/ImmutableSet;", "buildFqNameByInternal", "Lorg/jetbrains/kotlin/name/FqName;", "internalClassName", "getValuesTypeOfProgressionClass", "Lorg/jetbrains/annotations/NotNull;", "progressionClassInternalName", "isProgressionClass", "", "isUnboxingMethodName", "name", "isWrapperClassName", "isWrapperClassNameOrNumber", "isBoxing", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "isBoxingMethodDescriptor", "Lorg/jetbrains/org/objectweb/asm/tree/MethodInsnNode;", "isIteratorMethodCallOfProgression", "values", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "isJavaLangClassBoxing", "isJavaLangClassUnboxing", "isMethodInsnWith", "opcode", "", "condition", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "isNextMethodCallOfProgressionIterator", "isPrimitiveBoxing", "isPrimitiveUnboxing", "isUnboxing", "kotlin-compiler"})
    public static final class Companion {
        private final ImmutableSet<String> getUNBOXING_METHOD_NAMES() {
            return UNBOXING_METHOD_NAMES;
        }

        private final String getKCLASS_TO_JLCLASS() {
            return KCLASS_TO_JLCLASS;
        }

        private final String getJLCLASS_TO_KCLASS() {
            return JLCLASS_TO_KCLASS;
        }

        private final boolean isWrapperClassNameOrNumber(String internalClassName) {
            return this.isWrapperClassName(internalClassName) || Intrinsics.areEqual(internalClassName, Type.getInternalName(Number.class));
        }

        private final boolean isWrapperClassName(String internalClassName) {
            return JvmPrimitiveType.isWrapperClassName(this.buildFqNameByInternal(internalClassName));
        }

        private final FqName buildFqNameByInternal(String internalClassName) {
            return new FqName(Type.getObjectType(internalClassName).getClassName());
        }

        private final boolean isUnboxing(@NotNull AbstractInsnNode $receiver) {
            return this.isPrimitiveUnboxing($receiver) || this.isJavaLangClassUnboxing($receiver);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isPrimitiveUnboxing(@NotNull AbstractInsnNode $receiver) {
            void opcode$iv;
            void $receiver$iv;
            AbstractInsnNode abstractInsnNode = $receiver;
            Companion companion = this;
            int n = 182;
            if ($receiver$iv.getOpcode() != opcode$iv) return false;
            if (!($receiver$iv instanceof MethodInsnNode)) return false;
            MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
            String string = $receiver2.owner;
            Intrinsics.checkExpressionValueIsNotNull(string, "owner");
            if (!Companion.isWrapperClassNameOrNumber(string)) return false;
            String string2 = $receiver2.name;
            Intrinsics.checkExpressionValueIsNotNull(string2, "name");
            if (!Companion.isUnboxingMethodName(string2)) return false;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isJavaLangClassUnboxing(@NotNull AbstractInsnNode $receiver) {
            boolean bl;
            void opcode$iv;
            void $receiver$iv;
            AbstractInsnNode abstractInsnNode = $receiver;
            Companion companion = this;
            int n = 184;
            if ($receiver$iv.getOpcode() == opcode$iv && $receiver$iv instanceof MethodInsnNode) {
                MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
                bl = Intrinsics.areEqual($receiver2.owner, "kotlin/jvm/JvmClassMappingKt") && Intrinsics.areEqual($receiver2.name, "getJavaClass") && Intrinsics.areEqual($receiver2.desc, Companion.getKCLASS_TO_JLCLASS());
            } else {
                bl = false;
            }
            return bl;
        }

        private final boolean isUnboxingMethodName(String name) {
            return this.getUNBOXING_METHOD_NAMES().contains(name);
        }

        private final boolean isBoxing(@NotNull AbstractInsnNode $receiver) {
            return this.isPrimitiveBoxing($receiver) || this.isJavaLangClassBoxing($receiver);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isPrimitiveBoxing(@NotNull AbstractInsnNode $receiver) {
            boolean bl;
            void opcode$iv;
            void $receiver$iv;
            AbstractInsnNode abstractInsnNode = $receiver;
            Companion companion = this;
            int n = 184;
            if ($receiver$iv.getOpcode() == opcode$iv && $receiver$iv instanceof MethodInsnNode) {
                MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
                String string = $receiver2.owner;
                Intrinsics.checkExpressionValueIsNotNull(string, "owner");
                bl = Companion.isWrapperClassName(string) && Intrinsics.areEqual($receiver2.name, "valueOf") && Companion.isBoxingMethodDescriptor($receiver2);
            } else {
                bl = false;
            }
            return bl;
        }

        private final boolean isBoxingMethodDescriptor(@NotNull MethodInsnNode $receiver) {
            Type ownerType = Type.getObjectType($receiver.owner);
            return Intrinsics.areEqual($receiver.desc, Type.getMethodDescriptor(ownerType, AsmUtil.unboxType(ownerType)));
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isJavaLangClassBoxing(@NotNull AbstractInsnNode $receiver) {
            boolean bl;
            void opcode$iv;
            void $receiver$iv;
            AbstractInsnNode abstractInsnNode = $receiver;
            Companion companion = this;
            int n = 184;
            if ($receiver$iv.getOpcode() == opcode$iv && $receiver$iv instanceof MethodInsnNode) {
                MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
                bl = Intrinsics.areEqual($receiver2.owner, "kotlin/jvm/internal/Reflection") && Intrinsics.areEqual($receiver2.name, "getOrCreateKotlinClass") && Intrinsics.areEqual($receiver2.desc, Companion.getJLCLASS_TO_KCLASS());
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNextMethodCallOfProgressionIterator(@NotNull AbstractInsnNode $receiver, List<? extends BasicValue> values) {
            void opcode$iv;
            void $receiver$iv;
            if (!(values.get(0) instanceof ProgressionIteratorBasicValue)) return false;
            AbstractInsnNode abstractInsnNode = $receiver;
            Companion companion = this;
            int n = OptimizationBasicInterpreter.INVOKEINTERFACE;
            if ($receiver$iv.getOpcode() != opcode$iv) return false;
            if (!($receiver$iv instanceof MethodInsnNode)) return false;
            MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
            boolean bl = Intrinsics.areEqual($receiver2.name, "next");
            if (!bl) return false;
            return true;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isIteratorMethodCallOfProgression(@NotNull AbstractInsnNode $receiver, List<? extends BasicValue> values) {
            void opcode$iv;
            void $receiver$iv;
            AbstractInsnNode abstractInsnNode = $receiver;
            Companion companion = this;
            int n = OptimizationBasicInterpreter.INVOKEINTERFACE;
            if ($receiver$iv.getOpcode() != opcode$iv) return false;
            if (!($receiver$iv instanceof MethodInsnNode)) return false;
            MethodInsnNode $receiver2 = (MethodInsnNode)$receiver$iv;
            Type firstArgType = values.get(0).getType();
            if (firstArgType == null) return false;
            String string = firstArgType.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "firstArgType.internalName");
            if (!Companion.isProgressionClass(string)) return false;
            if (!Intrinsics.areEqual($receiver2.name, "iterator")) return false;
            return true;
        }

        private final boolean isProgressionClass(String internalClassName) {
            return RangeCodegenUtil.isRangeOrProgression(this.buildFqNameByInternal(internalClassName));
        }

        private final String getValuesTypeOfProgressionClass(String progressionClassInternalName) {
            Object object;
            block3: {
                Object object2;
                block2: {
                    object = RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(this.buildFqNameByInternal(progressionClassInternalName));
                    if (object == null) break block2;
                    object2 = object;
                    Object type2 = object2;
                    object = type2.getTypeName().asString();
                    if (object != null) break block3;
                }
                object2 = "type should be not null";
                throw (Throwable)new IllegalStateException(object2.toString());
            }
            return object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

