/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.state;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.BuiltInsPackageFragment;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForCallableDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForPropertyDescriptor;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.binding.PsiCodegenPredictor;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.codegen.state.IncompatibleClassTracker;
import org.jetbrains.kotlin.codegen.state.ReceiverTypeAndTypeParameters;
import org.jetbrains.kotlin.codegen.state.TypeMapperUtilsKt;
import org.jetbrains.kotlin.codegen.state.TypeMappingMode;
import org.jetbrains.kotlin.codegen.state.TypeMappingUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PossiblyInnerType;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterUtilsKt;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.JvmBytecodeBinaryVersion;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageFragment;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageScope;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryPackageSourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.incremental.IncrementalPackageFragmentProvider;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionImportedFromObject;
import org.jetbrains.kotlin.resolve.ImportedFromObjectCallableDescriptor;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.AbstractScopeAdapter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedType;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class KotlinTypeMapper {
    private final BindingContext bindingContext;
    private final ClassBuilderMode classBuilderMode;
    private final JvmFileClassesProvider fileClassesProvider;
    private final IncrementalCache incrementalCache;
    private final IncompatibleClassTracker incompatibleClassTracker;
    private final String moduleName;
    private static final ClassId FAKE_CLASS_ID_FOR_BUILTINS = ClassId.topLevel(new FqName("kotlin.KotlinPackage"));

    public KotlinTypeMapper(@NotNull BindingContext bindingContext, @NotNull ClassBuilderMode classBuilderMode, @NotNull JvmFileClassesProvider fileClassesProvider, @Nullable IncrementalCache incrementalCache, @NotNull IncompatibleClassTracker incompatibleClassTracker, @NotNull String moduleName) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "<init>"));
        }
        if (classBuilderMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classBuilderMode", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "<init>"));
        }
        if (fileClassesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileClassesProvider", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "<init>"));
        }
        if (incompatibleClassTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incompatibleClassTracker", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "<init>"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "<init>"));
        }
        this.bindingContext = bindingContext;
        this.classBuilderMode = classBuilderMode;
        this.fileClassesProvider = fileClassesProvider;
        this.incrementalCache = incrementalCache;
        this.incompatibleClassTracker = incompatibleClassTracker;
        this.moduleName = moduleName;
    }

    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.bindingContext;
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getBindingContext"));
        }
        return bindingContext;
    }

    @NotNull
    public Type mapOwner(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapOwner"));
        }
        Type type2 = this.mapOwner(descriptor2, true);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapOwner"));
        }
        return type2;
    }

    public Type mapImplementationOwner(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapImplementationOwner"));
        }
        return this.mapOwner(descriptor2, false);
    }

    @NotNull
    public Type mapOwner(@NotNull DeclarationDescriptor descriptor2, boolean publicFacade) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapOwner"));
        }
        if (ExpressionTypingUtils.isLocalFunction(descriptor2)) {
            Type type2 = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor2);
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapOwner"));
            }
            return type2;
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (container2 instanceof PackageFragmentDescriptor) {
            String packageMemberOwner = this.internalNameForPackageMemberOwner((CallableMemberDescriptor)descriptor2, publicFacade);
            Type type3 = Type.getObjectType(packageMemberOwner);
            if (type3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapOwner"));
            }
            return type3;
        }
        if (container2 instanceof ClassDescriptor) {
            Type type4 = this.mapClass((ClassDescriptor)container2);
            if (type4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapOwner"));
            }
            return type4;
        }
        throw new UnsupportedOperationException("Don't know how to map owner for " + descriptor2);
    }

    @NotNull
    private String internalNameForPackageMemberOwner(@NotNull CallableMemberDescriptor descriptor2, boolean publicFacade) {
        String facadeFqName;
        KtFile file;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "internalNameForPackageMemberOwner"));
        }
        boolean isAccessor = descriptor2 instanceof AccessorForCallableDescriptor;
        if (isAccessor) {
            descriptor2 = ((AccessorForCallableDescriptor)((Object)descriptor2)).getCalleeDescriptor();
        }
        if ((file = DescriptorToSourceUtils.getContainingFile(descriptor2)) != null) {
            Visibility visibility = descriptor2.getVisibility();
            if (!publicFacade || KotlinTypeMapper.isNonConstProperty(descriptor2) || Visibilities.isPrivate(visibility) || isAccessor) {
                String string = FileClasses.getFileClassInternalName(this.fileClassesProvider, file);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "internalNameForPackageMemberOwner"));
                }
                return string;
            }
            String string = FileClasses.getFacadeClassInternalName(this.fileClassesProvider, file);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "internalNameForPackageMemberOwner"));
            }
            return string;
        }
        CallableMemberDescriptor directMember = JvmCodegenUtil.getDirectMember(descriptor2);
        if (directMember instanceof DeserializedCallableMemberDescriptor && (facadeFqName = this.getPackageMemberOwnerInternalName((DeserializedCallableMemberDescriptor)directMember, publicFacade)) != null) {
            String string = facadeFqName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "internalNameForPackageMemberOwner"));
            }
            return string;
        }
        throw new RuntimeException("Could not find package member for " + descriptor2 + " in package fragment " + descriptor2.getContainingDeclaration());
    }

    private static boolean isNonConstProperty(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "isNonConstProperty"));
        }
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return false;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
        return !propertyDescriptor.isConst();
    }

    public ContainingClassesInfo getContainingClassesForDeserializedCallable(DeserializedCallableMemberDescriptor deserializedDescriptor) {
        ContainingClassesInfo containingClassesInfo;
        DeclarationDescriptor parentDeclaration = deserializedDescriptor.getContainingDeclaration();
        if (parentDeclaration instanceof PackageFragmentDescriptor) {
            containingClassesInfo = this.getPackageMemberContainingClassesInfo(deserializedDescriptor);
        } else {
            ClassId classId = KotlinTypeMapper.getContainerClassIdForClassDescriptor((ClassDescriptor)parentDeclaration);
            containingClassesInfo = ContainingClassesInfo.forClassMemberOrNull(classId);
        }
        if (containingClassesInfo == null) {
            throw new IllegalStateException("Couldn't find container for " + deserializedDescriptor.getName());
        }
        return containingClassesInfo;
    }

    private static ClassId getContainerClassIdForClassDescriptor(ClassDescriptor classDescriptor) {
        ClassId classId = DescriptorUtilsKt.getClassId(classDescriptor);
        if (DescriptorUtils.isInterface(classDescriptor)) {
            FqName relativeClassName = classId.getRelativeClassName();
            classId = new ClassId(classId.getPackageFqName(), Name.identifier(relativeClassName.shortName().asString() + "$DefaultImpls"));
        }
        return classId;
    }

    @Nullable
    private String getPackageMemberOwnerInternalName(@NotNull DeserializedCallableMemberDescriptor descriptor2, boolean publicFacade) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getPackageMemberOwnerInternalName"));
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        assert (containingDeclaration instanceof PackageFragmentDescriptor) : "Not a top-level member: " + descriptor2;
        ContainingClassesInfo containingClasses = this.getPackageMemberContainingClassesInfo(descriptor2);
        if (containingClasses == null) {
            return null;
        }
        ClassId ownerClassId = publicFacade ? containingClasses.getFacadeClassId() : containingClasses.getImplClassId();
        return JvmClassName.byClassId(ownerClassId).getInternalName();
    }

    @Nullable
    private ContainingClassesInfo getPackageMemberContainingClassesInfo(@NotNull DeserializedCallableMemberDescriptor descriptor2) {
        String facadeSimpleName;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getPackageMemberContainingClassesInfo"));
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        assert (containingDeclaration instanceof PackageFragmentDescriptor) : "Package member expected, got " + descriptor2 + " in " + containingDeclaration;
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)containingDeclaration;
        if (packageFragmentDescriptor instanceof BuiltInsPackageFragment) {
            return new ContainingClassesInfo(FAKE_CLASS_ID_FOR_BUILTINS, FAKE_CLASS_ID_FOR_BUILTINS);
        }
        Name implClassName = JvmFileClassUtil.getImplClassName(descriptor2);
        assert (implClassName != null) : "No implClassName for " + descriptor2;
        String implSimpleName = implClassName.asString();
        MemberScope scope2 = packageFragmentDescriptor.getMemberScope();
        if (scope2 instanceof AbstractScopeAdapter) {
            scope2 = ((AbstractScopeAdapter)scope2).getActualScope();
        }
        if (scope2 instanceof LazyJavaPackageScope) {
            facadeSimpleName = ((LazyJavaPackageScope)scope2).getFacadeSimpleNameForPartSimpleName(implClassName.asString());
        } else if (packageFragmentDescriptor instanceof IncrementalPackageFragmentProvider.IncrementalPackageFragment) {
            assert (this.incrementalCache != null) : "IncrementalPackageFragment found outside of incremental compilation context for " + descriptor2 + " in package " + packageFragmentDescriptor;
            String implClassInternalName = AsmUtil.internalNameByFqNameWithoutInnerClasses(packageFragmentDescriptor.getFqName().child(implClassName));
            String facadeClassInternalName = this.incrementalCache.getMultifileFacade(implClassInternalName);
            facadeSimpleName = facadeClassInternalName == null ? implClassName.asString() : AsmUtil.getSimpleInternalName(facadeClassInternalName);
        } else {
            throw new AssertionError((Object)("Unexpected package member scope for " + descriptor2 + ": " + scope2 + " :" + scope2.getClass().getSimpleName()));
        }
        return ContainingClassesInfo.forPackageMemberOrNull(packageFragmentDescriptor.getFqName(), facadeSimpleName, implSimpleName);
    }

    @NotNull
    public Type mapReturnType(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
        }
        Type type2 = this.mapReturnType(descriptor2, null);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
        }
        return type2;
    }

    @NotNull
    private Type mapReturnType(@NotNull CallableDescriptor descriptor2, @Nullable JvmSignatureWriter sw) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
        }
        KotlinType returnType = descriptor2.getReturnType();
        assert (returnType != null) : "Function has no return type: " + descriptor2;
        if (descriptor2 instanceof ConstructorDescriptor) {
            Type type2 = Type.VOID_TYPE;
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
            }
            return type2;
        }
        if (KotlinBuiltIns.isUnit(returnType) && !TypeUtils.isNullableType(returnType) && !(descriptor2 instanceof PropertyGetterDescriptor)) {
            if (sw != null) {
                sw.writeAsmType(Type.VOID_TYPE);
            }
            Type type3 = Type.VOID_TYPE;
            if (type3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
            }
            return type3;
        }
        if (descriptor2 instanceof FunctionDescriptor && KotlinTypeMapper.forceBoxedReturnType((FunctionDescriptor)descriptor2)) {
            Type type4 = this.mapType(descriptor2.getReturnType(), sw, TypeMappingMode.GENERIC_ARGUMENT);
            if (type4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
            }
            return type4;
        }
        Type type5 = this.mapReturnType(descriptor2, sw, returnType);
        if (type5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
        }
        return type5;
    }

    @NotNull
    private Type mapReturnType(@NotNull CallableDescriptor descriptor2, @Nullable JvmSignatureWriter sw, @NotNull KotlinType returnType) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
        }
        boolean isAnnotationMethod = DescriptorUtils.isAnnotationClass(descriptor2.getContainingDeclaration());
        if (sw == null || sw.skipGenericSignature()) {
            Type type2 = this.mapType(returnType, sw, TypeMappingMode.getModeForReturnTypeNoGeneric(isAnnotationMethod));
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
            }
            return type2;
        }
        TypeMappingMode typeMappingModeFromAnnotation = TypeMappingUtil.extractTypeMappingModeFromAnnotation(descriptor2, returnType, isAnnotationMethod);
        if (typeMappingModeFromAnnotation != null) {
            Type type3 = this.mapType(returnType, sw, typeMappingModeFromAnnotation);
            if (type3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
            }
            return type3;
        }
        TypeMappingMode mappingMode = TypeMappingMode.getOptimalModeForReturnType(returnType, isAnnotationMethod);
        Type type4 = this.mapType(returnType, sw, mappingMode);
        if (type4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
        }
        return type4;
    }

    @NotNull
    private Type mapType(@NotNull KotlinType jetType, @NotNull TypeMappingMode mode) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(jetType, null, mode);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    public Type mapSupertype(@NotNull KotlinType jetType, @Nullable JvmSignatureWriter signatureVisitor) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSupertype"));
        }
        Type type2 = this.mapType(jetType, signatureVisitor, TypeMappingMode.SUPER_TYPE);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSupertype"));
        }
        return type2;
    }

    @NotNull
    public Type mapTypeParameter(@NotNull KotlinType jetType, @Nullable JvmSignatureWriter signatureVisitor) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapTypeParameter"));
        }
        Type type2 = this.mapType(jetType, signatureVisitor, TypeMappingMode.GENERIC_ARGUMENT);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapTypeParameter"));
        }
        return type2;
    }

    @NotNull
    public Type mapClass(@NotNull ClassifierDescriptor classifier2) {
        if (classifier2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifier", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapClass"));
        }
        Type type2 = this.mapType(classifier2.getDefaultType(), null, TypeMappingMode.DEFAULT);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapClass"));
        }
        return type2;
    }

    @NotNull
    public Type mapType(@NotNull KotlinType jetType) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(jetType, null, TypeMappingMode.DEFAULT);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    public Type mapType(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(descriptor2.getReturnType());
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    public JvmMethodGenericSignature mapAnnotationParameterSignature(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapAnnotationParameterSignature"));
        }
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        ((JvmSignatureWriter)sw).writeReturnType();
        this.mapType(descriptor2.getType(), sw, TypeMappingMode.VALUE_FOR_ANNOTATION);
        ((JvmSignatureWriter)sw).writeReturnTypeEnd();
        JvmMethodGenericSignature jvmMethodGenericSignature = sw.makeJvmMethodSignature(descriptor2.getName().asString());
        if (jvmMethodGenericSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapAnnotationParameterSignature"));
        }
        return jvmMethodGenericSignature;
    }

    @NotNull
    public Type mapType(@NotNull ClassifierDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(descriptor2.getDefaultType());
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    private Type mapType(@NotNull KotlinType jetType, @Nullable JvmSignatureWriter signatureVisitor, @NotNull TypeMappingMode mode) {
        ClassifierDescriptor descriptor2;
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        Type builtinType = KotlinTypeMapper.mapBuiltinType(jetType);
        if (builtinType != null) {
            Type asmType = mode.getNeedPrimitiveBoxing() ? AsmUtil.boxType(builtinType) : builtinType;
            this.writeGenericType(jetType, asmType, signatureVisitor, mode);
            Type type2 = asmType;
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
            }
            return type2;
        }
        TypeConstructor constructor = jetType.getConstructor();
        if (constructor instanceof IntersectionTypeConstructor) {
            jetType = CommonSupertypes.commonSupertype(new ArrayList<KotlinType>(constructor.getSupertypes()));
            jetType = TypeUtilsKt.replaceArgumentsWithStarProjections(jetType);
            constructor = jetType.getConstructor();
        }
        if ((descriptor2 = constructor.getDeclarationDescriptor()) == null) {
            throw new UnsupportedOperationException("no descriptor for type constructor of " + jetType);
        }
        if (ErrorUtils.isError(descriptor2)) {
            if (this.classBuilderMode == ClassBuilderMode.FULL) {
                throw new IllegalStateException(KotlinTypeMapper.generateErrorMessageForErrorType(jetType, descriptor2));
            }
            Type asmType = Type.getObjectType("error/NonExistentClass");
            if (signatureVisitor != null) {
                signatureVisitor.writeAsmType(asmType);
            }
            Type type3 = asmType;
            if (type3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
            }
            return type3;
        }
        if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isArray(jetType)) {
            Type arrayElementType;
            if (jetType.getArguments().size() != 1) {
                throw new UnsupportedOperationException("arrays must have one type argument");
            }
            TypeProjection memberProjection = jetType.getArguments().get(0);
            KotlinType memberType = memberProjection.getType();
            if (memberProjection.getProjectionKind() == Variance.IN_VARIANCE) {
                arrayElementType = AsmTypes.OBJECT_TYPE;
                if (signatureVisitor != null) {
                    signatureVisitor.writeArrayType();
                    signatureVisitor.writeAsmType(arrayElementType);
                    signatureVisitor.writeArrayEnd();
                }
            } else {
                arrayElementType = AsmUtil.boxType(this.mapType(memberType, mode));
                if (signatureVisitor != null) {
                    signatureVisitor.writeArrayType();
                    this.mapType(memberType, signatureVisitor, mode.toGenericArgumentMode(memberProjection.getProjectionKind()));
                    signatureVisitor.writeArrayEnd();
                }
            }
            Type type4 = Type.getType("[" + arrayElementType.getDescriptor());
            if (type4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
            }
            return type4;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            Type asmType = mode.isForAnnotationParameter() && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2) ? AsmTypes.JAVA_CLASS_TYPE : this.computeAsmType((ClassDescriptor)descriptor2.getOriginal());
            this.writeGenericType(jetType, asmType, signatureVisitor, mode);
            Type type5 = asmType;
            if (type5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
            }
            return type5;
        }
        if (descriptor2 instanceof TypeParameterDescriptor) {
            Type type6 = this.mapType(KotlinTypeMapper.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor2), mode);
            if (signatureVisitor != null) {
                signatureVisitor.writeTypeVariable(descriptor2.getName(), type6);
            }
            Type type7 = type6;
            if (type7 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
            }
            return type7;
        }
        throw new UnsupportedOperationException("Unknown type " + jetType);
    }

    @NotNull
    private static KotlinType getRepresentativeUpperBound(@NotNull TypeParameterDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getRepresentativeUpperBound"));
        }
        List<KotlinType> upperBounds = descriptor2.getUpperBounds();
        assert (!upperBounds.isEmpty()) : "Upper bounds should not be empty: " + descriptor2;
        for (KotlinType upperBound : upperBounds) {
            if (JvmCodegenUtil.isJvmInterface(upperBound)) continue;
            KotlinType kotlinType = upperBound;
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getRepresentativeUpperBound"));
            }
            return kotlinType;
        }
        KotlinType kotlinType = CollectionsKt.first(upperBounds);
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getRepresentativeUpperBound"));
        }
        return kotlinType;
    }

    @Nullable
    private static Type mapBuiltinType(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapBuiltinType"));
        }
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return null;
        }
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(descriptor2);
        PrimitiveType primitiveType = KotlinBuiltIns.getPrimitiveTypeByFqName(fqName2);
        if (primitiveType != null) {
            Type asmType = Type.getType(JvmPrimitiveType.get(primitiveType).getDesc());
            boolean isNullableInJava = TypeUtils.isNullableType(type2) || TypeEnhancementKt.hasEnhancedNullability(type2);
            return isNullableInJava ? AsmUtil.boxType(asmType) : asmType;
        }
        PrimitiveType arrayElementType = KotlinBuiltIns.getPrimitiveTypeByArrayClassFqName(fqName2);
        if (arrayElementType != null) {
            return Type.getType("[" + JvmPrimitiveType.get(arrayElementType).getDesc());
        }
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqName2);
        if (classId != null) {
            return Type.getObjectType(JvmClassName.byClassId(classId).getInternalName());
        }
        return null;
    }

    @NotNull
    private Type computeAsmType(@NotNull ClassDescriptor klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "computeAsmType"));
        }
        Type alreadyComputedType = this.bindingContext.get(CodegenBinding.ASM_TYPE, klass);
        if (alreadyComputedType != null) {
            Type type2 = alreadyComputedType;
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "computeAsmType"));
            }
            return type2;
        }
        Type asmType = Type.getObjectType(this.computeAsmTypeImpl(klass));
        assert (PsiCodegenPredictor.checkPredictedNameFromPsi(klass, asmType, this.fileClassesProvider));
        Type type3 = asmType;
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "computeAsmType"));
        }
        return type3;
    }

    @NotNull
    private String computeAsmTypeImpl(@NotNull ClassDescriptor klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "computeAsmTypeImpl"));
        }
        DeclarationDescriptor container2 = klass.getContainingDeclaration();
        String name = SpecialNames.safeIdentifier(klass.getName()).getIdentifier();
        if (container2 instanceof PackageFragmentDescriptor) {
            FqName fqName2 = ((PackageFragmentDescriptor)container2).getFqName();
            String string = fqName2.isRoot() ? name : fqName2.asString().replace('.', '/') + '/' + name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "computeAsmTypeImpl"));
            }
            return string;
        }
        assert (container2 instanceof ClassDescriptor) : "Unexpected container: " + container2 + " for " + klass;
        String containerInternalName = this.computeAsmTypeImpl((ClassDescriptor)container2);
        String string = klass.getKind() == ClassKind.ENUM_ENTRY ? containerInternalName : containerInternalName + "$" + name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "computeAsmTypeImpl"));
        }
        return string;
    }

    @NotNull
    public Type mapDefaultImpls(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapDefaultImpls"));
        }
        Type type2 = Type.getObjectType(this.mapType(descriptor2).getInternalName() + "$DefaultImpls");
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapDefaultImpls"));
        }
        return type2;
    }

    @NotNull
    private static String generateErrorMessageForErrorType(@NotNull KotlinType type2, @NotNull DeclarationDescriptor descriptor2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "generateErrorMessageForErrorType"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "generateErrorMessageForErrorType"));
        }
        PsiElement declarationElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (declarationElement == null) {
            String message = "Error type encountered: %s (%s).";
            if (FlexibleTypesKt.upperIfFlexible(type2) instanceof DeserializedType) {
                message = message + " One of the possible reasons may be that this type is not directly accessible from this module. To workaround this error, try adding an explicit dependency on the module or library which contains this type to the classpath";
            }
            String string = String.format(message, type2, type2.getClass().getSimpleName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "generateErrorMessageForErrorType"));
            }
            return string;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        PsiElement parentDeclarationElement = containingDeclaration != null ? DescriptorToSourceUtils.descriptorToDeclaration(containingDeclaration) : null;
        String string = String.format("Error type encountered: %s (%s). Descriptor: %s. For declaration %s:%s in %s:%s", type2, type2.getClass().getSimpleName(), descriptor2, declarationElement, declarationElement.getText(), parentDeclarationElement, parentDeclarationElement != null ? parentDeclarationElement.getText() : "null");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "generateErrorMessageForErrorType"));
        }
        return string;
    }

    private void writeGenericType(@NotNull KotlinType type2, @NotNull Type asmType, @Nullable JvmSignatureWriter signatureVisitor, @NotNull TypeMappingMode mode) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericType"));
        }
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericType"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericType"));
        }
        if (signatureVisitor != null) {
            if (signatureVisitor.skipGenericSignature() || KotlinTypeMapper.hasNothingInNonContravariantPosition(type2) || type2.getArguments().isEmpty()) {
                signatureVisitor.writeAsmType(asmType);
                return;
            }
            PossiblyInnerType possiblyInnerType = TypeParameterUtilsKt.buildPossiblyInnerType(type2);
            assert (possiblyInnerType != null) : "possiblyInnerType with arguments should not be null";
            List<PossiblyInnerType> innerTypesAsList = possiblyInnerType.segments();
            PossiblyInnerType outermostInnerType = innerTypesAsList.get(0);
            ClassDescriptor outermostClass = outermostInnerType.getClassDescriptor();
            if (innerTypesAsList.size() == 1) {
                signatureVisitor.writeClassBegin(asmType);
            } else {
                signatureVisitor.writeOuterClassBegin(asmType, this.mapType(outermostClass.getDefaultType()).getInternalName());
            }
            this.writeGenericArguments(signatureVisitor, outermostInnerType.getArguments(), outermostClass.getDeclaredTypeParameters(), mode);
            for (PossiblyInnerType innerPart : innerTypesAsList.subList(1, innerTypesAsList.size())) {
                ClassDescriptor classDescriptor = innerPart.getClassDescriptor();
                signatureVisitor.writeInnerClass(KotlinTypeMapper.getJvmShortName(classDescriptor));
                this.writeGenericArguments(signatureVisitor, innerPart.getArguments(), classDescriptor.getDeclaredTypeParameters(), mode);
            }
            signatureVisitor.writeClassEnd();
        }
    }

    @Nullable
    private static String getJvmShortName(@NotNull ClassDescriptor klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getJvmShortName"));
        }
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(DescriptorUtils.getFqName(klass));
        if (classId != null) {
            return classId.getShortClassName().asString();
        }
        return SpecialNames.safeIdentifier(klass.getName()).getIdentifier();
    }

    private void writeGenericArguments(@NotNull JvmSignatureWriter signatureVisitor, @NotNull List<? extends TypeProjection> arguments2, @NotNull List<? extends TypeParameterDescriptor> parameters2, @NotNull TypeMappingMode mode) {
        if (signatureVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureVisitor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericArguments"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericArguments"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericArguments"));
        }
        for (Pair<? extends TypeParameterDescriptor, ? extends TypeProjection> item : CollectionsKt.zip(parameters2, arguments2)) {
            TypeParameterDescriptor parameter = item.getFirst();
            TypeProjection argument = item.getSecond();
            if (argument.isStarProjection() || KotlinBuiltIns.isNothing(argument.getType()) && parameter.getVariance() == Variance.IN_VARIANCE) {
                signatureVisitor.writeUnboundedWildcard();
                continue;
            }
            TypeMappingMode argumentMode = TypeMappingUtil.updateArgumentModeFromAnnotations(mode, argument.getType());
            Variance projectionKind = KotlinTypeMapper.getVarianceForWildcard(parameter, argument, argumentMode);
            signatureVisitor.writeTypeArgument(projectionKind);
            this.mapType(argument.getType(), signatureVisitor, argumentMode.toGenericArgumentMode(TypeMappingUtil.getEffectiveVariance(parameter.getVariance(), argument.getProjectionKind())));
            signatureVisitor.writeTypeArgumentEnd();
        }
    }

    private static boolean hasNothingInNonContravariantPosition(KotlinType kotlinType) {
        List<TypeParameterDescriptor> parameters2 = kotlinType.getConstructor().getParameters();
        List<TypeProjection> arguments2 = kotlinType.getArguments();
        for (int i = 0; i < arguments2.size(); ++i) {
            KotlinType type2;
            TypeProjection projection = arguments2.get(i);
            if (projection.isStarProjection() || !KotlinBuiltIns.isNullableNothing(type2 = projection.getType()) && (!KotlinBuiltIns.isNothing(type2) || parameters2.get(i).getVariance() == Variance.IN_VARIANCE)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Variance getVarianceForWildcard(@NotNull TypeParameterDescriptor parameter, @NotNull TypeProjection projection, @NotNull TypeMappingMode mode) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
        }
        if (projection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projection", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
        }
        Variance projectionKind = projection.getProjectionKind();
        Variance parameterVariance = parameter.getVariance();
        if (parameterVariance == Variance.INVARIANT) {
            Variance variance = projectionKind;
            if (variance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
            }
            return variance;
        }
        if (mode.getSkipDeclarationSiteWildcards()) {
            Variance variance = Variance.INVARIANT;
            if (variance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
            }
            return variance;
        }
        if (projectionKind == Variance.INVARIANT || projectionKind == parameterVariance) {
            if (mode.getSkipDeclarationSiteWildcardsIfPossible() && !projection.isStarProjection()) {
                if (parameterVariance == Variance.OUT_VARIANCE && TypeMappingUtil.isMostPreciseCovariantArgument(projection.getType())) {
                    Variance variance = Variance.INVARIANT;
                    if (variance == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
                    }
                    return variance;
                }
                if (parameterVariance == Variance.IN_VARIANCE && TypeMappingUtil.isMostPreciseContravariantArgument(projection.getType(), parameter)) {
                    Variance variance = Variance.INVARIANT;
                    if (variance == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
                    }
                    return variance;
                }
            }
            Variance variance = parameterVariance;
            if (variance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
            }
            return variance;
        }
        Variance variance = Variance.OUT_VARIANCE;
        if (variance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
        }
        return variance;
    }

    @NotNull
    public CallableMethod mapToCallableMethod(@NotNull FunctionDescriptor descriptor2, boolean superCall) {
        Type owner;
        JvmMethodSignature signature;
        int invokeOpcode;
        Type thisClass;
        Type ownerForDefaultImpl;
        FunctionDescriptor baseMethodDescriptor;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapToCallableMethod"));
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            JvmMethodSignature method = this.mapSignatureSkipGeneric(descriptor2);
            Type owner2 = this.mapClass(((ConstructorDescriptor)descriptor2).getContainingDeclaration());
            String defaultImplDesc = this.mapDefaultMethod(descriptor2, OwnerKind.IMPLEMENTATION).getDescriptor();
            CallableMethod callableMethod = new CallableMethod(owner2, owner2, defaultImplDesc, method, 183, null, null, null);
            if (callableMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapToCallableMethod"));
            }
            return callableMethod;
        }
        DeclarationDescriptor functionParent = descriptor2.getOriginal().getContainingDeclaration();
        FunctionDescriptor functionDescriptor = DescriptorUtils.unwrapFakeOverride(descriptor2.getOriginal());
        if (functionParent instanceof ClassDescriptor) {
            FunctionDescriptor declarationFunctionDescriptor = KotlinTypeMapper.findAnyDeclaration(functionDescriptor);
            ClassDescriptor currentOwner = (ClassDescriptor)functionParent;
            ClassDescriptor declarationOwner = (ClassDescriptor)declarationFunctionDescriptor.getContainingDeclaration();
            boolean originalIsInterface = JvmCodegenUtil.isJvmInterface(declarationOwner);
            boolean currentIsInterface = JvmCodegenUtil.isJvmInterface(currentOwner);
            boolean isInterface = currentIsInterface && originalIsInterface;
            baseMethodDescriptor = KotlinTypeMapper.findBaseDeclaration(functionDescriptor).getOriginal();
            ClassDescriptor ownerForDefault = (ClassDescriptor)baseMethodDescriptor.getContainingDeclaration();
            Type type2 = ownerForDefaultImpl = JvmCodegenUtil.isJvmInterface(ownerForDefault) ? this.mapDefaultImpls(ownerForDefault) : this.mapClass(ownerForDefault);
            if (isInterface && (superCall || descriptor2.getVisibility() == Visibilities.PRIVATE || KotlinTypeMapper.isAccessor(descriptor2))) {
                thisClass = this.mapClass(currentOwner);
                if (declarationOwner instanceof JavaClassDescriptor) {
                    invokeOpcode = 183;
                    signature = this.mapSignatureSkipGeneric(functionDescriptor);
                    owner = thisClass;
                } else {
                    invokeOpcode = 184;
                    signature = this.mapSignatureSkipGeneric(descriptor2.getOriginal(), OwnerKind.DEFAULT_IMPLS);
                    owner = this.mapDefaultImpls(currentOwner);
                }
            } else {
                boolean isStaticInvocation;
                boolean bl = isStaticInvocation = DescriptorUtils.isStaticDeclaration(functionDescriptor) && !(functionDescriptor instanceof ImportedFromObjectCallableDescriptor) || KotlinTypeMapper.isStaticAccessor(functionDescriptor) || AnnotationUtilKt.isPlatformStaticInObjectOrClass(functionDescriptor);
                if (isStaticInvocation) {
                    invokeOpcode = 184;
                } else if (isInterface) {
                    invokeOpcode = 185;
                } else {
                    boolean isPrivateFunInvocation = Visibilities.isPrivate(functionDescriptor.getVisibility());
                    invokeOpcode = superCall || isPrivateFunInvocation ? 183 : 182;
                }
                FunctionDescriptor overriddenSpecialBuiltinFunction = SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(functionDescriptor.getOriginal());
                FunctionDescriptor functionToCall = overriddenSpecialBuiltinFunction != null && !superCall ? overriddenSpecialBuiltinFunction.getOriginal() : functionDescriptor.getOriginal();
                signature = this.mapSignatureSkipGeneric(functionToCall);
                ClassDescriptor receiver = currentIsInterface && !originalIsInterface || currentOwner instanceof FunctionClassDescriptor ? declarationOwner : currentOwner;
                thisClass = owner = this.mapClass(receiver);
            }
        } else {
            signature = this.mapSignatureSkipGeneric(functionDescriptor.getOriginal());
            ownerForDefaultImpl = owner = this.mapOwner(functionDescriptor);
            baseMethodDescriptor = functionDescriptor;
            if (functionParent instanceof PackageFragmentDescriptor) {
                invokeOpcode = 184;
                thisClass = null;
            } else if (functionDescriptor instanceof ConstructorDescriptor) {
                invokeOpcode = 183;
                thisClass = null;
            } else {
                invokeOpcode = 182;
                thisClass = owner;
            }
        }
        Type calleeType = ExpressionTypingUtils.isLocalFunction(functionDescriptor) ? owner : null;
        ReceiverParameterDescriptor receiverParameter = functionDescriptor.getOriginal().getExtensionReceiverParameter();
        Type receiverParameterType = receiverParameter != null ? this.mapType(receiverParameter.getType()) : null;
        String defaultImplDesc = this.mapDefaultMethod(baseMethodDescriptor, KotlinTypeMapper.getKindForDefaultImplCall(baseMethodDescriptor)).getDescriptor();
        CallableMethod callableMethod = new CallableMethod(owner, ownerForDefaultImpl, defaultImplDesc, signature, invokeOpcode, thisClass, receiverParameterType, calleeType);
        if (callableMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapToCallableMethod"));
        }
        return callableMethod;
    }

    public static boolean isAccessor(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "isAccessor"));
        }
        return descriptor2 instanceof AccessorForCallableDescriptor;
    }

    public static boolean isStaticAccessor(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "isStaticAccessor"));
        }
        if (descriptor2 instanceof AccessorForConstructorDescriptor) {
            return false;
        }
        return KotlinTypeMapper.isAccessor(descriptor2);
    }

    @NotNull
    private static FunctionDescriptor findAnyDeclaration(@NotNull FunctionDescriptor function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "findAnyDeclaration"));
        }
        if (function.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            FunctionDescriptor functionDescriptor = function;
            if (functionDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "findAnyDeclaration"));
            }
            return functionDescriptor;
        }
        FunctionDescriptor functionDescriptor = KotlinTypeMapper.findBaseDeclaration(function);
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "findAnyDeclaration"));
        }
        return functionDescriptor;
    }

    @NotNull
    private static FunctionDescriptor findBaseDeclaration(@NotNull FunctionDescriptor function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "findBaseDeclaration"));
        }
        if (function.getOverriddenDescriptors().isEmpty()) {
            FunctionDescriptor functionDescriptor = function;
            if (functionDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "findBaseDeclaration"));
            }
            return functionDescriptor;
        }
        FunctionDescriptor functionDescriptor = KotlinTypeMapper.findBaseDeclaration(function.getOverriddenDescriptors().iterator().next());
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "findBaseDeclaration"));
        }
        return functionDescriptor;
    }

    @NotNull
    private String mapFunctionName(@NotNull FunctionDescriptor descriptor2) {
        String platformName;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
        }
        if (!(descriptor2 instanceof JavaCallableMemberDescriptor) && (platformName = DescriptorUtils.getJvmName(descriptor2)) != null) {
            String string = platformName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        String nameForSpecialFunction = SpecialBuiltinMembers.getJvmMethodNameIfSpecial(descriptor2);
        if (nameForSpecialFunction != null) {
            String string = nameForSpecialFunction;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor property = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
            if (DescriptorUtils.isAnnotationClass(property.getContainingDeclaration())) {
                String string = property.getName().asString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
                }
                return string;
            }
            boolean isAccessor = property instanceof AccessorForPropertyDescriptor;
            String propertyName = isAccessor ? ((AccessorForPropertyDescriptor)property).getAccessorSuffix() : property.getName().asString();
            String accessorName = descriptor2 instanceof PropertyGetterDescriptor ? JvmAbi.getterName(propertyName) : JvmAbi.setterName(propertyName);
            String string = this.mangleMemberNameIfRequired(isAccessor ? "access$" + accessorName : accessorName, descriptor2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        if (ExpressionTypingUtils.isFunctionLiteral(descriptor2)) {
            SamType samType;
            PsiElement expression;
            PsiElement element = DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2);
            if (element instanceof KtFunctionLiteral && (expression = element.getParent()) instanceof KtLambdaExpression && (samType = this.bindingContext.get(CodegenBinding.SAM_VALUE, (KtExpression)expression)) != null) {
                String string = samType.getAbstractMethod().getName().asString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
                }
                return string;
            }
            String string = OperatorNameConventions.INVOKE.asString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        if (ExpressionTypingUtils.isLocalFunction(descriptor2) || ExpressionTypingUtils.isFunctionExpression(descriptor2)) {
            String string = OperatorNameConventions.INVOKE.asString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        String string = this.mangleMemberNameIfRequired(descriptor2.getName().asString(), descriptor2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
        }
        return string;
    }

    @NotNull
    private static OwnerKind getKindForDefaultImplCall(@NotNull FunctionDescriptor baseMethodDescriptor) {
        if (baseMethodDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseMethodDescriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getKindForDefaultImplCall"));
        }
        DeclarationDescriptor containingDeclaration = baseMethodDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            OwnerKind ownerKind = OwnerKind.PACKAGE;
            if (ownerKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getKindForDefaultImplCall"));
            }
            return ownerKind;
        }
        if (DescriptorUtils.isInterface(containingDeclaration)) {
            OwnerKind ownerKind = OwnerKind.DEFAULT_IMPLS;
            if (ownerKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getKindForDefaultImplCall"));
            }
            return ownerKind;
        }
        OwnerKind ownerKind = OwnerKind.IMPLEMENTATION;
        if (ownerKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getKindForDefaultImplCall"));
        }
        return ownerKind;
    }

    @NotNull
    public static String mapDefaultFieldName(@NotNull PropertyDescriptor propertyDescriptor, boolean isDelegated) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapDefaultFieldName"));
        }
        String name = propertyDescriptor instanceof AccessorForPropertyDescriptor ? ((AccessorForPropertyDescriptor)propertyDescriptor).getCalleeDescriptor().getName().asString() : propertyDescriptor.getName().asString();
        String string = isDelegated ? name + "$delegate" : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapDefaultFieldName"));
        }
        return string;
    }

    @NotNull
    private String mangleMemberNameIfRequired(@NotNull String name, @NotNull CallableMemberDescriptor descriptor2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mangleMemberNameIfRequired"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mangleMemberNameIfRequired"));
        }
        if (descriptor2.getContainingDeclaration() instanceof ScriptDescriptor) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mangleMemberNameIfRequired"));
            }
            return string;
        }
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            if (Visibilities.isPrivate(descriptor2.getVisibility()) && !(descriptor2 instanceof ConstructorDescriptor) && !"<clinit>".equals(name)) {
                KtFile containingFile = DescriptorToSourceUtils.getContainingFile(descriptor2);
                assert (containingFile != null) : "Private descriptor accessed outside of corresponding file scope: " + descriptor2;
                JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(containingFile);
                if (fileClassInfo.getWithJvmMultifileClass()) {
                    String string = name + "$" + fileClassInfo.getFileClassFqName().shortName().asString();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mangleMemberNameIfRequired"));
                    }
                    return string;
                }
            }
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mangleMemberNameIfRequired"));
            }
            return string;
        }
        if (!(descriptor2 instanceof ConstructorDescriptor) && descriptor2.getVisibility() == Visibilities.INTERNAL) {
            String string = name + "$" + JvmAbi.sanitizeAsJavaIdentifier(this.moduleName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mangleMemberNameIfRequired"));
            }
            return string;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mangleMemberNameIfRequired"));
        }
        return string;
    }

    @NotNull
    public Method mapAsmMethod(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapAsmMethod"));
        }
        Method method = this.mapSignature(descriptor2, true).getAsmMethod();
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapAsmMethod"));
        }
        return method;
    }

    @NotNull
    public Method mapAsmMethod(@NotNull FunctionDescriptor descriptor2, @NotNull OwnerKind kind) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapAsmMethod"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapAsmMethod"));
        }
        Method method = this.mapSignature(descriptor2, kind, true).getAsmMethod();
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapAsmMethod"));
        }
        return method;
    }

    @NotNull
    private JvmMethodGenericSignature mapSignature(@NotNull FunctionDescriptor f, boolean skipGenericSignature) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        JvmMethodGenericSignature jvmMethodGenericSignature = this.mapSignature(f, OwnerKind.IMPLEMENTATION, skipGenericSignature);
        if (jvmMethodGenericSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        return jvmMethodGenericSignature;
    }

    @NotNull
    public JvmMethodSignature mapSignatureSkipGeneric(@NotNull FunctionDescriptor f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignatureSkipGeneric"));
        }
        JvmMethodSignature jvmMethodSignature = this.mapSignatureSkipGeneric(f, OwnerKind.IMPLEMENTATION);
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignatureSkipGeneric"));
        }
        return jvmMethodSignature;
    }

    @NotNull
    public JvmMethodSignature mapSignatureSkipGeneric(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignatureSkipGeneric"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignatureSkipGeneric"));
        }
        JvmMethodGenericSignature jvmMethodGenericSignature = this.mapSignature(f, kind, true);
        if (jvmMethodGenericSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignatureSkipGeneric"));
        }
        return jvmMethodGenericSignature;
    }

    @NotNull
    public JvmMethodGenericSignature mapSignatureWithGeneric(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignatureWithGeneric"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignatureWithGeneric"));
        }
        JvmMethodGenericSignature jvmMethodGenericSignature = this.mapSignature(f, kind, false);
        if (jvmMethodGenericSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignatureWithGeneric"));
        }
        return jvmMethodGenericSignature;
    }

    @NotNull
    private JvmMethodGenericSignature mapSignature(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind, boolean skipGenericSignature) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        if (f.getInitialSignatureDescriptor() != null && f != f.getInitialSignatureDescriptor() && (SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(f) == null || f.getContainingDeclaration().getOriginal() instanceof JavaClassDescriptor)) {
            JvmMethodGenericSignature jvmMethodGenericSignature = this.mapSignature(f.getInitialSignatureDescriptor(), kind, skipGenericSignature);
            if (jvmMethodGenericSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
            }
            return jvmMethodGenericSignature;
        }
        if (f instanceof ConstructorDescriptor) {
            JvmMethodGenericSignature jvmMethodGenericSignature = this.mapSignature(f, kind, f.getOriginal().getValueParameters(), skipGenericSignature);
            if (jvmMethodGenericSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
            }
            return jvmMethodGenericSignature;
        }
        JvmMethodGenericSignature jvmMethodGenericSignature = this.mapSignature(f, kind, f.getValueParameters(), skipGenericSignature);
        if (jvmMethodGenericSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        return jvmMethodGenericSignature;
    }

    @NotNull
    public JvmMethodGenericSignature mapSignature(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind, @NotNull List<ValueParameterDescriptor> valueParameters, boolean skipGenericSignature) {
        BuiltinMethodsWithSpecialGenericSignature.SpecialSignatureInfo specialSignatureInfo;
        JvmSignatureWriter sw;
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        if (f instanceof FunctionImportedFromObject) {
            JvmMethodGenericSignature jvmMethodGenericSignature = this.mapSignature((FunctionDescriptor)((FunctionImportedFromObject)f).getCallableFromObject(), kind, skipGenericSignature);
            if (jvmMethodGenericSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
            }
            return jvmMethodGenericSignature;
        }
        this.checkOwnerCompatibility(f);
        JvmSignatureWriter jvmSignatureWriter = sw = skipGenericSignature || f instanceof AccessorForCallableDescriptor ? new JvmSignatureWriter() : new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        if (f instanceof ConstructorDescriptor) {
            sw.writeParametersStart();
            this.writeAdditionalConstructorParameters((ConstructorDescriptor)f, sw);
            for (ValueParameterDescriptor parameter : valueParameters) {
                this.writeParameter(sw, parameter.getType(), f);
            }
            if (f instanceof AccessorForConstructorDescriptor) {
                KotlinTypeMapper.writeParameter(sw, JvmMethodParameterKind.CONSTRUCTOR_MARKER, AsmTypes.DEFAULT_CONSTRUCTOR_MARKER);
            }
            KotlinTypeMapper.writeVoidReturn(sw);
        } else {
            ReceiverParameterDescriptor receiverParameter;
            CallableMemberDescriptor directMember = JvmCodegenUtil.getDirectMember(f);
            KotlinType thisIfNeeded = null;
            if (OwnerKind.DEFAULT_IMPLS == kind) {
                ReceiverTypeAndTypeParameters receiverTypeAndTypeParameters = TypeMapperUtilsKt.patchTypeParametersForDefaultImplMethod(directMember);
                this.writeFormalTypeParameters(CollectionsKt.plus(receiverTypeAndTypeParameters.getTypeParameters(), directMember.getTypeParameters()), sw);
                thisIfNeeded = receiverTypeAndTypeParameters.getReceiverType();
            } else {
                this.writeFormalTypeParameters(directMember.getTypeParameters(), sw);
                if (KotlinTypeMapper.isAccessor(f) && f.getDispatchReceiverParameter() != null) {
                    thisIfNeeded = ((ClassDescriptor)f.getContainingDeclaration()).getDefaultType();
                }
            }
            sw.writeParametersStart();
            if (thisIfNeeded != null) {
                this.writeParameter(sw, JvmMethodParameterKind.THIS, thisIfNeeded, f);
            }
            if ((receiverParameter = f.getExtensionReceiverParameter()) != null) {
                this.writeParameter(sw, JvmMethodParameterKind.RECEIVER, receiverParameter.getType(), f);
            }
            for (ValueParameterDescriptor parameter : valueParameters) {
                if (this.writeCustomParameter(f, parameter, sw)) continue;
                this.writeParameter(sw, parameter.getType(), f);
            }
            sw.writeReturnType();
            this.mapReturnType(f, sw);
            sw.writeReturnTypeEnd();
        }
        JvmMethodGenericSignature signature = sw.makeJvmMethodSignature(this.mapFunctionName(f));
        if (kind != OwnerKind.DEFAULT_IMPLS && (specialSignatureInfo = BuiltinMethodsWithSpecialGenericSignature.getSpecialSignatureInfo(f)) != null) {
            String newGenericSignature = CodegenUtilKt.replaceValueParametersIn(specialSignatureInfo, signature.getGenericsSignature());
            JvmMethodGenericSignature jvmMethodGenericSignature = new JvmMethodGenericSignature(signature.getAsmMethod(), signature.getValueParameters(), newGenericSignature);
            if (jvmMethodGenericSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
            }
            return jvmMethodGenericSignature;
        }
        JvmMethodGenericSignature jvmMethodGenericSignature = signature;
        if (jvmMethodGenericSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        return jvmMethodGenericSignature;
    }

    private void checkOwnerCompatibility(@NotNull FunctionDescriptor descriptor2) {
        JvmBytecodeBinaryVersion version;
        SourceElement source;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "checkOwnerCompatibility"));
        }
        if (!(descriptor2 instanceof DeserializedCallableMemberDescriptor)) {
            return;
        }
        KotlinJvmBinaryClass ownerClass = null;
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (container2 instanceof DeserializedClassDescriptor) {
            source = ((DeserializedClassDescriptor)container2).getSource();
            if (source instanceof KotlinJvmBinarySourceElement) {
                ownerClass = ((KotlinJvmBinarySourceElement)source).getBinaryClass();
            }
        } else if (container2 instanceof LazyJavaPackageFragment && (source = ((LazyJavaPackageFragment)container2).getSource()) instanceof KotlinJvmBinaryPackageSourceElement) {
            ownerClass = ((KotlinJvmBinaryPackageSourceElement)source).getRepresentativeBinaryClass();
        }
        if (ownerClass != null && !(version = ownerClass.getClassHeader().getBytecodeVersion()).isCompatible()) {
            this.incompatibleClassTracker.record(ownerClass);
        }
    }

    private boolean writeCustomParameter(@NotNull FunctionDescriptor f, @NotNull ValueParameterDescriptor parameter, @NotNull JvmSignatureWriter sw) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeCustomParameter"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeCustomParameter"));
        }
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeCustomParameter"));
        }
        FunctionDescriptor overridden = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava(f);
        if (overridden == null) {
            return false;
        }
        if (SpecialBuiltinMembers.isFromJavaOrBuiltins(f)) {
            return false;
        }
        if (overridden.getName().asString().equals("remove") && this.mapType(parameter.getType()).getSort() == 5) {
            this.writeParameter(sw, TypeUtils.makeNullable(parameter.getType()), f);
            return true;
        }
        return false;
    }

    @NotNull
    private static String getDefaultDescriptor(@NotNull Method method, @Nullable String dispatchReceiverDescriptor, boolean isExtension) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getDefaultDescriptor"));
        }
        String descriptor2 = method.getDescriptor();
        int argumentsCount = Type.getArgumentTypes(descriptor2).length;
        if (isExtension) {
            --argumentsCount;
        }
        int maskArgumentsCount = (argumentsCount + 32 - 1) / 32;
        String additionalArgs = StringUtil.repeat(Type.INT_TYPE.getDescriptor(), maskArgumentsCount);
        additionalArgs = additionalArgs + (KotlinTypeMapper.isConstructor(method) ? AsmTypes.DEFAULT_CONSTRUCTOR_MARKER : AsmTypes.OBJECT_TYPE).getDescriptor();
        String result2 = descriptor2.replace(")", additionalArgs + ")");
        if (dispatchReceiverDescriptor != null && !KotlinTypeMapper.isConstructor(method)) {
            String string = result2.replace("(", "(" + dispatchReceiverDescriptor);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getDefaultDescriptor"));
            }
            return string;
        }
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getDefaultDescriptor"));
        }
        return string;
    }

    public ClassBuilderMode getClassBuilderMode() {
        return this.classBuilderMode;
    }

    private static boolean isConstructor(@NotNull Method method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "isConstructor"));
        }
        return "<init>".equals(method.getName());
    }

    @NotNull
    public Method mapDefaultMethod(@NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind kind) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapDefaultMethod"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapDefaultMethod"));
        }
        Method jvmSignature = this.mapAsmMethod(functionDescriptor, kind);
        Type ownerType = this.mapOwner(functionDescriptor);
        boolean isConstructor = KotlinTypeMapper.isConstructor(jvmSignature);
        String descriptor2 = KotlinTypeMapper.getDefaultDescriptor(jvmSignature, AsmUtil.isStaticMethod(kind, functionDescriptor) || isConstructor ? null : ownerType.getDescriptor(), functionDescriptor.getExtensionReceiverParameter() != null);
        Method method = new Method(isConstructor ? "<init>" : jvmSignature.getName() + "$default", descriptor2);
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapDefaultMethod"));
        }
        return method;
    }

    private static boolean forceBoxedReturnType(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "forceBoxedReturnType"));
        }
        if (!KotlinBuiltIns.isPrimitiveType(descriptor2.getReturnType())) {
            return false;
        }
        for (FunctionDescriptor overridden : DescriptorUtils.getAllOverriddenDescriptors(descriptor2)) {
            if (KotlinBuiltIns.isPrimitiveType(overridden.getOriginal().getReturnType())) continue;
            return true;
        }
        return false;
    }

    private static void writeVoidReturn(@NotNull JvmSignatureWriter sw) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeVoidReturn"));
        }
        sw.writeReturnType();
        sw.writeAsmType(Type.VOID_TYPE);
        sw.writeReturnTypeEnd();
    }

    @Nullable
    public String mapFieldSignature(@NotNull KotlinType backingFieldType, @NotNull PropertyDescriptor propertyDescriptor) {
        if (backingFieldType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backingFieldType", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFieldSignature"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFieldSignature"));
        }
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.TYPE);
        if (!propertyDescriptor.isVar()) {
            this.mapReturnType(propertyDescriptor, sw, backingFieldType);
        } else {
            this.writeParameterType(sw, backingFieldType, propertyDescriptor);
        }
        return ((JvmSignatureWriter)sw).makeJavaGenericSignature();
    }

    public void writeFormalTypeParameters(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull JvmSignatureWriter sw) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeFormalTypeParameters"));
        }
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeFormalTypeParameters"));
        }
        if (sw.skipGenericSignature()) {
            return;
        }
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            this.writeFormalTypeParameter(typeParameter, sw);
        }
    }

    private void writeFormalTypeParameter(@NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull JvmSignatureWriter sw) {
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeFormalTypeParameter"));
        }
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeFormalTypeParameter"));
        }
        if (this.classBuilderMode != ClassBuilderMode.FULL && typeParameterDescriptor.getName().isSpecial()) {
            return;
        }
        sw.writeFormalTypeParameter(typeParameterDescriptor.getName().asString());
        sw.writeClassBound();
        for (KotlinType jetType : typeParameterDescriptor.getUpperBounds()) {
            if (!(jetType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) || JvmCodegenUtil.isJvmInterface(jetType)) continue;
            this.mapType(jetType, sw, TypeMappingMode.GENERIC_ARGUMENT);
            break;
        }
        sw.writeClassBoundEnd();
        for (KotlinType jetType : typeParameterDescriptor.getUpperBounds()) {
            ClassifierDescriptor classifier2 = jetType.getConstructor().getDeclarationDescriptor();
            if (classifier2 instanceof ClassDescriptor) {
                if (!JvmCodegenUtil.isJvmInterface(jetType)) continue;
                sw.writeInterfaceBound();
                this.mapType(jetType, sw, TypeMappingMode.GENERIC_ARGUMENT);
                sw.writeInterfaceBoundEnd();
                continue;
            }
            if (classifier2 instanceof TypeParameterDescriptor) {
                sw.writeInterfaceBound();
                this.mapType(jetType, sw, TypeMappingMode.GENERIC_ARGUMENT);
                sw.writeInterfaceBoundEnd();
                continue;
            }
            throw new UnsupportedOperationException("Unknown classifier: " + classifier2);
        }
    }

    private void writeParameter(@NotNull JvmSignatureWriter sw, @NotNull KotlinType type2, @Nullable CallableDescriptor callableDescriptor) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameter"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameter"));
        }
        this.writeParameter(sw, JvmMethodParameterKind.VALUE, type2, callableDescriptor);
    }

    private void writeParameter(@NotNull JvmSignatureWriter sw, @NotNull JvmMethodParameterKind kind, @NotNull KotlinType type2, @Nullable CallableDescriptor callableDescriptor) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameter"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameter"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameter"));
        }
        sw.writeParameterType(kind);
        this.writeParameterType(sw, type2, callableDescriptor);
        sw.writeParameterTypeEnd();
    }

    private void writeParameterType(@NotNull JvmSignatureWriter sw, @NotNull KotlinType type2, @Nullable CallableDescriptor callableDescriptor) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameterType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameterType"));
        }
        if (sw.skipGenericSignature()) {
            this.mapType(type2, sw, TypeMappingMode.DEFAULT);
            return;
        }
        TypeMappingMode typeMappingModeFromAnnotation = TypeMappingUtil.extractTypeMappingModeFromAnnotation(callableDescriptor, type2, false);
        TypeMappingMode typeMappingMode = typeMappingModeFromAnnotation != null ? typeMappingModeFromAnnotation : (TypeMappingUtil.isMethodWithDeclarationSiteWildcards(callableDescriptor) && !type2.getArguments().isEmpty() ? TypeMappingMode.GENERIC_ARGUMENT : TypeMappingMode.getOptimalModeForValueParameter(type2));
        this.mapType(type2, sw, typeMappingMode);
    }

    private static void writeParameter(@NotNull JvmSignatureWriter sw, @NotNull JvmMethodParameterKind kind, @NotNull Type type2) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameter"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameter"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameter"));
        }
        sw.writeParameterType(kind);
        sw.writeAsmType(type2);
        sw.writeParameterTypeEnd();
    }

    private void writeAdditionalConstructorParameters(@NotNull ConstructorDescriptor descriptor2, @NotNull JvmSignatureWriter sw) {
        ClassDescriptor containingDeclaration;
        KotlinType captureReceiverType;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeAdditionalConstructorParameters"));
        }
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeAdditionalConstructorParameters"));
        }
        MutableClosure closure = this.bindingContext.get(CodegenBinding.CLOSURE, descriptor2.getContainingDeclaration());
        ClassDescriptor captureThis = JvmCodegenUtil.getDispatchReceiverParameterForConstructorCall(descriptor2, closure);
        if (captureThis != null) {
            this.writeParameter(sw, JvmMethodParameterKind.OUTER, captureThis.getDefaultType(), descriptor2);
        }
        KotlinType kotlinType = captureReceiverType = closure != null ? closure.getCaptureReceiverType() : null;
        if (captureReceiverType != null) {
            this.writeParameter(sw, JvmMethodParameterKind.RECEIVER, captureReceiverType, descriptor2);
        }
        if ((containingDeclaration = descriptor2.getContainingDeclaration()).getKind() == ClassKind.ENUM_CLASS || containingDeclaration.getKind() == ClassKind.ENUM_ENTRY) {
            this.writeParameter(sw, JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL, DescriptorUtilsKt.getBuiltIns(descriptor2).getStringType(), descriptor2);
            this.writeParameter(sw, JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL, DescriptorUtilsKt.getBuiltIns(descriptor2).getIntType(), descriptor2);
        }
        if (closure == null) {
            return;
        }
        for (DeclarationDescriptor variableDescriptor : closure.getCaptureVariables().keySet()) {
            Type type2;
            if (variableDescriptor instanceof VariableDescriptor && !(variableDescriptor instanceof PropertyDescriptor)) {
                Type sharedVarType = this.getSharedVarType(variableDescriptor);
                if (sharedVarType == null) {
                    sharedVarType = this.mapType(((VariableDescriptor)variableDescriptor).getType());
                }
                type2 = sharedVarType;
            } else {
                type2 = ExpressionTypingUtils.isLocalFunction(variableDescriptor) ? CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)variableDescriptor) : null;
            }
            if (type2 == null) continue;
            closure.setCapturedParameterOffsetInConstructor(variableDescriptor, sw.getCurrentSignatureSize() + 1);
            KotlinTypeMapper.writeParameter(sw, JvmMethodParameterKind.CAPTURED_LOCAL_VARIABLE, type2);
        }
        if (this.classBuilderMode == ClassBuilderMode.FULL) {
            ResolvedCall<ConstructorDescriptor> superCall = this.findFirstDelegatingSuperCall(descriptor2);
            if (superCall == null) {
                return;
            }
            this.writeSuperConstructorCallParameters(sw, descriptor2, superCall, captureThis != null);
        }
    }

    private void writeSuperConstructorCallParameters(@NotNull JvmSignatureWriter sw, @NotNull ConstructorDescriptor descriptor2, @NotNull ResolvedCall<ConstructorDescriptor> superCall, boolean hasOuter) {
        int i;
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeSuperConstructorCallParameters"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeSuperConstructorCallParameters"));
        }
        if (superCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superCall", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeSuperConstructorCallParameters"));
        }
        ConstructorDescriptor superDescriptor = (ConstructorDescriptor)SamCodegenUtil.resolveSamAdapter((FunctionDescriptor)superCall.getResultingDescriptor());
        List<ResolvedValueArgument> valueArguments2 = superCall.getValueArgumentsByIndex();
        assert (valueArguments2 != null) : "Failed to arrange value arguments by index: " + superDescriptor;
        List<JvmMethodParameterSignature> parameters2 = this.mapSignatureSkipGeneric(superDescriptor).getValueParameters();
        int params = parameters2.size();
        int args = valueArguments2.size();
        assert (params >= args) : String.format("Incorrect number of mapped parameters vs arguments: %d < %d for %s", params, args, descriptor2);
        for (i = 0; i < params - args; ++i) {
            JvmMethodParameterSignature parameter = parameters2.get(i);
            JvmMethodParameterKind kind = parameter.getKind();
            if (kind == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL || hasOuter && kind == JvmMethodParameterKind.OUTER) continue;
            KotlinTypeMapper.writeParameter(sw, JvmMethodParameterKind.SUPER_CALL_PARAM, parameter.getAsmType());
        }
        if (DescriptorUtils.isAnonymousObject(descriptor2.getContainingDeclaration())) {
            for (i = 0; i < args; ++i) {
                ResolvedValueArgument valueArgument = valueArguments2.get(i);
                JvmMethodParameterSignature parameter = parameters2.get(params - args + i);
                if (valueArgument instanceof DefaultValueArgument) continue;
                KotlinTypeMapper.writeParameter(sw, JvmMethodParameterKind.SUPER_CALL_PARAM, parameter.getAsmType());
            }
        }
    }

    @Nullable
    private ResolvedCall<ConstructorDescriptor> findFirstDelegatingSuperCall(@NotNull ConstructorDescriptor descriptor2) {
        ResolvedCall<ConstructorDescriptor> next;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "findFirstDelegatingSuperCall"));
        }
        ClassDescriptor classDescriptor = descriptor2.getContainingDeclaration();
        do {
            if ((next = BindingContextUtils.getDelegationConstructorCall(this.bindingContext, descriptor2)) != null) continue;
            return null;
        } while ((descriptor2 = next.getResultingDescriptor()).getContainingDeclaration() == classDescriptor);
        return next;
    }

    @NotNull
    public JvmMethodSignature mapScriptSignature(@NotNull ScriptDescriptor script, @NotNull List<ScriptDescriptor> importedScripts) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapScriptSignature"));
        }
        if (importedScripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedScripts", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapScriptSignature"));
        }
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        ((JvmSignatureWriter)sw).writeParametersStart();
        for (ScriptDescriptor importedScript : importedScripts) {
            this.writeParameter(sw, importedScript.getDefaultType(), null);
        }
        for (ValueParameterDescriptor valueParameter : script.getUnsubstitutedPrimaryConstructor().getValueParameters()) {
            this.writeParameter(sw, valueParameter.getType(), null);
        }
        KotlinTypeMapper.writeVoidReturn(sw);
        JvmMethodGenericSignature jvmMethodGenericSignature = sw.makeJvmMethodSignature("<init>");
        if (jvmMethodGenericSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapScriptSignature"));
        }
        return jvmMethodGenericSignature;
    }

    public Type getSharedVarType(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof SimpleFunctionDescriptor && descriptor2.getContainingDeclaration() instanceof FunctionDescriptor) {
            return CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor2);
        }
        if (descriptor2 instanceof PropertyDescriptor || descriptor2 instanceof FunctionDescriptor) {
            ReceiverParameterDescriptor receiverParameter = ((CallableDescriptor)descriptor2).getExtensionReceiverParameter();
            assert (receiverParameter != null) : "Callable should have a receiver parameter: " + descriptor2;
            return StackValue.sharedTypeForType(this.mapType(receiverParameter.getType()));
        }
        if (descriptor2 instanceof VariableDescriptor && BindingContextUtils.isVarCapturedInClosure(this.bindingContext, descriptor2)) {
            return StackValue.sharedTypeForType(this.mapType(((VariableDescriptor)descriptor2).getType()));
        }
        return null;
    }

    public static class ContainingClassesInfo {
        private final ClassId facadeClassId;
        private final ClassId implClassId;

        public ContainingClassesInfo(ClassId facadeClassId, ClassId implClassId) {
            this.facadeClassId = facadeClassId;
            this.implClassId = implClassId;
        }

        public ClassId getFacadeClassId() {
            return this.facadeClassId;
        }

        public ClassId getImplClassId() {
            return this.implClassId;
        }

        @Nullable
        private static ContainingClassesInfo forPackageMemberOrNull(@NotNull FqName packageFqName, @Nullable String facadeClassName, @Nullable String implClassName) {
            if (packageFqName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$ContainingClassesInfo", "forPackageMemberOrNull"));
            }
            if (facadeClassName == null || implClassName == null) {
                return null;
            }
            return new ContainingClassesInfo(ClassId.topLevel(packageFqName.child(Name.identifier(facadeClassName))), ClassId.topLevel(packageFqName.child(Name.identifier(implClassName))));
        }

        @Nullable
        private static ContainingClassesInfo forClassMemberOrNull(@Nullable ClassId classId) {
            if (classId == null) {
                return null;
            }
            return new ContainingClassesInfo(classId, classId);
        }
    }
}

