/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.FunctionTypeResolveUtilsKt;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010JH\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!H\u0002J6\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010 \u001a\u00020!2\u0006\u0010*\u001a\u00020+H\u0002J6\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020!2\u0006\u0010*\u001a\u00020+J0\u00100\u001a\u00020-2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u0002012\u0006\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020!2\u0006\u00102\u001a\u000203H\u0002Jd\u00104\u001a\u0002052*\u00106\u001a&\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020'072\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u0002012\u0006\u0010 \u001a\u00020!2\u0006\u00102\u001a\u0002032\u0006\u0010*\u001a\u00020+H\u0002J.\u00104\u001a\u0002052\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u0002012\u0006\u0010 \u001a\u00020!2\u0006\u00102\u001a\u000203J6\u0010<\u001a\u0002052\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u0002012\u0006\u0010 \u001a\u00020!2\u0006\u00102\u001a\u0002032\u0006\u0010*\u001a\u00020+J(\u0010=\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010>\u001a\u00020?2\u0006\u0010 \u001a\u00020!J&\u0010@\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010A\u001a\u00020B2\u0006\u0010 \u001a\u00020!JD\u0010C\u001a\b\u0012\u0004\u0012\u00020#0\u001e2\u0006\u0010&\u001a\u00020D2\u0006\u0010E\u001a\u00020)2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\u000e\u0010F\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001eH\u0002J\f\u0010G\u001a\u00020\u0018*\u00020+H\u0002J\u000e\u0010H\u001a\u0004\u0018\u00010+*\u00020+H\u0002J\u001c\u0010I\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001e*\u00020+2\u0006\u0010J\u001a\u00020DH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/resolve/FunctionDescriptorResolver;", "", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "(Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;)V", "createConstructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/ConstructorDescriptorImpl;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isPrimary", "", "modifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "declarationToTrace", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "valueParameters", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "createValueParameterDescriptors", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;", "innerScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "expectedFunctionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "initializeFunctionDescriptorAndExplicitReturnType", "", "containingDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "initializeFunctionReturnTypeBasedOnFunctionBody", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "resolveFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "functionConstructor", "Lkotlin/Function5;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor$Kind;", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "resolveFunctionExpressionDescriptor", "resolvePrimaryConstructorDescriptor", "classElement", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "resolveSecondaryConstructorDescriptor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "resolveValueParameters", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parameterScope", "expectedValueParameters", "functionTypeExpected", "getReceiverType", "getValueParameters", "owner", "kotlin-compiler"})
public final class FunctionDescriptorResolver {
    private final TypeResolver typeResolver;
    private final DescriptorResolver descriptorResolver;
    private final AnnotationResolver annotationResolver;
    private final StorageManager storageManager;
    private final ExpressionTypingServices expressionTypingServices;
    private final KotlinBuiltIns builtIns;
    private final ModifiersChecker modifiersChecker;

    @NotNull
    public final SimpleFunctionDescriptor resolveFunctionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope2, @NotNull KtNamedFunction function, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        Intrinsics.checkParameterIsNotNull(containingDescriptor, "containingDescriptor");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(dataFlowInfo, "dataFlowInfo");
        if (function.getName() == null) {
            trace.report(Errors.FUNCTION_DECLARATION_WITH_NO_NAME.on((KtFunction)((PsiElement)function)));
        }
        Function5 function5 = resolveFunctionDescriptor.1.INSTANCE;
        KotlinType kotlinType = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TypeUtils.NO_EXPECTED_TYPE");
        return this.resolveFunctionDescriptor(function5, containingDescriptor, scope2, function, trace, dataFlowInfo, kotlinType);
    }

    @NotNull
    public final SimpleFunctionDescriptor resolveFunctionExpressionDescriptor(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope2, @NotNull KtNamedFunction function, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull KotlinType expectedFunctionType) {
        Intrinsics.checkParameterIsNotNull(containingDescriptor, "containingDescriptor");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkParameterIsNotNull(expectedFunctionType, "expectedFunctionType");
        return this.resolveFunctionDescriptor(resolveFunctionExpressionDescriptor.1.INSTANCE, containingDescriptor, scope2, function, trace, dataFlowInfo, expectedFunctionType);
    }

    private final SimpleFunctionDescriptor resolveFunctionDescriptor(Function5<? super DeclarationDescriptor, ? super Annotations, ? super Name, ? super CallableMemberDescriptor.Kind, ? super SourceElement, ? extends SimpleFunctionDescriptorImpl> functionConstructor, DeclarationDescriptor containingDescriptor, LexicalScope scope2, KtNamedFunction function, BindingTrace trace, DataFlowInfo dataFlowInfo, KotlinType expectedFunctionType) {
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, function.getModifierList(), trace);
        Intrinsics.checkExpressionValueIsNotNull(annotations2, "annotationResolver.resol\u2026getModifierList(), trace)");
        Name name = function.getNameAsSafeName();
        Intrinsics.checkExpressionValueIsNotNull(name, "function.getNameAsSafeName()");
        SimpleFunctionDescriptorImpl functionDescriptor = functionConstructor.invoke(containingDescriptor, annotations2, name, CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(function));
        this.initializeFunctionDescriptorAndExplicitReturnType(containingDescriptor, scope2, function, functionDescriptor, trace, expectedFunctionType);
        this.initializeFunctionReturnTypeBasedOnFunctionBody(scope2, function, functionDescriptor, trace, dataFlowInfo);
        BindingContextUtils.recordFunctionDeclarationToDescriptor(trace, function, functionDescriptor);
        return functionDescriptor;
    }

    private final void initializeFunctionReturnTypeBasedOnFunctionBody(LexicalScope scope2, KtNamedFunction function, SimpleFunctionDescriptorImpl functionDescriptor, BindingTrace trace, DataFlowInfo dataFlowInfo) {
        KotlinType kotlinType;
        Unit unit;
        if (functionDescriptor.getReturnType() != null) {
            return;
        }
        boolean bl = function.getTypeReference() == null;
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "Return type must be initialized early for function: " + function.getText() + ", at: " + DiagnosticUtils.atLocation(function);
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        if (function.hasBlockBody()) {
            kotlinType = this.builtIns.getUnitType();
        } else if (function.hasBody()) {
            KotlinType kotlinType2 = DescriptorResolver.inferReturnTypeFromExpressionBody(this.storageManager, this.expressionTypingServices, trace, scope2, dataFlowInfo, function, functionDescriptor);
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "inferReturnTypeFromExpre\u2026tion, functionDescriptor)");
        } else {
            KotlinType kotlinType3 = ErrorUtils.createErrorType("No type, no body");
            kotlinType = kotlinType3;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "ErrorUtils.createErrorType(\"No type, no body\")");
        }
        KotlinType returnType = kotlinType;
        functionDescriptor.setReturnType(returnType);
    }

    public final void initializeFunctionDescriptorAndExplicitReturnType(@NotNull DeclarationDescriptor containingDescriptor, @NotNull LexicalScope scope2, @NotNull KtFunction function, @NotNull SimpleFunctionDescriptorImpl functionDescriptor, @NotNull BindingTrace trace, @NotNull KotlinType expectedFunctionType) {
        Unit unit;
        KotlinType kotlinType;
        Intrinsics.checkParameterIsNotNull(containingDescriptor, "containingDescriptor");
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(expectedFunctionType, "expectedFunctionType");
        LexicalWritableScope innerScope = new LexicalWritableScope(scope2, functionDescriptor, true, null, new TraceBasedLocalRedeclarationChecker(trace), LexicalScopeKind.FUNCTION_HEADER);
        List<TypeParameterDescriptorImpl> typeParameterDescriptors2 = this.descriptorResolver.resolveTypeParametersForCallableDescriptor(functionDescriptor, innerScope, scope2, function.getTypeParameters(), trace);
        this.descriptorResolver.resolveGenericBounds(function, functionDescriptor, innerScope, typeParameterDescriptors2, trace);
        KtTypeReference receiverTypeRef = function.getReceiverTypeReference();
        KotlinType receiverType = receiverTypeRef != null ? this.typeResolver.resolveType(innerScope, receiverTypeRef, trace, true) : this.getReceiverType(expectedFunctionType);
        List<ValueParameterDescriptor> valueParameterDescriptors = this.createValueParameterDescriptors(function, functionDescriptor, innerScope, trace, expectedFunctionType);
        innerScope.freeze();
        KtTypeReference ktTypeReference = function.getTypeReference();
        if (ktTypeReference != null) {
            KtTypeReference ktTypeReference2 = ktTypeReference;
            KtTypeReference it = ktTypeReference2;
            LexicalScope lexicalScope = innerScope;
            KtTypeReference ktTypeReference3 = it;
            Intrinsics.checkExpressionValueIsNotNull(ktTypeReference3, "it");
            kotlinType = this.typeResolver.resolveType(lexicalScope, ktTypeReference3, trace, true);
        } else {
            kotlinType = null;
        }
        KotlinType returnType = kotlinType;
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(function, DescriptorResolver.getDefaultVisibility(function, containingDescriptor));
        Modality modality = ModifiersChecker.resolveModalityFromModifiers(function, DescriptorResolver.getDefaultModality(containingDescriptor, visibility, function.hasBody()));
        functionDescriptor.initialize(receiverType, DescriptorUtils.getDispatchReceiverParameterIfNeeded(containingDescriptor), typeParameterDescriptors2, (List)valueParameterDescriptors, returnType, modality, visibility);
        functionDescriptor.setOperator(function.hasModifier(KtTokens.OPERATOR_KEYWORD));
        functionDescriptor.setInfix(function.hasModifier(KtTokens.INFIX_KEYWORD));
        functionDescriptor.setExternal(function.hasModifier(KtTokens.EXTERNAL_KEYWORD));
        functionDescriptor.setInline(function.hasModifier(KtTokens.INLINE_KEYWORD));
        functionDescriptor.setTailrec(function.hasModifier(KtTokens.TAILREC_KEYWORD));
        KotlinType kotlinType2 = receiverType;
        if (kotlinType2 != null) {
            KotlinType $i$a$1$let = kotlinType2;
            KotlinType it = $i$a$1$let;
            ForceResolveUtil.forceResolveAllContents(it.getAnnotations());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        for (ValueParameterDescriptor valueParameterDescriptor : valueParameterDescriptors) {
            ForceResolveUtil.forceResolveAllContents(valueParameterDescriptor.getType().getAnnotations());
        }
    }

    private final List<ValueParameterDescriptor> createValueParameterDescriptors(KtFunction function, SimpleFunctionDescriptorImpl functionDescriptor, LexicalWritableScope innerScope, BindingTrace trace, KotlinType expectedFunctionType) {
        List<ValueParameterDescriptor> expectedValueParameters = this.getValueParameters(expectedFunctionType, functionDescriptor);
        if (expectedValueParameters != null) {
            if (expectedValueParameters.size() == 1 && function instanceof KtFunctionLiteral && function.getValueParameterList() == null) {
                ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.first(expectedValueParameters);
                CallableDescriptor callableDescriptor = functionDescriptor;
                ValueParameterDescriptor valueParameterDescriptor2 = null;
                Annotations annotations2 = Annotations.Companion.getEMPTY();
                Name name = Name.identifier("it");
                Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(\"it\")");
                KotlinType kotlinType = valueParameterDescriptor.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "valueParameterDescriptor.type");
                boolean bl = valueParameterDescriptor.declaresDefaultValue();
                boolean bl2 = valueParameterDescriptor.isCrossinline();
                boolean bl3 = valueParameterDescriptor.isNoinline();
                KotlinType kotlinType2 = valueParameterDescriptor.getVarargElementType();
                SourceElement sourceElement = SourceElement.NO_SOURCE;
                Intrinsics.checkExpressionValueIsNotNull(sourceElement, "SourceElement.NO_SOURCE");
                ValueParameterDescriptorImpl it = new ValueParameterDescriptorImpl(callableDescriptor, valueParameterDescriptor2, 0, annotations2, name, kotlinType, bl, bl2, bl3, kotlinType2, sourceElement);
                trace.record(BindingContext.AUTO_CREATED_IT, it);
                return CollectionsKt.listOf(it);
            }
            if (function.getValueParameters().size() != expectedValueParameters.size()) {
                List<KotlinType> expectedParameterTypes = ExpressionTypingUtils.getValueParametersTypes(expectedValueParameters);
                trace.report(Errors.EXPECTED_PARAMETERS_NUMBER_MISMATCH.on((KtFunction)((PsiElement)function), expectedParameterTypes.size(), expectedParameterTypes));
            }
        }
        BindingContextUtilsKt.recordScope(trace, innerScope, function.getValueParameterList());
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        List<KtParameter> list2 = function.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "function.valueParameters");
        return this.resolveValueParameters(functionDescriptor2, innerScope, list2, trace, expectedValueParameters);
    }

    private final boolean functionTypeExpected(@NotNull KotlinType $receiver) {
        return !TypeUtils.noExpectedType($receiver) && FunctionTypesKt.isFunctionType($receiver);
    }

    private final KotlinType getReceiverType(@NotNull KotlinType $receiver) {
        return this.functionTypeExpected($receiver) ? FunctionTypesKt.getReceiverTypeFromFunctionType($receiver) : (KotlinType)null;
    }

    private final List<ValueParameterDescriptor> getValueParameters(@NotNull KotlinType $receiver, FunctionDescriptor owner) {
        return this.functionTypeExpected($receiver) ? FunctionTypeResolveUtilsKt.createValueParametersForInvokeInFunctionType(owner, FunctionTypesKt.getValueParameterTypesFromFunctionType($receiver)) : (List<ValueParameterDescriptor>)null;
    }

    @Nullable
    public final ConstructorDescriptorImpl resolvePrimaryConstructorDescriptor(@NotNull LexicalScope scope2, @NotNull ClassDescriptor classDescriptor, @NotNull KtClassOrObject classElement, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        Intrinsics.checkParameterIsNotNull(classElement, "classElement");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if (Intrinsics.areEqual((Object)classDescriptor.getKind(), (Object)ClassKind.ENUM_ENTRY) || !classElement.hasPrimaryConstructor()) {
            return null;
        }
        KtPrimaryConstructor ktPrimaryConstructor = classElement.getPrimaryConstructor();
        return this.createConstructorDescriptor(scope2, classDescriptor, true, classElement.getPrimaryConstructorModifierList(), ktPrimaryConstructor != null ? (KtDeclaration)ktPrimaryConstructor : (KtDeclaration)classElement, classElement.getPrimaryConstructorParameters(), trace);
    }

    @NotNull
    public final ConstructorDescriptorImpl resolveSecondaryConstructorDescriptor(@NotNull LexicalScope scope2, @NotNull ClassDescriptor classDescriptor, @NotNull KtSecondaryConstructor constructor, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        Intrinsics.checkParameterIsNotNull(constructor, "constructor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        KtModifierList ktModifierList = constructor.getModifierList();
        KtDeclaration ktDeclaration = constructor;
        List<KtParameter> list2 = constructor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "constructor.getValueParameters()");
        return this.createConstructorDescriptor(scope2, classDescriptor, false, ktModifierList, ktDeclaration, list2, trace);
    }

    private final ConstructorDescriptorImpl createConstructorDescriptor(LexicalScope scope2, ClassDescriptor classDescriptor, boolean isPrimary, KtModifierList modifierList, KtDeclaration declarationToTrace, List<? extends KtParameter> valueParameters, BindingTrace trace) {
        ConstructorDescriptorImpl constructorDescriptor = ConstructorDescriptorImpl.create(classDescriptor, this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, modifierList, trace), isPrimary, KotlinSourceElementKt.toSourceElement(declarationToTrace));
        trace.record(BindingContext.CONSTRUCTOR, declarationToTrace, constructorDescriptor);
        DeclarationDescriptor declarationDescriptor = constructorDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "constructorDescriptor");
        LexicalWritableScope parameterScope = new LexicalWritableScope(scope2, declarationDescriptor, false, null, new TraceBasedLocalRedeclarationChecker(trace), LexicalScopeKind.CONSTRUCTOR_HEADER);
        FunctionDescriptor functionDescriptor = constructorDescriptor;
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "constructorDescriptor");
        ConstructorDescriptorImpl constructor = constructorDescriptor.initialize(this.resolveValueParameters(functionDescriptor, parameterScope, valueParameters, trace, null), ModifiersChecker.resolveVisibilityFromModifiers(modifierList, DescriptorUtils.getDefaultConstructorVisibility(classDescriptor)));
        if (DescriptorUtils.isAnnotationClass(classDescriptor)) {
            CompileTimeConstantUtils.checkConstructorParametersType(valueParameters, trace);
        }
        ConstructorDescriptorImpl constructorDescriptorImpl = constructor;
        Intrinsics.checkExpressionValueIsNotNull(constructorDescriptorImpl, "constructor");
        return constructorDescriptorImpl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ValueParameterDescriptor> resolveValueParameters(FunctionDescriptor functionDescriptor, LexicalWritableScope parameterScope, List<? extends KtParameter> valueParameters, BindingTrace trace, List<? extends ValueParameterDescriptor> expectedValueParameters) {
        int n;
        ArrayList<ValueParameterDescriptorImpl> result2 = new ArrayList<ValueParameterDescriptorImpl>();
        IntRange intRange = CollectionsKt.getIndices((Collection)valueParameters);
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                KotlinType type2;
                KotlinType expectedType;
                List<? extends ValueParameterDescriptor> list2;
                List<? extends ValueParameterDescriptor> it;
                void i;
                KtParameter valueParameter = valueParameters.get((int)i);
                KtTypeReference typeReference = valueParameter.getTypeReference();
                KotlinType kotlinType = expectedValueParameters != null ? (i < (it = list2).size() ? it.get((int)i).getType() : (KotlinType)null) : (expectedType = null);
                if (typeReference != null) {
                    type2 = this.typeResolver.resolveType(parameterScope, typeReference, trace, true);
                    if (expectedType != null && !TypeUtils.noExpectedType(expectedType) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(expectedType, type2)) {
                        trace.report(Errors.EXPECTED_PARAMETER_TYPE_MISMATCH.on((KtParameter)((PsiElement)valueParameter), expectedType));
                    }
                } else if (ExpressionTypingUtils.isFunctionLiteral(functionDescriptor) || ExpressionTypingUtils.isFunctionExpression(functionDescriptor)) {
                    boolean containsUninferredParameter2 = TypeUtils.contains(expectedType, resolveValueParameters.containsUninferredParameter.1.INSTANCE);
                    if (expectedType == null || containsUninferredParameter2) {
                        trace.report(Errors.CANNOT_INFER_PARAMETER_TYPE.on((KtParameter)((PsiElement)valueParameter)));
                    }
                    if (expectedType != null) {
                        type2 = expectedType;
                    } else {
                        Intrinsics.checkExpressionValueIsNotNull(TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE, "TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE");
                    }
                } else {
                    trace.report(Errors.VALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION.on((KtParameter)((PsiElement)valueParameter)));
                    Intrinsics.checkExpressionValueIsNotNull(ErrorUtils.createErrorType("Type annotation was missing for parameter " + valueParameter.getNameAsSafeName()), "ErrorUtils.createErrorTy\u2026er.getNameAsSafeName()}\")");
                }
                if (!(functionDescriptor instanceof ConstructorDescriptor) || !((ConstructorDescriptor)functionDescriptor).isPrimary()) {
                    boolean isConstructor = functionDescriptor instanceof ConstructorDescriptor;
                    ModifiersChecker.ModifiersCheckingProcedure modifiersCheckingProcedure = this.modifiersChecker.withTrace(trace);
                    ModifiersChecker.ModifiersCheckingProcedure $receiver = modifiersCheckingProcedure;
                    $receiver.checkParameterHasNoValOrVar(valueParameter, isConstructor ? Errors.VAL_OR_VAR_ON_SECONDARY_CONSTRUCTOR_PARAMETER : Errors.VAL_OR_VAR_ON_FUN_PARAMETER);
                }
                ValueParameterDescriptorImpl valueParameterDescriptor = this.descriptorResolver.resolveValueParameterDescriptor(parameterScope, functionDescriptor, valueParameter, (int)i, type2, trace);
                VariableDescriptor variableDescriptor = valueParameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(variableDescriptor, "valueParameterDescriptor");
                parameterScope.addVariableDescriptor(variableDescriptor);
                result2.add(valueParameterDescriptor);
                if (i == n) break;
                ++i;
            }
        }
        return result2;
    }

    public FunctionDescriptorResolver(@NotNull TypeResolver typeResolver, @NotNull DescriptorResolver descriptorResolver, @NotNull AnnotationResolver annotationResolver, @NotNull StorageManager storageManager, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull KotlinBuiltIns builtIns, @NotNull ModifiersChecker modifiersChecker) {
        Intrinsics.checkParameterIsNotNull(typeResolver, "typeResolver");
        Intrinsics.checkParameterIsNotNull(descriptorResolver, "descriptorResolver");
        Intrinsics.checkParameterIsNotNull(annotationResolver, "annotationResolver");
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(expressionTypingServices, "expressionTypingServices");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        Intrinsics.checkParameterIsNotNull(modifiersChecker, "modifiersChecker");
        this.typeResolver = typeResolver;
        this.descriptorResolver = descriptorResolver;
        this.annotationResolver = annotationResolver;
        this.storageManager = storageManager;
        this.expressionTypingServices = expressionTypingServices;
        this.builtIns = builtIns;
        this.modifiersChecker = modifiersChecker;
    }
}

