/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.Check;
import org.jetbrains.kotlin.util.CheckResult;
import org.jetbrains.kotlin.util.Checks;
import org.jetbrains.kotlin.util.IsKPropertyCheck;
import org.jetbrains.kotlin.util.MemberKindCheck;
import org.jetbrains.kotlin.util.NoDefaultAndVarargsCheck;
import org.jetbrains.kotlin.util.OperatorChecks;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.ReturnsCheck;
import org.jetbrains.kotlin.util.ValueParameterCountCheck;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ!\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0082\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/util/OperatorChecks;", "", "()V", "CHECKS", "", "Lorg/jetbrains/kotlin/util/Checks;", "checkOperator", "Lorg/jetbrains/kotlin/util/CheckResult;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "ensure", "", "cond", "", "msg", "Lkotlin/Function0;", "kotlin-compiler"})
public final class OperatorChecks {
    private static final List<Checks> CHECKS;
    public static final OperatorChecks INSTANCE;

    private final String ensure(boolean cond, Function0<String> msg) {
        return !cond ? msg.invoke() : (String)null;
    }

    @NotNull
    public final CheckResult checkOperator(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        for (Checks check : CHECKS) {
            if (!check.isApplicable(functionDescriptor)) continue;
            return check.checkAll(functionDescriptor);
        }
        return CheckResult.IllegalFunctionName.INSTANCE;
    }

    private OperatorChecks() {
        INSTANCE = this;
        Checks[] checksArray = new Checks[17];
        Name name = OperatorNameConventions.GET;
        Intrinsics.checkExpressionValueIsNotNull(name, "GET");
        checksArray[0] = new Checks(name, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, new ValueParameterCountCheck.AtLeast(1)}, null, 4, null);
        Name name2 = OperatorNameConventions.SET;
        Intrinsics.checkExpressionValueIsNotNull(name2, "SET");
        checksArray[1] = new Checks(name2, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, new ValueParameterCountCheck.AtLeast(2)}, (Function1<? super FunctionDescriptor, String>)CHECKS.1.INSTANCE);
        Name name3 = OperatorNameConventions.GET_VALUE;
        Intrinsics.checkExpressionValueIsNotNull(name3, "GET_VALUE");
        checksArray[2] = new Checks(name3, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, new ValueParameterCountCheck.AtLeast(2), IsKPropertyCheck.INSTANCE}, null, 4, null);
        Name name4 = OperatorNameConventions.SET_VALUE;
        Intrinsics.checkExpressionValueIsNotNull(name4, "SET_VALUE");
        checksArray[3] = new Checks(name4, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, new ValueParameterCountCheck.AtLeast(3), IsKPropertyCheck.INSTANCE}, null, 4, null);
        Name name5 = OperatorNameConventions.INVOKE;
        Intrinsics.checkExpressionValueIsNotNull(name5, "INVOKE");
        checksArray[4] = new Checks(name5, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE}, null, 4, null);
        Name name6 = OperatorNameConventions.CONTAINS;
        Intrinsics.checkExpressionValueIsNotNull(name6, "CONTAINS");
        checksArray[5] = new Checks(name6, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE, ReturnsCheck.ReturnsBoolean.INSTANCE}, null, 4, null);
        Name name7 = OperatorNameConventions.ITERATOR;
        Intrinsics.checkExpressionValueIsNotNull(name7, "ITERATOR");
        checksArray[6] = new Checks(name7, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE}, null, 4, null);
        Name name8 = OperatorNameConventions.NEXT;
        Intrinsics.checkExpressionValueIsNotNull(name8, "NEXT");
        checksArray[7] = new Checks(name8, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE}, null, 4, null);
        Name name9 = OperatorNameConventions.HAS_NEXT;
        Intrinsics.checkExpressionValueIsNotNull(name9, "HAS_NEXT");
        checksArray[8] = new Checks(name9, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE, ReturnsCheck.ReturnsBoolean.INSTANCE}, null, 4, null);
        Name name10 = OperatorNameConventions.RANGE_TO;
        Intrinsics.checkExpressionValueIsNotNull(name10, "RANGE_TO");
        checksArray[9] = new Checks(name10, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE}, null, 4, null);
        Name name11 = OperatorNameConventions.EQUALS;
        Intrinsics.checkExpressionValueIsNotNull(name11, "EQUALS");
        checksArray[10] = new Checks(name11, new Check[]{MemberKindCheck.Member.INSTANCE}, (Function1<? super FunctionDescriptor, String>)CHECKS.2.INSTANCE);
        Name name12 = OperatorNameConventions.COMPARE_TO;
        Intrinsics.checkExpressionValueIsNotNull(name12, "COMPARE_TO");
        checksArray[11] = new Checks(name12, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ReturnsCheck.ReturnsInt.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE}, null, 4, null);
        checksArray[12] = new Checks(OperatorNameConventions.BINARY_OPERATION_NAMES, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE}, null, 4, null);
        checksArray[13] = new Checks(OperatorNameConventions.SIMPLE_UNARY_OPERATION_NAMES, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE}, null, 4, null);
        checksArray[14] = new Checks((Collection<Name>)CollectionsKt.listOf(new Name[]{OperatorNameConventions.INC, OperatorNameConventions.DEC}), new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE}, (Function1<? super FunctionDescriptor, String>)CHECKS.3.INSTANCE);
        checksArray[15] = new Checks(OperatorNameConventions.ASSIGNMENT_OPERATIONS, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ReturnsCheck.ReturnsUnit.INSTANCE, ValueParameterCountCheck.SingleValueParameter.INSTANCE, NoDefaultAndVarargsCheck.INSTANCE}, null, 4, null);
        checksArray[16] = new Checks(OperatorNameConventions.COMPONENT_REGEX, new Check[]{MemberKindCheck.MemberOrExtension.INSTANCE, ValueParameterCountCheck.NoValueParameters.INSTANCE}, null, 4, null);
        CHECKS = CollectionsKt.listOf(checksArray);
    }

    static {
        new OperatorChecks();
    }

    @Nullable
    public static final /* synthetic */ String access$ensure(OperatorChecks $this, boolean cond, @NotNull Function0 msg) {
        return $this.ensure(cond, msg);
    }
}

