/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.PropertyName;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ObjectUtils;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertiesComponent {
    public abstract void unsetValue(String var1);

    public abstract boolean isValueSet(String var1);

    @Nullable
    public abstract String getValue(@NonNls String var1);

    public abstract void setValue(@NotNull String var1, @Nullable String var2);

    public abstract void setValue(@NotNull String var1, @Nullable String var2, @Nullable String var3);

    public abstract void setValue(@NotNull String var1, float var2, float var3);

    public abstract void setValue(@NotNull String var1, int var2, int var3);

    public final void setValue(@NotNull String name, boolean value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/util/PropertiesComponent", "setValue"));
        }
        this.setValue(name, value, false);
    }

    public abstract void setValue(@NotNull String var1, boolean var2, boolean var3);

    @Nullable
    public abstract String[] getValues(@NonNls String var1);

    public abstract void setValues(@NonNls String var1, String[] var2);

    public static PropertiesComponent getInstance(Project project) {
        return ServiceManager.getService(project, PropertiesComponent.class);
    }

    public static PropertiesComponent getInstance() {
        return ServiceManager.getService(PropertiesComponent.class);
    }

    public final boolean isTrueValue(@NonNls String name) {
        return Boolean.valueOf(this.getValue(name));
    }

    public final boolean getBoolean(@NotNull String name, boolean defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/util/PropertiesComponent", "getBoolean"));
        }
        return this.isValueSet(name) ? this.isTrueValue(name) : defaultValue;
    }

    public final boolean getBoolean(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/util/PropertiesComponent", "getBoolean"));
        }
        return this.getBoolean(name, false);
    }

    @NotNull
    public String getValue(@NonNls String name, @NotNull String defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/ide/util/PropertiesComponent", "getValue"));
        }
        if (!this.isValueSet(name)) {
            String string = defaultValue;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/PropertiesComponent", "getValue"));
            }
            return string;
        }
        String string = (String)ObjectUtils.notNull((Object)this.getValue(name), (Object)defaultValue);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/PropertiesComponent", "getValue"));
        }
        return string;
    }

    @Deprecated
    public final int getOrInitInt(@NotNull String name, int defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/util/PropertiesComponent", "getOrInitInt"));
        }
        return this.getInt(name, defaultValue);
    }

    public int getInt(@NotNull String name, int defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/util/PropertiesComponent", "getInt"));
        }
        return StringUtilRt.parseInt((String)this.getValue(name), (int)defaultValue);
    }

    public final long getOrInitLong(@NonNls String name, long defaultValue) {
        try {
            String value = this.getValue(name);
            return value == null ? defaultValue : Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Deprecated
    public String getOrInit(@NonNls String name, String defaultValue) {
        if (!this.isValueSet(name)) {
            this.setValue(name, defaultValue);
            return defaultValue;
        }
        return this.getValue(name);
    }

    public final boolean saveFields(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/ide/util/PropertiesComponent", "saveFields"));
        }
        try {
            for (Field field : object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                PropertyName annotation = field.getAnnotation(PropertyName.class);
                if (annotation == null) continue;
                String name = annotation.value();
                this.setValue(name, String.valueOf(field.get(object)));
            }
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public final boolean loadFields(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/ide/util/PropertiesComponent", "loadFields"));
        }
        try {
            for (Field field : object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                PropertyName annotation = field.getAnnotation(PropertyName.class);
                if (annotation == null) continue;
                Class<?> type = field.getType();
                String defaultValue = annotation.defaultValue();
                if ("".equals(defaultValue)) {
                    if (type.equals(Boolean.TYPE)) {
                        defaultValue = String.valueOf(field.getBoolean(object));
                    } else if (type.equals(Long.TYPE)) {
                        defaultValue = String.valueOf(field.getLong(object));
                    } else if (type.equals(Integer.TYPE)) {
                        defaultValue = String.valueOf(field.getInt(object));
                    } else if (type.equals(Short.TYPE)) {
                        defaultValue = String.valueOf(field.getShort(object));
                    } else if (type.equals(Byte.TYPE)) {
                        defaultValue = String.valueOf(field.getByte(object));
                    } else if (type.equals(Double.TYPE)) {
                        defaultValue = String.valueOf(field.getDouble(object));
                    } else if (type.equals(Float.TYPE)) {
                        defaultValue = String.valueOf(field.getFloat(object));
                    } else if (type.equals(String.class)) {
                        defaultValue = String.valueOf(field.get(object));
                    }
                }
                String stringValue = this.getValue(annotation.value(), defaultValue);
                Object value = null;
                if (type.equals(Boolean.TYPE)) {
                    value = Boolean.valueOf(stringValue);
                } else if (type.equals(Long.TYPE)) {
                    value = Long.parseLong(stringValue);
                } else if (type.equals(Integer.TYPE)) {
                    value = Integer.parseInt(stringValue);
                } else if (type.equals(Short.TYPE)) {
                    value = Short.parseShort(stringValue);
                } else if (type.equals(Byte.TYPE)) {
                    value = Byte.parseByte(stringValue);
                } else if (type.equals(Double.TYPE)) {
                    value = Double.parseDouble(stringValue);
                } else if (type.equals(Float.TYPE)) {
                    value = Float.valueOf(Float.parseFloat(stringValue));
                } else if (type.equals(String.class)) {
                    value = stringValue;
                }
                if (value == null) continue;
                field.set(object, value);
            }
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public float getFloat(String name, float defaultValue) {
        if (this.isValueSet(name)) {
            try {
                return Float.parseFloat(this.getValue(name));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

