/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.LazyUiDisposable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentWithBrowseButton<Comp extends JComponent>
extends JPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ComponentWithBrowseButton.class);
    private final Comp myComponent;
    private final FixedSizeButton myBrowseButton;
    private boolean myButtonEnabled = true;
    private KeyEvent myCurrentEvent = null;

    public ComponentWithBrowseButton(Comp component, @Nullable ActionListener browseActionListener) {
        super(new BorderLayout(SystemInfo.isMac ? 0 : 2, 0));
        this.myComponent = component;
        this.setFocusable(false);
        this.add((Component)this.myComponent, "Center");
        this.myBrowseButton = new FixedSizeButton((JComponent)this.myComponent);
        if (browseActionListener != null) {
            this.myBrowseButton.addActionListener(browseActionListener);
        }
        this.add((Component)ComponentWithBrowseButton.centerComponentVertically(this.myBrowseButton), "East");
        this.myBrowseButton.setToolTipText(UIBundle.message((String)"component.with.browse.button.browse.button.tooltip.text", (Object[])new Object[0]));
        if (ApplicationManager.getApplication() != null) {
            new MyDoClickAction(this.myBrowseButton).registerShortcut((JComponent)this.myComponent);
        }
        if (ScreenReader.isActive()) {
            this.myBrowseButton.setFocusable(true);
            this.myBrowseButton.getAccessibleContext().setAccessibleName("Browse");
        }
    }

    @NotNull
    private static JPanel centerComponentVertically(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/ui/ComponentWithBrowseButton", "centerComponentVertically"));
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(component, new GridBagConstraints());
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/ComponentWithBrowseButton", "centerComponentVertically"));
        }
        return jPanel;
    }

    public final Comp getChildComponent() {
        return this.myComponent;
    }

    public void setTextFieldPreferredWidth(int charCount) {
        Comp comp = this.getChildComponent();
        Dimension size = GuiUtils.getSizeByChars(charCount, comp);
        ((JComponent)comp).setPreferredSize(size);
        Dimension preferredSize = this.myBrowseButton.getPreferredSize();
        this.setPreferredSize(new Dimension(size.width + preferredSize.width + 2, UIUtil.isUnderAquaLookAndFeel() ? preferredSize.height : preferredSize.height + 2));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myBrowseButton.setEnabled(enabled && this.myButtonEnabled);
        ((JComponent)this.myComponent).setEnabled(enabled);
    }

    public void setButtonEnabled(boolean buttonEnabled) {
        this.myButtonEnabled = buttonEnabled;
        this.setEnabled(this.isEnabled());
    }

    public void setButtonIcon(Icon icon) {
        this.myBrowseButton.setIcon(icon);
    }

    public void addActionListener(ActionListener listener) {
        this.myBrowseButton.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.myBrowseButton.removeActionListener(listener);
    }

    public void addBrowseFolderListener(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable @Nls(capitalization=Nls.Capitalization.Sentence) String description, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor<Comp> accessor) {
        this.addBrowseFolderListener(title, description, project, fileChooserDescriptor, accessor, true);
    }

    public void addBrowseFolderListener(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable @Nls(capitalization=Nls.Capitalization.Sentence) String description, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor<Comp> accessor, boolean autoRemoveOnHide) {
        this.addBrowseFolderListener(project, new BrowseFolderActionListener<Comp>(title, description, this, project, fileChooserDescriptor, accessor), autoRemoveOnHide);
    }

    public void addBrowseFolderListener(@Nullable Project project, BrowseFolderActionListener<Comp> actionListener) {
        this.addBrowseFolderListener(project, actionListener, true);
    }

    public void addBrowseFolderListener(@Nullable Project project, final BrowseFolderActionListener<Comp> actionListener, boolean autoRemoveOnHide) {
        if (autoRemoveOnHide) {
            new LazyUiDisposable<ComponentWithBrowseButton<Comp>>(null, this, this){

                @Override
                protected void initialize(@NotNull Disposable parent, @NotNull ComponentWithBrowseButton<Comp> child, @Nullable Project project) {
                    if (parent == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/ComponentWithBrowseButton$1", "initialize"));
                    }
                    if (child == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/ui/ComponentWithBrowseButton$1", "initialize"));
                    }
                    ComponentWithBrowseButton.this.addActionListener(actionListener);
                    Disposer.register(child, (Disposable)new Disposable(){

                        public void dispose() {
                            ComponentWithBrowseButton.this.removeActionListener(actionListener);
                        }
                    });
                }
            };
        } else {
            this.addActionListener(actionListener);
        }
    }

    public void dispose() {
    }

    public FixedSizeButton getButton() {
        return this.myBrowseButton;
    }

    @Override
    public final void requestFocus() {
        ((JComponent)this.myComponent).requestFocus();
    }

    @Override
    public final void setNextFocusableComponent(Component aComponent) {
        super.setNextFocusableComponent(aComponent);
        ((JComponent)this.myComponent).setNextFocusableComponent(aComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (condition == 0 && this.myCurrentEvent != e) {
            try {
                this.myCurrentEvent = e;
                ((Component)this.myComponent).dispatchEvent(e);
            }
            finally {
                this.myCurrentEvent = null;
            }
        }
        if (e.isConsumed()) {
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public static class BrowseFolderActionListener<T extends JComponent>
    implements ActionListener {
        private final String myTitle;
        private final String myDescription;
        protected ComponentWithBrowseButton<T> myTextComponent;
        private final TextComponentAccessor<T> myAccessor;
        private Project myProject;
        protected final FileChooserDescriptor myFileChooserDescriptor;

        public BrowseFolderActionListener(@Nullable @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable @Nls(capitalization=Nls.Capitalization.Sentence) String description, ComponentWithBrowseButton<T> textField, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor<T> accessor) {
            if (fileChooserDescriptor != null && fileChooserDescriptor.isChooseMultiple()) {
                LOG.error("multiple selection not supported");
                fileChooserDescriptor = new FileChooserDescriptor(fileChooserDescriptor){

                    @Override
                    public boolean isChooseMultiple() {
                        return false;
                    }
                };
            }
            this.myTitle = title;
            this.myDescription = description;
            this.myTextComponent = textField;
            this.myProject = project;
            this.myFileChooserDescriptor = fileChooserDescriptor;
            this.myAccessor = accessor;
        }

        @Nullable
        protected Project getProject() {
            return this.myProject;
        }

        protected void setProject(@Nullable Project project) {
            this.myProject = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileChooserDescriptor fileChooserDescriptor = this.myFileChooserDescriptor;
            if (this.myTitle != null || this.myDescription != null) {
                fileChooserDescriptor = (FileChooserDescriptor)this.myFileChooserDescriptor.clone();
                if (this.myTitle != null) {
                    fileChooserDescriptor.setTitle(this.myTitle);
                }
                if (this.myDescription != null) {
                    fileChooserDescriptor.setDescription(this.myDescription);
                }
            }
            FileChooser.chooseFile(fileChooserDescriptor, this.getProject(), this.getInitialFile(), (Consumer<VirtualFile>)((Consumer)file -> this.onFileChosen((VirtualFile)file)));
        }

        @Nullable
        protected VirtualFile getInitialFile() {
            int pos;
            String directoryName = this.getComponentText();
            if (StringUtil.isEmptyOrSpaces((String)directoryName)) {
                return null;
            }
            directoryName = FileUtil.toSystemIndependentName((String)directoryName);
            VirtualFile path2 = LocalFileSystem.getInstance().findFileByPath(this.expandPath(directoryName));
            while (path2 == null && directoryName.length() > 0 && (pos = directoryName.lastIndexOf(47)) > 0) {
                directoryName = directoryName.substring(0, pos);
                path2 = LocalFileSystem.getInstance().findFileByPath(directoryName);
            }
            return path2;
        }

        @NotNull
        protected String expandPath(@NotNull String path2) {
            if (path2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/ui/ComponentWithBrowseButton$BrowseFolderActionListener", "expandPath"));
            }
            String string = path2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/ComponentWithBrowseButton$BrowseFolderActionListener", "expandPath"));
            }
            return string;
        }

        protected String getComponentText() {
            return this.myAccessor.getText(this.myTextComponent.getChildComponent()).trim();
        }

        @NotNull
        protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
            if (chosenFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/openapi/ui/ComponentWithBrowseButton$BrowseFolderActionListener", "chosenFileToResultingText"));
            }
            String string = chosenFile.getPresentableUrl();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/ComponentWithBrowseButton$BrowseFolderActionListener", "chosenFileToResultingText"));
            }
            return string;
        }

        protected void onFileChosen(@NotNull VirtualFile chosenFile) {
            if (chosenFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/openapi/ui/ComponentWithBrowseButton$BrowseFolderActionListener", "onFileChosen"));
            }
            this.myAccessor.setText(this.myTextComponent.getChildComponent(), this.chosenFileToResultingText(chosenFile));
        }
    }

    public static final class MyDoClickAction
    extends DumbAwareAction {
        private final FixedSizeButton myBrowseButton;

        public MyDoClickAction(FixedSizeButton browseButton) {
            this.myBrowseButton = browseButton;
        }

        @Override
        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.myBrowseButton.isVisible() && this.myBrowseButton.isEnabled());
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            this.myBrowseButton.doClick();
        }

        public void registerShortcut(JComponent textField) {
            CustomShortcutSet shiftEnter = new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64));
            this.registerCustomShortcutSet(shiftEnter, textField);
            this.myBrowseButton.setToolTipText(KeymapUtil.getShortcutsText(shiftEnter.getShortcuts()));
        }

        public static void addTo(FixedSizeButton browseButton, JComponent aComponent) {
            new MyDoClickAction(browseButton).registerShortcut(aComponent);
        }
    }
}

