/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config.ui;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.intellij.plugins.intelliLang.inject.config.MethodParameterInjection;
import org.intellij.plugins.intelliLang.inject.config.ui.AbstractInjectionPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.AdvancedPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.LanguagePanel;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodParameterPanel
extends AbstractInjectionPanel<MethodParameterInjection> {
    LanguagePanel myLanguagePanel;
    AdvancedPanel myAdvancedPanel;
    private JPanel myRoot;
    private JPanel myClassPanel;
    private TreeTableView myParamsTable;
    private final ReferenceEditorWithBrowseButton myClassField;
    private DefaultMutableTreeNode myRootNode;
    private final THashMap<PsiMethod, MethodParameterInjection.MethodInfo> myData = new THashMap();

    public MethodParameterPanel(MethodParameterInjection injection, Project project) {
        super(injection, project);
        this.$$$setupUI$$$();
        this.myClassField = new ReferenceEditorWithBrowseButton((ActionListener)new BrowseClassListener(project), project, s -> {
            Document document = PsiUtilEx.createDocument(s, project);
            document.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void documentChanged(DocumentEvent e) {
                    MethodParameterPanel.this.updateParamTree();
                    MethodParameterPanel.this.updateTree();
                }
            });
            return document;
        }, "");
        this.myClassPanel.add((Component)this.myClassField, "Center");
        this.myParamsTable.getTree().setShowsRootHandles(true);
        this.myParamsTable.getTree().setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                boolean missing;
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/intellij/plugins/intelliLang/inject/config/ui/MethodParameterPanel$2", "customizeCellRenderer"));
                }
                Object o = ((DefaultMutableTreeNode)value).getUserObject();
                this.setIcon(o instanceof PsiMethod ? PlatformIcons.METHOD_ICON : (o instanceof PsiParameter ? PlatformIcons.PARAMETER_ICON : null));
                String name = o instanceof PsiMethod ? PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)o), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)3) : (o instanceof PsiParameter ? PsiFormatUtil.formatVariable((PsiVariable)((PsiParameter)o), (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY) : null);
                boolean bl = missing = o instanceof PsiElement && !((PsiElement)o).isPhysical();
                if (name != null) {
                    this.append(name, missing ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        });
        this.init(injection.copy());
        new TreeTableSpeedSearch((TreeTable)this.myParamsTable, (Convertor)new Convertor<TreePath, String>(){

            @Nullable
            public String convert(TreePath o) {
                Object userObject = ((DefaultMutableTreeNode)o.getLastPathComponent()).getUserObject();
                return userObject instanceof PsiNamedElement ? ((PsiNamedElement)userObject).getName() : null;
            }
        });
        new AnAction("Toggle"){

            public void actionPerformed(AnActionEvent e) {
                MethodParameterPanel.this.performToggleAction();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), (JComponent)this.myParamsTable);
    }

    private void performToggleAction() {
        List selectedInjections = this.myParamsTable.getSelection();
        boolean enabledExists = false;
        boolean disabledExists = false;
        for (DefaultMutableTreeNode node : selectedInjections) {
            Boolean nodeSelected = this.isNodeSelected(node);
            if (Boolean.TRUE == nodeSelected) {
                enabledExists = true;
            } else if (Boolean.FALSE == nodeSelected) {
                disabledExists = true;
            }
            if (!enabledExists || !disabledExists) continue;
            break;
        }
        boolean allEnabled = !enabledExists && disabledExists;
        for (DefaultMutableTreeNode node : selectedInjections) {
            this.setNodeSelected(node, allEnabled);
        }
        this.myParamsTable.updateUI();
    }

    @Nullable
    private PsiType getClassType() {
        Document document = this.myClassField.getEditorTextField().getDocument();
        PsiDocumentManager dm = PsiDocumentManager.getInstance((Project)this.myProject);
        dm.commitDocument(document);
        PsiFile psiFile = dm.getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        try {
            return ((PsiTypeCodeFragment)psiFile).getType();
        }
        catch (PsiTypeCodeFragment.TypeSyntaxException e1) {
            return null;
        }
        catch (PsiTypeCodeFragment.NoTypeException e1) {
            return null;
        }
    }

    private void setPsiClass(String name) {
        this.myClassField.setText(name);
    }

    private void updateParamTree() {
        this.rebuildTreeModel();
        this.refreshTreeStructure();
    }

    private void rebuildTreeModel() {
        this.myData.clear();
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass[] classes;
            PsiType classType = this.getClassType();
            PsiClass[] psiClassArray = classes = classType instanceof PsiClassType ? JavaPsiFacade.getInstance((Project)this.myProject).findClasses(classType.getCanonicalText(), GlobalSearchScope.allScope((Project)this.myProject)) : PsiClass.EMPTY_ARRAY;
            if (classes.length == 0) {
                return;
            }
            THashSet visitedSignatures = new THashSet();
            for (PsiClass psiClass : classes) {
                for (PsiMethod method : psiClass.getMethods()) {
                    MethodParameterInjection.MethodInfo info;
                    PsiModifierList modifiers = method.getModifierList();
                    if (modifiers.hasModifierProperty("private") || modifiers.hasModifierProperty("packageLocal") || !MethodParameterInjection.isInjectable(method.getReturnType(), method.getProject()) && ContainerUtil.find((Object[])method.getParameterList().getParameters(), p -> MethodParameterInjection.isInjectable(p.getType(), p.getProject())) == null || !visitedSignatures.add((Object)(info = MethodParameterInjection.createMethodInfo(method)).getMethodSignature())) continue;
                    this.myData.put((Object)method, (Object)info);
                }
            }
        });
    }

    private void refreshTreeStructure() {
        this.myRootNode.removeAllChildren();
        ArrayList methods = new ArrayList(this.myData.keySet());
        Collections.sort(methods, (o1, o2) -> {
            int names = o1.getName().compareTo(o2.getName());
            if (names != 0) {
                return names;
            }
            return o1.getParameterList().getParametersCount() - o2.getParameterList().getParametersCount();
        });
        for (PsiMethod method : methods) {
            PsiParameter[] params = method.getParameterList().getParameters();
            DefaultMutableTreeNode methodNode = new DefaultMutableTreeNode(method, true);
            this.myRootNode.add(methodNode);
            for (PsiParameter parameter : params) {
                methodNode.add(new DefaultMutableTreeNode(parameter, false));
            }
        }
        ListTreeTableModelOnColumns tableModel = (ListTreeTableModelOnColumns)this.myParamsTable.getTableModel();
        tableModel.reload();
        TreeUtil.expandAll((JTree)this.myParamsTable.getTree());
        this.myParamsTable.revalidate();
    }

    private String getClassName() {
        PsiType type = this.getClassType();
        if (type == null) {
            return this.myClassField.getText();
        }
        return type.getCanonicalText();
    }

    @Override
    protected void apply(final MethodParameterInjection other) {
        boolean applyMethods = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                other.setClassName(MethodParameterPanel.this.getClassName());
                return MethodParameterPanel.this.getClassType() != null;
            }
        });
        if (applyMethods) {
            other.setMethodInfos(ContainerUtil.findAll((Collection)this.myData.values(), methodInfo -> methodInfo.isEnabled()));
        }
    }

    @Override
    protected void resetImpl() {
        this.setPsiClass(((MethodParameterInjection)this.myOrigInjection).getClassName());
        this.rebuildTreeModel();
        THashMap map = new THashMap();
        for (PsiMethod method : this.myData.keySet()) {
            MethodParameterInjection.MethodInfo methodInfo = (MethodParameterInjection.MethodInfo)this.myData.get((Object)method);
            map.put((Object)methodInfo.getMethodSignature(), (Object)methodInfo);
        }
        for (MethodParameterInjection.MethodInfo info : ((MethodParameterInjection)this.myOrigInjection).getMethodInfos()) {
            MethodParameterInjection.MethodInfo curInfo = (MethodParameterInjection.MethodInfo)map.get((Object)info.getMethodSignature());
            if (curInfo != null) {
                System.arraycopy(info.getParamFlags(), 0, curInfo.getParamFlags(), 0, Math.min(info.getParamFlags().length, curInfo.getParamFlags().length));
                curInfo.setReturnFlag(info.isReturnFlag());
                continue;
            }
            PsiMethod missingMethod = MethodParameterInjection.makeMethod(this.myProject, info.getMethodSignature());
            this.myData.put((Object)missingMethod, (Object)info.copy());
        }
        this.refreshTreeStructure();
        Enumeration<TreeNode> enumeration = this.myRootNode.children();
        while (enumeration.hasMoreElements()) {
            PsiMethod method;
            method = (PsiMethod)((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
            assert (this.myData.containsKey((Object)method));
        }
    }

    @Override
    public JPanel getComponent() {
        return this.myRoot;
    }

    private void createUIComponents() {
        this.myLanguagePanel = new LanguagePanel(this.myProject, this.myOrigInjection);
        this.myRootNode = new DefaultMutableTreeNode(null, true);
        this.myParamsTable = new MyView(new ListTreeTableModelOnColumns((TreeNode)this.myRootNode, this.createColumnInfos()));
        this.myAdvancedPanel = new AdvancedPanel(this.myProject, this.myOrigInjection);
    }

    @Nullable
    private Boolean isNodeSelected(DefaultMutableTreeNode o) {
        Object userObject = o.getUserObject();
        if (userObject instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)userObject;
            return MethodParameterInjection.isInjectable(method.getReturnType(), method.getProject()) ? Boolean.valueOf(((MethodParameterInjection.MethodInfo)this.myData.get((Object)method)).isReturnFlag()) : null;
        }
        if (userObject instanceof PsiParameter) {
            PsiMethod method = MethodParameterPanel.getMethodByNode(o);
            PsiParameter parameter = (PsiParameter)userObject;
            int index = method.getParameterList().getParameterIndex(parameter);
            return MethodParameterInjection.isInjectable(parameter.getType(), method.getProject()) ? Boolean.valueOf(((MethodParameterInjection.MethodInfo)this.myData.get((Object)method)).getParamFlags()[index]) : null;
        }
        return null;
    }

    private void setNodeSelected(DefaultMutableTreeNode o, boolean value) {
        Object userObject = o.getUserObject();
        if (userObject instanceof PsiMethod) {
            ((MethodParameterInjection.MethodInfo)this.myData.get((Object)((PsiMethod)userObject))).setReturnFlag(value);
        } else if (userObject instanceof PsiParameter) {
            PsiMethod method = MethodParameterPanel.getMethodByNode(o);
            int index = method.getParameterList().getParameterIndex((PsiParameter)userObject);
            ((MethodParameterInjection.MethodInfo)this.myData.get((Object)method)).getParamFlags()[index] = value;
        }
    }

    private static PsiMethod getMethodByNode(DefaultMutableTreeNode o) {
        Object userObject = o.getUserObject();
        if (userObject instanceof PsiMethod) {
            return (PsiMethod)userObject;
        }
        return (PsiMethod)((DefaultMutableTreeNode)o.getParent()).getUserObject();
    }

    private ColumnInfo[] createColumnInfos() {
        return new ColumnInfo[]{new ColumnInfo<DefaultMutableTreeNode, Boolean>(" "){
            final BooleanTableCellRenderer myRenderer;
            {
                this.myRenderer = new BooleanTableCellRenderer();
            }

            public Boolean valueOf(DefaultMutableTreeNode o) {
                return MethodParameterPanel.this.isNodeSelected(o);
            }

            public int getWidth(JTable table) {
                return this.myRenderer.getPreferredSize().width;
            }

            public TableCellEditor getEditor(DefaultMutableTreeNode o) {
                return new DefaultCellEditor(new JCheckBox());
            }

            public TableCellRenderer getRenderer(DefaultMutableTreeNode o) {
                this.myRenderer.setEnabled(this.isCellEditable(o));
                return this.myRenderer;
            }

            public void setValue(DefaultMutableTreeNode o, Boolean value) {
                MethodParameterPanel.this.setNodeSelected(o, Boolean.TRUE.equals(value));
            }

            public Class<Boolean> getColumnClass() {
                return Boolean.class;
            }

            public boolean isCellEditable(DefaultMutableTreeNode o) {
                return this.valueOf(o) != null;
            }
        }, new TreeColumnInfo(" ")};
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRoot = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        LanguagePanel languagePanel = this.myLanguagePanel;
        JComponent jComponent = languagePanel.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Class Methods", (int)0, (int)0, null, null));
        this.myClassPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        TreeTableView treeTableView = this.myParamsTable;
        jBScrollPane.setViewportView((Component)treeTableView);
        AdvancedPanel advancedPanel = this.myAdvancedPanel;
        JComponent jComponent2 = advancedPanel.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent2, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private static class MyView
    extends TreeTableView
    implements TypeSafeDataProvider {
        public MyView(ListTreeTableModelOnColumns treeTableModel) {
            super(treeTableModel);
        }

        public void calcData(DataKey key, DataSink sink) {
            Object o;
            List selection;
            if (CommonDataKeys.PSI_ELEMENT.equals(key) && !(selection = this.getSelection()).isEmpty() && (o = ((DefaultMutableTreeNode)selection.iterator().next()).getUserObject()) instanceof PsiElement) {
                sink.put(CommonDataKeys.PSI_ELEMENT, (Object)((PsiElement)o));
            }
        }
    }

    private class BrowseClassListener
    implements ActionListener {
        private final Project myProject;

        public BrowseClassListener(Project project) {
            this.myProject = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeClassChooserFactory factory = TreeClassChooserFactory.getInstance((Project)this.myProject);
            TreeClassChooser chooser = factory.createAllProjectScopeChooser("Select Class");
            chooser.showDialog();
            PsiClass psiClass = chooser.getSelected();
            if (psiClass != null) {
                MethodParameterPanel.this.setPsiClass(psiClass.getQualifiedName());
                MethodParameterPanel.this.updateParamTree();
                MethodParameterPanel.this.updateTree();
            }
        }
    }
}

