/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.writer.KCode;
import java.util.List;

public class CastExpr
extends Expr {
    final String mType;

    CastExpr(String type, Expr expr) {
        super(expr);
        this.mType = type;
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        return modelAnalyzer.findClass(this.mType, this.getModel().getImports());
    }

    @Override
    protected List<Dependency> constructDependencies() {
        List<Dependency> dependencies = this.constructDynamicChildrenDependencies();
        for (Dependency dependency : dependencies) {
            dependency.setMandatory(true);
        }
        return dependencies;
    }

    @Override
    protected String computeUniqueKey() {
        return this.addTwoWay(CastExpr.join(this.mType, this.getCastExpr().computeUniqueKey()));
    }

    public Expr getCastExpr() {
        return this.getChildren().get(0);
    }

    public String getCastType() {
        return this.getResolvedType().toJavaCode();
    }

    @Override
    protected KCode generateCode(boolean expand) {
        return new KCode().app("(").app(this.getCastType()).app(") ", this.getCastExpr().toCode(expand));
    }

    @Override
    public String getInvertibleError() {
        return this.getCastExpr().getInvertibleError();
    }

    @Override
    public KCode toInverseCode(KCode value) {
        return this.getCastExpr().toInverseCode(value);
    }
}

