/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.AbstractResizer;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.SubScene;

public class SubSceneResizer
extends AbstractResizer<SubScene> {
    private final double originalWidth;
    private final double originalHeight;
    private final PropertyName widthName = new PropertyName("width");
    private final PropertyName heightName = new PropertyName("height");
    private final List<PropertyName> propertyNames = new ArrayList<PropertyName>();

    public SubSceneResizer(SubScene sceneGraphObject) {
        super(sceneGraphObject);
        this.originalWidth = sceneGraphObject.getWidth();
        this.originalHeight = sceneGraphObject.getHeight();
        this.propertyNames.add(this.widthName);
        this.propertyNames.add(this.heightName);
    }

    @Override
    public final Bounds computeBounds(double width, double height) {
        return new BoundingBox(0.0, 0.0, (double)Math.round(width), (double)Math.round(height));
    }

    @Override
    public AbstractResizer.Feature getFeature() {
        return AbstractResizer.Feature.FREE;
    }

    @Override
    public void changeWidth(double w) {
        ((SubScene)this.sceneGraphObject).setWidth((double)Math.round(w));
    }

    @Override
    public void changeHeight(double h) {
        ((SubScene)this.sceneGraphObject).setHeight((double)Math.round(h));
    }

    @Override
    public void revertToOriginalSize() {
        ((SubScene)this.sceneGraphObject).setWidth(this.originalWidth);
        ((SubScene)this.sceneGraphObject).setHeight(this.originalHeight);
    }

    @Override
    public List<PropertyName> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object getValue(PropertyName propertyName) {
        assert (propertyName != null);
        assert (this.propertyNames.contains(propertyName));
        Double result = propertyName.equals(this.widthName) ? Double.valueOf(((SubScene)this.sceneGraphObject).getWidth()) : (propertyName.equals(this.heightName) ? Double.valueOf(((SubScene)this.sceneGraphObject).getHeight()) : null);
        return result;
    }

    @Override
    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (!MathUtils.equals(((SubScene)this.sceneGraphObject).getWidth(), this.originalWidth)) {
            result.put(this.widthName, ((SubScene)this.sceneGraphObject).getWidth());
        }
        if (!MathUtils.equals(((SubScene)this.sceneGraphObject).getHeight(), this.originalHeight)) {
            result.put(this.heightName, ((SubScene)this.sceneGraphObject).getHeight());
        }
        return result;
    }
}

