/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorItemDelegate;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.VBox;

public abstract class InlineListEditor
extends PropertyEditor
implements EditorItemDelegate {
    private final VBox vbox = new VBox(1.0);
    private final List<EditorItem> editorItems = new ArrayList<EditorItem>();

    public InlineListEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
        this.setLayoutFormat(PropertyEditor.LayoutFormat.DOUBLE_LINE);
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.vbox);
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        this.reset(propMeta, selectedClasses, true);
    }

    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, boolean removeAll) {
        super.reset(propMeta, selectedClasses);
        this.setLayoutFormat(PropertyEditor.LayoutFormat.DOUBLE_LINE);
        this.reset(removeAll);
    }

    @Override
    protected void valueIsIndeterminate() {
        for (EditorItem editorItem : this.editorItems) {
            editorItem.setValueAsIndeterminate();
        }
    }

    @Override
    public void commit(EditorItem source) {
        this.userUpdateValueProperty(this.getValue());
    }

    @Override
    public void editing(boolean editing, EventHandler<?> editingHandler) {
        this.editingProperty().setValue(Boolean.valueOf(editing));
        this.setCommitListener(editingHandler);
    }

    @Override
    public void add(EditorItem previousItem, EditorItem newItem) {
        this.addItem(previousItem, newItem);
        this.userUpdateValueProperty(this.getValue());
    }

    @Override
    public void remove(EditorItem source) {
        this.remove(source, false);
    }

    public void remove(EditorItem source, boolean removeAll) {
        this.removeItem(source, removeAll);
        this.userUpdateValueProperty(this.getValue());
    }

    @Override
    public void up(EditorItem source) {
        this.upItem(source);
        this.userUpdateValueProperty(this.getValue());
    }

    @Override
    public void down(EditorItem source) {
        this.downItem(source);
        this.userUpdateValueProperty(this.getValue());
    }

    protected final List<EditorItem> getEditorItems() {
        return this.editorItems;
    }

    protected final EditorItem addItem(EditorItem newItem) {
        return this.addItem(null, newItem);
    }

    protected final EditorItem addItem(EditorItem previousItem, EditorItem newItem) {
        int index = -1;
        if (previousItem != null) {
            index = this.editorItems.indexOf(previousItem) + 1;
        }
        if (index != -1) {
            this.editorItems.add(index, newItem);
            this.vbox.getChildren().add(index, (Object)newItem.getNode());
        } else {
            this.editorItems.add(newItem);
            this.vbox.getChildren().add((Object)newItem.getNode());
        }
        this.updateMenuItems();
        return newItem;
    }

    protected void removeItem(EditorItem editorItem) {
        this.removeItem(editorItem, false);
    }

    protected void removeItem(EditorItem editorItem, boolean removeAll) {
        if (!removeAll && this.editorItems.size() == 1) {
            editorItem.reset();
            if (editorItem.getRemoveMenuItem() != null) {
                editorItem.getRemoveMenuItem().setDisable(true);
            }
            return;
        }
        this.editorItems.remove(editorItem);
        this.vbox.getChildren().remove((Object)editorItem.getNode());
        this.updateMenuItems();
    }

    protected void upItem(EditorItem editorItem) {
        int indexItem = this.editorItems.indexOf(editorItem);
        assert (indexItem != -1 && indexItem != 0);
        assert (this.vbox.getChildren().indexOf((Object)editorItem.getNode()) == indexItem);
        Collections.swap(this.editorItems, indexItem, indexItem - 1);
        EditorUtils.swap((ObservableList<Node>)this.vbox.getChildren(), indexItem, indexItem - 1);
        this.vbox.requestLayout();
        this.updateMenuItems();
    }

    protected void downItem(EditorItem editorItem) {
        int indexItem = this.editorItems.indexOf(editorItem);
        assert (indexItem != -1 && indexItem != this.editorItems.size() - 1);
        assert (this.vbox.getChildren().indexOf((Object)editorItem.getNode()) == indexItem);
        Collections.swap(this.editorItems, indexItem, indexItem + 1);
        EditorUtils.swap((ObservableList<Node>)this.vbox.getChildren(), indexItem, indexItem + 1);
        this.updateMenuItems();
    }

    protected void reset() {
        this.reset(false);
    }

    protected void reset(boolean removeAll) {
        ArrayList<EditorItem> items = new ArrayList<EditorItem>(this.editorItems);
        for (EditorItem editorItem : items) {
            this.removeItem(editorItem, removeAll);
        }
        this.updateMenuItems();
    }

    private void updateMenuItems() {
        for (int ii = 0; ii < this.editorItems.size(); ++ii) {
            EditorItem item = this.editorItems.get(ii);
            if (item.getMoveUpMenuItem() == null || item.getMoveDownMenuItem() == null) continue;
            if (ii == 0) {
                item.getMoveUpMenuItem().setDisable(true);
            } else {
                item.getMoveUpMenuItem().setDisable(false);
            }
            if (ii == this.editorItems.size() - 1) {
                item.getMoveDownMenuItem().setDisable(true);
                continue;
            }
            item.getMoveDownMenuItem().setDisable(false);
        }
    }
}

