/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrHighlightUtil {
    private static final Logger LOG = Logger.getInstance(GrHighlightUtil.class);

    private static Set<String> getReassignedNames(PsiElement scope) {
        return (Set)CachedValuesManager.getCachedValue((PsiElement)scope, () -> CachedValueProvider.Result.create(GrHighlightUtil.collectReassignedNames(scope), (Object[])new Object[]{scope}));
    }

    private static Set<String> collectReassignedNames(PsiElement scope) {
        final HashSet result = ContainerUtil.newHashSet();
        PsiTreeUtil.processElements((PsiElement)scope, (PsiElementProcessor)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                PsiElement target;
                String varName;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/GrHighlightUtil$1", "execute"));
                }
                if (!(element instanceof GrReferenceExpression) || !((GrReferenceExpression)element).isQualified()) {
                    return true;
                }
                GrReferenceExpression ref = (GrReferenceExpression)element;
                if (GrHighlightUtil.isWriteAccess(ref) && !result.contains(varName = ref.getReferenceName()) && ((target = ref.resolve()) instanceof GrVariable && ((GrVariable)target).getInitializerGroovy() != null || target instanceof GrParameter)) {
                    result.add(varName);
                }
                return true;
            }
        });
        return result;
    }

    private static boolean isWriteAccess(GrReferenceExpression element) {
        return PsiUtil.isLValue(element) || element.getParent() instanceof GrUnaryExpression && ((GrUnaryExpression)element.getParent()).isPostfix();
    }

    static boolean isReassigned(GrVariable var) {
        LOG.assertTrue(!DumbService.getInstance((Project)var.getProject()).isDumb());
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)var, PsiMethod.class);
        PsiMethod scope = method == null ? var.getContainingFile() : method;
        return scope != null && GrHighlightUtil.getReassignedNames((PsiElement)scope).contains(var.getName());
    }

    @Nullable
    static TextAttributesKey getDeclarationHighlightingAttribute(PsiElement resolved, @Nullable PsiElement refElement) {
        if (refElement != null && GrHighlightUtil.isReferenceWithLiteralName(refElement)) {
            return null;
        }
        if (resolved instanceof PsiField || resolved instanceof GrVariable && ResolveUtil.isScriptField((GrVariable)resolved)) {
            boolean isStatic = ((PsiVariable)resolved).hasModifierProperty("static");
            return isStatic ? GroovySyntaxHighlighter.STATIC_FIELD : GroovySyntaxHighlighter.INSTANCE_FIELD;
        }
        if (resolved instanceof GrAccessorMethod) {
            boolean isStatic = ((GrAccessorMethod)resolved).hasModifierProperty("static");
            return isStatic ? GroovySyntaxHighlighter.STATIC_PROPERTY_REFERENCE : GroovySyntaxHighlighter.INSTANCE_PROPERTY_REFERENCE;
        }
        if (resolved instanceof PsiMethod) {
            if (GrHighlightUtil.isMethodWithLiteralName((PsiMethod)resolved)) {
                return null;
            }
            if (((PsiMethod)resolved).isConstructor()) {
                if (refElement != null) {
                    if (refElement.getNode().getElementType() == GroovyTokenTypes.kTHIS || refElement.getNode().getElementType() == GroovyTokenTypes.kSUPER) {
                        return null;
                    }
                    return GroovySyntaxHighlighter.CONSTRUCTOR_CALL;
                }
                return GroovySyntaxHighlighter.CONSTRUCTOR_DECLARATION;
            }
            boolean isStatic = ((PsiMethod)resolved).hasModifierProperty("static");
            if (GroovyPropertyUtils.isSimplePropertyAccessor((PsiMethod)resolved)) {
                return isStatic ? GroovySyntaxHighlighter.STATIC_PROPERTY_REFERENCE : GroovySyntaxHighlighter.INSTANCE_PROPERTY_REFERENCE;
            }
            if (refElement != null) {
                return isStatic ? GroovySyntaxHighlighter.STATIC_METHOD_ACCESS : GroovySyntaxHighlighter.METHOD_CALL;
            }
            return GroovySyntaxHighlighter.METHOD_DECLARATION;
        }
        if (resolved instanceof PsiTypeParameter) {
            return GroovySyntaxHighlighter.TYPE_PARAMETER;
        }
        if (resolved instanceof PsiClass) {
            if (((PsiClass)resolved).isAnnotationType()) {
                return GroovySyntaxHighlighter.ANNOTATION;
            }
            return GroovySyntaxHighlighter.CLASS_REFERENCE;
        }
        if (resolved instanceof GrParameter) {
            boolean reassigned = GrHighlightUtil.isReassigned((GrParameter)resolved);
            return reassigned ? GroovySyntaxHighlighter.REASSIGNED_PARAMETER : GroovySyntaxHighlighter.PARAMETER;
        }
        if (resolved instanceof GrVariable) {
            boolean reassigned = GrHighlightUtil.isReassigned((GrVariable)resolved);
            return reassigned ? GroovySyntaxHighlighter.REASSIGNED_LOCAL_VARIABLE : GroovySyntaxHighlighter.LOCAL_VARIABLE;
        }
        if (resolved instanceof GrLabeledStatement) {
            return GroovySyntaxHighlighter.LABEL;
        }
        return null;
    }

    private static boolean isMethodWithLiteralName(@Nullable PsiMethod method) {
        PsiElement nameIdentifier;
        return method instanceof GrMethod && GrHighlightUtil.isStringNameElement(nameIdentifier = ((GrMethod)method).getNameIdentifierGroovy());
    }

    private static boolean isReferenceWithLiteralName(@Nullable PsiElement ref) {
        PsiElement nameIdentifier;
        return ref instanceof GrReferenceExpression && (nameIdentifier = ((GrReferenceExpression)ref).getReferenceNameElement()) != null && GrHighlightUtil.isStringNameElement(nameIdentifier);
    }

    private static boolean isStringNameElement(@NotNull PsiElement nameIdentifier) {
        if (nameIdentifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameIdentifier", "org/jetbrains/plugins/groovy/annotator/GrHighlightUtil", "isStringNameElement"));
        }
        ASTNode node = nameIdentifier.getNode();
        if (node == null) {
            return false;
        }
        IElementType nameElementType = node.getElementType();
        return TokenSets.STRING_LITERAL_SET.contains(nameElementType);
    }

    public static boolean isDeclarationAssignment(GrReferenceExpression refExpr) {
        return GrHighlightUtil.isAssignmentLhs(refExpr) && GrHighlightUtil.isScriptPropertyAccess(refExpr);
    }

    private static boolean isAssignmentLhs(GrReferenceExpression refExpr) {
        return refExpr.getParent() instanceof GrAssignmentExpression && refExpr.equals(((GrAssignmentExpression)refExpr.getParent()).getLValue());
    }

    private static boolean isScriptPropertyAccess(GrReferenceExpression refExpr) {
        PsiClassType classType;
        PsiClass psiClass;
        GrExpression qualifier = refExpr.getQualifierExpression();
        if (qualifier == null) {
            PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)refExpr, PsiClass.class);
            return clazz == null;
        }
        PsiType type = qualifier.getType();
        return type instanceof PsiClassType && (!(qualifier instanceof GrReferenceExpression) || !(((GrReferenceExpression)qualifier).resolve() instanceof GroovyScriptClass)) && (psiClass = (classType = (PsiClassType)type).resolve()) instanceof GroovyScriptClass;
    }

    public static TextRange getMethodHeaderTextRange(PsiMethod method) {
        PsiModifierList modifierList = method.getModifierList();
        PsiParameterList parameterList = method.getParameterList();
        TextRange textRange = modifierList.getTextRange();
        LOG.assertTrue(textRange != null, (Object)(method.getClass() + ":" + method.getText()));
        int startOffset = textRange.getStartOffset();
        int endOffset = parameterList.getTextRange().getEndOffset() + 1;
        return new TextRange(startOffset, endOffset);
    }

    @NotNull
    public static PsiElement getElementToHighlight(@NotNull GrReferenceElement refElement) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "org/jetbrains/plugins/groovy/annotator/GrHighlightUtil", "getElementToHighlight"));
        }
        PsiElement refNameElement = refElement.getReferenceNameElement();
        Object object = refNameElement != null ? refNameElement : refElement;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/GrHighlightUtil", "getElementToHighlight"));
        }
        return object;
    }

    public static TextRange getClassHeaderTextRange(GrTypeDefinition clazz) {
        GrExtendsClause extendsClause;
        GrModifierList modifierList = clazz.getModifierList();
        int startOffset = modifierList != null ? modifierList.getTextOffset() : clazz.getTextOffset();
        GrImplementsClause implementsClause = clazz.getImplementsClause();
        int endOffset = implementsClause != null ? implementsClause.getTextRange().getEndOffset() : ((extendsClause = clazz.getExtendsClause()) != null ? extendsClause.getTextRange().getEndOffset() : clazz.getNameIdentifierGroovy().getTextRange().getEndOffset());
        return new TextRange(startOffset, endOffset);
    }

    public static TextRange getInitializerHeaderTextRange(GrClassInitializer initializer) {
        GrModifierList modifierList = initializer.getModifierList();
        GrOpenBlock block = initializer.getBlock();
        TextRange textRange = modifierList.getTextRange();
        LOG.assertTrue(textRange != null, (Object)(initializer.getClass() + ":" + initializer.getText()));
        int startOffset = textRange.getStartOffset();
        int endOffset = block.getLBrace().getTextRange().getEndOffset() + 1;
        return new TextRange(startOffset, endOffset);
    }

    @Nullable
    public static GrMember findClassMemberContainer(@NotNull GrReferenceExpression ref, @NotNull PsiClass aClass) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/annotator/GrHighlightUtil", "findClassMemberContainer"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/annotator/GrHighlightUtil", "findClassMemberContainer"));
        }
        for (PsiElement parent = ref.getParent(); parent != null && parent != aClass; parent = parent.getParent()) {
            if (!(parent instanceof GrMember) || ((GrMember)parent).getContainingClass() != aClass) continue;
            return (GrMember)parent;
        }
        return null;
    }
}

