/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcToolWindowDescriptor;

public class MvcModuleNode
extends AbstractModuleNode {
    private final MvcToolWindowDescriptor myDescriptor;

    public MvcModuleNode(@NotNull Module module, ViewSettings viewSettings, MvcToolWindowDescriptor descriptor) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/mvc/projectView/MvcModuleNode", "<init>"));
        }
        super(module.getProject(), module, viewSettings);
        this.myDescriptor = descriptor;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList<AbstractTreeNode> nodesList = new ArrayList<AbstractTreeNode>();
        Module module = (Module)this.getValue();
        ViewSettings viewSettings = this.getSettings();
        VirtualFile root = this.myDescriptor.getFramework().findAppRoot(module);
        if (root == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/projectView/MvcModuleNode", "getChildren"));
            }
            return list;
        }
        this.myDescriptor.fillModuleChildren(nodesList, module, viewSettings, root);
        ArrayList<AbstractTreeNode> arrayList = nodesList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/projectView/MvcModuleNode", "getChildren"));
        }
        return arrayList;
    }

    public void update(PresentationData presentation) {
        super.update(presentation);
        Module module = (Module)this.getValue();
        if (module == null || module.isDisposed()) {
            this.setValue(null);
            return;
        }
        presentation.setIcon(this.myDescriptor.getModuleNodeIcon());
    }
}

