/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLElementType;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLScalarList;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImpl;

public class YAMLScalarListImpl
extends YAMLBlockScalarImpl
implements YAMLScalarList {
    public YAMLScalarListImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/yaml/psi/impl/YAMLScalarListImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    protected IElementType getContentType() {
        YAMLElementType yAMLElementType = YAMLTokenTypes.SCALAR_LIST;
        if (yAMLElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLScalarListImpl", "getContentType"));
        }
        return yAMLElementType;
    }

    @Override
    @NotNull
    public String getTextValue() {
        String string = super.getTextValue() + "\n";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLScalarListImpl", "getTextValue"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getRangesJoiner(@NotNull CharSequence leftString, @NotNull CharSequence rightString) {
        if (leftString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftString", "org/jetbrains/yaml/psi/impl/YAMLScalarListImpl", "getRangesJoiner"));
        }
        if (rightString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightString", "org/jetbrains/yaml/psi/impl/YAMLScalarListImpl", "getRangesJoiner"));
        }
        if ("\n" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLScalarListImpl", "getRangesJoiner"));
        }
        return "\n";
    }

    @Override
    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "org/jetbrains/yaml/psi/impl/YAMLScalarListImpl", "getEncodeReplacements"));
        }
        if (!StringUtil.endsWithChar((CharSequence)input, (char)'\n')) {
            throw new IllegalArgumentException("Should end with a line break");
        }
        int indent = this.locateIndent();
        if (indent == 0) {
            indent = YAMLUtil.getIndentToThisElement((PsiElement)this) + 2;
        }
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indent);
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != '\n') continue;
            result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\n" + indentString)));
        }
        return result;
    }

    @Override
    public String toString() {
        return "YAML scalar list";
    }
}

