/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UType;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;

public class DateFormatDetector
extends Detector
implements UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(DateFormatDetector.class, Scope.SOURCE_FILE_SCOPE);
    public static final Issue DATE_FORMAT = Issue.create("SimpleDateFormat", "Implied locale in date format", "Almost all callers should use `getDateInstance()`, `getDateTimeInstance()`, or `getTimeInstance()` to get a ready-made instance of SimpleDateFormat suitable for the user's locale. The main reason you'd create an instance this class directly is because you need to format/parse a specific machine-readable format, in which case you almost certainly want to explicitly ask for US to ensure that you get ASCII digits (rather than, say, Arabic digits).\n\nTherefore, you should either use the form of the SimpleDateFormat constructor where you pass in an explicit locale, such as Locale.US, or use one of the get instance methods, or suppress this error if really know what you are doing.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/reference/java/text/SimpleDateFormat.html");
    public static final String LOCALE_CLS = "java.util.Locale";
    public static final String SIMPLE_DATE_FORMAT_CLS = "java.text.SimpleDateFormat";

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    @Nullable
    public List<String> getApplicableConstructorTypes() {
        return Collections.singletonList(SIMPLE_DATE_FORMAT_CLS);
    }

    @Override
    public void visitConstructor(UastAndroidContext context, UCallExpression functionCall, UFunction constructor) {
        if (!DateFormatDetector.specifiesLocale(constructor)) {
            Location location = context.getLocation(functionCall);
            String message2 = "To get local formatting use `getDateInstance()`, `getDateTimeInstance()`, or `getTimeInstance()`, or use `new SimpleDateFormat(String template, Locale locale)` with for example `Locale.US` for ASCII dates.";
            context.report(DATE_FORMAT, functionCall, location, message2);
        }
    }

    private static boolean specifiesLocale(@NonNull UFunction method) {
        int n = method.getValueParameterCount();
        for (int i = 0; i < n; ++i) {
            UType parameterType = method.getValueParameters().get(i).getType();
            if (!parameterType.matchesFqName(LOCALE_CLS)) continue;
            return true;
        }
        return false;
    }
}

