/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UType;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastClassKind;
import org.jetbrains.uast.UastModifier;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class ParcelDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("ParcelCreator", "Missing Parcelable `CREATOR` field", "According to the `Parcelable` interface documentation, \"Classes implementing the Parcelable interface must also have a static field called `CREATOR`, which is an object implementing the `Parcelable.Creator` interface.", Category.USABILITY, 3, Severity.ERROR, new Implementation(ParcelDetector.class, Scope.SOURCE_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/os/Parcelable.html");

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public UastVisitor createUastVisitor(UastAndroidContext context) {
        return new ParcelVisitor(context);
    }

    private static class ParcelVisitor
    extends AbstractUastVisitor {
        private final UastAndroidContext mContext;

        public ParcelVisitor(UastAndroidContext context) {
            this.mContext = context;
        }

        @Override
        public boolean visitClass(@NotNull UClass node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/ParcelDetector$ParcelVisitor", "visitClass"));
            }
            if (node.getKind() != UastClassKind.CLASS || node.hasModifier(UastModifier.ABSTRACT)) {
                return true;
            }
            for (UType reference : node.getSuperTypes()) {
                String name2 = reference.getName();
                if (!name2.equals("Parcelable")) continue;
                UVariable field = UastUtils.findStaticMemberOfType(node, "CREATOR", UVariable.class);
                boolean hasField = field != null && field.hasModifier(UastModifier.JVM_FIELD) && field.hasModifier(UastModifier.STATIC);
                boolean hasNamedCompanionObject = false;
                if (!hasField) {
                    for (UClass companion : node.getCompanions()) {
                        if (!companion.getName().equals("CREATOR")) continue;
                        hasNamedCompanionObject = true;
                        break;
                    }
                }
                if (hasField || hasNamedCompanionObject) continue;
                UClass parcelable = reference.resolve(this.mContext);
                if (parcelable != null && !parcelable.isSubclassOf("android.os.Parcelable")) {
                    return true;
                }
                Location location = this.mContext.getLocation(node.getNameElement());
                this.mContext.report(ISSUE, node, location, "This class implements `Parcelable` but does not provide a `CREATOR` field");
            }
            return true;
        }
    }
}

