/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceType;
import com.android.tools.klint.checks.PermissionHolder;
import com.android.tools.klint.checks.PermissionRequirement;
import com.android.tools.klint.client.api.LintClient;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Project;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFqNamed;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleReferenceExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UType;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastOperator;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;
import org.jetbrains.uast.java.JavaUFunction;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SupportAnnotationDetector
extends Detector
implements UastScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(SupportAnnotationDetector.class, Scope.SOURCE_FILE_SCOPE);
    public static final Issue RANGE = Issue.create("Range", "Outside Range", "Some parameters are required to in a particular numerical range; this check makes sure that arguments passed fall within the range. For arrays, Strings and collections this refers to the size or length.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION);
    public static final Issue RESOURCE_TYPE = Issue.create("ResourceType", "Wrong Resource Type", "Ensures that resource id's passed to APIs are of the right type; for example, calling `Resources.getColor(R.string.name)` is wrong.", Category.CORRECTNESS, 7, Severity.FATAL, IMPLEMENTATION);
    public static final Issue COLOR_USAGE = Issue.create("ResourceAsColor", "Should pass resolved color instead of resource id", "Methods that take a color in the form of an integer should be passed an RGB triple, not the actual color resource id. You must call `getResources().getColor(resource)` to resolve the actual color value first.", Category.CORRECTNESS, 7, Severity.ERROR, IMPLEMENTATION);
    public static final Issue TYPE_DEF = Issue.create("WrongConstant", "Incorrect constant", "Ensures that when parameter in a method only allows a specific set of constants, calls obey those rules.", Category.SECURITY, 6, Severity.ERROR, IMPLEMENTATION);
    public static final Issue CHECK_RESULT = Issue.create("CheckResult", "Ignoring results", "Some methods have no side effects, an calling them without doing something without the result is suspicious. ", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
    public static final Issue CHECK_PERMISSION = Issue.create("UseCheckPermission", "Using the result of check permission calls", "You normally want to use the result of checking a permission; these methods return whether the permission is held; they do not throw an error if the permission is not granted. Code which does not do anything with the return value probably meant to be calling the enforce methods instead, e.g. rather than `Context#checkCallingPermission` it should call `Context#enforceCallingPermission`.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION);
    public static final Issue MISSING_PERMISSION = Issue.create("MissingPermission", "Missing Permissions", "This check scans through your code and libraries and looks at the APIs being used, and checks this against the set of permissions required to access those APIs. If the code using those APIs is called at runtime, then the program will crash.\n\nFurthermore, for permissions that are revocable (with targetSdkVersion 23), client code must also be prepared to handle the calls throwing an exception if the user rejects the request for permission at runtime.", Category.CORRECTNESS, 9, Severity.ERROR, IMPLEMENTATION);
    public static final Issue THREAD = Issue.create("WrongThread", "Wrong Thread", "Ensures that a method which expects to be called on a specific thread, is actually called from that thread. For example, calls on methods in widgets should always be made on the UI thread.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/components/processes-and-threads.html#Threads");
    public static final String CHECK_RESULT_ANNOTATION = "android.support.annotation.CheckResult";
    public static final String COLOR_INT_ANNOTATION = "android.support.annotation.ColorInt";
    public static final String INT_RANGE_ANNOTATION = "android.support.annotation.IntRange";
    public static final String FLOAT_RANGE_ANNOTATION = "android.support.annotation.FloatRange";
    public static final String SIZE_ANNOTATION = "android.support.annotation.Size";
    public static final String PERMISSION_ANNOTATION = "android.support.annotation.RequiresPermission";
    public static final String UI_THREAD_ANNOTATION = "android.support.annotation.UiThread";
    public static final String MAIN_THREAD_ANNOTATION = "android.support.annotation.MainThread";
    public static final String WORKER_THREAD_ANNOTATION = "android.support.annotation.WorkerThread";
    public static final String BINDER_THREAD_ANNOTATION = "android.support.annotation.BinderThread";
    public static final String RES_SUFFIX = "Res";
    public static final String THREAD_SUFFIX = "Thread";
    public static final String ATTR_SUGGEST = "suggest";
    public static final String ATTR_TO = "to";
    public static final String ATTR_FROM = "from";
    public static final String ATTR_FROM_INCLUSIVE = "fromInclusive";
    public static final String ATTR_TO_INCLUSIVE = "toInclusive";
    public static final String ATTR_MULTIPLE = "multiple";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_ALL_OF = "allOf";
    public static final String ATTR_ANY_OF = "anyOf";
    public static final String ATTR_CONDITIONAL = "conditional";
    public static final ResourceType COLOR_INT_MARKER_TYPE = ResourceType.PUBLIC;
    private PermissionHolder mPermissions;

    private void checkMethodAnnotation(@NonNull UastAndroidContext context, @NonNull UFunction method, @NonNull UCallExpression node, @NonNull UAnnotation annotation) {
        String signature = annotation.getFqName();
        if (signature == null) {
            return;
        }
        if (CHECK_RESULT_ANNOTATION.equals(signature) || signature.endsWith(".CheckReturnValue")) {
            SupportAnnotationDetector.checkResult(context, node, annotation);
        } else if (signature.equals(PERMISSION_ANNOTATION)) {
            this.checkPermission(context, node, method, annotation);
        } else if (signature.endsWith(THREAD_SUFFIX) && signature.startsWith("android.support.annotation.")) {
            SupportAnnotationDetector.checkThreading(context, node, method, signature);
        }
    }

    private static void checkParameterAnnotation(@NonNull UastAndroidContext context, @NonNull UElement argument, @NonNull UAnnotation annotation) {
        String signature = annotation.getFqName();
        if (signature == null) {
            return;
        }
        if (COLOR_INT_ANNOTATION.equals(signature)) {
            SupportAnnotationDetector.checkColor(context, argument);
        } else if (signature.equals(INT_RANGE_ANNOTATION)) {
            SupportAnnotationDetector.checkIntRange(context, annotation, argument);
        } else if (signature.equals(FLOAT_RANGE_ANNOTATION)) {
            SupportAnnotationDetector.checkFloatRange(context, annotation, argument);
        } else if (signature.equals(SIZE_ANNOTATION)) {
            SupportAnnotationDetector.checkSize(context, annotation, argument);
        } else if (signature.equals("android.support.annotation.IntDef")) {
            boolean flag = annotation.getValue("flag") == Boolean.TRUE;
            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, null, flag);
        } else if (signature.equals("android.support.annotation.StringDef")) {
            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, null, false);
        } else if (signature.endsWith(RES_SUFFIX)) {
            String typeString = signature.substring("android.support.annotation.".length(), signature.length() - RES_SUFFIX.length()).toLowerCase(Locale.US);
            ResourceType type2 = ResourceType.getEnum((String)typeString);
            if (type2 != null) {
                SupportAnnotationDetector.checkResourceType(context, argument, type2);
            } else if (typeString.equals("any")) {
                SupportAnnotationDetector.checkResourceType(context, argument, null);
            }
        }
    }

    private static void checkColor(@NonNull UastAndroidContext context, @NonNull UElement argument) {
        if (argument instanceof UIfExpression) {
            UIfExpression expression2 = (UIfExpression)argument;
            if (expression2.isTernary()) {
                SupportAnnotationDetector.checkColor(context, expression2.getThenBranch());
                SupportAnnotationDetector.checkColor(context, expression2.getElseBranch());
            }
            return;
        }
        List<ResourceType> types2 = SupportAnnotationDetector.getResourceTypes(context, argument);
        if (types2 != null && types2.contains(ResourceType.COLOR)) {
            String message2 = String.format("Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`", argument.toString());
            context.report(COLOR_USAGE, argument, context.getLocation(argument), message2);
        }
    }

    private void checkPermission(@NonNull UastAndroidContext context, @NonNull UCallExpression node, @NonNull UFunction method, @NonNull UAnnotation annotation) {
        PermissionRequirement requirement = PermissionRequirement.create(context, annotation);
        if (requirement.isConditional()) {
            return;
        }
        PermissionHolder permissions = this.getPermissions(context.getLintContext());
        if (!requirement.isSatisfied(permissions)) {
            UClass containingClass;
            if (!requirement.isSatisfied(permissions = SupportAnnotationDetector.addLocalPermissions(context, permissions, node)) && (containingClass = UastUtils.getContainingClass(method)) != null) {
                String name2 = containingClass.getName() + "." + method.getName();
                String message2 = SupportAnnotationDetector.getMissingPermissionMessage(requirement, name2, permissions);
                context.report(MISSING_PERMISSION, node, context.getLocation(node), message2);
            }
        } else if (requirement.isRevocable(permissions) && context.getLintContext().getMainProject().getTargetSdkVersion().getFeatureLevel() >= 23) {
            UFunction methodNode;
            UFunction declaration2;
            UTryExpression tryCatch;
            boolean handlesMissingPermission = false;
            UExpression parent = node;
            while ((tryCatch = UastUtils.getParentOfType(parent, UTryExpression.class)) != null) {
                block1: for (UCatchClause aCatch : tryCatch.getCatchClauses()) {
                    for (UType catchType : aCatch.getTypes()) {
                        if (!SupportAnnotationDetector.isSecurityException(catchType)) continue;
                        handlesMissingPermission = true;
                        continue block1;
                    }
                }
                parent = tryCatch;
            }
            if (!handlesMissingPermission && (declaration2 = UastUtils.getParentOfType(parent, UFunction.class)) instanceof JavaUFunction) {
                List<UType> thrownExceptions2 = ((JavaUFunction)declaration2).getThrownExceptions();
                for (UType typeReference : thrownExceptions2) {
                    if (!SupportAnnotationDetector.isSecurityException(typeReference)) continue;
                    handlesMissingPermission = true;
                    break;
                }
            }
            if (!handlesMissingPermission && (methodNode = UastUtils.getContainingFunction(node)) != null) {
                CheckPermissionVisitor visitor2 = new CheckPermissionVisitor(node);
                methodNode.accept(visitor2);
                handlesMissingPermission = visitor2.checksPermission();
            }
            if (!handlesMissingPermission) {
                String message3 = SupportAnnotationDetector.getUnhandledPermissionMessage();
                context.report(MISSING_PERMISSION, node, context.getLocation(node), message3);
            }
        }
    }

    @NonNull
    private static PermissionHolder addLocalPermissions(@NonNull UastAndroidContext context, @NonNull PermissionHolder permissions, @NonNull UElement node) {
        UFunction method = UastUtils.getContainingFunction(node);
        if (method == null) {
            return permissions;
        }
        UAnnotation annotation = UastUtils.findAnnotation(method, PERMISSION_ANNOTATION);
        permissions = SupportAnnotationDetector.mergeAnnotationPermissions(context, permissions, annotation);
        annotation = UastUtils.findAnnotation(UastUtils.getContainingClassOrEmpty(method), PERMISSION_ANNOTATION);
        permissions = SupportAnnotationDetector.mergeAnnotationPermissions(context, permissions, annotation);
        return permissions;
    }

    @NonNull
    private static PermissionHolder mergeAnnotationPermissions(@NonNull UastAndroidContext context, @NonNull PermissionHolder permissions, @Nullable UAnnotation annotation) {
        if (annotation != null) {
            PermissionRequirement requirement = PermissionRequirement.create(context, annotation);
            permissions = PermissionHolder.SetPermissionLookup.join(permissions, requirement);
        }
        return permissions;
    }

    public static String getMissingPermissionMessage(@NonNull PermissionRequirement requirement, @NonNull String callName, @NonNull PermissionHolder permissions) {
        return String.format("Missing permissions required by %1$s: %2$s", callName, requirement.describeMissingPermissions(permissions));
    }

    public static String getUnhandledPermissionMessage() {
        return "Call requires permission which may be rejected by user: code should explicitly check to see if permission is available (with `checkPermission`) or handle a potential `SecurityException`";
    }

    private static boolean isSecurityException(@NonNull UType type2) {
        return type2 != null && (type2.matchesFqName("java.lang.SecurityException") || type2.matchesFqName("java.lang.RuntimeException") || type2.matchesFqName("java.lang.Exception") || type2.matchesFqName("java.lang.Throwable"));
    }

    private PermissionHolder getPermissions(@NonNull UastAndroidContext context) {
        if (this.mPermissions == null) {
            HashSet permissions = Sets.newHashSetWithExpectedSize((int)30);
            HashSet revocable = Sets.newHashSetWithExpectedSize((int)4);
            JavaContext lintContext = context.getLintContext();
            LintClient client = lintContext.getClient();
            Project mainProject = lintContext.getMainProject();
            for (File manifest : mainProject.getManifestFiles()) {
                SupportAnnotationDetector.addPermissions(client, permissions, revocable, manifest);
            }
            for (Project library : mainProject.getAllLibraries()) {
                for (File manifest : library.getManifestFiles()) {
                    SupportAnnotationDetector.addPermissions(client, permissions, revocable, manifest);
                }
            }
            this.mPermissions = new PermissionHolder.SetPermissionLookup(permissions, revocable);
        }
        return this.mPermissions;
    }

    private static void addPermissions(@NonNull LintClient client, @NonNull Set<String> permissions, @NonNull Set<String> revocable, @NonNull File manifest) {
        Document document = XmlUtils.parseDocumentSilently((String)client.readFile(manifest), (boolean)true);
        if (document == null) {
            return;
        }
        Element root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        NodeList children = root.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            String name2;
            String protectionLevel;
            Element element;
            Node item = children.item(i);
            if (item.getNodeType() != 1) continue;
            String nodeName = item.getNodeName();
            if (nodeName.equals("uses-permission")) {
                element = (Element)item;
                String name3 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                if (name3.isEmpty()) continue;
                permissions.add(name3);
                continue;
            }
            if (!nodeName.equals("permission") || !"dangerous".equals(protectionLevel = (element = (Element)item).getAttributeNS("http://schemas.android.com/apk/res/android", "protectionLevel")) || (name2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).isEmpty()) continue;
            revocable.add(name2);
        }
    }

    private static void checkResult(@NonNull UastAndroidContext context, @NonNull UCallExpression node, @NonNull UAnnotation annotation) {
        if (node.getParent() instanceof UExpression) {
            String methodName = node.getFunctionName();
            assert (methodName != null);
            Object suggested = annotation.getValue(ATTR_SUGGEST);
            Issue issue = CHECK_RESULT;
            if (methodName.startsWith("check") && methodName.contains("Permission")) {
                issue = CHECK_PERMISSION;
            }
            String message2 = String.format("The result of `%1$s` is not used", methodName);
            if (suggested != null) {
                message2 = String.format("The result of `%1$s` is not used; did you mean to call `%2$s`?", methodName, suggested.toString());
            }
            context.report(issue, node, context.getLocation(node), message2);
        }
    }

    private static void checkThreading(@NonNull UastAndroidContext context, @NonNull UCallExpression node, @NonNull UFunction method, @NonNull String annotation) {
        String threadContext = SupportAnnotationDetector.getThreadContext(context, node);
        if (threadContext != null && !SupportAnnotationDetector.isCompatibleThread(threadContext, annotation)) {
            String message2 = String.format("Method %1$s must be called from the `%2$s` thread, currently inferred thread is `%3$s` thread", method.getName(), SupportAnnotationDetector.describeThread(annotation), SupportAnnotationDetector.describeThread(threadContext));
            context.report(THREAD, node, context.getLocation(node), message2);
        }
    }

    @NonNull
    public static String describeThread(@NonNull String annotation) {
        if (UI_THREAD_ANNOTATION.equals(annotation)) {
            return "UI";
        }
        if (MAIN_THREAD_ANNOTATION.equals(annotation)) {
            return "main";
        }
        if (BINDER_THREAD_ANNOTATION.equals(annotation)) {
            return "binder";
        }
        if (WORKER_THREAD_ANNOTATION.equals(annotation)) {
            return "worker";
        }
        return "other";
    }

    public static boolean isCompatibleThread(@NonNull String thread1, @NonNull String thread2) {
        if (thread1.equals(thread2)) {
            return true;
        }
        return thread1.equals(UI_THREAD_ANNOTATION) ? thread2.equals(MAIN_THREAD_ANNOTATION) : thread1.equals(MAIN_THREAD_ANNOTATION) && thread2.equals(UI_THREAD_ANNOTATION);
    }

    @Nullable
    private static String getThreadContext(@NonNull UastAndroidContext context, @NonNull UCallExpression methodCall) {
        UFunction method = UastUtils.getContainingFunction(methodCall);
        if (method != null) {
            String name2;
            UClass cls = UastUtils.getContainingClass(method);
            while (method != null) {
                for (UAnnotation annotation : method.getAnnotations()) {
                    name2 = annotation.getFqName();
                    if (name2 == null || !name2.startsWith("android.support.annotation.") || !name2.endsWith(THREAD_SUFFIX)) continue;
                    return name2;
                }
                List<UFunction> superFunctions = method.getSuperFunctions(context);
                if (superFunctions.isEmpty()) {
                    method = null;
                    continue;
                }
                method = superFunctions.get(0);
            }
            while (cls != null) {
                for (UAnnotation annotation : cls.getAnnotations()) {
                    name2 = annotation.getFqName();
                    if (name2 == null || !name2.startsWith("android.support.annotation.") || !name2.endsWith(THREAD_SUFFIX)) continue;
                    return name2;
                }
                cls = cls.getSuperClass(context);
            }
        }
        return null;
    }

    private static boolean isNumber(@NonNull UElement argument) {
        return UastLiteralUtils.isIntegralLiteral(argument) || argument instanceof UPrefixExpression && ((UPrefixExpression)argument).getOperator() == UastPrefixOperator.UNARY_MINUS && UastLiteralUtils.isIntegralLiteral(((UPrefixExpression)argument).getOperand());
    }

    private static boolean isZero(@NonNull UElement argument) {
        return UastLiteralUtils.isIntegralLiteral(argument) && UastLiteralUtils.getLongValue((ULiteralExpression)argument) == 0L;
    }

    private static boolean isMinusOne(@NonNull UElement argument) {
        return argument instanceof UUnaryExpression && ((UUnaryExpression)argument).getOperator() == UastPrefixOperator.UNARY_MINUS && UastLiteralUtils.isIntegralLiteral(((UUnaryExpression)argument).getOperand()) && UastLiteralUtils.getLongValue((ULiteralExpression)((UUnaryExpression)argument).getOperand()) == 1L;
    }

    private static void checkResourceType(@NonNull UastAndroidContext context, @NonNull UElement argument, @Nullable ResourceType expectedType) {
        List<ResourceType> actual = SupportAnnotationDetector.getResourceTypes(context, argument);
        if (actual == null && (!SupportAnnotationDetector.isNumber(argument) || SupportAnnotationDetector.isZero(argument) || SupportAnnotationDetector.isMinusOne(argument))) {
            return;
        }
        if (actual != null && (expectedType == null || actual.contains(expectedType) || expectedType == ResourceType.DRAWABLE && (actual.contains(ResourceType.COLOR) || actual.contains(ResourceType.MIPMAP)))) {
            return;
        }
        String message2 = actual != null && actual.size() == 1 && actual.get(0) == COLOR_INT_MARKER_TYPE ? "Expected a color resource id (`R.color.`) but received an RGB integer" : (expectedType == COLOR_INT_MARKER_TYPE ? String.format("Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`", argument.toString()) : (expectedType != null ? String.format("Expected resource of type %1$s", expectedType.getName()) : "Expected resource identifier (`R`.type.`name`)"));
        context.report(RESOURCE_TYPE, argument, context.getLocation(argument), message2);
    }

    @Nullable
    private static List<ResourceType> getResourceTypes(@NonNull UastAndroidContext context, @NonNull UElement argument) {
        UFunction resolved;
        if (argument instanceof UQualifiedExpression) {
            UQualifiedExpression select;
            UExpression typeOperand;
            UElement grandParent;
            UElement parent;
            UQualifiedExpression node = (UQualifiedExpression)argument;
            if (node.getReceiver() instanceof UQualifiedExpression) {
                USimpleReferenceExpression reference;
                UQualifiedExpression innerSelect;
                UQualifiedExpression select2 = (UQualifiedExpression)node.getReceiver();
                if (select2.getReceiver() instanceof UQualifiedExpression && UastUtils.matchesQualified((innerSelect = (UQualifiedExpression)select2.getReceiver()).getSelector(), "R")) {
                    String typeName = select2.getSelector().renderString();
                    ResourceType type2 = ResourceType.getEnum((String)typeName);
                    return type2 != null ? Collections.singletonList(type2) : null;
                }
                if (select2.getReceiver() instanceof USimpleReferenceExpression && (reference = (USimpleReferenceExpression)select2.getReceiver()).getIdentifier().equals("R")) {
                    String typeName = select2.getSelector().renderString();
                    ResourceType type3 = ResourceType.getEnum((String)typeName);
                    return type3 != null ? Collections.singletonList(type3) : null;
                }
            }
            if (UastUtils.matchesQualified(node.getSelector(), "R") && (parent = node.getParent()) instanceof UQualifiedExpression && (grandParent = parent.getParent()) instanceof UQualifiedExpression && (typeOperand = (select = (UQualifiedExpression)grandParent).getReceiver()) instanceof UQualifiedExpression) {
                UQualifiedExpression typeSelect = (UQualifiedExpression)typeOperand;
                String typeName = typeSelect.getSelector().renderString();
                ResourceType type4 = ResourceType.getEnum((String)typeName);
                return type4 != null ? Collections.singletonList(type4) : null;
            }
        } else if (argument instanceof UCallExpression && (resolved = ((UCallExpression)argument).resolve(context)) != null) {
            List<UAnnotation> annotations2 = ((UAnnotated)resolved).getAnnotations();
            for (UAnnotation annotation : annotations2) {
                String signature = annotation.getFqName();
                if (COLOR_INT_ANNOTATION.equals(signature)) {
                    return Collections.singletonList(COLOR_INT_MARKER_TYPE);
                }
                if (signature == null || !signature.endsWith(RES_SUFFIX) || !signature.startsWith("android.support.annotation.")) continue;
                String typeString = signature.substring("android.support.annotation.".length(), signature.length() - RES_SUFFIX.length()).toLowerCase(Locale.US);
                ResourceType type5 = ResourceType.getEnum((String)typeString);
                if (type5 != null) {
                    return Collections.singletonList(type5);
                }
                if (!typeString.equals("any")) continue;
                ResourceType[] types2 = ResourceType.values();
                ArrayList result = Lists.newArrayListWithExpectedSize((int)types2.length);
                for (ResourceType t : types2) {
                    if (t == COLOR_INT_MARKER_TYPE) continue;
                    result.add(t);
                }
                return result;
            }
        }
        return null;
    }

    private static void checkIntRange(@NonNull UastAndroidContext context, @NonNull UAnnotation annotation, @NonNull UElement argument) {
        long to;
        long from;
        Object object = null;
        if (argument instanceof UExpression) {
            object = ((UExpression)argument).evaluate();
        }
        if (!(object instanceof Number)) {
            return;
        }
        long value2 = ((Number)object).longValue();
        String message2 = SupportAnnotationDetector.getIntRangeError(value2, from = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_FROM, Long.MIN_VALUE), to = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_TO, Long.MAX_VALUE));
        if (message2 != null) {
            context.report(RANGE, argument, context.getLocation(argument), message2);
        }
    }

    private static String getIntRangeError(long value2, long from, long to) {
        String message2 = null;
        if (value2 < from || value2 > to) {
            StringBuilder sb = new StringBuilder(20);
            if (value2 < from) {
                sb.append("Value must be \u2265 ");
                sb.append(Long.toString(from));
            } else {
                assert (value2 > to);
                sb.append("Value must be \u2264 ");
                sb.append(Long.toString(to));
            }
            sb.append(" (was ").append(value2).append(')');
            message2 = sb.toString();
        }
        return message2;
    }

    private static void checkFloatRange(@NonNull UastAndroidContext context, @NonNull UAnnotation annotation, @NonNull UElement argument) {
        boolean toInclusive;
        boolean fromInclusive;
        double to;
        double from;
        Object object = null;
        if (argument instanceof UExpression) {
            object = ((UExpression)argument).evaluate();
        }
        if (!(object instanceof Number)) {
            return;
        }
        double value2 = ((Number)object).doubleValue();
        String message2 = SupportAnnotationDetector.getFloatRangeError(value2, from = SupportAnnotationDetector.getDoubleAttribute(annotation, ATTR_FROM, Double.NEGATIVE_INFINITY), to = SupportAnnotationDetector.getDoubleAttribute(annotation, ATTR_TO, Double.POSITIVE_INFINITY), fromInclusive = SupportAnnotationDetector.getBoolean(annotation, ATTR_FROM_INCLUSIVE, true), toInclusive = SupportAnnotationDetector.getBoolean(annotation, ATTR_TO_INCLUSIVE, true), argument);
        if (message2 != null) {
            context.report(RANGE, argument, context.getLocation(argument), message2);
        }
    }

    @Nullable
    private static String getFloatRangeError(double value2, double from, double to, boolean fromInclusive, boolean toInclusive, @NonNull UElement node) {
        if (!((fromInclusive && value2 >= from || !fromInclusive && value2 > from) && (toInclusive && value2 <= to || !toInclusive && value2 < to))) {
            StringBuilder sb = new StringBuilder(20);
            if (from != Double.NEGATIVE_INFINITY) {
                if (to != Double.POSITIVE_INFINITY) {
                    if (fromInclusive && value2 < from || !fromInclusive && value2 <= from) {
                        sb.append("Value must be ");
                        if (fromInclusive) {
                            sb.append('\u2265');
                        } else {
                            sb.append('>');
                        }
                        sb.append(' ');
                        sb.append(Double.toString(from));
                    } else {
                        assert (toInclusive && value2 > to || !toInclusive && value2 >= to);
                        sb.append("Value must be ");
                        if (toInclusive) {
                            sb.append('\u2264');
                        } else {
                            sb.append('<');
                        }
                        sb.append(' ');
                        sb.append(Double.toString(to));
                    }
                } else {
                    sb.append("Value must be ");
                    if (fromInclusive) {
                        sb.append('\u2265');
                    } else {
                        sb.append('>');
                    }
                    sb.append(' ');
                    sb.append(Double.toString(from));
                }
            } else if (to != Double.POSITIVE_INFINITY) {
                sb.append("Value must be ");
                if (toInclusive) {
                    sb.append('\u2264');
                } else {
                    sb.append('<');
                }
                sb.append(' ');
                sb.append(Double.toString(to));
            }
            sb.append(" (was ");
            if (UastLiteralUtils.isNumberLiteral(node)) {
                String str = ((ULiteralExpression)node).getValue().toString();
                sb.append(str);
            } else {
                sb.append(value2);
            }
            sb.append(')');
            return sb.toString();
        }
        return null;
    }

    private static void checkSize(@NonNull UastAndroidContext context, @NonNull UAnnotation annotation, @NonNull UElement argument) {
        int actual;
        if (UastLiteralUtils.isStringLiteral(argument)) {
            ULiteralExpression literal = (ULiteralExpression)argument;
            String s = (String)literal.getValue();
            assert (s != null);
            actual = s.length();
        } else if (argument instanceof UCallExpression && ((UCallExpression)argument).getKind() == UastCallKind.ARRAY_INITIALIZER) {
            UCallExpression initializer2 = (UCallExpression)argument;
            actual = initializer2.getValueArgumentCount();
        } else {
            return;
        }
        long exact = SupportAnnotationDetector.getLongAttribute(annotation, "value", -1L);
        long min = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_MIN, Long.MIN_VALUE);
        long max = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_MAX, Long.MAX_VALUE);
        long multiple = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_MULTIPLE, 1L);
        boolean isString = argument instanceof ULiteralExpression;
        String unit = isString ? "length" : "size";
        String message2 = SupportAnnotationDetector.getSizeError(actual, exact, min, max, multiple, unit);
        if (message2 != null) {
            context.report(RANGE, argument, context.getLocation(argument), message2);
        }
    }

    private static String getSizeError(long actual, long exact, long min, long max, long multiple, @NonNull String unit) {
        String message2 = null;
        if (exact != -1L) {
            if (exact != actual) {
                message2 = String.format("Expected %1$s %2$d (was %3$d)", unit, exact, actual);
            }
        } else if (actual < min || actual > max) {
            StringBuilder sb = new StringBuilder(20);
            if (actual < min) {
                sb.append("Expected ").append(unit).append(" \u2265 ");
                sb.append(Long.toString(min));
            } else {
                assert (actual > max);
                sb.append("Expected ").append(unit).append(" \u2264 ");
                sb.append(Long.toString(max));
            }
            sb.append(" (was ").append(actual).append(')');
            message2 = sb.toString();
        } else if (actual % multiple != 0L) {
            message2 = String.format("Expected %1$s to be a multiple of %2$d (was %3$d and should be either %4$d or %5$d)", unit, multiple, actual, actual / multiple * multiple, (actual / multiple + 1L) * multiple);
        }
        return message2;
    }

    private static void checkTypeDefConstant(@NonNull UastAndroidContext context, @NonNull UAnnotation annotation, @NonNull UElement argument, @Nullable UElement errorNode, boolean flag) {
        UDeclaration resolved;
        if (UastLiteralUtils.isNullLiteral(argument)) {
            return;
        }
        if (UastLiteralUtils.isStringLiteral(argument)) {
            ULiteralExpression string = (ULiteralExpression)argument;
            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode, false, string.getValue());
        } else if (UastLiteralUtils.isIntegralLiteral(argument)) {
            ULiteralExpression literal = (ULiteralExpression)argument;
            long value2 = UastLiteralUtils.getLongValue(literal);
            if (flag && value2 == 0L) {
                return;
            }
            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode, flag, (int)value2);
        } else if (SupportAnnotationDetector.isMinusOne(argument)) {
            if (!flag) {
                SupportAnnotationDetector.reportTypeDef(context, annotation, argument, errorNode);
            }
        } else if (argument instanceof UIfExpression) {
            UIfExpression expression2 = (UIfExpression)argument;
            if (expression2.getThenBranch() != null) {
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, expression2.getThenBranch(), errorNode, flag);
            }
            if (expression2.getElseBranch() != null) {
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, expression2.getElseBranch(), errorNode, flag);
            }
        } else if (argument instanceof UUnaryExpression) {
            UUnaryExpression expression3 = (UUnaryExpression)argument;
            UastOperator operator2 = expression3.getOperator();
            if (flag) {
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, expression3.getOperand(), errorNode, true);
            } else if (operator2 == UastPrefixOperator.BITWISE_NOT) {
                context.report(TYPE_DEF, expression3, context.getLocation(expression3), "Flag not allowed here");
            }
        } else if (argument instanceof UBinaryExpression) {
            UBinaryExpression expression4 = (UBinaryExpression)argument;
            if (flag) {
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, expression4.getLeftOperand(), errorNode, true);
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, expression4.getRightOperand(), errorNode, true);
            } else {
                UastBinaryOperator operator3 = expression4.getOperator();
                if (operator3 == UastBinaryOperator.BITWISE_AND || operator3 == UastBinaryOperator.BITWISE_OR || operator3 == UastBinaryOperator.BITWISE_XOR) {
                    context.report(TYPE_DEF, expression4, context.getLocation(expression4), "Flag not allowed here");
                }
            }
        } else if (argument instanceof UResolvable && (resolved = ((UResolvable)((Object)argument)).resolve(context)) instanceof UVariable) {
            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode, flag, resolved);
        }
    }

    private static void checkTypeDefConstant(@NonNull UastAndroidContext context, @NonNull UAnnotation annotation, @NonNull UElement argument, @Nullable UElement errorNode, boolean flag, Object value2) {
        for (UNamedExpression namedExpression : annotation.getValueArguments()) {
            UExpression expression2 = namedExpression.getExpression();
            if (!(expression2 instanceof UCallExpression) || ((UCallExpression)expression2).getKind() != UastCallKind.ARRAY_INITIALIZER) continue;
            for (UExpression arg : ((UCallExpression)expression2).getValueArguments()) {
                if (!value2.equals(arg.evaluate())) continue;
                return;
            }
        }
        SupportAnnotationDetector.reportTypeDef(context, argument, errorNode, flag, annotation.getValues());
    }

    private static void reportTypeDef(@NonNull UastAndroidContext context, @NonNull UAnnotation annotation, @NonNull UElement argument, @Nullable UElement errorNode) {
        List<Pair<String, Object>> allowed = annotation.getValues();
        SupportAnnotationDetector.reportTypeDef(context, argument, errorNode, false, allowed);
    }

    private static void reportTypeDef(@NonNull UastAndroidContext context, @NonNull UElement node, @Nullable UElement errorNode, boolean flag, @NonNull List<Pair<String, Object>> allowedValues) {
        String values = SupportAnnotationDetector.listAllowedValues(allowedValues);
        String message2 = flag ? "Must be one or more of: " + values : "Must be one of: " + values;
        if (errorNode == null) {
            errorNode = node;
        }
        context.report(TYPE_DEF, errorNode, context.getLocation(errorNode), message2);
    }

    private static String listAllowedValues(@NonNull List<Pair<String, Object>> allowedValues) {
        StringBuilder sb = new StringBuilder();
        for (Pair<String, Object> namedValue : allowedValues) {
            String s;
            Object allowedValue = namedValue.getSecond();
            if (allowedValue instanceof Integer) {
                s = allowedValue.toString();
            } else if (allowedValue instanceof UVariable) {
                UVariable variable2 = (UVariable)allowedValue;
                UClass containingClass = UastUtils.getContainingClassOrEmpty(variable2);
                String containingClassName = containingClass.getFqName();
                if (containingClassName == null) continue;
                containingClassName = containingClassName.substring(containingClassName.lastIndexOf(46) + 1);
                s = containingClassName + "." + variable2.getName();
            } else {
                String fqName;
                if (!(allowedValue instanceof UFqNamed) || (fqName = ((UFqNamed)allowedValue).getFqName()) == null) continue;
                s = fqName;
            }
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private static double getDoubleAttribute(@NonNull UAnnotation annotation, @NonNull String name2, double defaultValue) {
        Object value2 = annotation.getValue(name2);
        if (value2 instanceof Number) {
            return ((Number)value2).doubleValue();
        }
        return defaultValue;
    }

    private static long getLongAttribute(@NonNull UAnnotation annotation, @NonNull String name2, long defaultValue) {
        Object value2 = annotation.getValue(name2);
        if (value2 instanceof Number) {
            return ((Number)value2).longValue();
        }
        return defaultValue;
    }

    private static boolean getBoolean(@NonNull UAnnotation annotation, @NonNull String name2, boolean defaultValue) {
        Object value2 = annotation.getValue(name2);
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        return defaultValue;
    }

    @Nullable
    static UAnnotation getRelevantAnnotation(@NonNull UAnnotation annotation, @NonNull UastAndroidContext context) {
        String signature = annotation.getFqName();
        if (signature == null) {
            return null;
        }
        if (signature.startsWith("android.support.annotation.")) {
            if (signature.endsWith(".Nullable") || signature.endsWith(".NonNull")) {
                return null;
            }
            return annotation;
        }
        if (signature.startsWith("java.")) {
            return null;
        }
        UClass type2 = annotation.resolve(context);
        if (type2 != null) {
            for (UAnnotation inner : type2.getAnnotations()) {
                if (!inner.matchesFqName("android.support.annotation.IntDef") && !inner.matchesFqName("android.support.annotation.StringDef") && !inner.matchesFqName(PERMISSION_ANNOTATION)) continue;
                return inner;
            }
        }
        return null;
    }

    @Override
    public UastVisitor createUastVisitor(UastAndroidContext context) {
        return new CallVisitor(context);
    }

    private class CallVisitor
    extends AbstractUastVisitor {
        private final UastAndroidContext mContext;

        public CallVisitor(UastAndroidContext context) {
            this.mContext = context;
        }

        @Override
        public boolean visitCallExpression(@NotNull UCallExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/SupportAnnotationDetector$CallVisitor", "visitCallExpression"));
            }
            if (node.getKind() == UastCallKind.FUNCTION_CALL) {
                this.visitFunctionInvocation(node);
            }
            return super.visitCallExpression(node);
        }

        private boolean visitFunctionInvocation(@NonNull UCallExpression call) {
            UFunction method = call.resolve(this.mContext);
            if (method != null) {
                List<UAnnotation> annotations2 = method.getAnnotations();
                for (UAnnotation uAnnotation : annotations2) {
                    UAnnotation uAnnotation2 = SupportAnnotationDetector.getRelevantAnnotation(uAnnotation, this.mContext);
                    if (uAnnotation2 == null) continue;
                    SupportAnnotationDetector.this.checkMethodAnnotation(this.mContext, method, call, uAnnotation2);
                }
                UClass containingClass = UastUtils.getContainingClass(method);
                if (containingClass != null) {
                    annotations2 = containingClass.getAnnotations();
                    for (UAnnotation annotation : annotations2) {
                        if ((annotation = SupportAnnotationDetector.getRelevantAnnotation(annotation, this.mContext)) == null) continue;
                        SupportAnnotationDetector.this.checkMethodAnnotation(this.mContext, method, call, annotation);
                    }
                }
                Iterator<UExpression> iterator = call.getValueArguments().iterator();
                int n = method.getValueParameterCount();
                for (int i = 0; i < n && iterator.hasNext(); ++i) {
                    UExpression argument = iterator.next();
                    annotations2 = method.getValueParameters().get(i).getAnnotations();
                    for (UAnnotation annotation : annotations2) {
                        if ((annotation = SupportAnnotationDetector.getRelevantAnnotation(annotation, this.mContext)) == null) continue;
                        SupportAnnotationDetector.checkParameterAnnotation(this.mContext, argument, annotation);
                    }
                }
            }
            return false;
        }
    }

    private static class CheckPermissionVisitor
    extends AbstractUastVisitor {
        private boolean mChecksPermission;
        private boolean mDone;
        private final UElement mTarget;

        public CheckPermissionVisitor(@NonNull UElement target) {
            this.mTarget = target;
        }

        @Override
        public boolean visitElement(@NotNull UElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/SupportAnnotationDetector$CheckPermissionVisitor", "visitElement"));
            }
            return this.mDone;
        }

        @Override
        public boolean visitCallExpression(@NotNull UCallExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/klint/checks/SupportAnnotationDetector$CheckPermissionVisitor", "visitCallExpression"));
            }
            if (node.getKind() == UastCallKind.FUNCTION_CALL) {
                String name2;
                if (node == this.mTarget) {
                    this.mDone = true;
                }
                if ((name2 = node.getFunctionName()) != null && (name2.startsWith("check") || name2.startsWith("enforce")) && name2.endsWith("Permission")) {
                    this.mChecksPermission = true;
                    this.mDone = true;
                }
            }
            return super.visitCallExpression(node);
        }

        public boolean checksPermission() {
            return this.mChecksPermission;
        }
    }
}

