/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.Speed;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UFunction;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastClassKind;
import org.jetbrains.uast.UastModifier;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.check.UastAndroidContext;
import org.jetbrains.uast.check.UastScanner;

public class ViewConstructorDetector
extends Detector
implements UastScanner {
    public static final Issue ISSUE = Issue.create("ViewConstructor", "Missing View constructors for XML inflation", "Some layout tools (such as the Android layout editor for Studio & Eclipse) needs to find a constructor with one of the following signatures:\n* `View(Context context)`\n* `View(Context context, AttributeSet attrs)`\n* `View(Context context, AttributeSet attrs, int defStyle)`\n\nIf your custom view needs to perform initialization which does not apply when used in a layout editor, you can surround the given code with a check to see if `View#isInEditMode()` is false, since that method will return `false` at runtime but true within a user interface editor.", Category.USABILITY, 3, Severity.WARNING, new Implementation(ViewConstructorDetector.class, Scope.SOURCE_FILE_SCOPE));

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    private static boolean isXmlConstructor(UFunction method) {
        List<UVariable> valueParameters2 = method.getValueParameters();
        int valueParameterCount2 = valueParameters2.size();
        if (valueParameterCount2 == 0 || valueParameterCount2 > 3) {
            return false;
        }
        if (!valueParameters2.get(0).getType().matchesFqName("android.content.Context")) {
            return false;
        }
        if (valueParameterCount2 == 1) {
            return true;
        }
        if (!valueParameters2.get(1).getType().matchesFqName("android.util.AttributeSet")) {
            return false;
        }
        if (valueParameterCount2 == 2) {
            return true;
        }
        return valueParameters2.get(2).getType().isInt();
    }

    @Override
    @Nullable
    public List<String> getApplicableSuperClasses() {
        return Collections.singletonList("android.view.View");
    }

    @Override
    public void visitClass(UastAndroidContext context, UClass node) {
        UastClassKind kind2 = node.getKind();
        if (kind2 != UastClassKind.CLASS || node.hasModifier(UastModifier.ABSTRACT)) {
            return;
        }
        if (UastUtils.getContainingClass(node) != null && !node.hasModifier(UastModifier.STATIC)) {
            return;
        }
        boolean found = false;
        for (UFunction constructor : node.getConstructors()) {
            if (!ViewConstructorDetector.isXmlConstructor(constructor)) continue;
            found = true;
            break;
        }
        if (!found) {
            String message2 = String.format("Custom view `%1$s` is missing constructor used by tools: `(Context)` or `(Context,AttributeSet)` or `(Context,AttributeSet,int)`", node.getFqName());
            Location location = context.getLocation(node.getNameElement());
            context.report(ISSUE, node, location, message2);
        }
    }
}

