/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInsight;

import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInsight.GradlePluginDescriptionsExtension;
import org.jetbrains.plugins.gradle.util.GradleDocumentationBundle;

public class GradlePluginDescriptions
implements GradlePluginDescriptionsExtension {
    @Override
    @NotNull
    public Map<String, String> getPluginDescriptions() {
        List plugins = StringUtil.split((String)"java,groovy,idea,eclipse,scala,antlr,application,ear,jetty,maven,osgi,war,announce,build-announcements,checkstyle,codenarc,eclipse-wtp,findbugs,jdepend,pmd,project-report,signing,sonar", (String)",");
        HashMap<String, String> descriptions = new HashMap<String, String>(plugins.size());
        for (String plugin : plugins) {
            descriptions.put(plugin, GradlePluginDescriptions.getDescription(plugin));
        }
        HashMap<String, String> hashMap = descriptions;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/codeInsight/GradlePluginDescriptions", "getPluginDescriptions"));
        }
        return hashMap;
    }

    @NotNull
    private static String getDescription(@NotNull String pluginName) {
        if (pluginName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginName", "org/jetbrains/plugins/gradle/codeInsight/GradlePluginDescriptions", "getDescription"));
        }
        String string = GradleDocumentationBundle.messageOrDefault(String.format("gradle.documentation.org.gradle.api.Project.apply.plugin.%s.non-html", pluginName), "", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/codeInsight/GradlePluginDescriptions", "getDescription"));
        }
        return string;
    }
}

