/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventResult;
import org.jetbrains.plugins.gradle.util.XmlXpathHelper;

public class AfterSuiteEvent
extends AbstractTestEvent {
    public AfterSuiteEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(XmlXpathHelper eventXml) throws XmlXpathHelper.XmlParserException {
        String testId = this.getTestId(eventXml);
        TestEventResult result = this.getTestEventResultType(eventXml);
        this.addToInvokeLater(() -> {
            SMTestProxy testProxy = this.findTestProxy(testId);
            if (testProxy == null) {
                return;
            }
            switch (result) {
                case SUCCESS: {
                    testProxy.setFinished();
                    break;
                }
                case FAILURE: {
                    testProxy.setTestFailed("", null, false);
                    break;
                }
                case SKIPPED: {
                    testProxy.setTestIgnored(null, null);
                    break;
                }
            }
            this.getResultsViewer().onSuiteFinished(testProxy);
        });
    }
}

