/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.actions;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.SyncType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\r"}, d2={"NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "Lorg/jetbrains/annotations/NotNull;", "getNOTIFICATION_GROUP", "()Lcom/intellij/notification/NotificationGroup;", "syncAndNotify", "", "syncType", "Lorg/jetbrains/settingsRepository/SyncType;", "project", "Lcom/intellij/openapi/project/Project;", "notifyIfUpToDate", "", "settings-repository"})
public final class SyncActionKt {
    @NotNull
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)IcsManagerKt.PLUGIN_NAME);

    @NotNull
    public static final NotificationGroup getNOTIFICATION_GROUP() {
        return NOTIFICATION_GROUP;
    }

    public static final void syncAndNotify(@NotNull SyncType syncType, @Nullable Project project, boolean notifyIfUpToDate) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)syncType), (String)"syncType");
        try {
            if (IcsManager.sync$default(IcsManagerKt.getIcsManager(), syncType, project, null, 4, null) == null && !notifyIfUpToDate) {
                return;
            }
            NOTIFICATION_GROUP.createNotification(IcsBundleKt.icsMessage("sync.done.message", new Object[0]), NotificationType.INFORMATION).notify(project);
        }
        catch (Exception e) {
            IcsManagerKt.getLOG().warn((Throwable)e);
            String string = IcsBundleKt.icsMessage("sync.rejected.title", new Object[0]);
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "Internal error";
            }
            NOTIFICATION_GROUP.createNotification(string, string2, NotificationType.ERROR, (NotificationListener)null).notify(project);
        }
    }

    public static /* bridge */ /* synthetic */ void syncAndNotify$default(SyncType syncType, Project project, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: syncAndNotify");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        SyncActionKt.syncAndNotify(syncType, project, bl);
    }
}

