/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation.inspections.quickfix;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.psi.XPathBinaryExpression;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathFunctionCall;
import org.intellij.lang.xpath.validation.ExpectedTypeUtil;
import org.intellij.lang.xpath.validation.inspections.quickfix.ReplaceElementFix;
import org.jetbrains.annotations.NotNull;

public class RemoveExplicitConversionFix
extends ReplaceElementFix<XPathExpression> {
    public RemoveExplicitConversionFix(XPathExpression expression) {
        super(ExpectedTypeUtil.unparenthesize(expression));
    }

    @NotNull
    public String getText() {
        if ("Remove Explicit Type Conversion" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/validation/inspections/quickfix/RemoveExplicitConversionFix", "getText"));
        }
        return "Remove Explicit Type Conversion";
    }

    @NotNull
    public String getFamilyName() {
        if ("ImplicitTypeConversion" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/validation/inspections/quickfix/RemoveExplicitConversionFix", "getFamilyName"));
        }
        return "ImplicitTypeConversion";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/lang/xpath/validation/inspections/quickfix/RemoveExplicitConversionFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/lang/xpath/validation/inspections/quickfix/RemoveExplicitConversionFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/intellij/lang/xpath/validation/inspections/quickfix/RemoveExplicitConversionFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/intellij/lang/xpath/validation/inspections/quickfix/RemoveExplicitConversionFix", "isAvailable"));
        }
        return super.isAvailable(project, file, startElement, endElement) && ((XPathFunctionCall)startElement).getArgumentList().length == 1;
    }

    @Override
    public void invokeImpl(Project project, PsiFile file) throws IncorrectOperationException {
        PsiElement myElement = this.getStartElement();
        XPathExpression arg0 = ((XPathFunctionCall)myElement).getArgumentList()[0];
        XPathExpression outer = (XPathExpression)PsiTreeUtil.getParentOfType((PsiElement)myElement, XPathExpression.class);
        if (arg0 instanceof XPathBinaryExpression && outer instanceof XPathBinaryExpression) {
            this.replace("(" + arg0.getText() + ")");
        } else {
            this.replace(arg0.getText());
        }
    }
}

