/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MultilineEditor
extends JPanel {
    private final EditorModel myModel;
    private EditorTextField myEditorTextField;

    public EditorTextField getField() {
        return this.myEditorTextField;
    }

    public MultilineEditor(Document document, Project project, FileType fileType, EditorModel model) {
        super(new BorderLayout());
        this.myModel = model;
        this.myEditorTextField = new EditorTextField(document, project, fileType){

            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.setHorizontalScrollbarVisible(true);
                editor.setVerticalScrollbarVisible(true);
                editor.setEmbeddedIntoDialogWrapper(true);
                editor.getComponent().setPreferredSize(null);
                return editor;
            }

            protected boolean isOneLineMode() {
                return false;
            }
        };
        this.add((Component)this.myEditorTextField, "Center");
        model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                int selectedIndex = MultilineEditor.this.myModel.getSelectedIndex();
                if (selectedIndex != -1) {
                    MultilineEditor.this.myEditorTextField.setText(MultilineEditor.this.myModel.getItemString(selectedIndex));
                }
            }
        });
        this.addHistoryPagers();
    }

    private void addHistoryPagers() {
        DefaultActionGroup pagerGroup = new DefaultActionGroup(null, false);
        pagerGroup.add((AnAction)new ItemAction("PreviousOccurence", this){

            public void update(AnActionEvent e) {
                Presentation presentation = e.getPresentation();
                presentation.setEnabled(MultilineEditor.this.myModel.getSelectedIndex() < MultilineEditor.this.myModel.getSize() - 1);
                presentation.setText("Previous history element");
                presentation.setDescription("Navigate to the previous history element");
            }

            public void actionPerformed(AnActionEvent e) {
                MultilineEditor.this.myModel.setSelectedIndex(MultilineEditor.this.myModel.getSelectedIndex() + 1);
                MultilineEditor.this.refocus();
            }
        });
        pagerGroup.add((AnAction)new ItemAction("NextOccurence", this){

            public void update(AnActionEvent e) {
                Presentation presentation = e.getPresentation();
                presentation.setEnabled(MultilineEditor.this.myModel.getSelectedIndex() > 0);
                presentation.setText("Next history element");
                presentation.setDescription("Navigate to the next history element");
            }

            public void actionPerformed(AnActionEvent e) {
                MultilineEditor.this.myModel.setSelectedIndex(MultilineEditor.this.myModel.getSelectedIndex() - 1);
                MultilineEditor.this.refocus();
            }
        });
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("HistoryPager", (ActionGroup)pagerGroup, false);
        this.add((Component)toolbar.getComponent(), "East");
    }

    private void refocus() {
        SwingUtilities.invokeLater(() -> {
            Editor editor = this.myEditorTextField.getEditor();
            if (editor != null) {
                editor.getContentComponent().requestFocus();
            }
            this.myEditorTextField.selectAll();
        });
    }

    private static abstract class ItemAction
    extends AnAction {
        public ItemAction(String id, JComponent component) {
            this.copyFrom(ActionManager.getInstance().getAction(id));
            this.registerCustomShortcutSet(this.getShortcutSet(), component);
        }
    }

    public static interface EditorModel
    extends ListModel {
        public int getSelectedIndex();

        public void setSelectedIndex(int var1);

        public String getItemString(int var1);

        @Override
        public int getSize();
    }
}

