/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.bmp.pixelparsers;

import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.bmp.BmpHeaderInfo;
import org.apache.sanselan.formats.bmp.pixelparsers.PixelParserSimple;

public class PixelParserRgb
extends PixelParserSimple {
    private int bytecount = 0;
    private int cached_bit_count = 0;
    private int cached_byte = 0;
    int pixelCount = 0;

    public PixelParserRgb(BmpHeaderInfo bhi, byte[] ColorTable, byte[] ImageData) {
        super(bhi, ColorTable, ImageData);
    }

    @Override
    public int getNextRGB() throws ImageReadException, IOException {
        ++this.pixelCount;
        if (this.bhi.bitsPerPixel == 1 || this.bhi.bitsPerPixel == 4) {
            if (this.cached_bit_count < this.bhi.bitsPerPixel) {
                if (this.cached_bit_count != 0) {
                    throw new ImageReadException("Unexpected leftover bits: " + this.cached_bit_count + "/" + this.bhi.bitsPerPixel);
                }
                this.cached_bit_count += 8;
                this.cached_byte = 0xFF & this.imageData[this.bytecount];
                ++this.bytecount;
            }
            int cache_mask = (1 << this.bhi.bitsPerPixel) - 1;
            int sample = cache_mask & this.cached_byte >> 8 - this.bhi.bitsPerPixel;
            this.cached_byte = 0xFF & this.cached_byte << this.bhi.bitsPerPixel;
            this.cached_bit_count -= this.bhi.bitsPerPixel;
            int rgb = this.getColorTableRGB(sample);
            return rgb;
        }
        if (this.bhi.bitsPerPixel == 8) {
            int sample = 0xFF & this.imageData[this.bytecount + 0];
            int rgb = this.getColorTableRGB(sample);
            ++this.bytecount;
            return rgb;
        }
        if (this.bhi.bitsPerPixel == 16) {
            int data = this.bfp.read2Bytes("Pixel", this.is, "BMP Image Data");
            int blue = (0x1F & data >> 0) << 3;
            int green = (0x1F & data >> 5) << 3;
            int red = (0x1F & data >> 10) << 3;
            int alpha = 255;
            int rgb = alpha << 24 | red << 16 | green << 8 | blue << 0;
            this.bytecount += 2;
            return rgb;
        }
        if (this.bhi.bitsPerPixel == 24) {
            int blue = 0xFF & this.imageData[this.bytecount + 0];
            int green = 0xFF & this.imageData[this.bytecount + 1];
            int red = 0xFF & this.imageData[this.bytecount + 2];
            int alpha = 255;
            int rgb = alpha << 24 | red << 16 | green << 8 | blue << 0;
            this.bytecount += 3;
            return rgb;
        }
        if (this.bhi.bitsPerPixel == 32) {
            int blue = 0xFF & this.imageData[this.bytecount + 0];
            int green = 0xFF & this.imageData[this.bytecount + 1];
            int red = 0xFF & this.imageData[this.bytecount + 2];
            int alpha = 255;
            int rgb = alpha << 24 | red << 16 | green << 8 | blue << 0;
            this.bytecount += 4;
            return rgb;
        }
        throw new ImageReadException("Unknown BitsPerPixel: " + this.bhi.bitsPerPixel);
    }

    @Override
    public void newline() throws ImageReadException, IOException {
        this.cached_bit_count = 0;
        while (this.bytecount % 4 != 0) {
            this.bfp.readByte("Pixel", this.is, "BMP Image Data");
            ++this.bytecount;
        }
    }
}

