/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.segments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.jpeg.segments.Segment;

public class SOFNSegment
extends Segment {
    public final int width;
    public final int height;
    public final int numberOfComponents;
    public final int precision;
    public final Component[] components;

    public SOFNSegment(int marker, byte[] segmentData) throws ImageReadException, IOException {
        this(marker, segmentData.length, new ByteArrayInputStream(segmentData));
    }

    public SOFNSegment(int marker, int marker_length, InputStream is) throws ImageReadException, IOException {
        super(marker, marker_length);
        if (this.getDebug()) {
            System.out.println("SOF0Segment marker_length: " + marker_length);
        }
        this.precision = this.readByte("Data_precision", is, "Not a Valid JPEG File");
        this.height = this.read2Bytes("Image_height", is, "Not a Valid JPEG File");
        this.width = this.read2Bytes("Image_Width", is, "Not a Valid JPEG File");
        this.numberOfComponents = this.readByte("Number_of_components", is, "Not a Valid JPEG File");
        this.components = new Component[this.numberOfComponents];
        for (int i = 0; i < this.numberOfComponents; ++i) {
            byte componentIdentifier = this.readByte("ComponentIdentifier", is, "Not a Valid JPEG File");
            byte hvSamplingFactors = this.readByte("SamplingFactors", is, "Not a Valid JPEG File");
            int horizontalSamplingFactor = hvSamplingFactors >> 4 & 0xF;
            int verticalSamplingFactor = hvSamplingFactors & 0xF;
            byte quantTabDestSelector = this.readByte("QuantTabDestSel", is, "Not a Valid JPEG File");
            this.components[i] = new Component(componentIdentifier, horizontalSamplingFactor, verticalSamplingFactor, quantTabDestSelector);
        }
        if (this.getDebug()) {
            System.out.println("");
        }
    }

    @Override
    public String getDescription() {
        return "SOFN (SOF" + (this.marker - 65472) + ") (" + this.getSegmentType() + ")";
    }

    public static class Component {
        public final int componentIdentifier;
        public final int horizontalSamplingFactor;
        public final int verticalSamplingFactor;
        public final int quantTabDestSelector;

        public Component(int componentIdentifier, int horizontalSamplingFactor, int veritcalSamplingFactor, int quantTabDestSelector) {
            this.componentIdentifier = componentIdentifier;
            this.horizontalSamplingFactor = horizontalSamplingFactor;
            this.verticalSamplingFactor = veritcalSamplingFactor;
            this.quantTabDestSelector = quantTabDestSelector;
        }
    }
}

