/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;

public class XSSimpleCM
implements XSCMValidator {
    private static final short STATE_START = 0;
    private static final short STATE_FIRST = 1;
    private static final short STATE_VALID = 2;
    private XSElementDecl fFirstElement = null;
    private XSElementDecl fSecondElement = null;
    private short fOperator;

    public XSSimpleCM(short s, XSElementDecl xSElementDecl) {
        this.fFirstElement = xSElementDecl;
        this.fOperator = s;
    }

    public XSSimpleCM(short s, XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2) {
        this.fFirstElement = xSElementDecl;
        this.fSecondElement = xSElementDecl2;
        this.fOperator = s;
    }

    public int[] startContentModel() {
        return new int[]{0};
    }

    public Object oneTransition(QName qName, int[] nArray, SubstitutionGroupHandler substitutionGroupHandler) {
        if (nArray[0] == -1) {
            nArray[0] = -2;
            return null;
        }
        int n = nArray[0];
        XSElementDecl xSElementDecl = null;
        switch (this.fOperator) {
            case 1: 
            case 6: {
                if (n != 0 || (xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fFirstElement)) == null) break;
                nArray[0] = 2;
                return xSElementDecl;
            }
            case 7: 
            case 8: {
                xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fFirstElement);
                if (xSElementDecl == null) break;
                nArray[0] = 2;
                return xSElementDecl;
            }
            case 3: {
                if (n != 0) break;
                xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fFirstElement);
                if (xSElementDecl != null) {
                    nArray[0] = 2;
                    return xSElementDecl;
                }
                xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fSecondElement);
                if (xSElementDecl == null) break;
                nArray[0] = 2;
                return xSElementDecl;
            }
            case 4: {
                if (n == 0) {
                    xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fFirstElement);
                    if (xSElementDecl == null) break;
                    nArray[0] = 1;
                    return xSElementDecl;
                }
                if (n != 1 || (xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fSecondElement)) == null) break;
                nArray[0] = 2;
                return xSElementDecl;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_CST");
            }
        }
        nArray[0] = -1;
        return null;
    }

    public boolean endContentModel(int[] nArray) {
        boolean bl = false;
        int n = nArray[0];
        if (n < 0) {
            return false;
        }
        switch (this.fOperator) {
            case 1: 
            case 3: 
            case 4: 
            case 8: {
                bl = n == 2;
                break;
            }
            case 6: 
            case 7: {
                bl = n == 2 || n == 0;
                break;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_CST");
            }
        }
        return bl;
    }

    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler substitutionGroupHandler) throws XMLSchemaException {
        if (this.fOperator == 3 && XSConstraints.overlapUPA(this.fFirstElement, this.fSecondElement, substitutionGroupHandler)) {
            throw new XMLSchemaException("cos-nonambig", new Object[]{this.fFirstElement.toString(), this.fSecondElement.toString()});
        }
        return false;
    }
}

